/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.plaincredentials.impl;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SecretBytes;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.CryptoConfidentialKey;
import org.apache.commons.fileupload.FileItem;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;

public final class FileCredentialsImpl
extends BaseStandardCredentials
implements FileCredentials {
    @Deprecated
    private static final CryptoConfidentialKey KEY = new CryptoConfidentialKey(FileCredentialsImpl.class.getName());
    private static final Logger LOGGER = Logger.getLogger(FileCredentialsImpl.class.getName());
    private static final long serialVersionUID = -7448141713963432962L;
    @NonNull
    private final String fileName;
    @NonNull
    private final SecretBytes secretBytes;
    @Deprecated
    @CheckForNull
    private transient byte[] data;

    @Deprecated
    public FileCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull FileItem file, @CheckForNull String fileName, @CheckForNull String data) throws IOException {
        super(scope, id, description);
        String name = file.getName();
        if (name.length() > 0) {
            this.fileName = name.replaceFirst("^.+[/\\\\]", "");
            this.secretBytes = SecretBytes.fromBytes((byte[])file.get());
        } else {
            this.fileName = fileName;
            this.secretBytes = SecretBytes.fromString((String)data);
        }
        if (this.fileName == null || this.fileName.isEmpty()) {
            throw new IllegalArgumentException(String.format("No FileName was provided or resolved. Input file item was %s and input file name was %s.", file, fileName));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "for {0} have {1} of length {2} after upload of \u2018{3}\u2019", new Object[]{this.getId(), this.fileName, this.secretBytes.getPlainData().length, name});
        }
    }

    @DataBoundConstructor
    public FileCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull FileItem file, @CheckForNull String fileName, @CheckForNull SecretBytes secretBytes) throws IOException {
        super(scope, id, description);
        String name;
        String string = name = file != null ? file.getName() : "";
        if (name.length() > 0) {
            this.fileName = name.replaceFirst("^.+[/\\\\]", "");
            this.secretBytes = SecretBytes.fromRawBytes((byte[])file.get());
        } else {
            if (secretBytes == null) {
                throw new IllegalArgumentException("No content provided or resolved.");
            }
            this.fileName = fileName;
            this.secretBytes = secretBytes;
        }
        if (this.fileName == null || this.fileName.isEmpty()) {
            throw new IllegalArgumentException(String.format("No FileName was provided or resolved. Input file item was %s and input file name was %s.", file.toString(), fileName));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "for {0} have {1} of length {2} after upload of \u2018{3}\u2019", new Object[]{this.getId(), this.fileName, this.secretBytes.getPlainData().length, name});
        }
    }

    public FileCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull String fileName, @NonNull SecretBytes secretBytes) {
        super(scope, id, description);
        this.fileName = fileName;
        this.secretBytes = secretBytes;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.data != null) {
            try {
                return new FileCredentialsImpl(this.getScope(), this.getId(), this.getDescription(), this.fileName, SecretBytes.fromBytes((byte[])KEY.decrypt().doFinal(this.data)));
            }
            catch (GeneralSecurityException e1) {
                InvalidObjectException e2 = new InvalidObjectException(e1.toString());
                e2.initCause(e1);
                throw e2;
            }
        }
        return this;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Restricted(value={DoNotUse.class})
    public SecretBytes getSecretBytes() {
        return this.secretBytes;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.secretBytes.getPlainData());
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return Messages.FileCredentialsImpl_secret_file();
        }
    }
}

