/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.findbugs.FindBugsPublisher;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.publishers.AbstractHealthAwarePublisher;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Element;

public class SpotBugsAnalysisPublisher
extends AbstractHealthAwarePublisher {
    private static final Logger LOGGER = Logger.getLogger(SpotBugsAnalysisPublisher.class.getName());
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public SpotBugsAnalysisPublisher() {
    }

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        FilePath workspace = (FilePath)context.get(FilePath.class);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        List<Element> spotbugsEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, "com.github.spotbugs", "spotbugs-maven-plugin", "spotbugs", "MojoSucceeded", "MojoFailed");
        if (spotbugsEvents.isEmpty()) {
            LOGGER.log(Level.FINE, "No com.github.spotbugs:spotbugs-maven-plugin:spotbugs execution found");
            return;
        }
        try {
            Class.forName("hudson.plugins.findbugs.FindBugsPublisher");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] Jenkins ");
            listener.hyperlink("https://wiki.jenkins-ci.org/display/JENKINS/FindBugs+Plugin", "FindBugs Plugin");
            listener.getLogger().println(" not found, don't display com.github.spotbugs:spotbugs-maven-plugin:spotbugs results in pipeline screen.");
            return;
        }
        for (Element findBugsTestEvent : spotbugsEvents) {
            String findBugsEventType = findBugsTestEvent.getAttribute("type");
            if (!findBugsEventType.equals("MojoSucceeded") && !findBugsEventType.equals("MojoFailed")) continue;
            Element pluginElt = XmlUtils.getUniqueChildElement(findBugsTestEvent, "plugin");
            Element xmlOutputDirectoryElt = XmlUtils.getUniqueChildElementOrNull(pluginElt, "xmlOutputDirectory");
            Element projectElt = XmlUtils.getUniqueChildElement(findBugsTestEvent, "project");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.PluginInvocation pluginInvocation = XmlUtils.newPluginInvocation(pluginElt);
            if (xmlOutputDirectoryElt == null) {
                listener.getLogger().println("[withMaven] No <xmlOutputDirectoryElt> element found for <plugin> in " + XmlUtils.toString(findBugsTestEvent));
                continue;
            }
            String xmlOutputDirectory = xmlOutputDirectoryElt.getTextContent().trim();
            if (xmlOutputDirectory.contains("${project.build.directory}")) {
                String projectBuildDirectory = XmlUtils.getProjectBuildDirectory(projectElt);
                if (projectBuildDirectory == null || projectBuildDirectory.isEmpty()) {
                    listener.getLogger().println("[withMaven] '${project.build.directory}' found for <project> in " + XmlUtils.toString(findBugsTestEvent));
                    continue;
                }
                xmlOutputDirectory = xmlOutputDirectory.replace("${project.build.directory}", projectBuildDirectory);
            } else if (xmlOutputDirectory.contains("${basedir}")) {
                String baseDir = projectElt.getAttribute("baseDir");
                if (baseDir.isEmpty()) {
                    listener.getLogger().println("[withMaven] '${basedir}' found for <project> in " + XmlUtils.toString(findBugsTestEvent));
                    continue;
                }
                xmlOutputDirectory = xmlOutputDirectory.replace("${basedir}", baseDir);
            }
            xmlOutputDirectory = XmlUtils.getPathInWorkspace(xmlOutputDirectory, workspace);
            String findBugsResultsFile = xmlOutputDirectory + "/spotbugsXml.xml";
            listener.getLogger().println("[withMaven] SpotBugsPublisher - Archive SpotBugs analysis results for Maven artifact " + mavenArtifact.toString() + " generated by " + pluginInvocation + ": " + findBugsResultsFile);
            FindBugsPublisher findBugsPublisher = new FindBugsPublisher();
            findBugsPublisher.setPattern(findBugsResultsFile);
            this.setHealthAwarePublisherAttributes(findBugsPublisher);
            try {
                findBugsPublisher.perform(run, workspace, launcher, listener);
            }
            catch (Exception e) {
                listener.error("[withMaven] SpotBugsPublisher - Silently ignore exception archiving FindBugs results for Maven artifact " + mavenArtifact.toString() + " generated by " + pluginInvocation + ": " + e);
                LOGGER.log(Level.WARNING, "Exception processing " + XmlUtils.toString(findBugsTestEvent), e);
            }
        }
    }

    @Symbol(value={"spotbugsPublisher"})
    @Extension
    public static class DescriptorImpl
    extends AbstractHealthAwarePublisher.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return "SpotBugs Publisher";
        }

        @Override
        public int ordinal() {
            return 20;
        }

        @Override
        @Nonnull
        public String getSkipFileName() {
            return ".skip-publish-spotbugs-results";
        }
    }
}

