/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.listeners.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

@Extension
public class DatabaseSyncItemListener
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(DatabaseSyncItemListener.class.getName());
    @Inject
    public GlobalPipelineMavenConfig globalPipelineMavenConfig;

    public void onDeleted(Item item) {
        if (item instanceof WorkflowJob) {
            WorkflowJob pipeline = (WorkflowJob)item;
            this.onDeleted(pipeline);
        } else {
            LOGGER.log(Level.FINE, "Ignore onDeleted({0})", new Object[]{item});
        }
    }

    public void onDeleted(WorkflowJob pipeline) {
        LOGGER.log(Level.FINE, "onDeleted({0})", pipeline);
        this.globalPipelineMavenConfig.getDao().deleteJob(pipeline.getFullName());
    }

    public void onRenamed(Item item, String oldName, String newName) {
        if (item instanceof WorkflowJob) {
            WorkflowJob pipeline = (WorkflowJob)item;
            this.onRenamed(pipeline, oldName, newName);
        } else {
            LOGGER.log(Level.FINE, "Ignore onRenamed({0}, {1}, {2})", new Object[]{item, oldName, newName});
        }
    }

    public void onRenamed(WorkflowJob pipeline, String oldName, String newName) {
        LOGGER.log(Level.FINE, "onRenamed({0}, {1}, {2})", new Object[]{pipeline, oldName, newName});
        ItemGroup parent = pipeline.getParent();
        String oldFullName = parent.equals(Jenkins.get()) ? oldName : parent.getFullName() + "/" + oldName;
        String newFullName = pipeline.getFullName();
        this.globalPipelineMavenConfig.getDao().renameJob(oldFullName, newFullName);
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        if (item instanceof WorkflowJob) {
            WorkflowJob pipeline = (WorkflowJob)item;
            this.onLocationChanged(pipeline, oldFullName, newFullName);
        } else {
            LOGGER.log(Level.FINE, "Ignore onLocationChanged({0}, {1}, {2})", new Object[]{item, oldFullName, newFullName});
        }
    }

    public void onLocationChanged(WorkflowJob pipeline, String oldFullName, String newFullName) {
        LOGGER.log(Level.FINE, "onLocationChanged({0}, {1}, {2})", new Object[]{pipeline, oldFullName, newFullName});
        this.globalPipelineMavenConfig.getDao().renameJob(oldFullName, newFullName);
    }
}

