CREATE TABLE MAVEN_ARTIFACT
(
    GROUP_ID varchar(256) NOT NULL,
    ARTIFACT_ID varchar(256) NOT NULL,
    VERSION varchar(100) NOT NULL,
    TYPE varchar(64) NOT NULL,
    ID SERIAL PRIMARY KEY,
    CLASSIFIER varchar(256) DEFAULT NULL
);
CREATE INDEX IDX_MAVEN_ARTIFACT on MAVEN_ARTIFACT (GROUP_ID, ARTIFACT_ID, VERSION, TYPE);

CREATE TABLE JENKINS_BUILD_RESULT
(
    NAME varchar(256) NOT NULL,
    ID integer PRIMARY KEY NOT NULL,
    COMPLETE boolean
);

INSERT INTO JENKINS_BUILD_RESULT (ID, NAME, COMPLETE) VALUES (0, 'SUCCESS', true);
INSERT INTO JENKINS_BUILD_RESULT (ID, NAME, COMPLETE) VALUES (1, 'UNSTABLE', true);
INSERT INTO JENKINS_BUILD_RESULT (ID, NAME, COMPLETE) VALUES (2, 'FAILURE', true);
INSERT INTO JENKINS_BUILD_RESULT (ID, NAME, COMPLETE) VALUES (3, 'NOT_BUILT', false);
INSERT INTO JENKINS_BUILD_RESULT (ID, NAME, COMPLETE) VALUES (4, 'ABORTED', false);

CREATE TABLE JENKINS_MASTER
(
    LEGACY_INSTANCE_ID varchar(256) NOT NULL,
    URL varchar(256) NOT NULL,
    ID SERIAL PRIMARY KEY
);
CREATE UNIQUE INDEX IDX_LEGACY_INSTANCE_ID on JENKINS_MASTER (LEGACY_INSTANCE_ID);

CREATE TABLE JENKINS_JOB
(
    FULL_NAME varchar(512) NOT NULL,
    ID SERIAL PRIMARY KEY,
    JENKINS_MASTER_ID integer NOT NULL,
    LAST_BUILD_NUMBER integer,
    LAST_SUCCESSFUL_BUILD_NUMBER integer
);

CREATE UNIQUE INDEX IDX_JENKINS_JOB on JENKINS_JOB (JENKINS_MASTER_ID, FULL_NAME);


CREATE TABLE JENKINS_BUILD
(
    JOB_ID integer NOT NULL,
    NUMBER integer NOT NULL,
    ID SERIAL PRIMARY KEY,
    RESULT_ID integer,
    START_TIME timestamp,
    DURATION_IN_MILLIS integer,
    FOREIGN KEY (JOB_ID) REFERENCES JENKINS_JOB (ID) ON DELETE CASCADE,
    FOREIGN KEY (RESULT_ID) REFERENCES JENKINS_BUILD_RESULT (ID)
);

CREATE UNIQUE INDEX IDX_JENKINS_BUILD on JENKINS_BUILD (JOB_ID, NUMBER);

CREATE TABLE MAVEN_DEPENDENCY
(
    ARTIFACT_ID integer NOT NULL,
    BUILD_ID integer NOT NULL,
    SCOPE varchar(20),
    ID SERIAL PRIMARY KEY,
    IGNORE_UPSTREAM_TRIGGERS BOOLEAN DEFAULT FALSE,
    CONSTRAINT DEPENDENCY_BUILD_ID_FK FOREIGN KEY (BUILD_ID) REFERENCES JENKINS_BUILD (ID) ON DELETE CASCADE,
    CONSTRAINT DEPENDENCY_ARTIFACT_ID_FK FOREIGN KEY (ARTIFACT_ID) REFERENCES MAVEN_ARTIFACT(ID) ON DELETE CASCADE
);

CREATE TABLE GENERATED_MAVEN_ARTIFACT
(
    ARTIFACT_ID INT NOT NULL,
    BUILD_ID INT NOT NULL,
    ID SERIAL PRIMARY KEY,
    VERSION varchar(256),
    SKIP_DOWNSTREAM_TRIGGERS BOOLEAN DEFAULT FALSE,
    REPOSITORY_URL varchar(256) DEFAULT NULL,
    EXTENSION varchar(256) DEFAULT NULL,
    CONSTRAINT GENERATED_MAVEN_ARTIFACT_BUILD_ID_FK FOREIGN KEY (BUILD_ID) REFERENCES JENKINS_BUILD (ID) ON DELETE CASCADE,
    CONSTRAINT GENERATED_MAVEN_ARTIFACT_ARTIFACT_ID_FK FOREIGN KEY (ARTIFACT_ID) REFERENCES MAVEN_ARTIFACT (ID) ON DELETE CASCADE
);


CREATE TABLE VERSION
(
    VERSION integer
);

CREATE TABLE MAVEN_PARENT_PROJECT
(
    ARTIFACT_ID integer NOT NULL,
    BUILD_ID integer NOT NULL,
    ID SERIAL PRIMARY KEY,
    IGNORE_UPSTREAM_TRIGGERS BOOLEAN DEFAULT FALSE,
    CONSTRAINT PARENT_PROJECT_BUILD_ID_FK FOREIGN KEY (BUILD_ID) REFERENCES JENKINS_BUILD (ID) ON DELETE CASCADE,
    CONSTRAINT PARENT_PROJECT_ARTIFACT_ID_FK FOREIGN KEY (ARTIFACT_ID) REFERENCES MAVEN_ARTIFACT(ID) ON DELETE CASCADE
);

CREATE TABLE JENKINS_BUILD_UPSTREAM_CAUSE
(
    UPSTREAM_BUILD_ID integer NOT NULL,
    DOWNSTREAM_BUILD_ID integer NOT NULL,
    ID SERIAL PRIMARY KEY,
    CONSTRAINT UPSTREAM_BUILD_ID_FK FOREIGN KEY (UPSTREAM_BUILD_ID) REFERENCES JENKINS_BUILD (ID) ON DELETE CASCADE,
    CONSTRAINT DOWNSTREAM_BUILD_ID_FK FOREIGN KEY (DOWNSTREAM_BUILD_ID) REFERENCES JENKINS_BUILD (ID) ON DELETE CASCADE
);

CREATE OR REPLACE VIEW JOB_GENERATED_ARTIFACTS as
select
    JENKINS_JOB.FULL_NAME as JOB_FULL_NAME, JENKINS_BUILD.NUMBER AS BUILD_NUMBER,
    GENERATED_MAVEN_ARTIFACT.VERSION as GENERATED_MAVEN_ARTIFACT_VERSION, GENERATED_MAVEN_ARTIFACT.SKIP_DOWNSTREAM_TRIGGERS, GENERATED_MAVEN_ARTIFACT.REPOSITORY_URL, GENERATED_MAVEN_ARTIFACT.EXTENSION,
    MAVEN_ARTIFACT.GROUP_ID, MAVEN_ARTIFACT.ARTIFACT_ID, MAVEN_ARTIFACT.VERSION, MAVEN_ARTIFACT.TYPE, MAVEN_ARTIFACT.CLASSIFIER, MAVEN_ARTIFACT.ID
from MAVEN_ARTIFACT inner join GENERATED_MAVEN_ARTIFACT on MAVEN_ARTIFACT.ID = GENERATED_MAVEN_ARTIFACT.ARTIFACT_ID
                    inner join JENKINS_BUILD on GENERATED_MAVEN_ARTIFACT.BUILD_ID = JENKINS_BUILD.ID
                    inner join JENKINS_JOB on JENKINS_BUILD.JOB_ID = JENKINS_JOB.ID;

CREATE OR REPLACE VIEW JOB_DEPENDENCIES as
select
    JENKINS_JOB.FULL_NAME as JOB_FULL_NAME, JENKINS_BUILD.NUMBER AS BUILD_NUMBER,
    MAVEN_DEPENDENCY.SCOPE, MAVEN_DEPENDENCY.IGNORE_UPSTREAM_TRIGGERS,
    MAVEN_ARTIFACT.GROUP_ID, MAVEN_ARTIFACT.ARTIFACT_ID, MAVEN_ARTIFACT.VERSION, MAVEN_ARTIFACT.TYPE, MAVEN_ARTIFACT.CLASSIFIER, MAVEN_ARTIFACT.ID
from MAVEN_ARTIFACT inner join MAVEN_DEPENDENCY on MAVEN_ARTIFACT.ID = MAVEN_DEPENDENCY.ARTIFACT_ID
                    inner join JENKINS_BUILD on MAVEN_DEPENDENCY.BUILD_ID = JENKINS_BUILD.ID
                    inner join JENKINS_JOB on JENKINS_BUILD.JOB_ID = JENKINS_JOB.ID;

INSERT INTO VERSION(VERSION) VALUES (2);


