/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.jenkinsci.plugins.pipeline.maven.dao.AbstractPipelineMavenPluginDao;

public class PipelineMavenPluginH2Dao
extends AbstractPipelineMavenPluginDao {
    public PipelineMavenPluginH2Dao(@Nonnull DataSource ds) {
        super(ds);
    }

    public PipelineMavenPluginH2Dao(@Nonnull File rootDir) {
        this((DataSource)JdbcConnectionPool.create((String)("jdbc:h2:file:" + new File(rootDir, "jenkins-jobs").getAbsolutePath() + ";AUTO_SERVER=TRUE;MULTI_THREADED=1;QUERY_CACHE_SIZE=25;JMX=TRUE"), (String)"sa", (String)"sa"));
    }

    @Override
    protected void registerJdbcDriver() {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("H2 driver 'org.h2.Driver' not found. Please install the 'H2 Database Plugin' to install the H2 driver");
        }
    }

    @Override
    public String getJdbcScheme() {
        return "h2";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isEnoughProductionGradeForTheWorkload() {
        try (Connection cnn = this.getDataSource().getConnection();){
            Throwable throwable;
            ResultSet rst;
            try (Statement stmt = cnn.createStatement();){
                rst = stmt.executeQuery("select count(*) from MAVEN_DEPENDENCY");
                throwable = null;
                try {
                    rst.next();
                    int count = rst.getInt(1);
                    if (count > 100) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (Throwable count) {
                    throwable = count;
                    throw count;
                }
                finally {
                    if (rst != null) {
                        if (throwable != null) {
                            try {
                                rst.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            rst.close();
                        }
                    }
                }
            }
            stmt = cnn.createStatement();
            var4_7 = null;
            try {
                rst = stmt.executeQuery("select count(*) from GENERATED_MAVEN_ARTIFACT");
                throwable = null;
                try {
                    rst.next();
                    int count = rst.getInt(1);
                    if (count > 100) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rst != null) {
                        if (throwable != null) {
                            try {
                                rst.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rst.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                var4_7 = throwable5;
                throw throwable5;
            }
            finally {
                if (stmt != null) {
                    if (var4_7 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable6) {
                            var4_7.addSuppressed(throwable6);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.LOGGER.log(Level.INFO, "Exception counting rows", e);
            return false;
        }
    }
}

