/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import hudson.model.Result;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenDependency;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginJdbcDao;
import org.jenkinsci.plugins.pipeline.maven.db.migration.MigrationStep;
import org.jenkinsci.plugins.pipeline.maven.util.ClassUtils;
import org.jenkinsci.plugins.pipeline.maven.util.RuntimeIoException;
import org.jenkinsci.plugins.pipeline.maven.util.RuntimeSqlException;

public abstract class AbstractPipelineMavenPluginDao
implements PipelineMavenPluginJdbcDao,
Closeable {
    private static final int OPTIMIZATION_MAX_RECURSION_DEPTH = Integer.getInteger("org.jenkinsci.plugins.pipeline.PipelineMavenPluginDao.OPTIMIZATION_MAX_RECURSION_DEPTH", 3);
    protected final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    @Nonnull
    private transient DataSource ds;
    @Nullable
    private transient Long jenkinsMasterPrimaryKey;

    public AbstractPipelineMavenPluginDao(@Nonnull DataSource ds) {
        ds.getClass();
        this.ds = ds;
        this.registerJdbcDriver();
        this.initializeDatabase();
        this.testDatabase();
    }

    protected abstract void registerJdbcDriver();

    @Override
    public void recordDependency(String jobFullName, int buildNumber, String groupId, String artifactId, String version, String type, String scope, boolean ignoreUpstreamTriggers, String classifier) {
        this.LOGGER.log(Level.FINE, "recordDependency({0}#{1}, {2}:{3}:{4}:{5}, {6}, ignoreUpstreamTriggers:{7}})", new Object[]{jobFullName, buildNumber, groupId, artifactId, version, type, scope, ignoreUpstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long artifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(groupId, artifactId, version, type, classifier);
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO MAVEN_DEPENDENCY(ARTIFACT_ID, BUILD_ID, SCOPE, IGNORE_UPSTREAM_TRIGGERS) VALUES (?, ?, ?, ?)");){
                stmt.setLong(1, artifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setString(3, scope);
                stmt.setBoolean(4, ignoreUpstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    @Nonnull
    public List<MavenDependency> listDependencies(@Nonnull String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "listDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String dependenciesSql = "SELECT DISTINCT MAVEN_ARTIFACT.group_id, MAVEN_ARTIFACT.artifact_id, MAVEN_ARTIFACT.version, MAVEN_ARTIFACT.type, MAVEN_ARTIFACT.classifier,  MAVEN_DEPENDENCY.scope  FROM MAVEN_ARTIFACT  INNER JOIN MAVEN_DEPENDENCY ON MAVEN_ARTIFACT.ID = MAVEN_DEPENDENCY.ARTIFACT_ID INNER JOIN JENKINS_BUILD ON MAVEN_DEPENDENCY.BUILD_ID = JENKINS_BUILD.ID  INNER JOIN JENKINS_JOB ON JENKINS_BUILD.JOB_ID = JENKINS_JOB.ID  WHERE    JENKINS_JOB.FULL_NAME = ? AND   JENKINS_BUILD.NUMBER = ? ";
        ArrayList<MavenDependency> results = new ArrayList<MavenDependency>();
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(dependenciesSql);){
            stmt.setString(1, jobFullName);
            stmt.setInt(2, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenDependency artifact = new MavenDependency();
                    artifact.setGroupId(rst.getString("group_id"));
                    artifact.setArtifactId(rst.getString("artifact_id"));
                    artifact.setVersion(rst.getString("version"));
                    artifact.setSnapshot(artifact.getVersion().endsWith("-SNAPSHOT"));
                    artifact.setType(rst.getString("type"));
                    artifact.setClassifier(rst.getString("classifier"));
                    artifact.setScope(rst.getString("scope"));
                    results.add(artifact);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public void recordParentProject(@Nonnull String jobFullName, int buildNumber, @Nonnull String parentGroupId, @Nonnull String parentArtifactId, @Nonnull String parentVersion, boolean ignoreUpstreamTriggers) {
        this.LOGGER.log(Level.FINE, "recordParentProject({0}#{1}, {2}:{3} ignoreUpstreamTriggers:{5}})", new Object[]{jobFullName, buildNumber, parentGroupId, parentArtifactId, parentVersion, ignoreUpstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long parentArtifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(parentGroupId, parentArtifactId, parentVersion, "pom", null);
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO MAVEN_PARENT_PROJECT(ARTIFACT_ID, BUILD_ID, IGNORE_UPSTREAM_TRIGGERS) VALUES (?, ?, ?)");){
                stmt.setLong(1, parentArtifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setBoolean(3, ignoreUpstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void recordGeneratedArtifact(String jobFullName, int buildNumber, String groupId, String artifactId, String version, String type, String baseVersion, String repositoryUrl, boolean skipDownstreamTriggers, String extension, String classifier) {
        this.LOGGER.log(Level.FINE, "recordGeneratedArtifact({0}#{1}, {2}:{3}:{4}:{5}, version:{6}, repositoryUrl:{7}, skipDownstreamTriggers:{8})", new Object[]{jobFullName, buildNumber, groupId, artifactId, baseVersion, type, version, repositoryUrl, skipDownstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long artifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(groupId, artifactId, baseVersion, type, classifier);
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO GENERATED_MAVEN_ARTIFACT(ARTIFACT_ID, BUILD_ID, VERSION, REPOSITORY_URL, EXTENSION, SKIP_DOWNSTREAM_TRIGGERS) VALUES (?, ?, ?, ?, ?, ?)");){
                stmt.setLong(1, artifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setString(3, version);
                stmt.setString(4, repositoryUrl);
                stmt.setString(5, extension);
                stmt.setBoolean(6, skipDownstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void recordBuildUpstreamCause(String upstreamJobName, int upstreamBuildNumber, String downstreamJobName, int downstreamBuildNumber) {
        this.LOGGER.log(Level.FINE, "recordBuildUpstreamCause(upstreamBuild: {0}#{1}, downstreamBuild: {2}#{3})", new Object[]{upstreamJobName, upstreamBuildNumber, downstreamJobName, downstreamBuildNumber});
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            String sql = "insert into JENKINS_BUILD_UPSTREAM_CAUSE (upstream_build_id, downstream_build_id) values (?, ?)";
            long upstreamBuildPrimaryKey = this.getOrCreateBuildPrimaryKey(upstreamJobName, upstreamBuildNumber);
            long downstreamBuildPrimaryKey = this.getOrCreateBuildPrimaryKey(downstreamJobName, downstreamBuildNumber);
            try (PreparedStatement stmt = cnn.prepareStatement(sql);){
                stmt.setLong(1, upstreamBuildPrimaryKey);
                stmt.setLong(2, downstreamBuildPrimaryKey);
                int rowCount = stmt.executeUpdate();
                if (rowCount != 1) {
                    this.LOGGER.log(Level.INFO, "More/less ({0}) than 1 record inserted in JENKINS_BUILD_UPSTREAM_CAUSE for upstreamBuild: {1}#{2}, downstreamBuild: {3}#{4}", new Object[]{rowCount, upstreamJobName, upstreamBuildNumber, downstreamJobName, downstreamBuildNumber});
                }
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void renameJob(String oldFullName, String newFullName) {
        this.LOGGER.log(Level.FINER, "renameJob({0}, {1})", new Object[]{oldFullName, newFullName});
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("UPDATE JENKINS_JOB SET FULL_NAME = ? WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, newFullName);
                stmt.setString(2, oldFullName);
                stmt.setLong(3, this.getJenkinsMasterPrimaryKey(cnn));
                int count = stmt.executeUpdate();
                this.LOGGER.log(Level.FINE, "renameJob({0}, {1}): {2}", new Object[]{oldFullName, newFullName, count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void deleteJob(String jobFullName) {
        this.LOGGER.log(Level.FINER, "deleteJob({0})", new Object[]{jobFullName});
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("DELETE FROM JENKINS_JOB WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, jobFullName);
                stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                int count = stmt.executeUpdate();
                this.LOGGER.log(Level.FINE, "deleteJob({0}): {1}", new Object[]{jobFullName, count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void deleteBuild(String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "deleteBuild({0}#{1})", new Object[]{jobFullName, buildNumber});
        try (Connection cnn = this.ds.getConnection();){
            Integer lastSuccessfulBuildNumber;
            Integer lastBuildNumber;
            Long jobPrimaryKey;
            Throwable throwable;
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID, LAST_BUILD_NUMBER, LAST_SUCCESSFUL_BUILD_NUMBER FROM JENKINS_JOB WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, jobFullName);
                stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                throwable = null;
                try (ResultSet rst = stmt.executeQuery();){
                    if (rst.next()) {
                        jobPrimaryKey = rst.getLong("ID");
                        lastBuildNumber = rst.getInt("LAST_BUILD_NUMBER");
                        lastSuccessfulBuildNumber = rst.getInt("LAST_SUCCESSFUL_BUILD_NUMBER");
                    } else {
                        jobPrimaryKey = null;
                        lastBuildNumber = null;
                        lastSuccessfulBuildNumber = null;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            if (jobPrimaryKey == null) {
                this.LOGGER.log(Level.FINE, "No record found for job {0}", new Object[]{jobFullName});
                return;
            }
            if (buildNumber == lastBuildNumber || buildNumber == lastSuccessfulBuildNumber) {
                Integer newLastBuildNumber = lastBuildNumber == buildNumber ? null : lastBuildNumber;
                Integer newLastSuccessfulBuildNumber = lastSuccessfulBuildNumber == buildNumber ? null : lastSuccessfulBuildNumber;
                throwable = null;
                try (PreparedStatement stmt = cnn.prepareStatement("SELECT JENKINS_BUILD.number, JENKINS_BUILD.result_id FROM JENKINS_BUILD WHERE JOB_ID = ? AND NUMBER != ? ORDER BY NUMBER DESC");){
                    stmt.setLong(1, jobPrimaryKey);
                    stmt.setInt(2, buildNumber);
                    stmt.setFetchSize(5);
                    try (ResultSet rst = stmt.executeQuery();){
                        while (rst.next() && (newLastBuildNumber == null || newLastSuccessfulBuildNumber == null)) {
                            int currentBuildNumber = rst.getInt("number");
                            int currentBuildResultId = rst.getInt("result_id");
                            if (newLastBuildNumber == null) {
                                newLastBuildNumber = currentBuildNumber;
                            }
                            if (newLastSuccessfulBuildNumber != null || Result.SUCCESS.ordinal != currentBuildResultId) continue;
                            newLastSuccessfulBuildNumber = currentBuildNumber;
                        }
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                stmt = cnn.prepareStatement("UPDATE JENKINS_JOB SET LAST_BUILD_NUMBER = ?, LAST_SUCCESSFUL_BUILD_NUMBER = ? WHERE ID = ?");
                throwable = null;
                try {
                    stmt.setInt(1, newLastBuildNumber);
                    stmt.setInt(2, newLastSuccessfulBuildNumber);
                    stmt.setLong(3, jobPrimaryKey);
                    stmt.execute();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            stmt = cnn.prepareStatement("DELETE FROM JENKINS_BUILD WHERE JOB_ID = ? AND NUMBER = ?");
            var9_8 = null;
            try {
                stmt.setLong(1, jobPrimaryKey);
                stmt.setInt(2, buildNumber);
                int count = stmt.executeUpdate();
                this.LOGGER.log(Level.FINE, "deleteJob({0}#{1}): {2}", new Object[]{jobFullName, buildNumber, count});
            }
            catch (Throwable throwable6) {
                var9_8 = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (var9_8 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            var9_8.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void cleanup() {
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            String sql = "DELETE FROM MAVEN_ARTIFACT WHERE ID NOT IN (SELECT DISTINCT ARTIFACT_ID FROM MAVEN_DEPENDENCY UNION SELECT DISTINCT ARTIFACT_ID FROM GENERATED_MAVEN_ARTIFACT)";
            try (Statement stmt = cnn.createStatement();){
                int count = stmt.executeUpdate(sql);
                this.LOGGER.log(Level.FINE, "cleanup(): {0}", new Object[]{count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getOrCreateBuildPrimaryKey(String jobFullName, int buildNumber) {
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            Long jobPrimaryKey = null;
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_JOB WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, jobFullName);
                stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                try (ResultSet rst = stmt.executeQuery();){
                    if (rst.next()) {
                        jobPrimaryKey = rst.getLong(1);
                    }
                }
            }
            if (jobPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO JENKINS_JOB(FULL_NAME, JENKINS_MASTER_ID) VALUES (?, ?)", 1);
                var7_9 = null;
                try {
                    stmt.setString(1, jobFullName);
                    stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                    stmt.execute();
                    jobPrimaryKey = this.getGeneratedPrimaryKey(stmt, "ID");
                }
                catch (Throwable throwable) {
                    var7_9 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var7_9 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var7_9.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            Long buildPrimaryKey = null;
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_BUILD WHERE JOB_ID=? AND NUMBER=?");){
                stmt.setLong(1, jobPrimaryKey);
                stmt.setInt(2, buildNumber);
                try (ResultSet rst = stmt.executeQuery();){
                    if (rst.next()) {
                        buildPrimaryKey = rst.getLong(1);
                    }
                }
            }
            if (buildPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO JENKINS_BUILD(JOB_ID, NUMBER) VALUES (?, ?)", 1);
                var8_11 = null;
                try {
                    stmt.setLong(1, jobPrimaryKey);
                    stmt.setInt(2, buildNumber);
                    stmt.execute();
                    buildPrimaryKey = this.getGeneratedPrimaryKey(stmt, "ID");
                }
                catch (Throwable throwable) {
                    var8_11 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var8_11 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var8_11.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            cnn.commit();
            long l = buildPrimaryKey;
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected Long getGeneratedPrimaryKey(PreparedStatement stmt, String column) throws SQLException {
        Long jobPrimaryKey;
        block13: {
            try (ResultSet rst = stmt.getGeneratedKeys();){
                if (rst.next()) {
                    jobPrimaryKey = rst.getLong(1);
                    break block13;
                }
                throw new IllegalStateException();
            }
        }
        return jobPrimaryKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getOrCreateArtifactPrimaryKey(@Nonnull String groupId, @Nonnull String artifactId, @Nonnull String version, @Nonnull String type, @Nullable String classifier) {
        try (Connection cnn = this.ds.getConnection();){
            Throwable throwable;
            PreparedStatement stmt;
            Long artifactPrimaryKey;
            block78: {
                ResultSet rst2;
                cnn.setAutoCommit(false);
                artifactPrimaryKey = null;
                if (classifier == null) {
                    stmt = cnn.prepareStatement("SELECT ID FROM MAVEN_ARTIFACT WHERE GROUP_ID = ? AND ARTIFACT_ID = ? AND VERSION = ? AND TYPE = ? AND CLASSIFIER is NULL");
                    throwable = null;
                    try {
                        stmt.setString(1, groupId);
                        stmt.setString(2, artifactId);
                        stmt.setString(3, version);
                        stmt.setString(4, type);
                        rst2 = stmt.executeQuery();
                        Throwable throwable2 = null;
                        try {
                            if (rst2.next()) {
                                artifactPrimaryKey = rst2.getLong(1);
                            }
                            break block78;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rst2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        rst2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                } else {
                                    rst2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable rst2) {
                        throwable = rst2;
                        throw rst2;
                    }
                    finally {
                        if (stmt != null) {
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable rst2) {
                                    throwable.addSuppressed(rst2);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                stmt = cnn.prepareStatement("SELECT ID FROM MAVEN_ARTIFACT WHERE GROUP_ID = ? AND ARTIFACT_ID = ? AND VERSION = ? AND TYPE = ? AND CLASSIFIER = ?");
                throwable = null;
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, artifactId);
                    stmt.setString(3, version);
                    stmt.setString(4, type);
                    stmt.setString(5, classifier);
                    rst2 = stmt.executeQuery();
                    Throwable throwable5 = null;
                    try {
                        if (rst2.next()) {
                            artifactPrimaryKey = rst2.getLong(1);
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable5 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (rst2 != null) {
                            if (throwable5 != null) {
                                try {
                                    rst2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable5.addSuppressed(throwable7);
                                }
                            } else {
                                rst2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            if (artifactPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO MAVEN_ARTIFACT(GROUP_ID, ARTIFACT_ID, VERSION, TYPE, CLASSIFIER) VALUES (?, ?, ?, ?, ?)", 1);
                throwable = null;
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, artifactId);
                    stmt.setString(3, version);
                    stmt.setString(4, type);
                    stmt.setString(5, classifier);
                    stmt.execute();
                    artifactPrimaryKey = this.getGeneratedPrimaryKey(stmt, "ID");
                }
                catch (Throwable throwable10) {
                    throwable = throwable10;
                    throw throwable10;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable11) {
                                throwable.addSuppressed(throwable11);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            cnn.commit();
            long l = artifactPrimaryKey;
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected synchronized void initializeDatabase() {
        try (Connection cnn = this.ds.getConnection();){
            String sqlScriptPath;
            InputStream sqlScriptInputStream;
            cnn.setAutoCommit(false);
            int initialSchemaVersion = this.getSchemaVersion(cnn);
            this.LOGGER.log(Level.FINE, "Initialise database. Current schema version: {0}", new Object[]{initialSchemaVersion});
            DecimalFormat numberFormat = new DecimalFormat("00");
            int idx = initialSchemaVersion;
            while ((sqlScriptInputStream = ClassUtils.getResourceAsStream(sqlScriptPath = "sql/" + this.getJdbcScheme() + "/" + numberFormat.format(++idx) + "_migration.sql")) != null) {
                String sqlScript;
                try {
                    sqlScript = IOUtils.toString((InputStream)sqlScriptInputStream);
                }
                catch (IOException e) {
                    throw new RuntimeIoException("Exception reading " + sqlScriptPath, e);
                }
                this.LOGGER.log(Level.FINE, "Execute database migration script {0}", sqlScriptPath);
                for (String sqlCommand : sqlScript.split(";")) {
                    if ((sqlCommand = sqlCommand.trim()).isEmpty()) continue;
                    try (Statement stmt = cnn.createStatement();){
                        this.LOGGER.log(Level.FINER, "Execute command {0}", sqlCommand);
                        stmt.execute(sqlCommand);
                    }
                    catch (SQLException e) {
                        this.handleDatabaseInitialisationException(e);
                    }
                }
                String className = "org.jenkinsci.plugins.pipeline.maven.db.migration." + this.getJdbcScheme() + ".MigrationStep" + idx;
                try {
                    MigrationStep migrationStep = (MigrationStep)Class.forName(className).newInstance();
                    this.LOGGER.log(Level.FINE, "Execute database migration step {0}", migrationStep.getClass().getName());
                    migrationStep.execute(cnn, this.getJenkinsDetails());
                }
                catch (ClassNotFoundException e) {
                    this.LOGGER.log(Level.FINER, "Migration step {0} not found", new Object[]{className});
                }
                catch (Exception e) {
                    cnn.rollback();
                    throw new RuntimeException(e);
                }
                cnn.commit();
            }
            int newSchemaVersion = this.getSchemaVersion(cnn);
            if (newSchemaVersion == 0) {
                throw new IllegalStateException("Failure to load database DDL files. Files 'sql/" + this.getJdbcScheme() + "/xxx_migration.sql' NOT found in the Thread Context Class Loader.  Pipeline Maven Plugin may be installed in an unsupported manner (thread.contextClassLoader: " + Thread.currentThread().getContextClassLoader() + ", classLoader: " + ClassUtils.class.getClassLoader() + ")");
            }
            if (newSchemaVersion == initialSchemaVersion) {
            } else {
                this.LOGGER.log(Level.INFO, "Database successfully migrated from version {0} to version {1}", new Object[]{initialSchemaVersion, newSchemaVersion});
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected void handleDatabaseInitialisationException(SQLException e) {
        throw new RuntimeSqlException(e);
    }

    public abstract String getJdbcScheme();

    protected int getSchemaVersion(Connection cnn) throws SQLException {
        int schemaVersion;
        block29: {
            try (Statement stmt = cnn.createStatement();){
                try (ResultSet rst = stmt.executeQuery("SELECT * FROM VERSION");){
                    schemaVersion = rst.next() ? rst.getInt(1) : 0;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 42102) {
                        schemaVersion = 0;
                        break block29;
                    }
                    if (e.getErrorCode() == 1146) {
                        schemaVersion = 0;
                        break block29;
                    }
                    if ("42P01".equals(e.getSQLState())) {
                        schemaVersion = 0;
                        cnn.rollback();
                        break block29;
                    }
                    throw new RuntimeSqlException(e);
                }
            }
        }
        return schemaVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void testDatabase() throws RuntimeSqlException {
        try (Connection cnn = this.ds.getConnection();){
            List<String> tables = Arrays.asList("MAVEN_ARTIFACT", "JENKINS_JOB", "JENKINS_BUILD", "MAVEN_DEPENDENCY", "GENERATED_MAVEN_ARTIFACT", "MAVEN_PARENT_PROJECT");
            for (String table : tables) {
                try {
                    Statement stmt = cnn.createStatement();
                    Throwable throwable = null;
                    try {
                        ResultSet rst = stmt.executeQuery("SELECT count(*) FROM " + table);
                        Throwable throwable2 = null;
                        try {
                            if (!rst.next()) throw new IllegalStateException("Exception testing table '" + table + "'");
                            int count = rst.getInt(1);
                            this.LOGGER.log(Level.FINE, "Table {0}: {1} rows", new Object[]{table, count});
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rst == null) continue;
                            if (throwable2 != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            rst.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (stmt == null) continue;
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeSqlException("Exception testing table '" + table + "' on " + cnn.toString(), e);
                    return;
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    @Nonnull
    @Deprecated
    public List<String> listDownstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        List<String> downstreamJobs = this.listDownstreamPipelinesBasedOnMavenDependencies(jobFullName, buildNumber);
        downstreamJobs.addAll(this.listDownstreamPipelinesBasedOnParentProjectDependencies(jobFullName, buildNumber));
        downstreamJobs.remove(jobFullName);
        return downstreamJobs;
    }

    @Override
    @Nonnull
    public Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifact(@Nonnull String jobFullName, int buildNumber) {
        MavenArtifact mavenArtifact;
        Map<MavenArtifact, SortedSet<String>> downstreamJobsByArtifactBasedOnMavenDependencies = this.listDownstreamJobsByArtifactBasedOnMavenDependencies(jobFullName, buildNumber);
        Map<MavenArtifact, SortedSet<String>> downstreamJobsByArtifactBasedOnParentProjectDependencies = this.listDownstreamJobsByArtifactBasedOnParentProjectDependencies(jobFullName, buildNumber);
        HashMap<MavenArtifact, SortedSet<String>> results = new HashMap<MavenArtifact, SortedSet<String>>();
        results.putAll(downstreamJobsByArtifactBasedOnMavenDependencies);
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : downstreamJobsByArtifactBasedOnParentProjectDependencies.entrySet()) {
            mavenArtifact = entry.getKey();
            if (results.containsKey(mavenArtifact)) {
                ((SortedSet)results.get(mavenArtifact)).addAll((Collection)entry.getValue());
                continue;
            }
            results.put(mavenArtifact, new TreeSet<String>(entry.getValue()));
        }
        Iterator it = results.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<MavenArtifact, SortedSet<String>> entry;
            entry = it.next();
            mavenArtifact = entry.getKey();
            SortedSet<String> jobs = entry.getValue();
            boolean removed = jobs.remove(jobFullName);
            if (!removed) continue;
            this.LOGGER.log(Level.FINER, "Remove {0} from downstreamJobs of artifact {1}", new Object[]{jobFullName, mavenArtifact});
            if (!jobs.isEmpty()) continue;
            it.remove();
        }
        return results;
    }

    @Override
    @Nonnull
    public SortedSet<String> listDownstreamJobs(@Nonnull String groupId, @Nonnull String artifactId, @Nonnull String version, @Nullable String baseVersion, @Nonnull String type) {
        return this.listDownstreamPipelinesBasedOnMavenDependencies(groupId, artifactId, baseVersion == null ? version : baseVersion, type);
    }

    protected SortedSet<String> listDownstreamPipelinesBasedOnMavenDependencies(@Nonnull String groupId, @Nonnull String artifactId, @Nonnull String version, @Nonnull String type) {
        this.LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnMavenDependencies({0}:{1}:{2}:{3})", new Object[]{groupId, artifactId, version, type});
        String sql = "select distinct downstream_job.full_name \nfrom MAVEN_ARTIFACT  \ninner join MAVEN_DEPENDENCY on (MAVEN_DEPENDENCY.artifact_id = MAVEN_ARTIFACT.id and MAVEN_DEPENDENCY.ignore_upstream_triggers = false) \ninner join JENKINS_BUILD as downstream_build on MAVEN_DEPENDENCY.build_id = downstream_build.id \ninner join JENKINS_JOB as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere MAVEN_ARTIFACT.group_id = ? and MAVEN_ARTIFACT.artifact_id = ? and MAVEN_ARTIFACT.version = ? and MAVEN_ARTIFACT.type = ? and downstream_job.jenkins_master_id = ?";
        TreeSet<String> downstreamJobsFullNames = new TreeSet<String>();
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, groupId);
            stmt.setString(2, artifactId);
            stmt.setString(3, version);
            stmt.setString(4, type);
            stmt.setLong(5, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnMavenDependencies({0}:{1}:{2}:{3}): {4}", new Object[]{groupId, artifactId, version, type, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }

    @Deprecated
    protected List<String> listDownstreamPipelinesBasedOnMavenDependencies(@Nonnull String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "listDownstreamJobs({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name \nfrom JENKINS_JOB as upstream_job \ninner join JENKINS_BUILD as upstream_build on upstream_job.id = upstream_build.job_id \ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false) \ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id \ninner join MAVEN_DEPENDENCY on (MAVEN_DEPENDENCY.artifact_id = MAVEN_ARTIFACT.id and MAVEN_DEPENDENCY.ignore_upstream_triggers = false) \ninner join JENKINS_BUILD as downstream_build on MAVEN_DEPENDENCY.build_id = downstream_build.id \ninner join JENKINS_JOB as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        ArrayList<String> downstreamJobsFullNames = new ArrayList<String>();
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listDownstreamJobs({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }

    protected Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifactBasedOnMavenDependencies(@Nonnull String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "listDownstreamJobsByArtifactBasedOnMavenDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name, \n    MAVEN_ARTIFACT.group_id, MAVEN_ARTIFACT.artifact_id, MAVEN_ARTIFACT.version as base_version, MAVEN_ARTIFACT.type, MAVEN_ARTIFACT.classifier, \n   GENERATED_MAVEN_ARTIFACT.version as version, GENERATED_MAVEN_ARTIFACT.extension \nfrom JENKINS_JOB as upstream_job \ninner join JENKINS_BUILD as upstream_build on upstream_job.id = upstream_build.job_id \ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false) \ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id \ninner join MAVEN_DEPENDENCY on (MAVEN_DEPENDENCY.artifact_id = MAVEN_ARTIFACT.id and MAVEN_DEPENDENCY.ignore_upstream_triggers = false) \ninner join JENKINS_BUILD as downstream_build on MAVEN_DEPENDENCY.build_id = downstream_build.id \ninner join JENKINS_JOB as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        HashMap<MavenArtifact, SortedSet<String>> results = new HashMap<MavenArtifact, SortedSet<String>>();
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenArtifact artifact = new MavenArtifact();
                    artifact.setGroupId(rst.getString("group_id"));
                    artifact.setArtifactId(rst.getString("artifact_id"));
                    artifact.setVersion(rst.getString("version"));
                    artifact.setBaseVersion(rst.getString("base_version"));
                    artifact.setType(rst.getString("type"));
                    artifact.setClassifier(rst.getString("classifier"));
                    artifact.setExtension(rst.getString("extension"));
                    String downstreamJobFullName = rst.getString("full_name");
                    results.computeIfAbsent(artifact, a -> new TreeSet()).add(downstreamJobFullName);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listDownstreamJobsByArtifactBasedOnMavenDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, results});
        return results;
    }

    @Deprecated
    protected List<String> listDownstreamPipelinesBasedOnParentProjectDependencies(@Nonnull String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name \nfrom JENKINS_JOB as upstream_job \ninner join JENKINS_BUILD as upstream_build on upstream_job.id = upstream_build.job_id \ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false) \ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id \ninner join MAVEN_PARENT_PROJECT on (MAVEN_PARENT_PROJECT.artifact_id = MAVEN_ARTIFACT.id and MAVEN_PARENT_PROJECT.ignore_upstream_triggers = false) \ninner join JENKINS_BUILD as downstream_build on MAVEN_PARENT_PROJECT.build_id = downstream_build.id \ninner join JENKINS_JOB as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        ArrayList<String> downstreamJobsFullNames = new ArrayList<String>();
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }

    protected Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifactBasedOnParentProjectDependencies(String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name, \n   MAVEN_ARTIFACT.group_id, MAVEN_ARTIFACT.artifact_id, MAVEN_ARTIFACT.version as base_version, MAVEN_ARTIFACT.type, MAVEN_ARTIFACT.classifier, \n   GENERATED_MAVEN_ARTIFACT.version as version, GENERATED_MAVEN_ARTIFACT.extension \nfrom JENKINS_JOB as upstream_job \ninner join JENKINS_BUILD as upstream_build on upstream_job.id = upstream_build.job_id \ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false) \ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id \ninner join MAVEN_PARENT_PROJECT on (MAVEN_PARENT_PROJECT.artifact_id = MAVEN_ARTIFACT.id and MAVEN_PARENT_PROJECT.ignore_upstream_triggers = false) \ninner join JENKINS_BUILD as downstream_build on MAVEN_PARENT_PROJECT.build_id = downstream_build.id \ninner join JENKINS_JOB as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        HashMap<MavenArtifact, SortedSet<String>> results = new HashMap<MavenArtifact, SortedSet<String>>();
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenArtifact artifact = new MavenArtifact();
                    artifact.setGroupId(rst.getString("group_id"));
                    artifact.setArtifactId(rst.getString("artifact_id"));
                    artifact.setVersion(rst.getString("version"));
                    artifact.setBaseVersion(rst.getString("base_version"));
                    artifact.setType(rst.getString("type"));
                    artifact.setClassifier(rst.getString("classifier"));
                    artifact.setExtension(rst.getString("extension"));
                    String downstreamJobFullName = rst.getString("full_name");
                    results.computeIfAbsent(artifact, a -> new TreeSet()).add(downstreamJobFullName);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listDownstreamJobsByArtifactBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, results});
        return results;
    }

    @Override
    @Nonnull
    public Map<String, Integer> listUpstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        Map<String, Integer> upstreamJobs = this.listUpstreamPipelinesBasedOnMavenDependencies(jobFullName, buildNumber);
        upstreamJobs.putAll(this.listUpstreamPipelinesBasedOnParentProjectDependencies(jobFullName, buildNumber));
        upstreamJobs.remove(jobFullName);
        return upstreamJobs;
    }

    protected Map<String, Integer> listUpstreamPipelinesBasedOnMavenDependencies(@Nonnull String downstreamJobFullName, int downstreamBuildNumber) {
        this.LOGGER.log(Level.FINER, "listUpstreamPipelinesBasedOnMavenDependencies({0}, {1})", new Object[]{downstreamJobFullName, downstreamBuildNumber});
        String sql = "select  upstream_job.full_name, upstream_build.number\nfrom JENKINS_JOB as upstream_job\ninner join JENKINS_BUILD as upstream_build on (upstream_job.id = upstream_build.job_id and upstream_job.last_successful_build_number = upstream_build.number)\ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id  and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false)\ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id\ninner join MAVEN_DEPENDENCY on (MAVEN_DEPENDENCY.artifact_id = MAVEN_ARTIFACT.id and MAVEN_DEPENDENCY.ignore_upstream_triggers = false)\ninner join JENKINS_BUILD as downstream_build on MAVEN_DEPENDENCY.build_id = downstream_build.id\ninner join JENKINS_JOB as downstream_job on downstream_build.job_id = downstream_job.id\nwhere downstream_job.full_name = ? and downstream_job.jenkins_master_id = ? and  downstream_build.number = ? and upstream_job.jenkins_master_id = ?";
        HashMap<String, Integer> upstreamJobsFullNames = new HashMap<String, Integer>();
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, downstreamJobFullName, downstreamBuildNumber});
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, downstreamJobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, downstreamBuildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    upstreamJobsFullNames.put(rst.getString(1), rst.getInt(2));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listUpstreamPipelinesBasedOnMavenDependencies({0}, {1}): {2}", new Object[]{downstreamJobFullName, downstreamBuildNumber, upstreamJobsFullNames});
        return upstreamJobsFullNames;
    }

    protected Map<String, Integer> listUpstreamPipelinesBasedOnParentProjectDependencies(@Nonnull String downstreamJobFullName, int downstreamBuildNumber) {
        this.LOGGER.log(Level.FINER, "listUpstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{downstreamJobFullName, downstreamBuildNumber});
        String sql = "select  upstream_job.full_name, upstream_build.number\nfrom JENKINS_JOB as upstream_job\ninner join JENKINS_BUILD as upstream_build on (upstream_job.id = upstream_build.job_id and upstream_job.last_successful_build_number = upstream_build.number)\ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id  and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false)\ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id\ninner join MAVEN_PARENT_PROJECT on (MAVEN_PARENT_PROJECT.artifact_id = MAVEN_ARTIFACT.id and MAVEN_PARENT_PROJECT.ignore_upstream_triggers = false)\ninner join JENKINS_BUILD as downstream_build on MAVEN_PARENT_PROJECT.build_id = downstream_build.id\ninner join JENKINS_JOB as downstream_job on downstream_build.job_id = downstream_job.id\nwhere downstream_job.full_name = ? and downstream_job.jenkins_master_id = ? and  downstream_build.number = ? and upstream_job.jenkins_master_id = ?";
        HashMap<String, Integer> upstreamJobsFullNames = new HashMap<String, Integer>();
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, downstreamJobFullName, downstreamBuildNumber});
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, downstreamJobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, downstreamBuildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    upstreamJobsFullNames.put(rst.getString(1), rst.getInt(2));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listUpstreamPipelinesBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{downstreamJobFullName, downstreamBuildNumber, upstreamJobsFullNames});
        return upstreamJobsFullNames;
    }

    @Override
    @Nonnull
    public Map<String, Integer> listTransitiveUpstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        return this.listTransitiveUpstreamJobs(jobFullName, buildNumber, new HashMap<String, Integer>(), 0);
    }

    private Map<String, Integer> listTransitiveUpstreamJobs(@Nonnull String jobFullName, int buildNumber, Map<String, Integer> transitiveUpstreamBuilds, int recursionDepth) {
        Map<String, Integer> upstreamBuilds = this.listUpstreamJobs(jobFullName, buildNumber);
        for (Map.Entry<String, Integer> upstreamBuild : upstreamBuilds.entrySet()) {
            String upstreamJobFullName = upstreamBuild.getKey();
            Integer upstreamBuildNumber = upstreamBuild.getValue();
            if (transitiveUpstreamBuilds.containsKey(upstreamJobFullName)) continue;
            transitiveUpstreamBuilds.put(upstreamJobFullName, upstreamBuildNumber);
            if (recursionDepth >= OPTIMIZATION_MAX_RECURSION_DEPTH) continue;
            this.listTransitiveUpstreamJobs(upstreamJobFullName, upstreamBuildNumber, transitiveUpstreamBuilds, recursionDepth++);
        }
        return transitiveUpstreamBuilds;
    }

    @Override
    @Nonnull
    public List<MavenArtifact> getGeneratedArtifacts(@Nonnull String jobFullName, @Nonnull int buildNumber) {
        this.LOGGER.log(Level.FINER, "getGeneratedArtifacts({0}, {1})", new Object[]{jobFullName, buildNumber});
        String generatedArtifactsSql = "SELECT DISTINCT MAVEN_ARTIFACT.group_id, MAVEN_ARTIFACT.artifact_id, MAVEN_ARTIFACT.type, MAVEN_ARTIFACT.classifier, MAVEN_ARTIFACT.version as base_version, GENERATED_MAVEN_ARTIFACT.version as version, GENERATED_MAVEN_ARTIFACT.repository_url, GENERATED_MAVEN_ARTIFACT.extension FROM MAVEN_ARTIFACT  INNER JOIN GENERATED_MAVEN_ARTIFACT ON MAVEN_ARTIFACT.ID = GENERATED_MAVEN_ARTIFACT.ARTIFACT_ID INNER JOIN JENKINS_BUILD AS UPSTREAM_BUILD ON GENERATED_MAVEN_ARTIFACT.BUILD_ID = UPSTREAM_BUILD.ID  INNER JOIN JENKINS_JOB AS UPSTREAM_JOB ON UPSTREAM_BUILD.JOB_ID = UPSTREAM_JOB.ID  WHERE    UPSTREAM_JOB.FULL_NAME = ? AND   UPSTREAM_JOB.JENKINS_MASTER_ID = ? AND   UPSTREAM_BUILD.NUMBER = ? ";
        ArrayList<MavenArtifact> results = new ArrayList<MavenArtifact>();
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(generatedArtifactsSql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenArtifact artifact = new MavenArtifact();
                    artifact.setGroupId(rst.getString("group_id"));
                    artifact.setArtifactId(rst.getString("artifact_id"));
                    artifact.setBaseVersion(rst.getString("base_version"));
                    artifact.setType(rst.getString("type"));
                    artifact.setClassifier(rst.getString("classifier"));
                    String version = rst.getString("version");
                    if (version == null || version.isEmpty()) {
                        version = rst.getString("base_version");
                    }
                    artifact.setVersion(version);
                    artifact.setRepositoryUrl(rst.getString("repository_url"));
                    artifact.setExtension(rst.getString("extension"));
                    artifact.setSnapshot(artifact.getVersion().endsWith("-SNAPSHOT"));
                    results.add(artifact);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        Collections.sort(results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public synchronized Long getJenkinsMasterPrimaryKey(Connection cnn) throws SQLException {
        block60: {
            if (this.jenkinsMasterPrimaryKey == null) {
                String jenkinsMasterLegacyInstanceId = this.getJenkinsDetails().getMasterLegacyInstanceId();
                String jenkinsMasterUrl = this.getJenkinsDetails().getMasterRootUrl();
                String jenkinsMasterUrlValueInDb = null;
                try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID, URL FROM JENKINS_MASTER WHERE LEGACY_INSTANCE_ID=?");){
                    stmt.setString(1, jenkinsMasterLegacyInstanceId);
                    try (ResultSet rst = stmt.executeQuery();){
                        if (rst.next()) {
                            this.jenkinsMasterPrimaryKey = rst.getLong("ID");
                            jenkinsMasterUrlValueInDb = rst.getString("URL");
                        }
                    }
                }
                if (this.jenkinsMasterPrimaryKey == null) {
                    try {
                        stmt = cnn.prepareStatement("INSERT INTO JENKINS_MASTER(LEGACY_INSTANCE_ID, URL) values (?, ?)", 1);
                        var6_6 = null;
                        try {
                            stmt.setString(1, jenkinsMasterLegacyInstanceId);
                            stmt.setString(2, jenkinsMasterUrl);
                            stmt.execute();
                            this.jenkinsMasterPrimaryKey = this.getGeneratedPrimaryKey(stmt, "ID");
                            break block60;
                        }
                        catch (Throwable rst) {
                            var6_6 = rst;
                            throw rst;
                        }
                        finally {
                            if (stmt != null) {
                                if (var6_6 != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable rst) {
                                        var6_6.addSuppressed(rst);
                                    }
                                } else {
                                    stmt.close();
                                }
                            }
                        }
                    }
                    finally {
                        cnn.commit();
                    }
                }
                if (!Objects.equals(jenkinsMasterUrl, jenkinsMasterUrlValueInDb)) {
                    this.LOGGER.log(Level.INFO, "Update url from \"{0}\" to \"{1}\" for master with legacyId {2}", new Object[]{jenkinsMasterUrlValueInDb, jenkinsMasterUrl, jenkinsMasterLegacyInstanceId});
                    try {
                        stmt = cnn.prepareStatement("UPDATE JENKINS_MASTER set URL = ? where ID = ?");
                        var6_6 = null;
                        try {
                            stmt.setString(1, jenkinsMasterUrl);
                            stmt.setLong(2, this.jenkinsMasterPrimaryKey);
                            int count = stmt.executeUpdate();
                            if (count != 1) {
                                this.LOGGER.warning("Updated more/less than 1 JENKINS_MASTER.URL=" + jenkinsMasterUrl + " for ID=" + this.jenkinsMasterPrimaryKey);
                            }
                        }
                        catch (Throwable throwable) {
                            var6_6 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (stmt != null) {
                                if (var6_6 != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable) {
                                        var6_6.addSuppressed(throwable);
                                    }
                                } else {
                                    stmt.close();
                                }
                            }
                        }
                    }
                    finally {
                        cnn.commit();
                    }
                }
            }
        }
        return this.jenkinsMasterPrimaryKey;
    }

    protected MigrationStep.JenkinsDetails getJenkinsDetails() {
        return new MigrationStep.JenkinsDetails();
    }

    @Override
    public String toPrettyString() {
        ArrayList<String> prettyStrings = new ArrayList<String>();
        try {
            Connection cnn = this.ds.getConnection();
            Object object = null;
            try {
                prettyStrings.add("JDBC URL: " + cnn.getMetaData().getURL());
                List<String> tables = Arrays.asList("JENKINS_MASTER", "MAVEN_ARTIFACT", "JENKINS_JOB", "JENKINS_BUILD", "MAVEN_DEPENDENCY", "GENERATED_MAVEN_ARTIFACT", "MAVEN_PARENT_PROJECT", "JENKINS_BUILD_UPSTREAM_CAUSE");
                for (String table : tables) {
                    try {
                        Statement stmt = cnn.createStatement();
                        Throwable throwable = null;
                        try {
                            ResultSet rst = stmt.executeQuery("SELECT count(*) FROM " + table);
                            Throwable throwable2 = null;
                            try {
                                if (rst.next()) {
                                    int count = rst.getInt(1);
                                    prettyStrings.add("Table " + table + ": " + count + " rows");
                                    continue;
                                }
                                prettyStrings.add("Table " + table + ": #IllegalStateException 'select count(*)' didn't return any row#");
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (rst == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        rst.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                rst.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        prettyStrings.add("Table " + table + ": " + e);
                        this.LOGGER.log(Level.WARNING, "SQLException counting rows on " + table, e);
                    }
                }
            }
            catch (Throwable tables) {
                object = tables;
                throw tables;
            }
            finally {
                if (cnn != null) {
                    if (object != null) {
                        try {
                            cnn.close();
                        }
                        catch (Throwable tables) {
                            ((Throwable)object).addSuppressed(tables);
                        }
                    } else {
                        cnn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            prettyStrings.add("SQLException getting a connection to " + this.ds + ": " + e);
            this.LOGGER.log(Level.WARNING, "SQLException getting a connection to " + this.ds, e);
        }
        StringBuilder result = new StringBuilder(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)".") + " - " + this.getDatabaseDescription());
        for (String prettyString : prettyStrings) {
            result.append("\r\n\t" + prettyString);
        }
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getDatabaseDescription() {
        try (Connection cnn = this.ds.getConnection();){
            DatabaseMetaData metaData = cnn.getMetaData();
            String string = metaData.getDatabaseProductName() + " " + metaData.getDatabaseProductVersion();
            return string;
        }
        catch (SQLException e) {
            return "#" + e.toString() + "#";
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateBuildOnCompletion(@Nonnull String jobFullName, int buildNumber, int buildResultOrdinal, long startTimeInMillis, long durationInMillis) {
        this.LOGGER.log(Level.FINE, "updateBuildOnCompletion({0}, {1}, result: {2}, startTime): {3}, duration: {4}", new Object[]{jobFullName, buildNumber, buildResultOrdinal, startTimeInMillis, durationInMillis});
        buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        try {
            cnn = this.ds.getConnection();
            var11_9 = null;
            try {
                cnn.setAutoCommit(false);
                stmt = cnn.prepareStatement("UPDATE JENKINS_BUILD SET RESULT_ID = ?, START_TIME = ?, DURATION_IN_MILLIS = ? WHERE ID = ?");
                var13_13 = null;
                try {
                    stmt.setInt(1, buildResultOrdinal);
                    stmt.setTimestamp(2, new Timestamp(startTimeInMillis));
                    stmt.setLong(3, durationInMillis);
                    stmt.setLong(4, buildPrimaryKey);
                    count = stmt.executeUpdate();
                    if (count != 1) {
                        this.LOGGER.log(Level.WARNING, "updateBuildOnCompletion - more/less than 1 JENKINS_BUILD record updated (" + count + ") for " + jobFullName + "#" + buildNumber + ", buildPrimaryKey=" + buildPrimaryKey);
                    }
                }
                catch (Throwable count) {
                    var13_13 = count;
                    throw count;
                }
                finally {
                    if (stmt != null) {
                        if (var13_13 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable count) {
                                var13_13.addSuppressed(count);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                if (Result.SUCCESS.ordinal == buildResultOrdinal) {
                    stmt = cnn.prepareStatement("UPDATE JENKINS_JOB set LAST_BUILD_NUMBER = ?, LAST_SUCCESSFUL_BUILD_NUMBER = ? where FULL_NAME = ? and JENKINS_MASTER_ID = ?");
                    var13_13 = null;
                    try {
                        stmt.setInt(1, buildNumber);
                        stmt.setInt(2, buildNumber);
                        stmt.setString(3, jobFullName);
                        stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
                        count = stmt.executeUpdate();
                        if (count == 1) ** GOTO lbl84
                        this.LOGGER.log(Level.WARNING, "updateBuildOnCompletion - more/less than 1 JENKINS_JOB record updated (" + count + ") for " + jobFullName + "#" + buildNumber);
                    }
                    catch (Throwable count) {
                        var13_13 = count;
                        throw count;
                    }
                    finally {
                        if (stmt != null) {
                            if (var13_13 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable count) {
                                    var13_13.addSuppressed(count);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                } else {
                    stmt = cnn.prepareStatement("UPDATE JENKINS_JOB set LAST_BUILD_NUMBER = ? where FULL_NAME = ?  and JENKINS_MASTER_ID = ?");
                    var13_13 = null;
                    try {
                        stmt.setInt(1, buildNumber);
                        stmt.setString(2, jobFullName);
                        stmt.setLong(3, this.getJenkinsMasterPrimaryKey(cnn));
                        count = stmt.executeUpdate();
                        if (count != 1) {
                            this.LOGGER.log(Level.WARNING, "updateBuildOnCompletion - more/less than 1 JENKINS_JOB record updated (" + count + ") for " + jobFullName + "#" + buildNumber);
                        }
                    }
                    catch (Throwable var14_20) {
                        var13_13 = var14_20;
                        throw var14_20;
                    }
                    finally {
                        if (stmt != null) {
                            if (var13_13 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable var14_19) {
                                    var13_13.addSuppressed(var14_19);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                cnn.commit();
            }
            catch (Throwable var12_12) {
                var11_9 = var12_12;
                throw var12_12;
            }
            finally {
                if (cnn != null) {
                    if (var11_9 != null) {
                        try {
                            cnn.close();
                        }
                        catch (Throwable var12_11) {
                            var11_9.addSuppressed(var12_11);
                        }
                    } else {
                        cnn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException("Exception updating build " + jobFullName + "#" + buildNumber + " with result " + buildResultOrdinal, e);
        }
    }

    @Override
    @Nonnull
    public DataSource getDataSource() {
        return this.ds;
    }

    @Override
    public void close() throws IOException {
        if (this.ds instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)this.ds);
            closeable.close();
        }
    }
}

