/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.CompareToBuilder;

public class MavenArtifact
implements Serializable,
Comparable<MavenArtifact> {
    private static final long serialVersionUID = 1L;
    private String groupId;
    private String artifactId;
    private String version;
    private String baseVersion;
    private String type;
    private String classifier;
    private String extension;
    @Nullable
    private String file;
    private boolean snapshot;
    @Nullable
    private String repositoryUrl;

    public MavenArtifact() {
    }

    public MavenArtifact(String identifier) throws IllegalArgumentException {
        String[] args = identifier.split(":");
        switch (args.length) {
            case 4: {
                this.setGroupId(args[0]);
                this.setArtifactId(args[1]);
                this.setType(args[2]);
                this.setVersion(args[3]);
                break;
            }
            case 3: {
                this.setGroupId(args[0]);
                this.setArtifactId(args[1]);
                this.setVersion(args[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported format: " + identifier);
            }
        }
        if (this.getVersion().endsWith("SNAPSHOT")) {
            this.setSnapshot(true);
        }
    }

    @Nonnull
    public String getFileName() {
        return this.getArtifactId() + "-" + this.getVersion() + (this.getClassifier() == null || this.getClassifier().isEmpty() ? "" : "-" + this.getClassifier()) + "." + this.getExtension();
    }

    @Nonnull
    public String getFileNameWithBaseVersion() {
        return this.getArtifactId() + "-" + this.getBaseVersion() + (this.getClassifier() == null || this.getClassifier().isEmpty() ? "" : "-" + this.getClassifier()) + "." + this.getExtension();
    }

    @Nonnull
    public String getFileNameWithVersion() {
        return this.getArtifactId() + "-" + this.getVersion() + (this.getClassifier() == null || this.getClassifier().isEmpty() ? "" : "-" + this.getClassifier()) + "." + this.getExtension();
    }

    @Nonnull
    public String getId() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + ":" + (this.getClassifier() == null || this.getClassifier().isEmpty() ? "" : this.getClassifier() + ":") + (this.getBaseVersion() == null ? this.getVersion() : this.getBaseVersion());
    }

    @Nonnull
    public String getShortDescription() {
        if (this.getBaseVersion() == null) {
            return this.getId();
        }
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + ":" + (this.getClassifier() == null || this.getClassifier().isEmpty() ? "" : this.getClassifier() + ":") + this.getBaseVersion() + "(" + this.getVersion() + ")";
    }

    @Nullable
    public String getUrl() {
        if (this.getRepositoryUrl() == null) {
            return null;
        }
        return this.getRepositoryUrl() + "/" + this.getGroupId().replace('.', '/') + "/" + this.getArtifactId() + "/" + this.getBaseVersion() + "/" + this.getFileNameWithVersion();
    }

    public String toString() {
        return "MavenArtifact{" + this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + (this.getClassifier() == null ? "" : ":" + this.getClassifier()) + ":" + this.getBaseVersion() + "(version: " + this.getVersion() + ", snapshot:" + this.isSnapshot() + ") " + (this.getFile() == null ? "" : " " + this.getFile()) + '}';
    }

    @Override
    public int compareTo(MavenArtifact o) {
        return new CompareToBuilder().append((Object)this.getGroupId(), (Object)o.getGroupId()).append((Object)this.getArtifactId(), (Object)o.getArtifactId()).append((Object)this.getBaseVersion(), (Object)o.getBaseVersion()).append((Object)this.getVersion(), (Object)o.getVersion()).append((Object)this.getType(), (Object)o.getType()).append((Object)this.getClassifier(), (Object)o.getClassifier()).toComparison();
    }

    public boolean isDeployed() {
        return this.getRepositoryUrl() != null && !this.getRepositoryUrl().isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getArtifactId(), this.getBaseVersion(), this.getVersion());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtifact other = (MavenArtifact)obj;
        if (this.getGroupId() == null ? other.getGroupId() != null : !this.getGroupId().equals(other.getGroupId())) {
            return false;
        }
        if (this.getArtifactId() == null ? other.getArtifactId() != null : !this.getArtifactId().equals(other.getArtifactId())) {
            return false;
        }
        if (this.getBaseVersion() == null ? other.getBaseVersion() != null : !this.getBaseVersion().equals(other.getBaseVersion())) {
            return false;
        }
        if (this.getVersion() == null ? other.getVersion() != null : !this.getVersion().equals(other.getVersion())) {
            return false;
        }
        if (this.getType() == null ? other.getType() != null : !this.getType().equals(other.getType())) {
            return false;
        }
        return !(this.getClassifier() == null ? other.getClassifier() != null : !this.getClassifier().equals(other.getClassifier()));
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public void setBaseVersion(String baseVersion) {
        this.baseVersion = baseVersion;
        if (baseVersion != null && baseVersion.endsWith("SNAPSHOT")) {
            this.snapshot = true;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        if (version != null && version.endsWith("SNAPSHOT")) {
            this.snapshot = true;
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(@Nullable String classifier) {
        this.classifier = classifier == null || classifier.isEmpty() ? null : classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Nullable
    public String getFile() {
        return this.file;
    }

    public void setFile(@Nullable String file) {
        this.file = file;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    @Nullable
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(@Nullable String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }
}

