/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jacoco.JacocoPublisher;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.publishers.AbstractHealthAwarePublisher;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Element;

public class JacocoReportPublisher
extends MavenPublisher {
    private static final Logger LOGGER = Logger.getLogger(JacocoReportPublisher.class.getName());
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public JacocoReportPublisher() {
    }

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        FilePath workspace = (FilePath)context.get(FilePath.class);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        List<Element> jacocoPrepareAgentEvents = XmlUtils.getExecutionEventsByPlugin(mavenSpyLogsElt, "org.jacoco", "jacoco-maven-plugin", "prepare-agent", "MojoSucceeded", "MojoFailed");
        if (jacocoPrepareAgentEvents.isEmpty()) {
            LOGGER.log(Level.FINE, "No org.jacoco:jacoco-maven-plugin:prepare-agent execution found");
            return;
        }
        if (jacocoPrepareAgentEvents.size() > 1) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().print("[withMaven - Jacoco] More than 1 Maven module (" + jacocoPrepareAgentEvents.size() + ") generated a Jacoco code coverage report, skip automatic collect of Jacoco reports as the Jenkins Jacoco report is not designed to render multiple reports per build");
            }
            return;
        }
        try {
            Class.forName("hudson.plugins.jacoco.JacocoPublisher");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] Jenkins ");
            listener.hyperlink("https://wiki.jenkins.io/display/JENKINS/JaCoCo+Plugin", "JaCoCo Plugin");
            listener.getLogger().println(" not found, don't display org.jacoco:jacoco-maven-plugin:findbugs results in pipeline screen.");
            return;
        }
        for (Element jacocoPrepareAgentEvent : jacocoPrepareAgentEvents) {
            String projectBuildDirectory;
            Element buildElement = XmlUtils.getUniqueChildElementOrNull(jacocoPrepareAgentEvent, "project", "build");
            if (buildElement == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Ignore execution event with missing 'build' child:" + XmlUtils.toString(jacocoPrepareAgentEvent));
                continue;
            }
            Element pluginElt = XmlUtils.getUniqueChildElement(jacocoPrepareAgentEvent, "plugin");
            Element destFileElt = XmlUtils.getUniqueChildElementOrNull(pluginElt, "destFile");
            Element projectElt = XmlUtils.getUniqueChildElement(jacocoPrepareAgentEvent, "project");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.PluginInvocation pluginInvocation = XmlUtils.newPluginInvocation(pluginElt);
            if (destFileElt == null) {
                listener.getLogger().println("[withMaven] No <destFile> element found for <plugin> in " + XmlUtils.toString(jacocoPrepareAgentEvent));
                continue;
            }
            String destFile = destFileElt.getTextContent().trim();
            if (destFile.equals("${jacoco.destFile}")) {
                destFile = "${project.build.directory}/jacoco.exec";
                projectBuildDirectory = XmlUtils.getProjectBuildDirectory(projectElt);
                if (projectBuildDirectory == null || projectBuildDirectory.isEmpty()) {
                    listener.getLogger().println("[withMaven] '${project.build.directory}' found for <project> in " + XmlUtils.toString(jacocoPrepareAgentEvent));
                    continue;
                }
                destFile = destFile.replace("${project.build.directory}", projectBuildDirectory);
            } else if (destFile.contains("${project.build.directory}")) {
                projectBuildDirectory = XmlUtils.getProjectBuildDirectory(projectElt);
                if (projectBuildDirectory == null || projectBuildDirectory.isEmpty()) {
                    listener.getLogger().println("[withMaven] '${project.build.directory}' found for <project> in " + XmlUtils.toString(jacocoPrepareAgentEvent));
                    continue;
                }
                destFile = destFile.replace("${project.build.directory}", projectBuildDirectory);
            } else if (destFile.contains("${basedir}")) {
                String baseDir = projectElt.getAttribute("baseDir");
                if (baseDir.isEmpty()) {
                    listener.getLogger().println("[withMaven] '${basedir}' found for <project> in " + XmlUtils.toString(jacocoPrepareAgentEvent));
                    continue;
                }
                destFile = destFile.replace("${basedir}", baseDir);
            }
            destFile = XmlUtils.getPathInWorkspace(destFile, workspace);
            String sourceDirectory = buildElement.getAttribute("sourceDirectory");
            String classesDirectory = buildElement.getAttribute("directory") + "/classes";
            String sourceDirectoryRelativePath = XmlUtils.getPathInWorkspace(sourceDirectory, workspace);
            String classesDirectoryRelativePath = XmlUtils.getPathInWorkspace(classesDirectory, workspace);
            listener.getLogger().println("[withMaven] jacocoPublisher - Archive JaCoCo analysis results for Maven artifact " + mavenArtifact.toString() + " generated by " + pluginInvocation + ": execFile: " + destFile + ", sources: " + sourceDirectoryRelativePath + ", classes: " + classesDirectoryRelativePath);
            JacocoPublisher jacocoPublisher = new JacocoPublisher();
            jacocoPublisher.setExecPattern(destFile);
            jacocoPublisher.setSourcePattern(sourceDirectoryRelativePath);
            jacocoPublisher.setClassPattern(classesDirectoryRelativePath);
            try {
                jacocoPublisher.perform(run, workspace, launcher, listener);
            }
            catch (Exception e) {
                listener.error("[withMaven] jacocoPublisher - Silently ignore exception archiving JaCoCo results for Maven artifact " + mavenArtifact.toString() + " generated by " + pluginInvocation + ": " + e);
                LOGGER.log(Level.WARNING, "Exception processing " + XmlUtils.toString(jacocoPrepareAgentEvent), e);
            }
        }
    }

    @Symbol(value={"jacocoPublisher"})
    @Extension
    public static class DescriptorImpl
    extends AbstractHealthAwarePublisher.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return "Jacoco Publisher";
        }

        @Override
        public int ordinal() {
            return 20;
        }

        @Override
        @Nonnull
        public String getSkipFileName() {
            return ".skip-publish-jacoco-results";
        }
    }
}

