/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.fix.jenkins49337;

import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.pipeline.maven.fix.jenkins49337.GeneralNonBlockingStepExecutionUtils;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public abstract class GeneralNonBlockingStepExecution
extends StepExecution {
    private static final long serialVersionUID = 1L;
    private volatile transient Future<?> task;
    private String threadName;
    private transient boolean stopping;

    protected GeneralNonBlockingStepExecution(StepContext context) {
        super(context);
    }

    protected final void run(Block block) {
        if (this.stopping) {
            return;
        }
        Authentication auth = Jenkins.getAuthentication();
        this.task = GeneralNonBlockingStepExecutionUtils.getExecutorService().submit(() -> {
            this.threadName = Thread.currentThread().getName();
            try (ACLContext acl = ACL.as((Authentication)auth);){
                block.run();
            }
            catch (Throwable e) {
                if (!this.stopping) {
                    this.getContext().onFailure(e);
                }
            }
            finally {
                this.threadName = null;
                this.task = null;
            }
        });
    }

    public void stop(Throwable cause) throws Exception {
        this.stopping = true;
        if (this.task != null) {
            this.task.cancel(true);
        }
        super.stop(cause);
    }

    public void onResume() {
        if (this.threadName != null) {
            this.getContext().onFailure((Throwable)new Exception("Resume after a restart not supported while running background code"));
        }
    }

    @Nonnull
    public String getStatus() {
        if (this.threadName != null) {
            return "running in thread: " + this.threadName;
        }
        return "not currently scheduled, or running blocks";
    }

    protected abstract class TailCall
    extends BodyExecutionCallback {
        private static final long serialVersionUID = 1L;

        protected TailCall() {
        }

        protected abstract void finished(StepContext var1) throws Exception;

        public final void onSuccess(StepContext context, Object result) {
            GeneralNonBlockingStepExecution.this.run(() -> {
                try {
                    this.finished(context);
                }
                catch (Exception x) {
                    context.onFailure((Throwable)x);
                    return;
                }
                context.onSuccess(result);
            });
        }

        public final void onFailure(StepContext context, Throwable t) {
            GeneralNonBlockingStepExecution.this.run(() -> {
                try {
                    this.finished(context);
                }
                catch (Exception x) {
                    t.addSuppressed(x);
                }
                context.onFailure(t);
            });
        }
    }

    @FunctionalInterface
    protected static interface Block {
        public void run() throws Exception;
    }
}

