/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.db.migration.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.pipeline.maven.db.migration.MigrationStep;

public class MigrationStep10
implements MigrationStep {
    private static final Logger LOGGER = Logger.getLogger(MigrationStep10.class.getName());

    @Override
    public void execute(@Nonnull Connection cnn, @Nonnull MigrationStep.JenkinsDetails jenkinsDetails) throws SQLException {
        int count = 0;
        LOGGER.info("Upgrade table JENKINS_JOB...");
        try (PreparedStatement stmt = cnn.prepareStatement("SELECT * from JENKINS_JOB ORDER BY FULL_NAME");
             ResultSet rst = stmt.executeQuery();){
            while (rst.next()) {
                long jobPrimaryKey;
                Integer lastBuildNumber;
                if (++count < 100 && count % 10 == 0 || count < 500 && count % 20 == 0 || count % 50 == 0) {
                    LOGGER.log(Level.INFO, "#" + count + " - " + rst.getString("FULL_NAME") + "...");
                }
                if ((lastBuildNumber = this.findLastBuildNumber(cnn, jobPrimaryKey = rst.getLong("ID"))) == null) continue;
                this.updateJenkinsJobRecord(cnn, jobPrimaryKey, lastBuildNumber);
            }
        }
        LOGGER.info("Successfully upgraded table JENKINS_JOB, " + count + " records upgraded");
    }

    protected void updateJenkinsJobRecord(@Nonnull Connection cnn, long jenkinsJobPrimaryKey, int lastBuildNumber) throws SQLException {
        try (PreparedStatement stmt = cnn.prepareStatement("UPDATE JENKINS_JOB set LAST_BUILD_NUMBER = ?, LAST_SUCCESSFUL_BUILD_NUMBER = ? where ID = ?");){
            stmt.setInt(1, lastBuildNumber);
            stmt.setInt(2, lastBuildNumber);
            stmt.setLong(3, jenkinsJobPrimaryKey);
            stmt.execute();
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    protected Integer findLastBuildNumber(@Nonnull Connection cnn, long jobPrimaryKey) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

