/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.dao.AbstractPipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.util.RuntimeSqlException;

public class PipelineMavenPluginMySqlDao
extends AbstractPipelineMavenPluginDao {
    @Nullable
    public static String extractMariaDbVersion(@Nullable String jdbcDatabaseProductVersion) {
        if (jdbcDatabaseProductVersion == null) {
            return null;
        }
        if (!jdbcDatabaseProductVersion.contains("MariaDB")) {
            return null;
        }
        String mariaDbVersion = StringUtils.substringBetween((String)jdbcDatabaseProductVersion, (String)"-", (String)"-MariaDB");
        if (mariaDbVersion == null) {
            return jdbcDatabaseProductVersion;
        }
        return mariaDbVersion;
    }

    public PipelineMavenPluginMySqlDao(@Nonnull DataSource ds) {
        super(ds);
    }

    @Override
    public String getJdbcScheme() {
        return "mysql";
    }

    @Override
    protected void handleDatabaseInitialisationException(SQLException e) {
        if ("S1009".equals(e.getSQLState())) {
            this.LOGGER.log(Level.FINE, "Ignore sql exception " + e.getErrorCode() + " - " + e.getSQLState(), e);
        } else if (1065 == e.getErrorCode()) {
            this.LOGGER.log(Level.FINE, "Ignore sql exception " + e.getErrorCode() + " - " + e.getSQLState(), e);
        } else {
            if (1071 == e.getErrorCode()) {
                throw new RuntimeSqlException(e);
            }
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    protected void registerJdbcDriver() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("MySql driver 'com.mysql.cj.jdbc.Driver' not found. Please install the 'MySQL Database Plugin' to install the MySql driver");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String getDatabaseDescription() {
        try (Connection cnn = this.getDataSource().getConnection();){
            DatabaseMetaData metaData = cnn.getMetaData();
            String version = metaData.getDatabaseProductName() + " " + metaData.getDatabaseProductVersion();
            try (Statement stmt = cnn.createStatement();){
                try (ResultSet rst = stmt.executeQuery("select AURORA_VERSION()");){
                    rst.next();
                    version = version + " / Amazon Aurora " + rst.getString(1);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != 1305) {
                        this.LOGGER.log(Level.WARNING, "Exception checking Amazon Aurora version", e);
                    }
                }
            }
            String string = version;
            return string;
        }
        catch (SQLException e) {
            return "#" + e.toString() + "#";
        }
    }

    @Override
    public boolean isEnoughProductionGradeForTheWorkload() {
        return true;
    }
}

