/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.console;

import hudson.console.LineTransformationOutputStream;
import hudson.tasks._maven.Maven3MojoNote;
import hudson.tasks._maven.MavenErrorNote;
import hudson.tasks._maven.MavenMojoNote;
import hudson.tasks._maven.MavenWarningNote;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import jenkins.util.JenkinsJVM;

class MavenConsoleAnnotator
extends LineTransformationOutputStream {
    private final OutputStream out;
    private final Charset charset;
    private final byte[][] notes;

    static byte[][] createNotes() {
        JenkinsJVM.checkJenkinsJVM();
        return (byte[][])Stream.of(new MavenMojoNote(), new Maven3MojoNote(), new MavenWarningNote(), new MavenErrorNote()).map(note -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                note.encodeTo((OutputStream)baos);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
            return baos.toByteArray();
        }).toArray(x$0 -> new byte[x$0][]);
    }

    MavenConsoleAnnotator(OutputStream out, Charset charset, byte[][] notes) {
        this.out = out;
        this.charset = charset;
        this.notes = notes;
    }

    protected void eol(byte[] b, int len) throws IOException {
        String line = this.charset.decode(ByteBuffer.wrap(b, 0, len)).toString();
        Matcher m = MavenMojoNote.PATTERN.matcher(line = this.trimEOL(line));
        if (m.matches()) {
            this.out.write(this.notes[0]);
        }
        if ((m = Maven3MojoNote.PATTERN.matcher(line)).matches()) {
            this.out.write(this.notes[1]);
        }
        if ((m = MavenWarningNote.PATTERN.matcher(line)).find()) {
            this.out.write(this.notes[2]);
        }
        if ((m = MavenErrorNote.PATTERN.matcher(line)).find()) {
            this.out.write(this.notes[3]);
        }
        this.out.write(b, 0, len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        super.close();
        this.out.close();
    }
}

