/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.cause;

import hudson.console.ModelHyperlinkNote;
import hudson.model.TaskListener;
import hudson.model.User;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyAbstractCause;

public class MavenDependencyCliCause
extends MavenDependencyAbstractCause {
    private final String startedBy;

    public MavenDependencyCliCause(String startedBy) {
        this.startedBy = startedBy;
    }

    public MavenDependencyCliCause(String startedBy, List<MavenArtifact> mavenArtifacts) {
        super(mavenArtifacts);
        this.startedBy = startedBy;
    }

    public MavenDependencyCliCause(String startedBy, MavenArtifact ... mavenArtifacts) {
        this(startedBy, Arrays.asList(mavenArtifacts));
    }

    public String getShortDescription() {
        User user = User.get((String)this.startedBy, (boolean)false, Collections.emptyMap());
        String userName = user != null ? user.getDisplayName() : this.startedBy;
        return "Started from command line by " + userName + " for maven artifacts " + this.getMavenArtifactsDescription();
    }

    public void print(TaskListener listener) {
        listener.getLogger().println("Started from command line by " + ModelHyperlinkNote.encodeTo((String)("/user/" + this.startedBy), (String)this.startedBy) + " for maven artifacts " + this.getMavenArtifactsDescription());
    }
}

