/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.tools.ToolConfigurationCategory;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginH2Dao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginMonitoringDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginMySqlDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginNullDao;
import org.jenkinsci.plugins.pipeline.maven.service.PipelineTriggerService;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=50.0)
@Symbol(value={"pipelineMaven"})
public class GlobalPipelineMavenConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(GlobalPipelineMavenConfig.class.getName());
    private transient PipelineMavenPluginDao dao;
    private transient PipelineTriggerService pipelineTriggerService;
    private boolean triggerDownstreamUponResultSuccess = true;
    private boolean triggerDownstreamUponResultUnstable;
    private boolean triggerDownstreamUponResultFailure;
    private boolean triggerDownstreamUponResultNotBuilt;
    private boolean triggerDownstreamUponResultAborted;
    private String jdbcUrl;
    private String jdbcCredentialsId;
    private String properties;
    private List<MavenPublisher> publisherOptions;

    @DataBoundConstructor
    public GlobalPipelineMavenConfig() {
        this.load();
    }

    public ToolConfigurationCategory getCategory() {
        return (ToolConfigurationCategory)GlobalConfigurationCategory.get(ToolConfigurationCategory.class);
    }

    @CheckForNull
    public List<MavenPublisher> getPublisherOptions() {
        return this.publisherOptions;
    }

    @DataBoundSetter
    public void setPublisherOptions(List<MavenPublisher> publisherOptions) {
        this.publisherOptions = publisherOptions;
    }

    public boolean isTriggerDownstreamUponResultSuccess() {
        return this.triggerDownstreamUponResultSuccess;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultSuccess(boolean triggerDownstreamUponResultSuccess) {
        this.triggerDownstreamUponResultSuccess = triggerDownstreamUponResultSuccess;
    }

    public boolean isTriggerDownstreamUponResultUnstable() {
        return this.triggerDownstreamUponResultUnstable;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultUnstable(boolean triggerDownstreamUponResultUnstable) {
        this.triggerDownstreamUponResultUnstable = triggerDownstreamUponResultUnstable;
    }

    public boolean isTriggerDownstreamUponResultFailure() {
        return this.triggerDownstreamUponResultFailure;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultFailure(boolean triggerDownstreamUponResultFailure) {
        this.triggerDownstreamUponResultFailure = triggerDownstreamUponResultFailure;
    }

    public boolean isTriggerDownstreamUponResultNotBuilt() {
        return this.triggerDownstreamUponResultNotBuilt;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultNotBuilt(boolean triggerDownstreamUponResultNotBuilt) {
        this.triggerDownstreamUponResultNotBuilt = triggerDownstreamUponResultNotBuilt;
    }

    public boolean isTriggerDownstreamUponResultAborted() {
        return this.triggerDownstreamUponResultAborted;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultAborted(boolean triggerDownstreamUponResultAborted) {
        this.triggerDownstreamUponResultAborted = triggerDownstreamUponResultAborted;
    }

    public synchronized String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @DataBoundSetter
    public synchronized void setJdbcUrl(String jdbcUrl) {
        if (!Objects.equals(jdbcUrl, this.jdbcUrl)) {
            PipelineMavenPluginDao daoToClose = this.dao;
            this.dao = null;
            if (daoToClose instanceof Closeable) {
                try {
                    ((Closeable)((Object)daoToClose)).close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Exception closing the previous DAO", e);
                }
            }
        }
        this.jdbcUrl = jdbcUrl;
    }

    public synchronized String getJdbcCredentialsId() {
        return this.jdbcCredentialsId;
    }

    public synchronized String getProperties() {
        return this.properties;
    }

    @DataBoundSetter
    public synchronized void setProperties(String properties) {
        if (!Objects.equals(properties, this.properties)) {
            PipelineMavenPluginDao daoToClose = this.dao;
            this.dao = null;
            if (daoToClose instanceof Closeable) {
                try {
                    ((Closeable)((Object)daoToClose)).close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Exception closing the previous DAO", e);
                }
            }
        }
        this.properties = properties;
    }

    @DataBoundSetter
    public synchronized void setJdbcCredentialsId(String jdbcCredentialsId) {
        if (!Objects.equals(jdbcCredentialsId, this.jdbcCredentialsId)) {
            PipelineMavenPluginDao daoToClose = this.dao;
            this.dao = null;
            if (daoToClose instanceof Closeable) {
                try {
                    ((Closeable)((Object)daoToClose)).close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Exception closing the previous DAO", e);
                }
            }
        }
        this.jdbcCredentialsId = jdbcCredentialsId;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.publisherOptions = req.bindJSONToList(MavenPublisher.class, json.get("publisherOptions"));
        this.save();
        return true;
    }

    @Nonnull
    public synchronized PipelineMavenPluginDao getDao() {
        if (this.dao == null) {
            try {
                Class daoClass;
                String jdbcPassword;
                String jdbcUserName;
                String jdbcUrl;
                if (StringUtils.isBlank((String)this.jdbcUrl)) {
                    boolean created;
                    File databaseRootDir = new File(Jenkins.getInstance().getRootDir(), "jenkins-jobs");
                    if (!databaseRootDir.exists() && !(created = databaseRootDir.mkdirs())) {
                        throw new IllegalStateException("Failure to create database root dir " + databaseRootDir);
                    }
                    jdbcUrl = "jdbc:h2:file:" + new File(databaseRootDir, "jenkins-jobs").getAbsolutePath() + ";AUTO_SERVER=TRUE;MULTI_THREADED=1;QUERY_CACHE_SIZE=25;JMX=TRUE";
                    jdbcUserName = "sa";
                    jdbcPassword = "sa";
                } else {
                    jdbcUrl = this.jdbcUrl;
                    if (this.jdbcCredentialsId == null) {
                        throw new IllegalStateException("No credentials defined for JDBC URL '" + jdbcUrl + "'");
                    }
                    UsernamePasswordCredentials jdbcCredentials = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)this.jdbcCredentialsId));
                    if (jdbcCredentials == null) {
                        throw new IllegalStateException("Credentials '" + this.jdbcCredentialsId + "' defined for JDBC URL '" + jdbcUrl + "' NOT found");
                    }
                    jdbcUserName = jdbcCredentials.getUsername();
                    jdbcPassword = Secret.toString((Secret)jdbcCredentials.getPassword());
                }
                HikariConfig dsConfig = new HikariConfig();
                dsConfig.setJdbcUrl(jdbcUrl);
                dsConfig.setUsername(jdbcUserName);
                dsConfig.setPassword(jdbcPassword);
                dsConfig.setAutoCommit(false);
                Properties p = new Properties();
                if (jdbcUrl.startsWith("jdbc:mysql")) {
                    p.setProperty("dataSource.cachePrepStmts", "true");
                    p.setProperty("dataSource.prepStmtCacheSize", "250");
                    p.setProperty("dataSource.prepStmtCacheSqlLimit", "2048");
                    p.setProperty("dataSource.useServerPrepStmts", "true");
                    p.setProperty("dataSource.useLocalSessionState", "true");
                    p.setProperty("dataSource.rewriteBatchedStatements", "true");
                    p.setProperty("dataSource.cacheResultSetMetadata", "true");
                    p.setProperty("dataSource.cacheServerConfiguration", "true");
                    p.setProperty("dataSource.elideSetAutoCommits", "true");
                    p.setProperty("dataSource.maintainTimeStats", "false");
                } else if (jdbcUrl.startsWith("jdbc:h2")) {
                    // empty if block
                }
                if (StringUtils.isNotBlank((String)this.properties)) {
                    p.load(new StringReader(this.properties));
                }
                dsConfig.setDataSourceProperties(p);
                try {
                    DriverManager.getDriver(jdbcUrl);
                }
                catch (SQLException e) {
                    if ("08001".equals(e.getSQLState()) && 0 == e.getErrorCode()) {
                        if (jdbcUrl.startsWith("jdbc:h2:")) {
                            try {
                                Class.forName("org.h2.Driver");
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new IllegalStateException("H2 driver should be bundled with this plugin");
                            }
                        } else if (jdbcUrl.startsWith("jdbc:mysql:")) {
                            try {
                                Class.forName("com.mysql.cj.jdbc.Driver");
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new RuntimeException("MySql driver 'com.mysql.cj.jdbc.Driver' not found. Please install the 'MySQL Database Plugin' to install the MySql driver");
                            }
                        } else {
                            throw new IllegalArgumentException("Unsupported database type in JDBC URL " + jdbcUrl);
                        }
                        DriverManager.getDriver(jdbcUrl);
                    }
                    throw e;
                }
                LOGGER.log(Level.INFO, "Connect to database {0} with username {1} and properties {2}", new Object[]{jdbcUrl, jdbcUserName, p});
                HikariDataSource ds = new HikariDataSource(dsConfig);
                if (jdbcUrl.startsWith("jdbc:h2:")) {
                    daoClass = PipelineMavenPluginH2Dao.class;
                } else if (jdbcUrl.startsWith("jdbc:mysql:")) {
                    daoClass = PipelineMavenPluginMySqlDao.class;
                } else {
                    throw new IllegalArgumentException("Unsupported database type in JDBC URL " + jdbcUrl);
                }
                try {
                    this.dao = new PipelineMavenPluginMonitoringDao((PipelineMavenPluginDao)daoClass.getConstructor(DataSource.class).newInstance(ds));
                }
                catch (Exception e) {
                    throw new SQLException("Exception connecting to '" + this.jdbcUrl + "' with credentials '" + this.jdbcCredentialsId + "' (" + jdbcUserName + "/***) and DAO " + daoClass.getSimpleName(), e);
                }
            }
            catch (IOException | RuntimeException | SQLException e) {
                LOGGER.log(Level.WARNING, "Exception creating database dao, skip", e);
                this.dao = new PipelineMavenPluginNullDao();
            }
        }
        return this.dao;
    }

    @Nonnull
    public synchronized PipelineTriggerService getPipelineTriggerService() {
        if (this.pipelineTriggerService == null) {
            this.pipelineTriggerService = new PipelineTriggerService(this);
        }
        return this.pipelineTriggerService;
    }

    @Nonnull
    public Set<Result> getTriggerDownstreamBuildsResultsCriteria() {
        HashSet<Result> result = new HashSet<Result>(5);
        if (this.triggerDownstreamUponResultSuccess) {
            result.add(Result.SUCCESS);
        }
        if (this.triggerDownstreamUponResultUnstable) {
            result.add(Result.UNSTABLE);
        }
        if (this.triggerDownstreamUponResultAborted) {
            result.add(Result.ABORTED);
        }
        if (this.triggerDownstreamUponResultNotBuilt) {
            result.add(Result.NOT_BUILT);
        }
        if (this.triggerDownstreamUponResultFailure) {
            result.add(Result.FAILURE);
        }
        return result;
    }

    @Nullable
    public static GlobalPipelineMavenConfig get() {
        return (GlobalPipelineMavenConfig)((Object)GlobalConfiguration.all().get(GlobalPipelineMavenConfig.class));
    }

    public ListBoxModel doFillJdbcCredentialsIdItems() {
        return new StandardListBoxModel().includeEmptyValue().withMatching(CredentialsMatchers.always(), (Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST));
    }

    /*
     * Exception decompiling
     */
    public FormValidation doValidateJdbcConnection(@QueryParameter String jdbcUrl, @QueryParameter String properties, @QueryParameter String jdbcCredentialsId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 68[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

