/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyAbstractCause;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCause;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCauseHelper;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyUpstreamCause;
import org.jenkinsci.plugins.pipeline.maven.cause.OtherMavenDependencyCause;
import org.jenkinsci.plugins.pipeline.maven.trigger.WorkflowJobDependencyTrigger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class DownstreamPipelineTriggerRunListener
extends RunListener<WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(DownstreamPipelineTriggerRunListener.class.getName());
    @Inject
    public GlobalPipelineMavenConfig globalPipelineMavenConfig;

    public void onCompleted(WorkflowRun upstreamBuild, @Nonnull TaskListener listener) {
        LOGGER.log(Level.FINER, "onCompleted({0})", new Object[]{upstreamBuild});
        long startTimeInNanos = System.nanoTime();
        if (LOGGER.isLoggable(Level.FINER)) {
            listener.getLogger().println("[withMaven] pipelineGraphPublisher - triggerDownstreamPipelines");
        }
        if (!this.globalPipelineMavenConfig.getTriggerDownstreamBuildsResultsCriteria().contains(upstreamBuild.getResult())) {
            HashMap<String, List> omittedPipelineFullNamesAndCauses = new HashMap<String, List>();
            for (Cause cause : upstreamBuild.getCauses()) {
                if (!(cause instanceof MavenDependencyCause)) continue;
                MavenDependencyCause mavenDependencyCause = (MavenDependencyCause)cause;
                for (String string : mavenDependencyCause.getOmittedPipelineFullNames()) {
                    omittedPipelineFullNamesAndCauses.computeIfAbsent(string, p -> new ArrayList()).add(mavenDependencyCause);
                }
            }
            if (omittedPipelineFullNamesAndCauses.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    listener.getLogger().println("[withMaven] Skip triggering downstream jobs for upstream build with ignored result status " + upstreamBuild + ": " + upstreamBuild.getResult());
                }
            } else {
                for (Map.Entry entry : omittedPipelineFullNamesAndCauses.entrySet()) {
                    Job omittedPipeline = (Job)Jenkins.getInstance().getItemByFullName((String)entry.getKey(), Job.class);
                    if (omittedPipeline == null) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Illegal state: " + (String)entry.getKey() + " not resolved");
                        continue;
                    }
                    ArrayList<MavenDependencyCause> omittedPipelineTriggerCauses = new ArrayList<MavenDependencyCause>();
                    for (MavenDependencyCause cause : (List)entry.getValue()) {
                        if (cause instanceof MavenDependencyUpstreamCause) {
                            MavenDependencyUpstreamCause mavenDependencyUpstreamCause = (MavenDependencyUpstreamCause)cause;
                            WorkflowRun upstreamRun = mavenDependencyUpstreamCause.getUpstreamRun() == null ? upstreamBuild : mavenDependencyUpstreamCause.getUpstreamRun();
                            omittedPipelineTriggerCauses.add(new MavenDependencyUpstreamCause((Run<?, ?>)upstreamRun, (Collection<MavenArtifact>)mavenDependencyUpstreamCause.getMavenArtifacts(), (Collection<String>)Collections.emptyList()));
                            continue;
                        }
                        if (cause instanceof MavenDependencyAbstractCause) {
                            try {
                                MavenDependencyAbstractCause mavenDependencyAbstractCause = ((MavenDependencyAbstractCause)cause).clone();
                                mavenDependencyAbstractCause.setOmittedPipelineFullNames(Collections.emptyList());
                                omittedPipelineTriggerCauses.add((MavenDependencyCause)((Cause)mavenDependencyAbstractCause));
                            }
                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Failure to clone pipeline cause " + cause + " : " + cloneNotSupportedException);
                                omittedPipelineTriggerCauses.add(new OtherMavenDependencyCause(((MavenDependencyAbstractCause)cause).getShortDescription()));
                            }
                            continue;
                        }
                        omittedPipelineTriggerCauses.add(new OtherMavenDependencyCause(((MavenDependencyAbstractCause)cause).getShortDescription()));
                    }
                    Queue.Item item = ParameterizedJobMixIn.scheduleBuild2((Job)omittedPipeline, (int)-1, (Action[])new Action[]{new CauseAction(omittedPipelineTriggerCauses)});
                    if (item == null) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Failure to trigger omitted pipeline " + ModelHyperlinkNote.encodeTo((Item)omittedPipeline) + " due to causes " + omittedPipelineTriggerCauses + ", invocation rejected.");
                        continue;
                    }
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - triggered " + ModelHyperlinkNote.encodeTo((Item)omittedPipeline) + " despite build result " + upstreamBuild.getResult() + " for the upstream causes: " + omittedPipelineTriggerCauses.stream().map(c -> c.getShortDescription()).collect(Collectors.joining(", ")));
                }
            }
            return;
        }
        try {
            this.globalPipelineMavenConfig.getPipelineTriggerService().checkNoInfiniteLoopOfUpstreamCause((Run)upstreamBuild);
        }
        catch (IllegalStateException e) {
            listener.getLogger().println("[withMaven] WARNING abort infinite build trigger loop. Please consider opening a Jira issue: " + e.getMessage());
            return;
        }
        WorkflowJob upstreamPipeline = (WorkflowJob)upstreamBuild.getParent();
        String upstreamPipelineFullName = upstreamPipeline.getFullName();
        int n = upstreamBuild.getNumber();
        Map<MavenArtifact, SortedSet<String>> downstreamPipelinesByArtifact = this.globalPipelineMavenConfig.getDao().listDownstreamJobsByArtifact(upstreamPipelineFullName, n);
        TreeMap<String, Set> jobsToTrigger = new TreeMap<String, Set>();
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : downstreamPipelinesByArtifact.entrySet()) {
            MavenArtifact mavenArtifact = entry.getKey();
            SortedSet<String> downstreamPipelines = entry.getValue();
            block11: for (String downstreamPipelineFullName : downstreamPipelines) {
                Map.Entry<MavenArtifact, SortedSet<String>> entry22;
                if (jobsToTrigger.containsKey(downstreamPipelineFullName)) {
                    Set mavenArtifacts;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip eligibility check of pipeline " + downstreamPipelineFullName + " for artifact " + mavenArtifact.getShortDescription() + ", eligibility already confirmed");
                    }
                    if ((mavenArtifacts = (Set)jobsToTrigger.get(downstreamPipelineFullName)) == null) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Invalid state, no artifacts found for pipeline '" + downstreamPipelineFullName + "' while evaluating " + mavenArtifact.getShortDescription());
                        continue;
                    }
                    mavenArtifacts.add(mavenArtifact);
                    continue;
                }
                if (Objects.equals(downstreamPipelineFullName, upstreamPipelineFullName)) continue;
                WorkflowJob downstreamPipeline = (WorkflowJob)Jenkins.getInstance().getItemByFullName(downstreamPipelineFullName, WorkflowJob.class);
                if (downstreamPipeline == null || downstreamPipeline.getLastBuild() == null) {
                    LOGGER.log(Level.FINE, "Downstream pipeline {0} or downstream pipeline last build not found from upstream build {1}. Database synchronization issue or security restriction?", new Object[]{downstreamPipelineFullName, upstreamBuild.getFullDisplayName(), Jenkins.getAuthentication()});
                    continue;
                }
                int downstreamBuildNumber = downstreamPipeline.getLastBuild().getNumber();
                List<MavenArtifact> downstreamPipelineGeneratedArtifacts = this.globalPipelineMavenConfig.getDao().getGeneratedArtifacts(downstreamPipelineFullName, downstreamBuildNumber);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " evaluated for because it has a dependency on " + mavenArtifact + " generates " + downstreamPipelineGeneratedArtifacts);
                }
                for (MavenArtifact mavenArtifact2 : downstreamPipelineGeneratedArtifacts) {
                    if (!Objects.equals(mavenArtifact.getGroupId(), mavenArtifact2.getGroupId()) || !Objects.equals(mavenArtifact.getArtifactId(), mavenArtifact2.getArtifactId())) continue;
                    if (!LOGGER.isLoggable(Level.FINE)) continue block11;
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " for " + mavenArtifact + " because it generates artifact with same groupId:artifactId " + mavenArtifact2);
                    continue block11;
                }
                Map<MavenArtifact, SortedSet<String>> downstreamDownstreamPipelinesByArtifact = this.globalPipelineMavenConfig.getDao().listDownstreamJobsByArtifact(downstreamPipelineFullName, downstreamBuildNumber);
                for (Map.Entry<MavenArtifact, SortedSet<String>> entry22 : downstreamDownstreamPipelinesByArtifact.entrySet()) {
                    SortedSet<String> downstreamDownstreamPipelines = entry22.getValue();
                    if (!downstreamDownstreamPipelines.contains(upstreamPipelineFullName)) continue;
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Infinite loop detected: skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + "  (dependency: " + mavenArtifact.getShortDescription() + ") because it is itself triggering this pipeline " + ModelHyperlinkNote.encodeTo((Item)upstreamPipeline) + " (dependency: " + ((MavenArtifact)entry22.getKey()).getShortDescription() + ")");
                    continue block11;
                }
                Map<String, Integer> map = this.globalPipelineMavenConfig.getDao().listTransitiveUpstreamJobs(downstreamPipelineFullName, downstreamBuildNumber);
                entry22 = map.keySet().iterator();
                while (entry22.hasNext()) {
                    String transitiveUpstreamPipelineName = (String)entry22.next();
                    WorkflowJob transitiveUpstreamPipeline = (WorkflowJob)Jenkins.getInstance().getItemByFullName(transitiveUpstreamPipelineName, WorkflowJob.class);
                    if (transitiveUpstreamPipeline == null || transitiveUpstreamPipeline.getFullName().equals(upstreamPipeline.getFullName())) continue;
                    if (transitiveUpstreamPipeline.isBuilding()) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because it has a dependency already building: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                        continue block11;
                    }
                    if (transitiveUpstreamPipeline.isInQueue()) {
                        listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because it has a dependency already building or in queue: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                        continue block11;
                    }
                    if (!downstreamPipelines.contains(transitiveUpstreamPipelineName)) continue;
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because it has a dependency on a pipeline that will be triggered by this build: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                    hashMap.computeIfAbsent(transitiveUpstreamPipelineName, p -> new TreeSet()).add(downstreamPipelineFullName);
                    continue block11;
                }
                if (!downstreamPipeline.isBuildable()) {
                    LOGGER.log(Level.FINE, "Skip triggering of non buildable (disabled: {0}, isHoldOffBuildUntilSave: {1}) downstream pipeline {2} from upstream build {3}", new Object[]{downstreamPipeline.isDisabled(), downstreamPipeline.isHoldOffBuildUntilSave(), downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName()});
                    continue;
                }
                WorkflowJobDependencyTrigger downstreamPipelineTrigger = this.globalPipelineMavenConfig.getPipelineTriggerService().getWorkflowJobDependencyTrigger((ParameterizedJobMixIn.ParameterizedJob)downstreamPipeline);
                if (downstreamPipelineTrigger == null) {
                    LOGGER.log(Level.FINE, "Skip triggering of downstream pipeline {0} from upstream build {1}: dependency trigger not configured", new Object[]{downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName()});
                    continue;
                }
                boolean downstreamVisibleByUpstreamBuildAuth = this.globalPipelineMavenConfig.getPipelineTriggerService().isDownstreamVisibleByUpstreamBuildAuth((Item)downstreamPipeline);
                boolean upstreamVisibleByDownstreamBuildAuth = this.globalPipelineMavenConfig.getPipelineTriggerService().isUpstreamBuildVisibleByDownstreamBuildAuth(upstreamPipeline, (Queue.Task)downstreamPipeline);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "upstreamPipeline (" + upstreamPipelineFullName + ", visibleByDownstreamBuildAuth: " + upstreamVisibleByDownstreamBuildAuth + "),  downstreamPipeline (" + downstreamPipeline.getFullName() + ", visibleByUpstreamBuildAuth: " + downstreamVisibleByUpstreamBuildAuth + "), upstreamBuildAuth: " + Jenkins.getAuthentication());
                }
                if (downstreamVisibleByUpstreamBuildAuth && upstreamVisibleByDownstreamBuildAuth) {
                    Set mavenArtifactsCausingTheTrigger = jobsToTrigger.computeIfAbsent(downstreamPipelineFullName, k -> new TreeSet());
                    if (mavenArtifactsCausingTheTrigger.contains(mavenArtifact)) continue;
                    mavenArtifactsCausingTheTrigger.add(mavenArtifact);
                    continue;
                }
                LOGGER.log(Level.FINE, "Skip triggering of {0} by {1}: downstreamVisibleByUpstreamBuildAuth: {2}, upstreamVisibleByDownstreamBuildAuth: {3}", new Object[]{downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName(), downstreamVisibleByUpstreamBuildAuth, upstreamVisibleByDownstreamBuildAuth});
            }
        }
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : jobsToTrigger.entrySet()) {
            List<MavenArtifact> matchingMavenDependencies;
            String downstreamJobFullName = (String)((Object)entry.getKey());
            Job downstreamJob = (Job)Jenkins.getInstance().getItemByFullName(downstreamJobFullName, Job.class);
            if (downstreamJob == null) {
                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Illegal state: " + downstreamJobFullName + " not resolved");
                continue;
            }
            Set mavenArtifacts = entry.getValue();
            MavenDependencyUpstreamCause cause = new MavenDependencyUpstreamCause((Run<?, ?>)upstreamBuild, mavenArtifacts, (Collection)hashMap.get(downstreamJobFullName));
            Run downstreamJobLastBuild = downstreamJob.getLastBuild();
            if (downstreamJobLastBuild != null && (matchingMavenDependencies = MavenDependencyCauseHelper.isSameCause((MavenDependencyCause)cause, downstreamJobLastBuild.getCauses())).size() > 0) {
                downstreamJobLastBuild.addAction((Action)new CauseAction((Cause)cause));
                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + " as it was already triggered for Maven dependencies: " + matchingMavenDependencies.stream().map(mavenDependency -> mavenDependency == null ? null : mavenDependency.getShortDescription()).collect(Collectors.joining(", ")));
                try {
                    downstreamJobLastBuild.save();
                }
                catch (IOException e) {
                    listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Failure to update build " + downstreamJobLastBuild.getFullDisplayName() + ": " + e.toString());
                }
                continue;
            }
            Queue.Item queuedItem = ParameterizedJobMixIn.scheduleBuild2((Job)downstreamJob, (int)-1, (Action[])new Action[]{new CauseAction((Cause)cause)});
            String dependenciesMessage = cause.getMavenArtifactsDescription();
            if (queuedItem == null) {
                listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Skip triggering downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + " due to dependencies on " + dependenciesMessage + ", invocation rejected.");
                continue;
            }
            listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - Triggering downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + "#" + downstreamJob.getNextBuildNumber() + " due to dependency on " + dependenciesMessage + " ...");
        }
        long durationInMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimeInNanos, TimeUnit.NANOSECONDS);
        if (durationInMillis > TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS) || LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] downstreamPipelineTriggerRunListener - completed in " + durationInMillis + " ms");
        }
    }
}

