/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.FingerprintMap;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.tasks.Fingerprinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.ArtifactManager;
import jenkins.model.Jenkins;
import jenkins.util.BuildListenerAdapter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Element;

public class GeneratedArtifactsPublisher
extends MavenPublisher {
    private static final Logger LOGGER = Logger.getLogger(GeneratedArtifactsPublisher.class.getName());
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GeneratedArtifactsPublisher() {
    }

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        Run run = (Run)context.get(Run.class);
        ArtifactManager artifactManager = run.pickArtifactManager();
        Launcher launcher = (Launcher)context.get(Launcher.class);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        String fileSeparatorOnAgent = XmlUtils.getFileSeparatorOnRemote(workspace);
        List<MavenArtifact> join = XmlUtils.listGeneratedArtifacts(mavenSpyLogsElt, true);
        HashMap<String, String> artifactsToArchive = new HashMap<String, String>();
        HashMap<String, String> artifactsToFingerPrint = new HashMap<String, String>();
        for (MavenArtifact mavenArtifact : join) {
            try {
                FilePath filePath;
                if (StringUtils.isEmpty((String)mavenArtifact.getFile())) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    listener.getLogger().println("[withMaven] artifactsPublisher - Can't archive maven artifact with no file attached: " + mavenArtifact);
                    continue;
                }
                if (!mavenArtifact.getFile().endsWith("." + mavenArtifact.getExtension()) && (filePath = workspace.child(XmlUtils.getPathInWorkspace(mavenArtifact.getFile(), workspace))).isDirectory()) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    listener.getLogger().println("[withMaven] artifactsPublisher - Skip archiving for generated maven artifact of type directory (it's likely to be target/classes, see JENKINS-43714) " + mavenArtifact);
                    continue;
                }
                String string = mavenArtifact.getGroupId().replace(".", fileSeparatorOnAgent) + fileSeparatorOnAgent + mavenArtifact.getArtifactId() + fileSeparatorOnAgent + mavenArtifact.getBaseVersion() + fileSeparatorOnAgent + mavenArtifact.getFileNameWithBaseVersion();
                String artifactPathInWorkspace = XmlUtils.getPathInWorkspace(mavenArtifact.getFile(), workspace);
                if (StringUtils.isEmpty((String)artifactPathInWorkspace)) {
                    listener.error("[withMaven] artifactsPublisher - Invalid path in the workspace (" + workspace.getRemote() + ") for artifact " + mavenArtifact);
                    continue;
                }
                if (Objects.equals(string, mavenArtifact.getFile())) {
                    listener.error("[withMaven] artifactsPublisher - Failed to relativize '" + mavenArtifact.getFile() + "' in workspace '" + workspace.getRemote() + "' with file separator '" + fileSeparatorOnAgent + "'");
                    continue;
                }
                FilePath artifactFilePath = new FilePath(workspace, artifactPathInWorkspace);
                if (artifactFilePath.exists()) {
                    listener.getLogger().println("[withMaven] artifactsPublisher - Archive artifact " + artifactPathInWorkspace + " under " + string);
                    artifactsToArchive.put(string, artifactPathInWorkspace);
                    String artifactDigest = artifactFilePath.digest();
                    artifactsToFingerPrint.put(string, artifactDigest);
                    continue;
                }
                listener.getLogger().println("[withMaven] artifactsPublisher - FAILURE to archive " + artifactPathInWorkspace + " under " + string + ", file not found in workspace " + workspace);
            }
            catch (IOException | RuntimeException exception) {
                listener.error("[withMaven] artifactsPublisher - WARNING: Exception archiving and fingerprinting " + mavenArtifact + ", skip archiving of the artifacts");
                exception.printStackTrace(listener.getLogger());
                listener.getLogger().flush();
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] artifactsPublisher - Archive and fingerprint artifacts " + artifactsToArchive + " located in workspace " + workspace.getRemote());
        }
        try {
            artifactManager.archive(workspace, launcher, (BuildListener)new BuildListenerAdapter(listener), artifactsToArchive);
        }
        catch (IOException e) {
            throw new IOException("Exception archiving " + artifactsToArchive, e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Exception archiving " + artifactsToArchive, e);
        }
        FingerprintMap fingerprintMap = Jenkins.getInstance().getFingerprintMap();
        for (Map.Entry entry : artifactsToFingerPrint.entrySet()) {
            String artifactPathInArchiveZone = (String)entry.getKey();
            String artifactMd5 = (String)entry.getValue();
            fingerprintMap.getOrCreate(run, artifactPathInArchiveZone, artifactMd5).addFor(run);
        }
        Fingerprinter.FingerprintAction fingerprintAction = (Fingerprinter.FingerprintAction)run.getAction(Fingerprinter.FingerprintAction.class);
        if (fingerprintAction == null) {
            run.addAction((Action)new Fingerprinter.FingerprintAction(run, artifactsToFingerPrint));
        } else {
            fingerprintAction.add(artifactsToFingerPrint);
        }
    }

    @Symbol(value={"artifactsPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return "Generated Artifacts Publisher";
        }

        @Override
        public int ordinal() {
            return 1;
        }

        @Override
        @Nonnull
        public String getSkipFileName() {
            return ".skip-archive-generated-artifacts";
        }
    }
}

