/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class DatabaseSyncRunListener
extends RunListener<WorkflowRun> {
    @Inject
    public GlobalPipelineMavenConfig globalPipelineMavenConfig;

    public void onDeleted(WorkflowRun run) {
        this.globalPipelineMavenConfig.getDao().deleteBuild(((WorkflowJob)run.getParent()).getFullName(), run.getNumber());
    }

    public void onInitialize(WorkflowRun run) {
        super.onInitialize((Run)run);
        for (Cause cause : run.getCauses()) {
            if (!(cause instanceof Cause.UpstreamCause)) continue;
            Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)cause;
            String upstreamJobName = upstreamCause.getUpstreamProject();
            int upstreamBuildNumber = upstreamCause.getUpstreamBuild();
            this.globalPipelineMavenConfig.getDao().recordBuildUpstreamCause(upstreamJobName, upstreamBuildNumber, ((WorkflowJob)run.getParent()).getFullName(), run.getNumber());
        }
    }

    public void onCompleted(WorkflowRun workflowRun, @Nonnull TaskListener listener) {
        super.onCompleted((Run)workflowRun, listener);
        Result result = workflowRun.getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        this.globalPipelineMavenConfig.getDao().updateBuildOnCompletion(((WorkflowJob)workflowRun.getParent()).getFullName(), workflowRun.getNumber(), result.ordinal, workflowRun.getStartTimeInMillis(), Math.max(System.currentTimeMillis() - workflowRun.getStartTimeInMillis(), 0L));
    }
}

