/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenDependency;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginJdbcDao;

public class PipelineMavenPluginMonitoringDao
implements PipelineMavenPluginJdbcDao,
Closeable {
    protected final PipelineMavenPluginDao delegate;
    protected final AtomicLong findDurationInNanos = new AtomicLong();
    protected final AtomicInteger findCount = new AtomicInteger();
    protected final AtomicLong writeDurationInNanos = new AtomicLong();
    protected final AtomicInteger writeCount = new AtomicInteger();

    public PipelineMavenPluginMonitoringDao(@Nonnull PipelineMavenPluginDao delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordDependency(@Nonnull String jobFullName, int buildNumber, @Nonnull String groupId, @Nonnull String artifactId, @Nonnull String version, @Nonnull String type, @Nonnull String scope, boolean ignoreUpstreamTriggers, String classifier) {
        long nanosBefore = System.nanoTime();
        try {
            this.delegate.recordDependency(jobFullName, buildNumber, groupId, artifactId, version, type, scope, ignoreUpstreamTriggers, classifier);
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.writeCount.incrementAndGet();
            this.writeDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordParentProject(@Nonnull String jobFullName, int buildNumber, @Nonnull String parentGroupId, @Nonnull String parentArtifactId, @Nonnull String parentVersion, boolean ignoreUpstreamTriggers) {
        long nanosBefore = System.nanoTime();
        try {
            this.delegate.recordParentProject(jobFullName, buildNumber, parentGroupId, parentArtifactId, parentVersion, ignoreUpstreamTriggers);
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.writeCount.incrementAndGet();
            this.writeDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordGeneratedArtifact(@Nonnull String jobFullName, int buildNumber, @Nonnull String groupId, @Nonnull String artifactId, @Nonnull String version, @Nonnull String type, @Nonnull String baseVersion, @Nullable String repositoryUrl, boolean skipDownstreamTriggers, String extension, String classifier) {
        long nanosBefore = System.nanoTime();
        try {
            this.delegate.recordGeneratedArtifact(jobFullName, buildNumber, groupId, artifactId, version, type, baseVersion, repositoryUrl, skipDownstreamTriggers, extension, classifier);
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.writeCount.incrementAndGet();
            this.writeDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordBuildUpstreamCause(String upstreamJobName, int upstreamBuildNumber, String downstreamJobName, int downstreamBuildNumber) {
        long nanosBefore = System.nanoTime();
        try {
            this.delegate.recordBuildUpstreamCause(upstreamJobName, upstreamBuildNumber, downstreamJobName, downstreamBuildNumber);
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.writeCount.incrementAndGet();
            this.writeDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<MavenDependency> listDependencies(@Nonnull String jobFullName, int buildNumber) {
        long nanosBefore = System.nanoTime();
        try {
            List<MavenDependency> list = this.delegate.listDependencies(jobFullName, buildNumber);
            return list;
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.findCount.incrementAndGet();
            this.findDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<MavenArtifact> getGeneratedArtifacts(@Nonnull String jobFullName, int buildNumber) {
        long nanosBefore = System.nanoTime();
        try {
            List<MavenArtifact> list = this.delegate.getGeneratedArtifacts(jobFullName, buildNumber);
            return list;
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.findCount.incrementAndGet();
            this.findDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameJob(@Nonnull String oldFullName, @Nonnull String newFullName) {
        long nanosBefore = System.nanoTime();
        try {
            this.delegate.renameJob(oldFullName, newFullName);
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.writeCount.incrementAndGet();
            this.writeDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteJob(@Nonnull String jobFullName) {
        long nanosBefore = System.nanoTime();
        try {
            this.delegate.deleteJob(jobFullName);
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.writeCount.incrementAndGet();
            this.writeDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBuild(@Nonnull String jobFullName, int buildNumber) {
        long nanosBefore = System.nanoTime();
        try {
            this.delegate.deleteBuild(jobFullName, buildNumber);
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.writeCount.incrementAndGet();
            this.writeDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @Deprecated
    public List<String> listDownstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        long nanosBefore = System.nanoTime();
        try {
            List<String> list = this.delegate.listDownstreamJobs(jobFullName, buildNumber);
            return list;
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.findCount.incrementAndGet();
            this.findDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifact(@Nonnull String jobFullName, int buildNumber) {
        long nanosBefore = System.nanoTime();
        try {
            Map<MavenArtifact, SortedSet<String>> map = this.delegate.listDownstreamJobsByArtifact(jobFullName, buildNumber);
            return map;
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.findCount.incrementAndGet();
            this.findDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public SortedSet<String> listDownstreamJobs(String groupId, String artifactId, String version, String baseVersion, String type) {
        long nanosBefore = System.nanoTime();
        try {
            SortedSet<String> sortedSet = this.delegate.listDownstreamJobs(groupId, artifactId, version, baseVersion, type);
            return sortedSet;
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.findCount.incrementAndGet();
            this.findDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Map<String, Integer> listUpstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        long nanosBefore = System.nanoTime();
        try {
            Map<String, Integer> map = this.delegate.listUpstreamJobs(jobFullName, buildNumber);
            return map;
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.findCount.incrementAndGet();
            this.findDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Map<String, Integer> listTransitiveUpstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        long nanosBefore = System.nanoTime();
        try {
            Map<String, Integer> map = this.delegate.listTransitiveUpstreamJobs(jobFullName, buildNumber);
            return map;
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.findCount.incrementAndGet();
            this.findDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        long nanosBefore = System.nanoTime();
        try {
            this.delegate.cleanup();
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.writeCount.incrementAndGet();
            this.writeDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBuildOnCompletion(@Nonnull String jobFullName, int buildNumber, int buildResultOrdinal, long startTimeInMillis, long durationInMillis) {
        long nanosBefore = System.nanoTime();
        try {
            this.delegate.updateBuildOnCompletion(jobFullName, buildNumber, buildResultOrdinal, startTimeInMillis, durationInMillis);
        }
        finally {
            long nanosAfter = System.nanoTime();
            this.writeCount.incrementAndGet();
            this.writeDurationInNanos.addAndGet(nanosAfter - nanosBefore);
        }
    }

    @Override
    public String toPrettyString() {
        return this.delegate.toPrettyString() + "\r\n Performances: \r\n\t find: totalDurationInMs=" + TimeUnit.NANOSECONDS.toMillis(this.findDurationInNanos.get()) + ", count=" + this.findCount.get() + "\r\n\t write: totalDurationInMs=" + TimeUnit.NANOSECONDS.toMillis(this.writeDurationInNanos.get()) + ", count=" + this.writeCount.get();
    }

    @Override
    @Nonnull
    public DataSource getDataSource() {
        return ((PipelineMavenPluginJdbcDao)this.delegate).getDataSource();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate instanceof Closeable) {
            ((Closeable)((Object)this.delegate)).close();
        }
    }

    @Override
    public boolean isEnoughProductionGradeForTheWorkload() {
        return this.delegate.isEnoughProductionGradeForTheWorkload();
    }
}

