/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import java.io.File;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.jenkinsci.plugins.pipeline.maven.dao.AbstractPipelineMavenPluginDao;

public class PipelineMavenPluginH2Dao
extends AbstractPipelineMavenPluginDao {
    public PipelineMavenPluginH2Dao(@Nonnull DataSource ds) {
        super(ds);
    }

    public PipelineMavenPluginH2Dao(@Nonnull File rootDir) {
        this((DataSource)JdbcConnectionPool.create((String)("jdbc:h2:file:" + new File(rootDir, "jenkins-jobs").getAbsolutePath() + ";AUTO_SERVER=TRUE;MULTI_THREADED=1;QUERY_CACHE_SIZE=25;JMX=TRUE"), (String)"sa", (String)"sa"));
    }

    @Override
    protected void registerJdbcDriver() {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("H2 driver 'org.h2.Driver' not found. Please install the 'H2 Database Plugin' to install the H2 driver");
        }
    }

    @Override
    public String getJdbcScheme() {
        return "h2";
    }
}

