/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jenkins.model.InterruptedBuildAction;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisherStrategy;
import org.jenkinsci.plugins.pipeline.maven.publishers.JenkinsMavenEventSpyLogsPublisher;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MavenSpyLogProcessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MavenSpyLogProcessor.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMavenSpyLogs(@Nonnull StepContext context, @Nonnull FilePath mavenSpyLogFolder, @Nonnull List<MavenPublisher> options, @Nonnull MavenPublisherStrategy publisherStrategy) throws IOException, InterruptedException {
        DocumentBuilder documentBuilder;
        long nanosBefore = System.nanoTime();
        FilePath[] mavenSpyLogsList = mavenSpyLogFolder.list("maven-spy-*.log");
        LOGGER.log(Level.FINE, "Found {0} maven execution reports in {1}", new Object[]{mavenSpyLogsList.length, mavenSpyLogFolder});
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        FilePath workspace = (FilePath)context.get(FilePath.class);
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Failure to create a DocumentBuilder", e);
        }
        for (FilePath mavenSpyLogs : mavenSpyLogsList) {
            ArrayList<AbstractMap.SimpleImmutableEntry<String, Long>> durationInMillisPerPublisher = new ArrayList<AbstractMap.SimpleImmutableEntry<String, Long>>();
            try {
                InputStream mavenSpyLogsInputStream;
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven] Evaluate Maven Spy logs: " + mavenSpyLogs.getRemote());
                }
                if ((mavenSpyLogsInputStream = mavenSpyLogs.read()) == null) {
                    throw new IllegalStateException("InputStream for " + mavenSpyLogs.getRemote() + " is null");
                }
                FilePath archiveJenkinsMavenEventSpyLogs = workspace.child(".archive-jenkins-maven-event-spy-logs");
                if (archiveJenkinsMavenEventSpyLogs.exists()) {
                    LOGGER.log(Level.FINE, "Archive Jenkins Maven Event Spy logs {0}", mavenSpyLogs.getRemote());
                    new JenkinsMavenEventSpyLogsPublisher().process(context, mavenSpyLogs);
                }
                Element mavenSpyLogsElt = documentBuilder.parse(mavenSpyLogsInputStream).getDocumentElement();
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven] Maven Publisher Strategy: " + publisherStrategy.getDescription());
                }
                List<MavenPublisher> mavenPublishers = publisherStrategy.buildPublishersList(options, listener);
                for (MavenPublisher mavenPublisher : mavenPublishers) {
                    String skipFileName = mavenPublisher.getDescriptor().getSkipFileName();
                    if (Boolean.TRUE.equals(mavenPublisher.isDisabled())) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        listener.getLogger().println("[withMaven] Skip '" + mavenPublisher.getDescriptor().getDisplayName() + "' disabled by configuration");
                        continue;
                    }
                    if (StringUtils.isNotEmpty((String)skipFileName) && workspace.child(skipFileName).exists()) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        listener.getLogger().println("[withMaven] Skip '" + mavenPublisher.getDescriptor().getDisplayName() + "' disabled by marker file '" + skipFileName + "'");
                        continue;
                    }
                    long nanosBeforePublisher = System.nanoTime();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        listener.getLogger().println("[withMaven] Run '" + mavenPublisher.getDescriptor().getDisplayName() + "'...");
                    }
                    try {
                        mavenPublisher.process(context, mavenSpyLogsElt);
                    }
                    catch (InterruptedException e) {
                        listener.error("[withMaven] Processing of Maven build outputs interrupted in " + mavenPublisher.toString() + " after " + TimeUnit.MILLISECONDS.convert(System.nanoTime() - nanosBefore, TimeUnit.NANOSECONDS) + "ms.");
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                    catch (IOException | RuntimeException e) {
                        PrintWriter error = listener.error("[withMaven] WARNING Exception executing Maven reporter '" + mavenPublisher.getDescriptor().getDisplayName() + "' / " + mavenPublisher.getDescriptor().getId() + ". Please report a bug associated for the component 'pipeline-maven-plugin' at https://issues.jenkins-ci.org ");
                        e.printStackTrace(error);
                    }
                    finally {
                        durationInMillisPerPublisher.add(new AbstractMap.SimpleImmutableEntry<String, Long>(mavenPublisher.getDescriptor().getDisplayName(), TimeUnit.MILLISECONDS.convert(System.nanoTime() - nanosBeforePublisher, TimeUnit.NANOSECONDS)));
                    }
                }
            }
            catch (SAXException e) {
                Run run = (Run)context.get(Run.class);
                if (run.getActions(InterruptedBuildAction.class).isEmpty()) {
                    listener.error("[withMaven] WARNING Exception parsing the logs generated by the Jenkins Maven Event Spy " + mavenSpyLogs + ", ignore file.  Please report a bug associated for the component 'pipeline-maven-plugin' at https://issues.jenkins-ci.org ");
                } else {
                    listener.error("[withMaven] WARNING logs generated by the Jenkins Maven Event Spy " + mavenSpyLogs + " are invalid, probably due to the interruption of the job, ignore file.");
                }
                listener.error(e.toString());
            }
            catch (InterruptedException e) {
                listener.error("[withMaven] Processing of Maven build outputs interrupted after " + TimeUnit.MILLISECONDS.convert(System.nanoTime() - nanosBefore, TimeUnit.NANOSECONDS) + "ms.");
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                PrintWriter errorWriter = listener.error("[withMaven] WARNING Exception processing the logs generated by the Jenkins Maven Event Spy " + mavenSpyLogs + ", ignore file.  Please report a bug associated for the component 'pipeline-maven-plugin' at https://issues.jenkins-ci.org ");
                e.printStackTrace(errorWriter);
            }
            finally {
                if (LOGGER.isLoggable(Level.INFO)) {
                    listener.getLogger().println("[withMaven] Publishers: " + durationInMillisPerPublisher.stream().filter(entry -> (Long)entry.getValue() > 0L).map(entry -> (String)entry.getKey() + ": " + entry.getValue() + " ms").collect(Collectors.joining(", ")));
                }
            }
        }
        FilePath[] mavenSpyLogsInterruptedList = mavenSpyLogFolder.list("maven-spy-*.log.tmp");
        if (mavenSpyLogsInterruptedList.length > 0) {
            listener.getLogger().print("[withMaven] One or multiple Maven executions have been ignored by the Jenkins Pipeline Maven Plugin because they have been interrupted before completion (" + mavenSpyLogsInterruptedList.length + "). See ");
            listener.hyperlink("https://wiki.jenkins.io/display/JENKINS/Pipeline+Maven+Plugin#PipelineMavenPlugin-mavenExecutionInterrupted", "Pipeline Maven Plugin FAQ");
            listener.getLogger().println(" for more details.");
            if (LOGGER.isLoggable(Level.FINE)) {
                for (FilePath mavenSpyLogsInterruptedLogs : mavenSpyLogsInterruptedList) {
                    listener.getLogger().print("[withMaven] Ignore: " + mavenSpyLogsInterruptedLogs.getRemote());
                }
            }
        }
    }

    public static class PluginInvocation {
        public String groupId;
        public String artifactId;
        public String version;
        public String goal;
        public String executionId;

        public String getId() {
            return this.artifactId + ":" + this.goal + " (" + this.executionId + ")";
        }

        public String toString() {
            return "PluginInvocation{" + this.groupId + ":" + this.artifactId + ":" + this.version + "@" + this.goal + "  " + this.executionId + '}';
        }
    }
}

