/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.service;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCause;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCauseHelper;
import org.jenkinsci.plugins.pipeline.maven.service.ServiceLogger;
import org.jenkinsci.plugins.pipeline.maven.trigger.WorkflowJobDependencyTrigger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;

public class PipelineTriggerService {
    private static final Logger LOGGER = Logger.getLogger(PipelineTriggerService.class.getName());
    private final GlobalPipelineMavenConfig globalPipelineMavenConfig;

    public PipelineTriggerService(@Nonnull GlobalPipelineMavenConfig globalPipelineMavenConfig) {
        this.globalPipelineMavenConfig = globalPipelineMavenConfig;
    }

    public Collection<String> triggerDownstreamPipelines(@Nonnull String groupId, @Nonnull String artifactId, @Nullable String baseVersion, @Nonnull String version, @Nonnull String type, @Nonnull MavenDependencyCause cause, @Nonnull ServiceLogger logger) {
        if (!(cause instanceof Cause)) {
            throw new IllegalArgumentException("Given cause must extend hudson.model.Cause: " + cause);
        }
        long startTimeInNanos = System.nanoTime();
        MavenArtifact mavenArtifact = new MavenArtifact();
        mavenArtifact.setGroupId(groupId);
        mavenArtifact.setArtifactId(artifactId);
        mavenArtifact.setBaseVersion(baseVersion);
        mavenArtifact.setVersion(version);
        mavenArtifact.setType(type);
        SortedSet<String> downstreamPipelines = this.globalPipelineMavenConfig.getDao().listDownstreamJobs(groupId, artifactId, version, baseVersion, type);
        TreeSet<String> jobsToTrigger = new TreeSet<String>();
        block2: for (String downstreamPipelineFullName : downstreamPipelines) {
            WorkflowJob downstreamPipeline = this.getItemByFullName(downstreamPipelineFullName, WorkflowJob.class);
            if (downstreamPipeline == null || downstreamPipeline.getLastBuild() == null) {
                logger.log(Level.FINE, "Downstream pipeline " + downstreamPipelineFullName + " or downstream pipeline last build not found. Database synchronization issue or security restriction?");
                continue;
            }
            int downstreamBuildNumber = downstreamPipeline.getLastBuild().getNumber();
            Map<String, Integer> transitiveUpstreamPipelines = this.globalPipelineMavenConfig.getDao().listTransitiveUpstreamJobs(downstreamPipelineFullName, downstreamBuildNumber);
            for (String transitiveUpstreamPipelineName : transitiveUpstreamPipelines.keySet()) {
                WorkflowJob transitiveUpstreamPipeline = this.getItemByFullName(transitiveUpstreamPipelineName, WorkflowJob.class);
                if (transitiveUpstreamPipeline == null) continue;
                if (transitiveUpstreamPipeline.isBuilding() || transitiveUpstreamPipeline.isInQueue()) {
                    logger.log(Level.INFO, "Not triggering " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamPipeline) + " because it has a dependency already building or in queue: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                    continue block2;
                }
                if (!downstreamPipelines.contains(transitiveUpstreamPipelineName)) continue;
                logger.log(Level.INFO, "Not triggering " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamPipeline) + " because it has a dependency on a pipeline that will be triggered by this build: " + logger.modelHyperlinkNoteEncodeTo((Item)transitiveUpstreamPipeline));
                continue block2;
            }
            if (!downstreamPipeline.isBuildable()) {
                logger.log(Level.FINE, "Skip triggering of non buildable (disabled: " + downstreamPipeline.isDisabled() + ", isHoldOffBuildUntilSave: " + downstreamPipeline.isHoldOffBuildUntilSave() + ") downstream pipeline " + downstreamPipeline.getFullName());
                continue;
            }
            WorkflowJobDependencyTrigger downstreamPipelineTrigger = this.getWorkflowJobDependencyTrigger((ParameterizedJobMixIn.ParameterizedJob)downstreamPipeline);
            if (downstreamPipelineTrigger == null) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Skip triggering of downstream pipeline " + downstreamPipeline.getFullName() + ": dependency trigger not configured");
                continue;
            }
            boolean downstreamVisibleByUpstreamBuildAuth = this.isDownstreamVisibleByUpstreamBuildAuth((Item)downstreamPipeline);
            if (downstreamVisibleByUpstreamBuildAuth) {
                jobsToTrigger.add(downstreamPipelineFullName);
                continue;
            }
            LOGGER.log(Level.FINE, "Skip triggering of {0} by CLI , not allowed to see downstream", new Object[]{downstreamPipeline.getFullName()});
        }
        for (String downstreamJobFullName : jobsToTrigger) {
            List<MavenArtifact> matchingMavenDependencies;
            Job downstreamJob = this.getItemByFullName(downstreamJobFullName, Job.class);
            if (downstreamJob == null) {
                logger.log(Level.WARNING, "Illegal state: downstream job " + downstreamJobFullName + " not resolved");
                continue;
            }
            cause.setMavenArtifacts(Collections.singletonList(mavenArtifact));
            Run downstreamJobLastBuild = downstreamJob.getLastBuild();
            if (downstreamJobLastBuild != null && (matchingMavenDependencies = MavenDependencyCauseHelper.isSameCause(cause, downstreamJobLastBuild.getCauses())).size() > 0) {
                downstreamJobLastBuild.addAction((Action)new CauseAction((Cause)cause));
                logger.log(Level.INFO, "Skip scheduling downstream pipeline " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamJob) + " as it was already triggered for Maven dependencies: " + matchingMavenDependencies.stream().map(mavenDependency -> mavenDependency == null ? null : mavenDependency.getShortDescription()).collect(Collectors.joining(", ")));
                try {
                    downstreamJobLastBuild.save();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failure to update build " + downstreamJobLastBuild.getFullDisplayName() + ": " + e.toString());
                }
                continue;
            }
            Queue.Item queuedItem = ParameterizedJobMixIn.scheduleBuild2((Job)downstreamJob, (int)-1, (Action[])new Action[]{new CauseAction((Cause)cause)});
            String dependenciesMessage = cause.getMavenArtifactsDescription();
            if (queuedItem == null) {
                logger.log(Level.INFO, "Skip scheduling downstream pipeline " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamJob) + " due to dependencies on " + dependenciesMessage + ", invocation rejected.");
                continue;
            }
            logger.log(Level.INFO, "Scheduling downstream pipeline " + logger.modelHyperlinkNoteEncodeTo((Item)downstreamJob) + "#" + downstreamJob.getNextBuildNumber() + " due to dependency on " + dependenciesMessage + " ...");
        }
        long durationInMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimeInNanos, TimeUnit.NANOSECONDS);
        if (durationInMillis > TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS) || logger.isLoggable(Level.FINE)) {
            logger.log(Level.INFO, "triggerDownstreamPipelines completed in " + durationInMillis + " ms");
        }
        return jobsToTrigger;
    }

    public void checkNoInfiniteLoopOfUpstreamCause(@Nonnull Run initialBuild) throws IllegalStateException {
        Run currentBuild;
        LinkedList<Run> builds = new LinkedList<Run>(Collections.singleton(initialBuild));
        while ((currentBuild = (Run)builds.poll()) != null) {
            for (Cause cause : currentBuild.getCauses()) {
                Cause.UpstreamCause upstreamCause;
                Run upstreamBuild;
                if (!(cause instanceof Cause.UpstreamCause) || (upstreamBuild = (upstreamCause = (Cause.UpstreamCause)cause).getUpstreamRun()) == null) continue;
                if (Objects.equals(upstreamBuild.getParent().getFullName(), initialBuild.getParent().getFullName())) {
                    throw new IllegalStateException("Infinite loop of job triggers ");
                }
                builds.add(upstreamBuild);
            }
        }
    }

    @Nullable
    public WorkflowJobDependencyTrigger getWorkflowJobDependencyTrigger(@Nonnull ParameterizedJobMixIn.ParameterizedJob parameterizedJob) {
        Map triggers = parameterizedJob.getTriggers();
        for (Object trigger : triggers.values()) {
            if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
            return (WorkflowJobDependencyTrigger)((Object)trigger);
        }
        if (parameterizedJob.getParent() instanceof ComputedFolder) {
            ComputedFolder multiBranchProject = (ComputedFolder)parameterizedJob.getParent();
            for (Trigger trigger : multiBranchProject.getTriggers().values()) {
                if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
                return (WorkflowJobDependencyTrigger)trigger;
            }
            if (multiBranchProject.getParent() instanceof ComputedFolder) {
                ComputedFolder grandParent = (ComputedFolder)multiBranchProject.getParent();
                Map grandParentTriggers = grandParent.getTriggers();
                for (Trigger trigger : grandParentTriggers.values()) {
                    if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
                    return (WorkflowJobDependencyTrigger)trigger;
                }
            }
        }
        return null;
    }

    public boolean isUpstreamBuildVisibleByDownstreamBuildAuth(@Nonnull WorkflowJob upstreamPipeline, @Nonnull Queue.Task downstreamPipeline) {
        Authentication auth = Tasks.getAuthenticationOf((Queue.Task)downstreamPipeline);
        Authentication downstreamPipelineAuth = auth.equals(ACL.SYSTEM) && !QueueItemAuthenticatorConfiguration.get().getAuthenticators().isEmpty() ? Jenkins.ANONYMOUS : auth;
        try (ACLContext ignored = ACL.as((Authentication)downstreamPipelineAuth);){
            WorkflowJob upstreamPipelineObtainedAsImpersonated = this.getItemByFullName(upstreamPipeline.getFullName(), WorkflowJob.class);
            boolean result = upstreamPipelineObtainedAsImpersonated != null;
            LOGGER.log(Level.FINE, "isUpstreamBuildVisibleByDownstreamBuildAuth({0}, {1}): taskAuth: {2}, downstreamPipelineAuth: {3}, upstreamPipelineObtainedAsImpersonated:{4}, result: {5}", new Object[]{upstreamPipeline, downstreamPipeline, auth, downstreamPipelineAuth, upstreamPipelineObtainedAsImpersonated, result});
            boolean bl = result;
            return bl;
        }
    }

    public boolean isDownstreamVisibleByUpstreamBuildAuth(@Nonnull Item downstreamPipeline) {
        boolean result = this.getItemByFullName(downstreamPipeline.getFullName(), Job.class) != null;
        LOGGER.log(Level.FINE, "isDownstreamVisibleByUpstreamBuildAuth({0}, auth: {1}): {2}", new Object[]{downstreamPipeline, Jenkins.getAuthentication(), result});
        return result;
    }

    @CheckForNull
    <T extends Item> T getItemByFullName(String fullName, Class<T> type) throws AccessDeniedException {
        return (T)Jenkins.getInstance().getItemByFullName(fullName, type);
    }
}

