/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.cause;

import hudson.console.ModelHyperlinkNote;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCause;

public class MavenDependencyUpstreamCause
extends Cause.UpstreamCause
implements MavenDependencyCause {
    private List<MavenArtifact> mavenArtifacts;

    public MavenDependencyUpstreamCause(Run<?, ?> up, MavenArtifact ... mavenArtifact) {
        super(up);
        this.mavenArtifacts = Arrays.asList(mavenArtifact);
    }

    public MavenDependencyUpstreamCause(Run<?, ?> up, @Nonnull Collection<MavenArtifact> mavenArtifacts) {
        super(up);
        this.mavenArtifacts = new ArrayList<MavenArtifact>(mavenArtifacts);
    }

    public String getShortDescription() {
        return "Started by upstream build \"" + this.getUpstreamProject() + "\" #" + this.getUpstreamBuild() + " generating Maven artifacts: " + this.getMavenArtifactsDescription();
    }

    public void print(TaskListener listener) {
        this.print(listener, 0);
    }

    private void indent(TaskListener listener, int depth) {
        for (int i = 0; i < depth; ++i) {
            listener.getLogger().print(' ');
        }
    }

    private void print(TaskListener listener, int depth) {
        this.indent(listener, depth);
        Run upstreamRun = this.getUpstreamRun();
        if (upstreamRun == null) {
            listener.getLogger().println("Started by upstream build " + ModelHyperlinkNote.encodeTo((String)('/' + this.getUpstreamUrl()), (String)this.getUpstreamProject()) + "\" #" + ModelHyperlinkNote.encodeTo((String)('/' + this.getUpstreamUrl() + this.getUpstreamBuild()), (String)Integer.toString(this.getUpstreamBuild())) + " generating Maven artifact: " + this.getMavenArtifactsDescription());
        } else {
            listener.getLogger().println("Started by upstream build " + ModelHyperlinkNote.encodeTo((String)('/' + upstreamRun.getUrl()), (String)upstreamRun.getFullDisplayName()) + " generating Maven artifacts: " + this.getMavenArtifactsDescription());
        }
        if (this.getUpstreamCauses() != null && !this.getUpstreamCauses().isEmpty()) {
            this.indent(listener, depth);
            listener.getLogger().println("originally caused by:");
            for (Cause cause : this.getUpstreamCauses()) {
                if (cause instanceof MavenDependencyUpstreamCause) {
                    ((MavenDependencyUpstreamCause)cause).print(listener, depth + 1);
                    continue;
                }
                this.indent(listener, depth + 1);
                cause.print(listener);
            }
        }
    }

    @Override
    @Nonnull
    public String getMavenArtifactsDescription() {
        return this.mavenArtifacts.stream().map(mavenArtifact -> mavenArtifact == null ? "null" : mavenArtifact.getShortDescription()).collect(Collectors.joining(","));
    }

    @Override
    @Nonnull
    public List<MavenArtifact> getMavenArtifacts() {
        return this.mavenArtifacts;
    }

    @Override
    public void setMavenArtifacts(List<MavenArtifact> mavenArtifacts) {
        this.mavenArtifacts = mavenArtifacts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenDependencyUpstreamCause that = (MavenDependencyUpstreamCause)o;
        return Objects.equals(this.mavenArtifacts, that.mavenArtifacts);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mavenArtifacts);
    }
}

