/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.tools.ToolConfigurationCategory;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginH2Dao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginMonitoringDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginMySqlDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginNullDao;
import org.jenkinsci.plugins.pipeline.maven.service.PipelineTriggerService;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=50.0)
@Symbol(value={"pipelineMaven"})
public class GlobalPipelineMavenConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(GlobalPipelineMavenConfig.class.getName());
    private transient PipelineMavenPluginDao dao;
    private transient PipelineTriggerService pipelineTriggerService;
    private boolean triggerDownstreamUponResultSuccess = true;
    private boolean triggerDownstreamUponResultUnstable;
    private boolean triggerDownstreamUponResultFailure;
    private boolean triggerDownstreamUponResultNotBuilt;
    private boolean triggerDownstreamUponResultAborted;
    private String jdbcUrl;
    private String jdbcCredentialsId;
    private String properties;
    private List<MavenPublisher> publisherOptions;

    @DataBoundConstructor
    public GlobalPipelineMavenConfig() {
        this.load();
    }

    public ToolConfigurationCategory getCategory() {
        return (ToolConfigurationCategory)GlobalConfigurationCategory.get(ToolConfigurationCategory.class);
    }

    @CheckForNull
    public List<MavenPublisher> getPublisherOptions() {
        return this.publisherOptions;
    }

    @DataBoundSetter
    public void setPublisherOptions(List<MavenPublisher> publisherOptions) {
        this.publisherOptions = publisherOptions;
    }

    public boolean isTriggerDownstreamUponResultSuccess() {
        return this.triggerDownstreamUponResultSuccess;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultSuccess(boolean triggerDownstreamUponResultSuccess) {
        this.triggerDownstreamUponResultSuccess = triggerDownstreamUponResultSuccess;
    }

    public boolean isTriggerDownstreamUponResultUnstable() {
        return this.triggerDownstreamUponResultUnstable;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultUnstable(boolean triggerDownstreamUponResultUnstable) {
        this.triggerDownstreamUponResultUnstable = triggerDownstreamUponResultUnstable;
    }

    public boolean isTriggerDownstreamUponResultFailure() {
        return this.triggerDownstreamUponResultFailure;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultFailure(boolean triggerDownstreamUponResultFailure) {
        this.triggerDownstreamUponResultFailure = triggerDownstreamUponResultFailure;
    }

    public boolean isTriggerDownstreamUponResultNotBuilt() {
        return this.triggerDownstreamUponResultNotBuilt;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultNotBuilt(boolean triggerDownstreamUponResultNotBuilt) {
        this.triggerDownstreamUponResultNotBuilt = triggerDownstreamUponResultNotBuilt;
    }

    public boolean isTriggerDownstreamUponResultAborted() {
        return this.triggerDownstreamUponResultAborted;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultAborted(boolean triggerDownstreamUponResultAborted) {
        this.triggerDownstreamUponResultAborted = triggerDownstreamUponResultAborted;
    }

    public synchronized String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @DataBoundSetter
    public synchronized void setJdbcUrl(String jdbcUrl) {
        if (!Objects.equals(jdbcUrl, this.jdbcUrl)) {
            this.dao = null;
        }
        this.jdbcUrl = jdbcUrl;
    }

    public synchronized String getJdbcCredentialsId() {
        return this.jdbcCredentialsId;
    }

    @DataBoundSetter
    public synchronized void setJdbcCredentialsId(String jdbcCredentialsId) {
        if (!Objects.equals(jdbcCredentialsId, this.jdbcCredentialsId)) {
            this.dao = null;
        }
        this.jdbcCredentialsId = jdbcCredentialsId;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.publisherOptions = req.bindJSONToList(MavenPublisher.class, json.get("publisherOptions"));
        this.save();
        return true;
    }

    @Nonnull
    public synchronized PipelineMavenPluginDao getDao() {
        if (this.dao == null) {
            try {
                Class daoClass;
                String jdbcPassword;
                String jdbcUserName;
                String jdbcUrl;
                if (StringUtils.isBlank((String)this.jdbcUrl)) {
                    boolean created;
                    File databaseRootDir = new File(Jenkins.getInstance().getRootDir(), "jenkins-jobs");
                    if (!databaseRootDir.exists() && !(created = databaseRootDir.mkdirs())) {
                        throw new IllegalStateException("Failure to create database root dir " + databaseRootDir);
                    }
                    jdbcUrl = "jdbc:h2:file:" + new File(databaseRootDir, "jenkins-jobs").getAbsolutePath() + ";AUTO_SERVER=TRUE;MULTI_THREADED=1;QUERY_CACHE_SIZE=25;JMX=TRUE";
                    jdbcUserName = "sa";
                    jdbcPassword = "sa";
                } else {
                    jdbcUrl = this.jdbcUrl;
                    if (this.jdbcCredentialsId == null) {
                        throw new IllegalStateException("No credentials defined for JDBC URL '" + jdbcUrl + "'");
                    }
                    UsernamePasswordCredentials jdbcCredentials = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)this.jdbcCredentialsId));
                    if (jdbcCredentials == null) {
                        throw new IllegalStateException("Credentials '" + this.jdbcCredentialsId + "' defined for JDBC URL '" + jdbcUrl + "' NOT found");
                    }
                    jdbcUserName = jdbcCredentials.getUsername();
                    jdbcPassword = Secret.toString((Secret)jdbcCredentials.getPassword());
                }
                HikariConfig dsConfig = new HikariConfig();
                dsConfig.setJdbcUrl(jdbcUrl);
                dsConfig.setUsername(jdbcUserName);
                dsConfig.setPassword(jdbcPassword);
                if (StringUtils.isNotBlank((String)this.properties)) {
                    Properties p = new Properties();
                    p.load(new StringReader(this.properties));
                    dsConfig.setDataSourceProperties(p);
                }
                HikariDataSource ds = new HikariDataSource(dsConfig);
                if (jdbcUrl.startsWith("jdbc:h2:")) {
                    daoClass = PipelineMavenPluginH2Dao.class;
                } else if (jdbcUrl.startsWith("jdbc:mysql:")) {
                    daoClass = PipelineMavenPluginMySqlDao.class;
                } else {
                    throw new IllegalArgumentException("Unsupported database type in JDBC URL " + jdbcUrl);
                }
                try {
                    this.dao = new PipelineMavenPluginMonitoringDao((PipelineMavenPluginDao)daoClass.getConstructor(DataSource.class).newInstance(ds));
                }
                catch (Exception e) {
                    throw new SQLException("Exception connecting to '" + this.jdbcUrl + "' with credentials '" + this.jdbcCredentialsId + "' (" + jdbcUserName + "/***) and DAO " + daoClass.getSimpleName(), e);
                }
            }
            catch (IOException | RuntimeException | SQLException e) {
                LOGGER.log(Level.WARNING, "Exception creating database dao, skip", e);
                this.dao = new PipelineMavenPluginNullDao();
            }
        }
        return this.dao;
    }

    @Nonnull
    public synchronized PipelineTriggerService getPipelineTriggerService() {
        if (this.pipelineTriggerService == null) {
            this.pipelineTriggerService = new PipelineTriggerService(this);
        }
        return this.pipelineTriggerService;
    }

    @Nonnull
    public Set<Result> getTriggerDownstreamBuildsResultsCriteria() {
        HashSet<Result> result = new HashSet<Result>(5);
        if (this.triggerDownstreamUponResultSuccess) {
            result.add(Result.SUCCESS);
        }
        if (this.triggerDownstreamUponResultUnstable) {
            result.add(Result.UNSTABLE);
        }
        if (this.triggerDownstreamUponResultAborted) {
            result.add(Result.ABORTED);
        }
        if (this.triggerDownstreamUponResultNotBuilt) {
            result.add(Result.NOT_BUILT);
        }
        if (this.triggerDownstreamUponResultFailure) {
            result.add(Result.FAILURE);
        }
        return result;
    }

    @Nullable
    public static GlobalPipelineMavenConfig get() {
        return (GlobalPipelineMavenConfig)((Object)GlobalConfiguration.all().get(GlobalPipelineMavenConfig.class));
    }

    public ListBoxModel doFillJdbcCredentialsIdItems() {
        return new StandardListBoxModel().includeEmptyValue().withMatching(CredentialsMatchers.always(), (Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FormValidation doValidateJdbcConnection(@QueryParameter String jdbcUrl, @QueryParameter String properties, @QueryParameter String jdbcCredentialsId) {
        if (StringUtils.isBlank((String)jdbcUrl)) {
            return FormValidation.ok((String)"OK");
        }
        String driverClass = null;
        try {
            if (StringUtils.isBlank((String)jdbcUrl)) {
                driverClass = "org.h2.Driver";
            } else if (jdbcUrl.startsWith("jdbc:h2")) {
                driverClass = "org.h2.Driver";
            } else {
                if (!jdbcUrl.startsWith("jdbc:mysql")) return FormValidation.error((String)("Unsupported database specified in JDBC url '" + jdbcUrl + "'"));
                driverClass = "com.mysql.cj.jdbc.Driver";
            }
            Class.forName(driverClass);
            if (StringUtils.isEmpty((String)jdbcCredentialsId)) {
                if (!StringUtils.isBlank((String)jdbcUrl)) return FormValidation.error((String)("No credentials specified for JDBC url '" + jdbcUrl + "'"));
                return FormValidation.ok((String)"OK");
            }
            UsernamePasswordCredentials jdbcCredentials = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)jdbcCredentialsId));
            if (jdbcCredentials == null) {
                return FormValidation.error((String)("Credentials '" + jdbcCredentialsId + "' defined for JDBC URL '" + jdbcUrl + "' not found"));
            }
            String jdbcUserName = jdbcCredentials.getUsername();
            String jdbcPassword = Secret.toString((Secret)jdbcCredentials.getPassword());
            HikariConfig dsConfig = new HikariConfig();
            dsConfig.setJdbcUrl(jdbcUrl);
            dsConfig.setUsername(jdbcUserName);
            dsConfig.setPassword(jdbcPassword);
            if (StringUtils.isNotBlank((String)properties)) {
                Properties p = new Properties();
                try {
                    p.load(new StringReader(properties));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                dsConfig.setDataSourceProperties(p);
            }
            try (HikariDataSource ds = new HikariDataSource(dsConfig);){
                try (Connection cnn = ds.getConnection();
                     Statement stmt = cnn.createStatement();
                     ResultSet rst = stmt.executeQuery("select 1");){
                    rst.next();
                    return FormValidation.ok((String)"OK");
                }
                catch (SQLException e) {
                    FormValidation formValidation = FormValidation.error((Throwable)e, (String)("Failure to connect to the database " + jdbcUrl));
                    if (ds == null) return formValidation;
                    if (throwable != null) {
                        try {
                            ds.close();
                            return formValidation;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return formValidation;
                        }
                    }
                    ds.close();
                    return formValidation;
                }
            }
        }
        catch (RuntimeException e) {
            return FormValidation.error((Throwable)e, (String)("Failed to test JDBC connection '" + jdbcUrl + "'"));
        }
        catch (ClassNotFoundException e) {
            return FormValidation.error((Throwable)e, (String)("Failed to load JDBC driver '" + driverClass + "' for JDBC connection '" + jdbcUrl + "'"));
        }
    }
}

