/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCause;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCauseHelper;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyUpstreamCause;
import org.jenkinsci.plugins.pipeline.maven.trigger.WorkflowJobDependencyTrigger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class DownstreamPipelineTriggerRunListener
extends RunListener<WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(DownstreamPipelineTriggerRunListener.class.getName());
    @Inject
    public GlobalPipelineMavenConfig globalPipelineMavenConfig;

    public void onCompleted(WorkflowRun upstreamBuild, @Nonnull TaskListener listener) {
        LOGGER.log(Level.FINER, "onCompleted({0})", new Object[]{upstreamBuild});
        long startTimeInNanos = System.nanoTime();
        if (LOGGER.isLoggable(Level.FINER)) {
            listener.getLogger().println("[withMaven] pipelineGraphPublisher - triggerDownstreamPipelines");
        }
        if (!this.globalPipelineMavenConfig.getTriggerDownstreamBuildsResultsCriteria().contains(upstreamBuild.getResult())) {
            if (LOGGER.isLoggable(Level.FINER)) {
                listener.getLogger().println("[withMaven] Skip downstream job triggering for upstream build with ignored result status " + upstreamBuild + ": " + upstreamBuild.getResult());
            }
            return;
        }
        try {
            this.globalPipelineMavenConfig.getPipelineTriggerService().checkNoInfiniteLoopOfUpstreamCause((Run)upstreamBuild);
        }
        catch (IllegalStateException e) {
            listener.getLogger().println("[withMaven] WARNING abort infinite build trigger loop. Please consider opening a Jira issue: " + e.getMessage());
            return;
        }
        WorkflowJob upstreamPipeline = (WorkflowJob)upstreamBuild.getParent();
        String upstreamPipelineFullName = upstreamPipeline.getFullName();
        int upstreamBuildNumber = upstreamBuild.getNumber();
        Map<MavenArtifact, SortedSet<String>> downstreamPipelinesByArtifact = this.globalPipelineMavenConfig.getDao().listDownstreamJobsByArtifact(upstreamPipelineFullName, upstreamBuildNumber);
        TreeMap jobsToTrigger = new TreeMap();
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : downstreamPipelinesByArtifact.entrySet()) {
            MavenArtifact mavenArtifact = entry.getKey();
            SortedSet<String> downstreamPipelines = entry.getValue();
            block5: for (String downstreamPipelineFullName : downstreamPipelines) {
                Map.Entry<MavenArtifact, SortedSet<String>> entry222;
                if (jobsToTrigger.containsKey(downstreamPipelineFullName)) {
                    Set mavenArtifacts;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        listener.getLogger().println("[withMaven - DownstreamPipelineTriggerRunListener] Skip eligibility check of pipeline " + downstreamPipelineFullName + " for artifact " + mavenArtifact.getShortDescription() + ", eligibility already confirmed");
                    }
                    if ((mavenArtifacts = (Set)jobsToTrigger.get(downstreamPipelineFullName)) == null) {
                        listener.getLogger().println("[withMaven - DownstreamPipelineTriggerRunListener] Invalid state, no artifacts found for pipeline '" + downstreamPipelineFullName + "' while evaluating " + mavenArtifact.getShortDescription());
                        continue;
                    }
                    mavenArtifacts.add(mavenArtifact);
                    continue;
                }
                if (Objects.equals(downstreamPipelineFullName, upstreamPipelineFullName)) continue;
                WorkflowJob downstreamPipeline = (WorkflowJob)Jenkins.getInstance().getItemByFullName(downstreamPipelineFullName, WorkflowJob.class);
                if (downstreamPipeline == null || downstreamPipeline.getLastBuild() == null) {
                    LOGGER.log(Level.FINE, "Downstream pipeline {0} or downstream pipeline last build not found from upstream build {1}. Database synchronization issue or security restriction?", new Object[]{downstreamPipelineFullName, upstreamBuild.getFullDisplayName(), Jenkins.getAuthentication()});
                    continue;
                }
                int downstreamBuildNumber = downstreamPipeline.getLastBuild().getNumber();
                Map<MavenArtifact, SortedSet<String>> downstreamDownstreamPipelinesByArtifact = this.globalPipelineMavenConfig.getDao().listDownstreamJobsByArtifact(downstreamPipelineFullName, downstreamBuildNumber);
                for (Map.Entry<MavenArtifact, SortedSet<String>> entry222 : downstreamDownstreamPipelinesByArtifact.entrySet()) {
                    SortedSet<String> downstreamDownstreamPipelines = entry222.getValue();
                    if (!downstreamDownstreamPipelines.contains(upstreamPipelineFullName)) continue;
                    listener.getLogger().println("[withMaven] Infinite loop detected: not triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + "  (dependency: " + mavenArtifact.getId() + ") because it is itself triggering this pipeline " + ModelHyperlinkNote.encodeTo((Item)upstreamPipeline) + " (dependency: " + entry222.getKey() + ")");
                    continue block5;
                }
                Map<String, Integer> transitiveUpstreamPipelines = this.globalPipelineMavenConfig.getDao().listTransitiveUpstreamJobs(downstreamPipelineFullName, downstreamBuildNumber);
                entry222 = transitiveUpstreamPipelines.keySet().iterator();
                while (entry222.hasNext()) {
                    String transitiveUpstreamPipelineName = (String)entry222.next();
                    WorkflowJob transitiveUpstreamPipeline = (WorkflowJob)Jenkins.getInstance().getItemByFullName(transitiveUpstreamPipelineName, WorkflowJob.class);
                    if (transitiveUpstreamPipeline == null) continue;
                    if (!transitiveUpstreamPipeline.equals(upstreamPipeline) && (transitiveUpstreamPipeline.isBuilding() || transitiveUpstreamPipeline.isInQueue())) {
                        listener.getLogger().println("[withMaven] Not triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because it has a dependency already building or in queue: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                        continue block5;
                    }
                    if (!downstreamPipelines.contains(transitiveUpstreamPipelineName)) continue;
                    listener.getLogger().println("[withMaven] Not triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because it has a dependency on a pipeline that will be triggered by this build: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                    continue block5;
                }
                if (!downstreamPipeline.isBuildable()) {
                    LOGGER.log(Level.FINE, "Skip triggering of non buildable (disabled: {0}, isHoldOffBuildUntilSave: {1}) downstream pipeline {2} from upstream build {3}", new Object[]{downstreamPipeline.isDisabled(), downstreamPipeline.isHoldOffBuildUntilSave(), downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName()});
                    continue;
                }
                WorkflowJobDependencyTrigger downstreamPipelineTrigger = this.globalPipelineMavenConfig.getPipelineTriggerService().getWorkflowJobDependencyTrigger((ParameterizedJobMixIn.ParameterizedJob)downstreamPipeline);
                if (downstreamPipelineTrigger == null) {
                    LOGGER.log(Level.FINE, "Skip triggering of downstream pipeline {0} from upstream build {1}: dependency trigger not configured", new Object[]{downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName()});
                    continue;
                }
                boolean downstreamVisibleByUpstreamBuildAuth = this.globalPipelineMavenConfig.getPipelineTriggerService().isDownstreamVisibleByUpstreamBuildAuth((Item)downstreamPipeline);
                boolean upstreamVisibleByDownstreamBuildAuth = this.globalPipelineMavenConfig.getPipelineTriggerService().isUpstreamBuildVisibleByDownstreamBuildAuth(upstreamPipeline, (Queue.Task)downstreamPipeline);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "upstreamPipeline (" + upstreamPipelineFullName + ", visibleByDownstreamBuildAuth: " + upstreamVisibleByDownstreamBuildAuth + "),  downstreamPipeline (" + downstreamPipeline.getFullName() + ", visibleByUpstreamBuildAuth: " + downstreamVisibleByUpstreamBuildAuth + "), upstreamBuildAuth: " + Jenkins.getAuthentication());
                }
                if (downstreamVisibleByUpstreamBuildAuth && upstreamVisibleByDownstreamBuildAuth) {
                    TreeSet<MavenArtifact> mavenArtifacts = (TreeSet<MavenArtifact>)jobsToTrigger.get(downstreamPipelineFullName);
                    if (mavenArtifacts == null) {
                        mavenArtifacts = new TreeSet<MavenArtifact>();
                        jobsToTrigger.put(downstreamPipelineFullName, mavenArtifacts);
                    }
                    if (mavenArtifacts.contains(mavenArtifact)) continue;
                    mavenArtifacts.add(mavenArtifact);
                    continue;
                }
                LOGGER.log(Level.FINE, "Skip triggering of {0} by {1}: downstreamVisibleByUpstreamBuildAuth: {2}, upstreamVisibleByDownstreamBuildAuth: {3}", new Object[]{downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName(), downstreamVisibleByUpstreamBuildAuth, upstreamVisibleByDownstreamBuildAuth});
            }
        }
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : jobsToTrigger.entrySet()) {
            List<MavenArtifact> matchingMavenDependencies;
            String downstreamJobFullName = (String)((Object)entry.getKey());
            Job downstreamJob = (Job)Jenkins.getInstance().getItemByFullName(downstreamJobFullName, Job.class);
            if (downstreamJob == null) {
                listener.getLogger().println("[withMaven] Illegal state: " + downstreamJobFullName + " not resolved");
                continue;
            }
            Set mavenArtifacts = entry.getValue();
            MavenDependencyUpstreamCause cause = new MavenDependencyUpstreamCause((Run<?, ?>)upstreamBuild, mavenArtifacts);
            Run downstreamJobLastBuild = downstreamJob.getLastBuild();
            if (downstreamJobLastBuild != null && (matchingMavenDependencies = MavenDependencyCauseHelper.isSameCause((MavenDependencyCause)cause, downstreamJobLastBuild.getCauses())).size() > 0) {
                downstreamJobLastBuild.addAction((Action)new CauseAction((Cause)cause));
                listener.getLogger().println("Skip scheduling downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + " as it was already triggered for Maven dependencies: " + Joiner.on((String)", ").join((Iterable)Collections2.transform(matchingMavenDependencies, mavenDependency -> mavenDependency == null ? null : mavenDependency.getShortDescription())));
                try {
                    downstreamJobLastBuild.save();
                }
                catch (IOException e) {
                    listener.getLogger().println("Failure to update build " + downstreamJobLastBuild.getFullDisplayName() + ": " + e.toString());
                }
                continue;
            }
            Queue.Item queuedItem = ParameterizedJobMixIn.scheduleBuild2((Job)downstreamJob, (int)-1, (Action[])new Action[]{new CauseAction((Cause)cause)});
            String dependenciesMessage = cause.getMavenArtifactsDescription();
            if (queuedItem == null) {
                listener.getLogger().println("[withMaven] Skip scheduling downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + " due to dependencies on " + dependenciesMessage + ", invocation rejected.");
                continue;
            }
            listener.getLogger().println("[withMaven] Scheduling downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + "#" + downstreamJob.getNextBuildNumber() + " due to dependency on " + dependenciesMessage + " ...");
        }
        long durationInMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTimeInNanos, TimeUnit.NANOSECONDS);
        if (durationInMillis > TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS) || LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] triggerDownstreamPipelines completed in " + durationInMillis + " ms");
        }
    }
}

