/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.cause;

import hudson.model.Cause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCause;

public class MavenDependencyCauseHelper {
    @Nonnull
    public static List<MavenArtifact> isSameCause(MavenDependencyCause newMavenCause, Cause oldMavenCause) {
        if (!(oldMavenCause instanceof MavenDependencyCause)) {
            return Collections.emptyList();
        }
        List<MavenArtifact> newCauseArtifacts = newMavenCause.getMavenArtifacts();
        List<MavenArtifact> oldCauseArtifacts = ((MavenDependencyCause)oldMavenCause).getMavenArtifacts();
        ArrayList<MavenArtifact> matchingArtifacts = new ArrayList<MavenArtifact>();
        for (MavenArtifact newCauseArtifact : newCauseArtifacts) {
            if (newCauseArtifact.isSnapshot() && newCauseArtifact.getVersion().contains("SNAPSHOT")) continue;
            for (MavenArtifact oldCauseArtifact : oldCauseArtifacts) {
                if (!Objects.equals(newCauseArtifact.getGroupId(), oldCauseArtifact.getGroupId()) || !Objects.equals(newCauseArtifact.getArtifactId(), oldCauseArtifact.getArtifactId()) || !Objects.equals(newCauseArtifact.getVersion(), oldCauseArtifact.getVersion()) || !Objects.equals(newCauseArtifact.getBaseVersion(), oldCauseArtifact.getBaseVersion()) || !Objects.equals(newCauseArtifact.getClassifier(), oldCauseArtifact.getClassifier()) || !Objects.equals(newCauseArtifact.getType(), oldCauseArtifact.getType())) continue;
                matchingArtifacts.add(newCauseArtifact);
            }
        }
        return matchingArtifacts;
    }

    public static List<MavenArtifact> isSameCause(MavenDependencyCause newMavenCause, List<Cause> oldMavenCauses) {
        ArrayList<MavenArtifact> matchingArtifacts = new ArrayList<MavenArtifact>();
        for (Cause oldMavenCause : oldMavenCauses) {
            matchingArtifacts.addAll(MavenDependencyCauseHelper.isSameCause(newMavenCause, oldMavenCause));
        }
        return matchingArtifacts;
    }
}

