/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import hudson.model.Result;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.h2.jdbcx.JdbcConnectionPool;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenDependency;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.db.migration.MigrationStep;
import org.jenkinsci.plugins.pipeline.maven.util.ClassUtils;
import org.jenkinsci.plugins.pipeline.maven.util.RuntimeIoException;
import org.jenkinsci.plugins.pipeline.maven.util.RuntimeSqlException;

public class PipelineMavenPluginH2Dao
implements PipelineMavenPluginDao {
    private static Logger LOGGER = Logger.getLogger(PipelineMavenPluginH2Dao.class.getName());
    private transient JdbcConnectionPool jdbcConnectionPool;
    private transient Long jenkinsMasterPrimaryKey;

    public PipelineMavenPluginH2Dao(@Nonnull File rootDir) {
        rootDir.getClass();
        File databaseFile = new File(rootDir, "jenkins-jobs");
        String jdbcUrl = "jdbc:h2:file:" + databaseFile.getAbsolutePath() + ";AUTO_SERVER=TRUE;MULTI_THREADED=1;QUERY_CACHE_SIZE=25;JMX=TRUE";
        if (LOGGER.isLoggable(Level.FINEST)) {
            jdbcUrl = jdbcUrl + ";TRACE_LEVEL_SYSTEM_OUT=3";
        } else if (LOGGER.isLoggable(Level.FINE)) {
            jdbcUrl = jdbcUrl + ";TRACE_LEVEL_SYSTEM_OUT=2";
        }
        LOGGER.log(Level.INFO, "Open database {0}", jdbcUrl);
        this.jdbcConnectionPool = JdbcConnectionPool.create((String)jdbcUrl, (String)"sa", (String)"sa");
        this.initializeDatabase();
        this.testDatabase();
    }

    public PipelineMavenPluginH2Dao(@Nonnull JdbcConnectionPool jdbcConnectionPool) {
        jdbcConnectionPool.getClass();
        this.jdbcConnectionPool = jdbcConnectionPool;
        this.initializeDatabase();
        this.testDatabase();
    }

    public PipelineMavenPluginH2Dao(String jdbcUrl, String username, String password) {
        jdbcUrl.getClass();
        username.getClass();
        password.getClass();
        this.jdbcConnectionPool = JdbcConnectionPool.create((String)jdbcUrl, (String)username, (String)password);
        LOGGER.log(Level.FINE, "Open database {0}", jdbcUrl);
        this.initializeDatabase();
    }

    @Override
    public void recordDependency(String jobFullName, int buildNumber, String groupId, String artifactId, String version, String type, String scope, boolean ignoreUpstreamTriggers, String classifier) {
        LOGGER.log(Level.FINE, "recordDependency({0}#{1}, {2}:{3}:{4}:{5}, {6}, ignoreUpstreamTriggers:{7}})", new Object[]{jobFullName, buildNumber, groupId, artifactId, version, type, scope, ignoreUpstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long artifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(groupId, artifactId, version, type, classifier);
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO MAVEN_DEPENDENCY(ARTIFACT_ID, BUILD_ID, SCOPE, IGNORE_UPSTREAM_TRIGGERS) VALUES (?, ?, ?, ?)");){
                stmt.setLong(1, artifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setString(3, scope);
                stmt.setBoolean(4, ignoreUpstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    @Nonnull
    public List<MavenDependency> listDependencies(@Nonnull String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "listDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String dependenciesSql = "SELECT DISTINCT MAVEN_ARTIFACT.*,  MAVEN_DEPENDENCY.scope  FROM MAVEN_ARTIFACT  INNER JOIN MAVEN_DEPENDENCY ON MAVEN_ARTIFACT.ID = MAVEN_DEPENDENCY.ARTIFACT_ID INNER JOIN JENKINS_BUILD ON MAVEN_DEPENDENCY.BUILD_ID = JENKINS_BUILD.ID  INNER JOIN JENKINS_JOB ON JENKINS_BUILD.JOB_ID = JENKINS_JOB.ID  WHERE    JENKINS_JOB.FULL_NAME = ? AND   JENKINS_BUILD.NUMBER = ? ";
        ArrayList<MavenDependency> results = new ArrayList<MavenDependency>();
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(dependenciesSql);){
            stmt.setString(1, jobFullName);
            stmt.setInt(2, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenDependency artifact = new MavenDependency();
                    artifact.groupId = rst.getString("maven_artifact.group_id");
                    artifact.artifactId = rst.getString("maven_artifact.artifact_id");
                    artifact.version = rst.getString("maven_artifact.version");
                    artifact.snapshot = artifact.version.endsWith("-SNAPSHOT");
                    artifact.type = rst.getString("maven_artifact.type");
                    artifact.classifier = rst.getString("maven_artifact.classifier");
                    artifact.setScope(rst.getString("maven_dependency.scope"));
                    results.add(artifact);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public void recordParentProject(@Nonnull String jobFullName, int buildNumber, @Nonnull String parentGroupId, @Nonnull String parentArtifactId, @Nonnull String parentVersion, boolean ignoreUpstreamTriggers) {
        LOGGER.log(Level.FINE, "recordParentProject({0}#{1}, {2}:{3} ignoreUpstreamTriggers:{5}})", new Object[]{jobFullName, buildNumber, parentGroupId, parentArtifactId, parentVersion, ignoreUpstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long parentArtifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(parentGroupId, parentArtifactId, parentVersion, "pom", null);
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO MAVEN_PARENT_PROJECT(ARTIFACT_ID, BUILD_ID, IGNORE_UPSTREAM_TRIGGERS) VALUES (?, ?, ?)");){
                stmt.setLong(1, parentArtifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setBoolean(3, ignoreUpstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void recordGeneratedArtifact(String jobFullName, int buildNumber, String groupId, String artifactId, String version, String type, String baseVersion, String repositoryUrl, boolean skipDownstreamTriggers, String extension, String classifier) {
        LOGGER.log(Level.FINE, "recordGeneratedArtifact({0}#{1}, {2}:{3}:{4}:{5}, version:{6}, repositoryUrl:{7}, skipDownstreamTriggers:{8})", new Object[]{jobFullName, buildNumber, groupId, artifactId, baseVersion, type, version, repositoryUrl, skipDownstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long artifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(groupId, artifactId, baseVersion, type, classifier);
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO GENERATED_MAVEN_ARTIFACT(ARTIFACT_ID, BUILD_ID, VERSION, REPOSITORY_URL, EXTENSION, SKIP_DOWNSTREAM_TRIGGERS) VALUES (?, ?, ?, ?, ?, ?)");){
                stmt.setLong(1, artifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setString(3, version);
                stmt.setString(4, repositoryUrl);
                stmt.setString(5, extension);
                stmt.setBoolean(6, skipDownstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void recordBuildUpstreamCause(String upstreamJobName, int upstreamBuildNumber, String downstreamJobName, int downstreamBuildNumber) {
        LOGGER.log(Level.FINE, "recordBuildUpstreamCause(upstreamBuild: {0}#{1}, downstreamBuild: {2}#{3})", new Object[]{upstreamJobName, upstreamBuildNumber, downstreamJobName, downstreamBuildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            String sql = "insert into jenkins_build_upstream_cause (upstream_build_id, downstream_build_id) values (?, ?)";
            long upstreamBuildPrimaryKey = this.getOrCreateBuildPrimaryKey(upstreamJobName, upstreamBuildNumber);
            long downstreamBuildPrimaryKey = this.getOrCreateBuildPrimaryKey(downstreamJobName, downstreamBuildNumber);
            try (PreparedStatement stmt = cnn.prepareStatement(sql);){
                stmt.setLong(1, upstreamBuildPrimaryKey);
                stmt.setLong(2, downstreamBuildPrimaryKey);
                int rowCount = stmt.executeUpdate();
                if (rowCount != 1) {
                    LOGGER.log(Level.INFO, "More/less ({0}) than 1 record inserted in jenkins_build_upstream_cause for upstreamBuild: {1}#{2}, downstreamBuild: {3}#{4}", new Object[]{rowCount, upstreamJobName, upstreamBuildNumber, downstreamJobName, downstreamBuildNumber});
                }
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void renameJob(String oldFullName, String newFullName) {
        LOGGER.log(Level.FINER, "renameJob({0}, {1})", new Object[]{oldFullName, newFullName});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("UPDATE JENKINS_JOB SET FULL_NAME = ? WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, newFullName);
                stmt.setString(2, oldFullName);
                stmt.setLong(3, this.getJenkinsMasterPrimaryKey(cnn));
                int count = stmt.executeUpdate();
                LOGGER.log(Level.FINE, "renameJob({0}, {1}): {2}", new Object[]{oldFullName, newFullName, count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void deleteJob(String jobFullName) {
        LOGGER.log(Level.FINER, "deleteJob({0})", new Object[]{jobFullName});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("DELETE FROM JENKINS_JOB WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, jobFullName);
                stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                int count = stmt.executeUpdate();
                LOGGER.log(Level.FINE, "deleteJob({0}): {1}", new Object[]{jobFullName, count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void deleteBuild(String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "deleteBuild({0}#{1})", new Object[]{jobFullName, buildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            Integer lastSuccessfulBuildNumber;
            Integer lastBuildNumber;
            Long jobPrimaryKey;
            Throwable throwable;
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID, LAST_BUILD_NUMBER, LAST_SUCCESSFUL_BUILD_NUMBER FROM JENKINS_JOB WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, jobFullName);
                stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                throwable = null;
                try (ResultSet rst = stmt.executeQuery();){
                    if (rst.next()) {
                        jobPrimaryKey = rst.getLong("ID");
                        lastBuildNumber = rst.getInt("LAST_BUILD_NUMBER");
                        lastSuccessfulBuildNumber = rst.getInt("LAST_SUCCESSFUL_BUILD_NUMBER");
                    } else {
                        jobPrimaryKey = null;
                        lastBuildNumber = null;
                        lastSuccessfulBuildNumber = null;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            if (jobPrimaryKey == null) {
                LOGGER.log(Level.FINE, "No record found for job {0}", new Object[]{jobFullName});
                return;
            }
            if (buildNumber == lastBuildNumber || buildNumber == lastSuccessfulBuildNumber) {
                Integer newLastBuildNumber = lastBuildNumber == buildNumber ? null : lastBuildNumber;
                Integer newLastSuccessfulBuildNumber = lastSuccessfulBuildNumber == buildNumber ? null : lastSuccessfulBuildNumber;
                throwable = null;
                try (PreparedStatement stmt = cnn.prepareStatement("SELECT JENKINS_BUILD.NUMBER, RESULT_ID FROM JENKINS_BUILD WHERE JOB_ID = ? AND NUMBER != ? ORDER BY NUMBER DESC");){
                    stmt.setLong(1, jobPrimaryKey);
                    stmt.setInt(2, buildNumber);
                    stmt.setFetchSize(5);
                    try (ResultSet rst = stmt.executeQuery();){
                        while (rst.next() && (newLastBuildNumber == null || newLastSuccessfulBuildNumber == null)) {
                            int currentBuildNumber = rst.getInt("JENKINS_BUILD.NUMBER");
                            int currentBuildResultId = rst.getInt("RESULT_ID");
                            if (newLastBuildNumber == null) {
                                newLastBuildNumber = currentBuildNumber;
                            }
                            if (newLastSuccessfulBuildNumber != null || Result.SUCCESS.ordinal != currentBuildResultId) continue;
                            newLastSuccessfulBuildNumber = currentBuildNumber;
                        }
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                stmt = cnn.prepareStatement("UPDATE JENKINS_JOB SET LAST_BUILD_NUMBER = ?, LAST_SUCCESSFUL_BUILD_NUMBER = ? WHERE ID = ?");
                throwable = null;
                try {
                    stmt.setInt(1, newLastBuildNumber);
                    stmt.setInt(2, newLastSuccessfulBuildNumber);
                    stmt.setLong(3, jobPrimaryKey);
                    stmt.execute();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            stmt = cnn.prepareStatement("DELETE FROM JENKINS_BUILD WHERE JOB_ID = ? AND NUMBER = ?");
            var9_8 = null;
            try {
                stmt.setLong(1, jobPrimaryKey);
                stmt.setInt(2, buildNumber);
                int count = stmt.executeUpdate();
                LOGGER.log(Level.FINE, "deleteJob({0}#{1}): {2}", new Object[]{jobFullName, buildNumber, count});
            }
            catch (Throwable throwable6) {
                var9_8 = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (var9_8 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            var9_8.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void cleanup() {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            String sql = "DELETE FROM MAVEN_ARTIFACT WHERE ID NOT IN (SELECT DISTINCT ARTIFACT_ID FROM MAVEN_DEPENDENCY UNION SELECT DISTINCT ARTIFACT_ID FROM GENERATED_MAVEN_ARTIFACT)";
            try (Statement stmt = cnn.createStatement();){
                int count = stmt.executeUpdate(sql);
                LOGGER.log(Level.FINE, "cleanup(): {0}", new Object[]{count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getOrCreateBuildPrimaryKey(String jobFullName, int buildNumber) {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            Throwable throwable;
            ResultSet rst;
            Throwable throwable2;
            ResultSet rst2;
            cnn.setAutoCommit(false);
            Long jobPrimaryKey = null;
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_JOB WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, jobFullName);
                stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                rst2 = stmt.executeQuery();
                throwable2 = null;
                try {
                    if (rst2.next()) {
                        jobPrimaryKey = rst2.getLong(1);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rst2 != null) {
                        if (throwable2 != null) {
                            try {
                                rst2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            rst2.close();
                        }
                    }
                }
            }
            if (jobPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO JENKINS_JOB(FULL_NAME, JENKINS_MASTER_ID) VALUES (?, ?)", 1);
                var7_9 = null;
                try {
                    stmt.setString(1, jobFullName);
                    stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                    stmt.execute();
                    rst2 = stmt.getGeneratedKeys();
                    throwable2 = null;
                    try {
                        if (!rst2.next()) throw new IllegalStateException();
                        jobPrimaryKey = rst2.getLong(1);
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (rst2 != null) {
                            if (throwable2 != null) {
                                try {
                                    rst2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                rst2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable7) {
                    var7_9 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (stmt != null) {
                        if (var7_9 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable8) {
                                var7_9.addSuppressed(throwable8);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            Long buildPrimaryKey = null;
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_BUILD WHERE JOB_ID=? AND NUMBER=?");){
                stmt.setLong(1, jobPrimaryKey);
                stmt.setInt(2, buildNumber);
                rst = stmt.executeQuery();
                throwable = null;
                try {
                    if (rst.next()) {
                        buildPrimaryKey = rst.getLong(1);
                    }
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (rst != null) {
                        if (throwable != null) {
                            try {
                                rst.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            rst.close();
                        }
                    }
                }
            }
            if (buildPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO JENKINS_BUILD(JOB_ID, NUMBER) VALUES (?, ?)", 1);
                var8_11 = null;
                try {
                    stmt.setLong(1, jobPrimaryKey);
                    stmt.setInt(2, buildNumber);
                    stmt.execute();
                    rst = stmt.getGeneratedKeys();
                    throwable = null;
                    try {
                        if (!rst.next()) throw new IllegalStateException();
                        buildPrimaryKey = rst.getLong(1);
                    }
                    catch (Throwable throwable11) {
                        throwable = throwable11;
                        throw throwable11;
                    }
                    finally {
                        if (rst != null) {
                            if (throwable != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable12) {
                                    throwable.addSuppressed(throwable12);
                                }
                            } else {
                                rst.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable13) {
                    var8_11 = throwable13;
                    throw throwable13;
                }
                finally {
                    if (stmt != null) {
                        if (var8_11 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable14) {
                                var8_11.addSuppressed(throwable14);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            cnn.commit();
            long l = buildPrimaryKey;
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getOrCreateArtifactPrimaryKey(@Nonnull String groupId, @Nonnull String artifactId, @Nonnull String version, @Nonnull String type, @Nullable String classifier) {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            Throwable throwable;
            ResultSet rst2;
            Throwable throwable2;
            PreparedStatement stmt;
            Long artifactPrimaryKey;
            block90: {
                cnn.setAutoCommit(false);
                artifactPrimaryKey = null;
                if (classifier == null) {
                    stmt = cnn.prepareStatement("SELECT ID FROM MAVEN_ARTIFACT WHERE GROUP_ID = ? AND ARTIFACT_ID = ? AND VERSION = ? AND TYPE = ? AND CLASSIFIER is NULL");
                    throwable2 = null;
                    try {
                        stmt.setString(1, groupId);
                        stmt.setString(2, artifactId);
                        stmt.setString(3, version);
                        stmt.setString(4, type);
                        rst2 = stmt.executeQuery();
                        throwable = null;
                        try {
                            if (rst2.next()) {
                                artifactPrimaryKey = rst2.getLong(1);
                            }
                            break block90;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rst2 != null) {
                                if (throwable != null) {
                                    try {
                                        rst2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    rst2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable rst2) {
                        throwable2 = rst2;
                        throw rst2;
                    }
                    finally {
                        if (stmt != null) {
                            if (throwable2 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable rst2) {
                                    throwable2.addSuppressed(rst2);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                stmt = cnn.prepareStatement("SELECT ID FROM MAVEN_ARTIFACT WHERE GROUP_ID = ? AND ARTIFACT_ID = ? AND VERSION = ? AND TYPE = ? AND CLASSIFIER = ?");
                throwable2 = null;
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, artifactId);
                    stmt.setString(3, version);
                    stmt.setString(4, type);
                    stmt.setString(5, classifier);
                    rst2 = stmt.executeQuery();
                    throwable = null;
                    try {
                        if (rst2.next()) {
                            artifactPrimaryKey = rst2.getLong(1);
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (rst2 != null) {
                            if (throwable != null) {
                                try {
                                    rst2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                rst2.close();
                            }
                        }
                    }
                }
                catch (Throwable rst3) {
                    throwable2 = rst3;
                    throw rst3;
                }
                finally {
                    if (stmt != null) {
                        if (throwable2 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable rst3) {
                                throwable2.addSuppressed(rst3);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            if (artifactPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO MAVEN_ARTIFACT(GROUP_ID, ARTIFACT_ID, VERSION, TYPE, CLASSIFIER) VALUES (?, ?, ?, ?, ?)", 1);
                throwable2 = null;
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, artifactId);
                    stmt.setString(3, version);
                    stmt.setString(4, type);
                    stmt.setString(5, classifier);
                    stmt.execute();
                    rst2 = stmt.getGeneratedKeys();
                    throwable = null;
                    try {
                        if (!rst2.next()) throw new IllegalStateException();
                        artifactPrimaryKey = rst2.getLong(1);
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (rst2 != null) {
                            if (throwable != null) {
                                try {
                                    rst2.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                rst2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (stmt != null) {
                        if (throwable2 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            cnn.commit();
            long l = artifactPrimaryKey;
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected synchronized void initializeDatabase() {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            String sqlScriptPath;
            InputStream sqlScriptInputStream;
            cnn.setAutoCommit(false);
            int initialSchemaVersion = this.getSchemaVersion(cnn);
            LOGGER.log(Level.FINE, "Initialise database. Current schema version: {0}", new Object[]{initialSchemaVersion});
            DecimalFormat numberFormat = new DecimalFormat("00");
            int idx = initialSchemaVersion;
            while ((sqlScriptInputStream = ClassUtils.getResourceAsStream(sqlScriptPath = "sql/h2/" + numberFormat.format(++idx) + "_migration.sql")) != null) {
                try (Statement stmt = cnn.createStatement();){
                    String sqlScript = IOUtils.toString((InputStream)sqlScriptInputStream);
                    LOGGER.log(Level.FINE, "Execute database migration script {0}", sqlScriptPath);
                    stmt.execute(sqlScript);
                }
                catch (IOException e) {
                    throw new RuntimeIoException("Exception reading " + sqlScriptPath, e);
                }
                String className = "org.jenkinsci.plugins.pipeline.maven.db.migration.h2.MigrationStep" + idx;
                try {
                    MigrationStep migrationStep = (MigrationStep)Class.forName(className).newInstance();
                    LOGGER.log(Level.FINE, "Execute database migration step {0}", migrationStep.getClass().getName());
                    migrationStep.execute(cnn, this.getJenkinsDetails());
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.FINER, "Migration step {0} not found", new Object[]{className});
                }
                catch (Exception e) {
                    cnn.rollback();
                    throw new RuntimeException(e);
                }
                cnn.commit();
            }
            int newSchemaVersion = this.getSchemaVersion(cnn);
            if (newSchemaVersion == 0) {
                throw new IllegalStateException("Failure to load database DDL files. Files 'sql/h2/xxx_migration.sql' NOT found in the Thread Context Class Loader.  Pipeline Maven Plugin may be installed in an unsupported manner (thread.contextClassLoader: " + Thread.currentThread().getContextClassLoader() + ", classLoader: " + ClassUtils.class.getClassLoader() + ")");
            }
            if (newSchemaVersion == initialSchemaVersion) {
            } else {
                LOGGER.log(Level.INFO, "Database successfully migrated from version {0} to version {1}", new Object[]{initialSchemaVersion, newSchemaVersion});
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected int getSchemaVersion(Connection cnn) throws SQLException {
        int schemaVersion;
        block27: {
            try (Statement stmt = cnn.createStatement();){
                try (ResultSet rst = stmt.executeQuery("SELECT * FROM VERSION");){
                    schemaVersion = rst.next() ? rst.getInt(1) : 0;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 42102) {
                        schemaVersion = 0;
                        break block27;
                    }
                    throw new RuntimeSqlException(e);
                }
            }
        }
        return schemaVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void testDatabase() throws RuntimeSqlException {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            List<String> tables = Arrays.asList("MAVEN_ARTIFACT", "JENKINS_JOB", "JENKINS_BUILD", "MAVEN_DEPENDENCY", "GENERATED_MAVEN_ARTIFACT", "MAVEN_PARENT_PROJECT");
            for (String table : tables) {
                try {
                    Statement stmt = cnn.createStatement();
                    Throwable throwable = null;
                    try {
                        ResultSet rst = stmt.executeQuery("SELECT count(*) FROM " + table);
                        Throwable throwable2 = null;
                        try {
                            if (!rst.next()) throw new IllegalStateException("Exception testing table '" + table + "'");
                            int count = rst.getInt(1);
                            LOGGER.log(Level.FINE, "Table {0}: {1} rows", new Object[]{table, count});
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rst == null) continue;
                            if (throwable2 != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            rst.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (stmt == null) continue;
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeSqlException("Exception testing table '" + table + "' on " + cnn.toString(), e);
                    return;
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    @Nonnull
    @Deprecated
    public List<String> listDownstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        List<String> downstreamJobs = this.listDownstreamPipelinesBasedOnMavenDependencies(jobFullName, buildNumber);
        downstreamJobs.addAll(this.listDownstreamPipelinesBasedOnParentProjectDependencies(jobFullName, buildNumber));
        downstreamJobs.remove(jobFullName);
        return downstreamJobs;
    }

    @Override
    @Nonnull
    public Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifact(@Nonnull String jobFullName, int buildNumber) {
        MavenArtifact mavenArtifact;
        Map<MavenArtifact, SortedSet<String>> downstreamJobsByArtifactBasedOnMavenDependencies = this.listDownstreamJobsByArtifactBasedOnMavenDependencies(jobFullName, buildNumber);
        Map<MavenArtifact, SortedSet<String>> downstreamJobsByArtifactBasedOnParentProjectDependencies = this.listDownstreamJobsByArtifactBasedOnParentProjectDependencies(jobFullName, buildNumber);
        HashMap<MavenArtifact, SortedSet<String>> results = new HashMap<MavenArtifact, SortedSet<String>>();
        results.putAll(downstreamJobsByArtifactBasedOnMavenDependencies);
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : downstreamJobsByArtifactBasedOnParentProjectDependencies.entrySet()) {
            mavenArtifact = entry.getKey();
            if (results.containsKey(mavenArtifact)) {
                ((SortedSet)results.get(mavenArtifact)).addAll((Collection)entry.getValue());
                continue;
            }
            results.put(mavenArtifact, new TreeSet<String>(entry.getValue()));
        }
        Iterator it = results.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<MavenArtifact, SortedSet<String>> entry;
            entry = it.next();
            mavenArtifact = entry.getKey();
            SortedSet<String> jobs = entry.getValue();
            boolean removed = jobs.remove(jobFullName);
            if (!removed) continue;
            LOGGER.log(Level.FINER, "Remove {0} from downstreamJobs of artifact {1}", new Object[]{jobFullName, mavenArtifact});
            if (!jobs.isEmpty()) continue;
            it.remove();
        }
        return results;
    }

    @Deprecated
    protected List<String> listDownstreamPipelinesBasedOnMavenDependencies(@Nonnull String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "listDownstreamJobs({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name \nfrom jenkins_job as upstream_job \ninner join jenkins_build as upstream_build on upstream_job.id = upstream_build.job_id \ninner join generated_maven_artifact on (upstream_build.id = generated_maven_artifact.build_id and generated_maven_artifact.skip_downstream_triggers = false) \ninner join maven_artifact on generated_maven_artifact.artifact_id = maven_artifact.id \ninner join maven_dependency on (maven_dependency.artifact_id = maven_artifact.id and maven_dependency.ignore_upstream_triggers = false) \ninner join jenkins_build as downstream_build on maven_dependency.build_id = downstream_build.id \ninner join jenkins_job as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        ArrayList<String> downstreamJobsFullNames = new ArrayList<String>();
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listDownstreamJobs({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }

    protected Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifactBasedOnMavenDependencies(@Nonnull String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "listDownstreamJobsByArtifactBasedOnMavenDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name, \n    maven_artifact.group_id, maven_artifact.artifact_id, maven_artifact.version, maven_artifact.type, maven_artifact.classifier, \n   generated_maven_artifact.version, generated_maven_artifact.extension \nfrom jenkins_job as upstream_job \ninner join jenkins_build as upstream_build on upstream_job.id = upstream_build.job_id \ninner join generated_maven_artifact on (upstream_build.id = generated_maven_artifact.build_id and generated_maven_artifact.skip_downstream_triggers = false) \ninner join maven_artifact on generated_maven_artifact.artifact_id = maven_artifact.id \ninner join maven_dependency on (maven_dependency.artifact_id = maven_artifact.id and maven_dependency.ignore_upstream_triggers = false) \ninner join jenkins_build as downstream_build on maven_dependency.build_id = downstream_build.id \ninner join jenkins_job as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        HashMap<MavenArtifact, SortedSet<String>> results = new HashMap<MavenArtifact, SortedSet<String>>();
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenArtifact artifact = new MavenArtifact();
                    artifact.groupId = rst.getString("group_id");
                    artifact.artifactId = rst.getString("artifact_id");
                    artifact.version = rst.getString("generated_maven_artifact.version");
                    artifact.baseVersion = rst.getString("maven_artifact.version");
                    artifact.type = rst.getString("type");
                    artifact.classifier = rst.getString("classifier");
                    artifact.extension = rst.getString("extension");
                    String downstreamJobFullName = rst.getString("full_name");
                    if (results.containsKey(artifact)) {
                        ((SortedSet)results.get(artifact)).add(downstreamJobFullName);
                        continue;
                    }
                    results.put(artifact, new TreeSet<String>(Collections.singleton(downstreamJobFullName)));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listDownstreamJobsByArtifactBasedOnMavenDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, results});
        return results;
    }

    @Deprecated
    protected List<String> listDownstreamPipelinesBasedOnParentProjectDependencies(@Nonnull String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name \nfrom jenkins_job as upstream_job \ninner join jenkins_build as upstream_build on upstream_job.id = upstream_build.job_id \ninner join generated_maven_artifact on (upstream_build.id = generated_maven_artifact.build_id and generated_maven_artifact.skip_downstream_triggers = false) \ninner join maven_artifact on generated_maven_artifact.artifact_id = maven_artifact.id \ninner join maven_parent_project on (maven_parent_project.artifact_id = maven_artifact.id and maven_parent_project.ignore_upstream_triggers = false) \ninner join jenkins_build as downstream_build on maven_parent_project.build_id = downstream_build.id \ninner join jenkins_job as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        ArrayList<String> downstreamJobsFullNames = new ArrayList<String>();
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }

    protected Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifactBasedOnParentProjectDependencies(String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name, \n   maven_artifact.group_id, maven_artifact.artifact_id, maven_artifact.version, maven_artifact.type, maven_artifact.classifier, \n   generated_maven_artifact.version, generated_maven_artifact.extension \nfrom jenkins_job as upstream_job \ninner join jenkins_build as upstream_build on upstream_job.id = upstream_build.job_id \ninner join generated_maven_artifact on (upstream_build.id = generated_maven_artifact.build_id and generated_maven_artifact.skip_downstream_triggers = false) \ninner join maven_artifact on generated_maven_artifact.artifact_id = maven_artifact.id \ninner join maven_parent_project on (maven_parent_project.artifact_id = maven_artifact.id and maven_parent_project.ignore_upstream_triggers = false) \ninner join jenkins_build as downstream_build on maven_parent_project.build_id = downstream_build.id \ninner join jenkins_job as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        HashMap<MavenArtifact, SortedSet<String>> results = new HashMap<MavenArtifact, SortedSet<String>>();
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenArtifact artifact = new MavenArtifact();
                    artifact.groupId = rst.getString("group_id");
                    artifact.artifactId = rst.getString("artifact_id");
                    artifact.version = rst.getString("generated_maven_artifact.version");
                    artifact.baseVersion = rst.getString("maven_artifact.version");
                    artifact.type = rst.getString("type");
                    artifact.classifier = rst.getString("classifier");
                    artifact.extension = rst.getString("extension");
                    String downstreamJobFullName = rst.getString("full_name");
                    if (results.containsKey(artifact)) {
                        ((SortedSet)results.get(artifact)).add(jobFullName);
                        continue;
                    }
                    results.put(artifact, new TreeSet<String>(Collections.singleton(downstreamJobFullName)));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listDownstreamJobsByArtifactBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, results});
        return results;
    }

    @Override
    @Nonnull
    public Map<String, Integer> listUpstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        Map<String, Integer> upstreamJobs = this.listUpstreamPipelinesBasedOnMavenDependencies(jobFullName, buildNumber);
        upstreamJobs.putAll(this.listUpstreamPipelinesBasedOnParentProjectDependencies(jobFullName, buildNumber));
        upstreamJobs.remove(jobFullName);
        return upstreamJobs;
    }

    protected Map<String, Integer> listUpstreamPipelinesBasedOnMavenDependencies(@Nonnull String downstreamJobFullName, int downstreamBuildNumber) {
        LOGGER.log(Level.FINER, "listUpstreamPipelinesBasedOnMavenDependencies({0}, {1})", new Object[]{downstreamJobFullName, downstreamBuildNumber});
        String sql = "select  upstream_job.full_name, upstream_build.number\nfrom jenkins_job as upstream_job\ninner join jenkins_build as upstream_build on (upstream_job.id = upstream_build.job_id and upstream_job.last_successful_build_number = upstream_build.number)\ninner join generated_maven_artifact on (upstream_build.id = generated_maven_artifact.build_id  and generated_maven_artifact.skip_downstream_triggers = false)\ninner join maven_artifact on generated_maven_artifact.artifact_id = maven_artifact.id\ninner join maven_dependency on (maven_dependency.artifact_id = maven_artifact.id and maven_dependency.ignore_upstream_triggers = false)\ninner join jenkins_build as downstream_build on maven_dependency.build_id = downstream_build.id\ninner join jenkins_job as downstream_job on downstream_build.job_id = downstream_job.id\nwhere downstream_job.full_name = ? and downstream_job.jenkins_master_id = ? and  downstream_build.number = ? and upstream_job.jenkins_master_id = ?";
        HashMap<String, Integer> upstreamJobsFullNames = new HashMap<String, Integer>();
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, downstreamJobFullName, downstreamBuildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, downstreamJobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, downstreamBuildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    upstreamJobsFullNames.put(rst.getString(1), rst.getInt(2));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listUpstreamPipelinesBasedOnMavenDependencies({0}, {1}): {2}", new Object[]{downstreamJobFullName, downstreamBuildNumber, upstreamJobsFullNames});
        return upstreamJobsFullNames;
    }

    protected Map<String, Integer> listUpstreamPipelinesBasedOnParentProjectDependencies(@Nonnull String downstreamJobFullName, int downstreamBuildNumber) {
        LOGGER.log(Level.FINER, "listUpstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{downstreamJobFullName, downstreamBuildNumber});
        String sql = "select  upstream_job.full_name, upstream_build.number\nfrom jenkins_job as upstream_job\ninner join jenkins_build as upstream_build on (upstream_job.id = upstream_build.job_id and upstream_job.last_successful_build_number = upstream_build.number)\ninner join generated_maven_artifact on (upstream_build.id = generated_maven_artifact.build_id  and generated_maven_artifact.skip_downstream_triggers = false)\ninner join maven_artifact on generated_maven_artifact.artifact_id = maven_artifact.id\ninner join maven_parent_project on (maven_parent_project.artifact_id = maven_artifact.id and maven_parent_project.ignore_upstream_triggers = false)\ninner join jenkins_build as downstream_build on maven_parent_project.build_id = downstream_build.id\ninner join jenkins_job as downstream_job on downstream_build.job_id = downstream_job.id\nwhere downstream_job.full_name = ? and downstream_job.jenkins_master_id = ? and  downstream_build.number = ? and upstream_job.jenkins_master_id = ?";
        HashMap<String, Integer> upstreamJobsFullNames = new HashMap<String, Integer>();
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, downstreamJobFullName, downstreamBuildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, downstreamJobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, downstreamBuildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    upstreamJobsFullNames.put(rst.getString(1), rst.getInt(2));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listUpstreamPipelinesBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{downstreamJobFullName, downstreamBuildNumber, upstreamJobsFullNames});
        return upstreamJobsFullNames;
    }

    @Override
    @Nonnull
    public Map<String, Integer> listTransitiveUpstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        return this.listTransitiveUpstreamJobs(jobFullName, buildNumber, new HashMap<String, Integer>());
    }

    private Map<String, Integer> listTransitiveUpstreamJobs(@Nonnull String jobFullName, int buildNumber, Map<String, Integer> transitiveUpstreamBuilds) {
        Map<String, Integer> upstreamBuilds = this.listUpstreamJobs(jobFullName, buildNumber);
        for (Map.Entry<String, Integer> upstreamBuild : upstreamBuilds.entrySet()) {
            String upstreamJobFullName = upstreamBuild.getKey();
            Integer upstreamBuildNumber = upstreamBuild.getValue();
            if (transitiveUpstreamBuilds.containsKey(upstreamJobFullName)) continue;
            transitiveUpstreamBuilds.put(upstreamJobFullName, upstreamBuildNumber);
            this.listTransitiveUpstreamJobs(upstreamJobFullName, upstreamBuildNumber, transitiveUpstreamBuilds);
        }
        return transitiveUpstreamBuilds;
    }

    @Override
    @Nonnull
    public List<MavenArtifact> getGeneratedArtifacts(@Nonnull String jobFullName, @Nonnull int buildNumber) {
        LOGGER.log(Level.FINER, "getGeneratedArtifacts({0}, {1})", new Object[]{jobFullName, buildNumber});
        String generatedArtifactsSql = "SELECT DISTINCT MAVEN_ARTIFACT.*,  GENERATED_MAVEN_ARTIFACT.*  FROM MAVEN_ARTIFACT  INNER JOIN GENERATED_MAVEN_ARTIFACT ON MAVEN_ARTIFACT.ID = GENERATED_MAVEN_ARTIFACT.ARTIFACT_ID INNER JOIN JENKINS_BUILD AS UPSTREAM_BUILD ON GENERATED_MAVEN_ARTIFACT.BUILD_ID = UPSTREAM_BUILD.ID  INNER JOIN JENKINS_JOB AS UPSTREAM_JOB ON UPSTREAM_BUILD.JOB_ID = UPSTREAM_JOB.ID  WHERE    UPSTREAM_JOB.FULL_NAME = ? AND   UPSTREAM_JOB.JENKINS_MASTER_ID = ? AND   UPSTREAM_BUILD.NUMBER = ? ";
        ArrayList<MavenArtifact> results = new ArrayList<MavenArtifact>();
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(generatedArtifactsSql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenArtifact artifact = new MavenArtifact();
                    artifact.groupId = rst.getString("maven_artifact.group_id");
                    artifact.artifactId = rst.getString("maven_artifact.artifact_id");
                    artifact.version = rst.getString("maven_artifact.version");
                    artifact.type = rst.getString("maven_artifact.type");
                    artifact.classifier = rst.getString("maven_artifact.classifier");
                    artifact.baseVersion = rst.getString("generated_maven_artifact.version");
                    artifact.repositoryUrl = rst.getString("generated_maven_artifact.repository_url");
                    artifact.extension = rst.getString("generated_maven_artifact.extension");
                    artifact.snapshot = artifact.version.endsWith("-SNAPSHOT");
                    results.add(artifact);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        Collections.sort(results);
        return results;
    }

    @Nonnull
    public synchronized Long getJenkinsMasterPrimaryKey(Connection cnn) throws SQLException {
        block53: {
            if (this.jenkinsMasterPrimaryKey == null) {
                Throwable throwable;
                ResultSet rst;
                String jenkinsMasterLegacyInstanceId = this.getJenkinsDetails().getMasterLegacyInstanceId();
                String jenkinsMasterUrl = this.getJenkinsDetails().getMasterRootUrl();
                try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_MASTER WHERE LEGACY_INSTANCE_ID=?");){
                    stmt.setString(1, jenkinsMasterLegacyInstanceId);
                    rst = stmt.executeQuery();
                    throwable = null;
                    try {
                        if (rst.next()) {
                            this.jenkinsMasterPrimaryKey = rst.getLong("ID");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rst != null) {
                            if (throwable != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                rst.close();
                            }
                        }
                    }
                }
                if (this.jenkinsMasterPrimaryKey == null) {
                    stmt = cnn.prepareStatement("INSERT INTO JENKINS_MASTER(LEGACY_INSTANCE_ID, URL) values (?, ?)");
                    var5_5 = null;
                    try {
                        stmt.setString(1, jenkinsMasterLegacyInstanceId);
                        stmt.setString(2, jenkinsMasterUrl);
                        stmt.execute();
                        rst = stmt.getGeneratedKeys();
                        throwable = null;
                        try {
                            if (rst.next()) {
                                this.jenkinsMasterPrimaryKey = rst.getLong(1);
                                break block53;
                            }
                            throw new IllegalStateException();
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (rst != null) {
                                if (throwable != null) {
                                    try {
                                        rst.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    rst.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable6) {
                        var5_5 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (stmt != null) {
                            if (var5_5 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable7) {
                                    var5_5.addSuppressed(throwable7);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
            }
        }
        return this.jenkinsMasterPrimaryKey;
    }

    protected MigrationStep.JenkinsDetails getJenkinsDetails() {
        return new MigrationStep.JenkinsDetails();
    }

    @Override
    public String toPrettyString() {
        ArrayList<String> prettyStrings = new ArrayList<String>();
        try {
            Connection cnn = this.jdbcConnectionPool.getConnection();
            Object object = null;
            try {
                prettyStrings.add("jdbc.url: " + cnn.getMetaData().getURL());
                List<String> tables = Arrays.asList("JENKINS_MASTER", "MAVEN_ARTIFACT", "JENKINS_JOB", "JENKINS_BUILD", "MAVEN_DEPENDENCY", "GENERATED_MAVEN_ARTIFACT", "MAVEN_PARENT_PROJECT", "JENKINS_BUILD_UPSTREAM_CAUSE");
                for (String table : tables) {
                    try {
                        Statement stmt = cnn.createStatement();
                        Throwable throwable = null;
                        try {
                            ResultSet rst = stmt.executeQuery("SELECT count(*) FROM " + table);
                            Throwable throwable2 = null;
                            try {
                                if (rst.next()) {
                                    int count = rst.getInt(1);
                                    prettyStrings.add("Table " + table + ": " + count + " rows");
                                    continue;
                                }
                                prettyStrings.add("Table " + table + ": #IllegalStateException 'select count(*)' didn't return any row#");
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (rst == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        rst.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                rst.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        prettyStrings.add("Table " + table + ": " + e);
                        LOGGER.log(Level.WARNING, "SQLException counting rows on " + table, e);
                    }
                }
            }
            catch (Throwable tables) {
                object = tables;
                throw tables;
            }
            finally {
                if (cnn != null) {
                    if (object != null) {
                        try {
                            cnn.close();
                        }
                        catch (Throwable tables) {
                            ((Throwable)object).addSuppressed(tables);
                        }
                    } else {
                        cnn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            prettyStrings.add("SQLException getting a connection to " + this.jdbcConnectionPool + ": " + e);
            LOGGER.log(Level.WARNING, "SQLException getting a connection to " + this.jdbcConnectionPool, e);
        }
        StringBuilder result = new StringBuilder("PipelineMavenPluginH2Dao ");
        for (String prettyString : prettyStrings) {
            result.append("\r\n\t" + prettyString);
        }
        return result.toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateBuildOnCompletion(@Nonnull String jobFullName, int buildNumber, int buildResultOrdinal, long startTimeInMillis, long durationInMillis) {
        PipelineMavenPluginH2Dao.LOGGER.log(Level.FINE, "updateBuildOnCompletion({0}, {1}, result: {2}, startTime): {3}, duration: {4}", new Object[]{jobFullName, buildNumber, buildResultOrdinal, startTimeInMillis, durationInMillis});
        buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        try {
            cnn = this.jdbcConnectionPool.getConnection();
            var11_9 = null;
            try {
                cnn.setAutoCommit(false);
                stmt = cnn.prepareStatement("UPDATE JENKINS_BUILD SET RESULT_ID = ?, START_TIME = ?, DURATION_IN_MILLIS = ? WHERE ID = ?");
                var13_13 = null;
                try {
                    stmt.setInt(1, buildResultOrdinal);
                    stmt.setTimestamp(2, new Timestamp(startTimeInMillis));
                    stmt.setLong(3, durationInMillis);
                    stmt.setLong(4, buildPrimaryKey);
                    count = stmt.executeUpdate();
                    if (count != 1) {
                        PipelineMavenPluginH2Dao.LOGGER.log(Level.WARNING, "updateBuildOnCompletion - more/less than 1 jenkins_build record updated (" + count + ") for " + jobFullName + "#" + buildNumber);
                    }
                }
                catch (Throwable count) {
                    var13_13 = count;
                    throw count;
                }
                finally {
                    if (stmt != null) {
                        if (var13_13 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable count) {
                                var13_13.addSuppressed(count);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                if (Result.SUCCESS.ordinal == buildResultOrdinal) {
                    stmt = cnn.prepareStatement("UPDATE JENKINS_JOB set LAST_BUILD_NUMBER = ?, LAST_SUCCESSFUL_BUILD_NUMBER = ? where FULL_NAME = ?");
                    var13_13 = null;
                    try {
                        stmt.setInt(1, buildNumber);
                        stmt.setInt(2, buildNumber);
                        stmt.setString(3, jobFullName);
                        count = stmt.executeUpdate();
                        if (count == 1) ** GOTO lbl82
                        PipelineMavenPluginH2Dao.LOGGER.log(Level.WARNING, "updateBuildOnCompletion - more/less than 1 jenkins_job record updated (" + count + ") for " + jobFullName + "#" + buildNumber);
                    }
                    catch (Throwable count) {
                        var13_13 = count;
                        throw count;
                    }
                    finally {
                        if (stmt != null) {
                            if (var13_13 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable count) {
                                    var13_13.addSuppressed(count);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                } else {
                    stmt = cnn.prepareStatement("UPDATE JENKINS_JOB set LAST_BUILD_NUMBER = ? where FULL_NAME = ?");
                    var13_13 = null;
                    try {
                        stmt.setInt(1, buildNumber);
                        stmt.setString(2, jobFullName);
                        count = stmt.executeUpdate();
                        if (count != 1) {
                            PipelineMavenPluginH2Dao.LOGGER.log(Level.WARNING, "updateBuildOnCompletion - more/less than 1 jenkins_job record updated (" + count + ") for " + jobFullName + "#" + buildNumber);
                        }
                    }
                    catch (Throwable var14_20) {
                        var13_13 = var14_20;
                        throw var14_20;
                    }
                    finally {
                        if (stmt != null) {
                            if (var13_13 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable var14_19) {
                                    var13_13.addSuppressed(var14_19);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                cnn.commit();
            }
            catch (Throwable var12_12) {
                var11_9 = var12_12;
                throw var12_12;
            }
            finally {
                if (cnn != null) {
                    if (var11_9 != null) {
                        try {
                            cnn.close();
                        }
                        catch (Throwable var12_11) {
                            var11_9.addSuppressed(var12_11);
                        }
                    } else {
                        cnn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException("Exception updating build " + jobFullName + "#" + buildNumber + " with result " + buildResultOrdinal, e);
        }
    }
}

