/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.CompareToBuilder;

public class MavenArtifact
implements Serializable,
Comparable<MavenArtifact> {
    private static final long serialVersionUID = 1L;
    public String groupId;
    public String artifactId;
    public String version;
    public String baseVersion;
    public String type;
    public String classifier;
    public String extension;
    @Nullable
    public String file;
    public boolean snapshot;
    @Nullable
    public String repositoryUrl;

    @Nonnull
    public String getFileName() {
        return this.artifactId + "-" + this.version + (this.classifier == null || this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + this.extension;
    }

    @Nonnull
    public String getFileNameWithBaseVersion() {
        return this.artifactId + "-" + this.baseVersion + (this.classifier == null || this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + this.extension;
    }

    @Nonnull
    public String getId() {
        return this.groupId + ":" + this.artifactId + ":" + this.type + ":" + (this.classifier == null || this.classifier.isEmpty() ? "" : this.classifier + ":") + (this.baseVersion == null ? this.version : this.baseVersion);
    }

    @Nonnull
    public String getShortDescription() {
        if (this.baseVersion == null) {
            return this.getId();
        }
        return this.groupId + ":" + this.artifactId + ":" + this.type + ":" + (this.classifier == null || this.classifier.isEmpty() ? "" : this.classifier + ":") + this.baseVersion + "(" + this.version + ")";
    }

    @Nullable
    public String getUrl() {
        if (this.repositoryUrl == null) {
            return null;
        }
        return this.repositoryUrl + "/" + this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/" + this.getFileNameWithBaseVersion();
    }

    public String toString() {
        return "MavenArtifact{" + this.groupId + ":" + this.artifactId + ":" + this.type + (this.classifier == null ? "" : ":" + this.classifier) + ":" + this.baseVersion + "(version: " + this.version + ", snapshot:" + this.snapshot + ") " + (this.file == null ? "" : " " + this.file) + '}';
    }

    @Override
    public int compareTo(MavenArtifact o) {
        return new CompareToBuilder().append((Object)this.groupId, (Object)o.groupId).append((Object)this.artifactId, (Object)o.artifactId).append((Object)this.baseVersion, (Object)o.baseVersion).append((Object)this.version, (Object)o.version).append((Object)this.type, (Object)o.type).append((Object)this.classifier, (Object)o.classifier).toComparison();
    }

    public boolean isDeployed() {
        return this.repositoryUrl != null && !this.repositoryUrl.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.baseVersion, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtifact other = (MavenArtifact)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.baseVersion == null ? other.baseVersion != null : !this.baseVersion.equals(other.baseVersion)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier));
    }
}

