/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.tools.ToolConfigurationCategory;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.h2.jdbcx.JdbcConnectionPool;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginH2Dao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginMonitoringDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginNullDao;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=50.0)
@Symbol(value={"pipelineMaven"})
public class GlobalPipelineMavenConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(GlobalPipelineMavenConfig.class.getName());
    private transient PipelineMavenPluginDao dao;
    private boolean triggerDownstreamUponResultSuccess = true;
    private boolean triggerDownstreamUponResultUnstable;
    private boolean triggerDownstreamUponResultFailure;
    private boolean triggerDownstreamUponResultNotBuilt;
    private boolean triggerDownstreamUponResultAborted;
    private String jdbcUrl;
    private String jdbcCredentialsId;
    private List<MavenPublisher> publisherOptions;

    @DataBoundConstructor
    public GlobalPipelineMavenConfig() {
        this.load();
    }

    public ToolConfigurationCategory getCategory() {
        return (ToolConfigurationCategory)GlobalConfigurationCategory.get(ToolConfigurationCategory.class);
    }

    @CheckForNull
    public List<MavenPublisher> getPublisherOptions() {
        return this.publisherOptions;
    }

    @DataBoundSetter
    public void setPublisherOptions(List<MavenPublisher> publisherOptions) {
        this.publisherOptions = publisherOptions;
    }

    public boolean isTriggerDownstreamUponResultSuccess() {
        return this.triggerDownstreamUponResultSuccess;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultSuccess(boolean triggerDownstreamUponResultSuccess) {
        this.triggerDownstreamUponResultSuccess = triggerDownstreamUponResultSuccess;
    }

    public boolean isTriggerDownstreamUponResultUnstable() {
        return this.triggerDownstreamUponResultUnstable;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultUnstable(boolean triggerDownstreamUponResultUnstable) {
        this.triggerDownstreamUponResultUnstable = triggerDownstreamUponResultUnstable;
    }

    public boolean isTriggerDownstreamUponResultFailure() {
        return this.triggerDownstreamUponResultFailure;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultFailure(boolean triggerDownstreamUponResultFailure) {
        this.triggerDownstreamUponResultFailure = triggerDownstreamUponResultFailure;
    }

    public boolean isTriggerDownstreamUponResultNotBuilt() {
        return this.triggerDownstreamUponResultNotBuilt;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultNotBuilt(boolean triggerDownstreamUponResultNotBuilt) {
        this.triggerDownstreamUponResultNotBuilt = triggerDownstreamUponResultNotBuilt;
    }

    public boolean isTriggerDownstreamUponResultAborted() {
        return this.triggerDownstreamUponResultAborted;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultAborted(boolean triggerDownstreamUponResultAborted) {
        this.triggerDownstreamUponResultAborted = triggerDownstreamUponResultAborted;
    }

    public synchronized String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @DataBoundSetter
    public synchronized void setJdbcUrl(String jdbcUrl) {
        if (!Objects.equals(jdbcUrl, this.jdbcUrl)) {
            this.dao = null;
        }
        this.jdbcUrl = jdbcUrl;
    }

    public synchronized String getJdbcCredentialsId() {
        return this.jdbcCredentialsId;
    }

    @DataBoundSetter
    public synchronized void setJdbcCredentialsId(String jdbcCredentialsId) {
        if (!Objects.equals(jdbcCredentialsId, this.jdbcCredentialsId)) {
            this.dao = null;
        }
        this.jdbcCredentialsId = jdbcCredentialsId;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.publisherOptions = req.bindJSONToList(MavenPublisher.class, json.get("publisherOptions"));
        this.save();
        return true;
    }

    @Nonnull
    public synchronized PipelineMavenPluginDao getDao() {
        block10: {
            if (this.dao == null) {
                try {
                    if (this.jdbcUrl == null || this.jdbcUrl.trim().isEmpty()) {
                        boolean created;
                        File jenkinsRootDir = Jenkins.getInstance().getRootDir();
                        File databaseRootDir = new File(jenkinsRootDir, "jenkins-jobs");
                        if (!databaseRootDir.exists() && !(created = databaseRootDir.mkdirs())) {
                            throw new IllegalStateException("Failure to create database root dir " + databaseRootDir);
                        }
                        this.dao = new PipelineMavenPluginMonitoringDao(new PipelineMavenPluginH2Dao(databaseRootDir));
                        break block10;
                    }
                    if (this.jdbcUrl.startsWith("jdbc:h2:")) {
                        if (this.jdbcCredentialsId == null || this.jdbcCredentialsId.isEmpty()) {
                            throw new IllegalStateException("No credentials defined for JDBC URL '" + this.jdbcUrl + "'");
                        }
                        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)this.jdbcCredentialsId));
                        if (credentials == null) {
                            throw new IllegalStateException("Credentials '" + this.jdbcCredentialsId + "' defined for JDBC URL '" + this.jdbcUrl + "' NOT found");
                        }
                        JdbcConnectionPool jdbcConnectionPool = JdbcConnectionPool.create((String)this.jdbcUrl, (String)credentials.getUsername(), (String)Secret.toString((Secret)credentials.getPassword()));
                        try {
                            this.dao = new PipelineMavenPluginMonitoringDao(new PipelineMavenPluginH2Dao(jdbcConnectionPool));
                            break block10;
                        }
                        catch (Exception e) {
                            throw new SQLException("Exception connecting to '" + this.jdbcUrl + "' with credentials '" + this.jdbcCredentialsId + "' - " + credentials.getUsername() + "/***", e);
                        }
                    }
                    LOGGER.warning("Unsupported jdbc URL '" + this.jdbcUrl + "'. JDBC URL must start with 'jdbc:h2:'");
                    this.dao = new PipelineMavenPluginNullDao();
                }
                catch (RuntimeException | SQLException e) {
                    LOGGER.log(Level.WARNING, "Exception creating database dao, skip", e);
                    this.dao = new PipelineMavenPluginNullDao();
                }
            }
        }
        return this.dao;
    }

    @Nonnull
    public Set<Result> getTriggerDownstreamBuildsResultsCriteria() {
        HashSet<Result> result = new HashSet<Result>(5);
        if (this.triggerDownstreamUponResultSuccess) {
            result.add(Result.SUCCESS);
        }
        if (this.triggerDownstreamUponResultUnstable) {
            result.add(Result.UNSTABLE);
        }
        if (this.triggerDownstreamUponResultAborted) {
            result.add(Result.ABORTED);
        }
        if (this.triggerDownstreamUponResultNotBuilt) {
            result.add(Result.NOT_BUILT);
        }
        if (this.triggerDownstreamUponResultFailure) {
            result.add(Result.FAILURE);
        }
        return result;
    }

    @Nullable
    public static GlobalPipelineMavenConfig get() {
        return (GlobalPipelineMavenConfig)((Object)GlobalConfiguration.all().get(GlobalPipelineMavenConfig.class));
    }

    public ListBoxModel doFillJdbcCredentialsIdItems() {
        return new StandardListBoxModel().includeEmptyValue().withMatching(CredentialsMatchers.always(), (Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST));
    }
}

