/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.TestDataPublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.w3c.dom.Element;

public class JunitTestsPublisher
extends MavenPublisher {
    private static final Logger LOGGER = Logger.getLogger(JunitTestsPublisher.class.getName());
    private static final String GROUP_ID = "org.apache.maven.plugins";
    private static final String SUREFIRE_ID = "maven-surefire-plugin";
    private static final String FAILSAFE_ID = "maven-failsafe-plugin";
    private static final String SUREFIRE_GOAL = "test";
    private static final String FAILSAFE_GOAL = "integration-test";
    private static final long serialVersionUID = 1L;
    private boolean keepLongStdio;
    @CheckForNull
    private Double healthScaleFactor;
    private boolean ignoreAttachments;

    @DataBoundConstructor
    public JunitTestsPublisher() {
    }

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        try {
            Class.forName("hudson.tasks.junit.JUnitResultArchiver");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] Jenkins ");
            listener.hyperlink("http://wiki.jenkins-ci.org/display/JENKINS/JUnit+Plugin", "JUnit Plugin");
            listener.getLogger().print(" not found, don't display org.apache.maven.plugins:maven-surefire-plugin:test");
            listener.getLogger().print(" nor org.apache.maven.plugins:maven-failsafe-plugin:integration-test results in pipeline screen.");
            return;
        }
        List<Element> sureFireTestEvents = XmlUtils.getExecutionEvents(mavenSpyLogsElt, GROUP_ID, SUREFIRE_ID, SUREFIRE_GOAL);
        List<Element> failSafeTestEvents = XmlUtils.getExecutionEvents(mavenSpyLogsElt, GROUP_ID, FAILSAFE_ID, FAILSAFE_GOAL);
        this.executeReporter(context, listener, sureFireTestEvents, "maven-surefire-plugin:test");
        this.executeReporter(context, listener, failSafeTestEvents, "maven-failsafe-plugin:integration-test");
    }

    private void executeReporter(StepContext context, TaskListener listener, List<Element> testEvents, String goal) throws IOException, InterruptedException {
        FilePath workspace = (FilePath)context.get(FilePath.class);
        String fileSeparatorOnAgent = XmlUtils.getFileSeparatorOnRemote(workspace);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        if (testEvents.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] junitPublisher - No org.apache.maven.plugins:" + goal + " execution found");
            }
            return;
        }
        for (Element testEvent : testEvents) {
            String surefireEventType = testEvent.getAttribute("type");
            if (!surefireEventType.equals("MojoSucceeded") && !surefireEventType.equals("MojoFailed")) continue;
            Element pluginElt = XmlUtils.getUniqueChildElement(testEvent, "plugin");
            Element reportsDirectoryElt = XmlUtils.getUniqueChildElementOrNull(pluginElt, "reportsDirectory");
            Element projectElt = XmlUtils.getUniqueChildElement(testEvent, "project");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.PluginInvocation pluginInvocation = XmlUtils.newPluginInvocation(pluginElt);
            if (reportsDirectoryElt == null) {
                listener.getLogger().println("[withMaven] No <reportsDirectory> element found for <plugin> in " + XmlUtils.toString(testEvent));
                continue;
            }
            String reportsDirectory = reportsDirectoryElt.getTextContent().trim();
            if (reportsDirectory.contains("${project.build.directory}")) {
                String projectBuildDirectory = XmlUtils.getProjectBuildDirectory(projectElt);
                if (projectBuildDirectory == null || projectBuildDirectory.isEmpty()) {
                    listener.getLogger().println("[withMaven] '${project.build.directory}' found for <project> in " + XmlUtils.toString(testEvent));
                    continue;
                }
                reportsDirectory = reportsDirectory.replace("${project.build.directory}", projectBuildDirectory);
            } else if (reportsDirectory.contains("${basedir}")) {
                String baseDir = projectElt.getAttribute("baseDir");
                if (baseDir.isEmpty()) {
                    listener.getLogger().println("[withMaven] '${basedir}' found for <project> in " + XmlUtils.toString(testEvent));
                    continue;
                }
                reportsDirectory = reportsDirectory.replace("${basedir}", baseDir);
            }
            reportsDirectory = XmlUtils.getPathInWorkspace(reportsDirectory, workspace);
            String testResults = reportsDirectory + fileSeparatorOnAgent + "*.xml";
            listener.getLogger().println("[withMaven] junitPublisher - Archive test results for Maven artifact " + mavenArtifact.getId() + " generated by " + pluginInvocation.getId() + ": " + testResults);
            JUnitResultArchiver archiver = new JUnitResultArchiver(testResults);
            if (this.healthScaleFactor != null) {
                archiver.setHealthScaleFactor(this.healthScaleFactor.doubleValue());
            }
            archiver.setKeepLongStdio(this.keepLongStdio);
            archiver.setAllowEmptyResults(true);
            if (Boolean.TRUE.equals(this.ignoreAttachments)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven] junitPublisher - Ignore junit test attachments");
                }
            } else {
                String className = "hudson.plugins.junitattachments.AttachmentPublisher";
                try {
                    TestDataPublisher attachmentPublisher = (TestDataPublisher)Class.forName(className).newInstance();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        listener.getLogger().println("[withMaven] junitPublisher - Publish junit test attachments...");
                    }
                    archiver.setTestDataPublishers(Collections.singletonList(attachmentPublisher));
                }
                catch (ClassNotFoundException e) {
                    listener.getLogger().print("[withMaven] junitPublisher - Jenkins ");
                    listener.hyperlink("https://wiki.jenkins-ci.org/display/JENKINS/JUnit+Attachments+Plugin", "JUnit Attachments Plugin");
                    listener.getLogger().print(" not found, can't publish test attachments.");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    PrintWriter err = listener.error("[withMaven] junitPublisher - Failure to publish test attachments, exception instantiating '" + className + "'");
                    e.printStackTrace(err);
                }
            }
            try {
                archiver.perform(run, workspace, launcher, listener);
            }
            catch (Exception e) {
                listener.error("[withMaven] junitPublisher - Silently ignore exception archiving JUnit results for Maven artifact " + mavenArtifact.toString() + " generated by " + pluginInvocation + ": " + e);
                LOGGER.log(Level.WARNING, "Exception processing " + XmlUtils.toString(testEvent), e);
            }
        }
    }

    public boolean getIgnoreAttachments() {
        return this.ignoreAttachments;
    }

    @DataBoundSetter
    public void setIgnoreAttachments(boolean ignoreAttachments) {
        this.ignoreAttachments = ignoreAttachments;
    }

    public boolean isKeepLongStdio() {
        return this.keepLongStdio;
    }

    @DataBoundSetter
    public void setKeepLongStdio(boolean keepLongStdio) {
        this.keepLongStdio = keepLongStdio;
    }

    @CheckForNull
    public Double getHealthScaleFactor() {
        return this.healthScaleFactor;
    }

    @DataBoundSetter
    public void setHealthScaleFactor(@Nullable Double healthScaleFactor) {
        this.healthScaleFactor = healthScaleFactor;
    }

    @Override
    public String toString() {
        return "JunitTestsPublisher[disabled=" + this.isDisabled() + ",healthScaleFactor=" + (this.healthScaleFactor == null ? "" : this.healthScaleFactor) + ",keepLongStdio=" + this.keepLongStdio + ",ignoreAttachments=" + this.ignoreAttachments + ']';
    }

    @Symbol(value={"junitPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return "Junit Publisher";
        }

        @Override
        public int ordinal() {
            return 10;
        }

        @Override
        @Nonnull
        public String getSkipFileName() {
            return ".skip-publish-junit-results";
        }
    }
}

