/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.triggers.Trigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyUpstreamCause;
import org.jenkinsci.plugins.pipeline.maven.trigger.WorkflowJobDependencyTrigger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class DownstreamPipelineTriggerRunListener
extends RunListener<WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(DownstreamPipelineTriggerRunListener.class.getName());
    @Inject
    public GlobalPipelineMavenConfig globalPipelineMavenConfig;

    public void onCompleted(WorkflowRun upstreamBuild, @Nonnull TaskListener listener) {
        LOGGER.log(Level.FINER, "onCompleted({0})", new Object[]{upstreamBuild});
        if (LOGGER.isLoggable(Level.FINER)) {
            listener.getLogger().println("[withMaven] pipelineGraphPublisher - triggerDownstreamPipelines");
        }
        if (!this.globalPipelineMavenConfig.getTriggerDownstreamBuildsResultsCriteria().contains(upstreamBuild.getResult())) {
            if (LOGGER.isLoggable(Level.FINER)) {
                listener.getLogger().println("[withMaven] Skip downstream job triggering for upstream build with ignored result status " + upstreamBuild + ": " + upstreamBuild.getResult());
            }
            return;
        }
        try {
            this.checkNoInfiniteLoopOfUpstreamCause((Run)upstreamBuild);
        }
        catch (IllegalStateException e) {
            listener.getLogger().println("[withMaven] WARNING abort infinite build trigger loop. Please consider opening a Jira issue: " + e.getMessage());
            return;
        }
        WorkflowJob upstreamPipeline = (WorkflowJob)upstreamBuild.getParent();
        String upstreamPipelineFullName = upstreamPipeline.getFullName();
        int upstreamBuildNumber = upstreamBuild.getNumber();
        Map<MavenArtifact, SortedSet<String>> downstreamPipelinesByArtifact = this.globalPipelineMavenConfig.getDao().listDownstreamJobsByArtifact(upstreamPipelineFullName, upstreamBuildNumber);
        TreeMap jobsToTrigger = new TreeMap();
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : downstreamPipelinesByArtifact.entrySet()) {
            MavenArtifact mavenArtifact = entry.getKey();
            SortedSet<String> downstreamPipelines = entry.getValue();
            block3: for (String downstreamPipelineFullName : downstreamPipelines) {
                Map.Entry<MavenArtifact, SortedSet<String>> entry222;
                if (Objects.equals(downstreamPipelineFullName, upstreamPipelineFullName)) continue;
                WorkflowJob downstreamPipeline = (WorkflowJob)Jenkins.getInstance().getItemByFullName(downstreamPipelineFullName, WorkflowJob.class);
                if (downstreamPipeline == null || downstreamPipeline.getLastBuild() == null) {
                    LOGGER.log(Level.FINE, "Downstream pipeline {0} or downstream pipeline last build not found from upstream build {1}. Database synchronization issue or security restriction?", new Object[]{downstreamPipelineFullName, upstreamBuild.getFullDisplayName(), Jenkins.getAuthentication()});
                    continue;
                }
                int downstreamBuildNumber = downstreamPipeline.getLastBuild().getNumber();
                Map<MavenArtifact, SortedSet<String>> downstreamDownstreamPipelinesByArtifact = this.globalPipelineMavenConfig.getDao().listDownstreamJobsByArtifact(downstreamPipelineFullName, downstreamBuildNumber);
                for (Map.Entry<MavenArtifact, SortedSet<String>> entry222 : downstreamDownstreamPipelinesByArtifact.entrySet()) {
                    SortedSet<String> downstreamDownstreamPipelines = entry222.getValue();
                    if (!downstreamDownstreamPipelines.contains(upstreamPipelineFullName)) continue;
                    listener.getLogger().println("[withMaven] Infinite loop detected: not triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + "  (dependency: " + mavenArtifact.getId() + " because it is itself triggering this pipeline " + ModelHyperlinkNote.encodeTo((Item)upstreamPipeline) + " (dependency: " + entry222.getKey() + ")");
                    continue block3;
                }
                Map<String, Integer> transitiveUpstreamPipelines = this.globalPipelineMavenConfig.getDao().listTransitiveUpstreamJobs(downstreamPipelineFullName, downstreamBuildNumber);
                entry222 = transitiveUpstreamPipelines.keySet().iterator();
                while (entry222.hasNext()) {
                    String transitiveUpstreamPipelineName = (String)entry222.next();
                    WorkflowJob transitiveUpstreamPipeline = (WorkflowJob)Jenkins.getInstance().getItemByFullName(transitiveUpstreamPipelineName, WorkflowJob.class);
                    if (transitiveUpstreamPipeline == null) continue;
                    if (!transitiveUpstreamPipeline.equals(upstreamPipeline) && (transitiveUpstreamPipeline.isBuilding() || transitiveUpstreamPipeline.isInQueue())) {
                        listener.getLogger().println("[withMaven] Not triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because it has a dependency already building or in queue: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                        continue block3;
                    }
                    if (!downstreamPipelines.contains(transitiveUpstreamPipelineName)) continue;
                    listener.getLogger().println("[withMaven] Not triggering " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + " because it has a dependency on a pipeline that will be triggered by this build: " + ModelHyperlinkNote.encodeTo((Item)transitiveUpstreamPipeline));
                    continue block3;
                }
                if (!downstreamPipeline.isBuildable()) {
                    LOGGER.log(Level.FINE, "Skip triggering of non buildable (disabled: {0}, isHoldOffBuildUntilSave: {1}) downstream pipeline {2} from upstream build {3}", new Object[]{downstreamPipeline.isDisabled(), downstreamPipeline.isHoldOffBuildUntilSave(), downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName()});
                    continue;
                }
                WorkflowJobDependencyTrigger downstreamPipelineTrigger = this.getWorkflowJobDependencyTrigger((ParameterizedJobMixIn.ParameterizedJob)downstreamPipeline);
                if (downstreamPipelineTrigger == null) {
                    LOGGER.log(Level.FINE, "Skip triggering of downstream pipeline {0} from upstream build {1}: dependency trigger not configured", new Object[]{downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName()});
                    continue;
                }
                boolean downstreamVisibleByUpstreamBuildAuth = this.isDownstreamVisibleByUpstreamBuildAuth((Item)downstreamPipeline);
                boolean upstreamVisibleByDownstreamBuildAuth = this.isUpstreamBuildVisibleByDownstreamBuildAuth(upstreamPipeline, (Queue.Task)downstreamPipeline);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "upstreamPipeline (" + upstreamPipelineFullName + ", visibleByDownstreamBuildAuth: " + upstreamVisibleByDownstreamBuildAuth + "),  downstreamPipeline (" + downstreamPipeline.getFullName() + ", visibleByUpstreamBuildAuth: " + downstreamVisibleByUpstreamBuildAuth + "), upstreamBuildAuth: " + Jenkins.getAuthentication());
                }
                if (downstreamVisibleByUpstreamBuildAuth && upstreamVisibleByDownstreamBuildAuth) {
                    TreeSet<MavenArtifact> mavenArtifacts = (TreeSet<MavenArtifact>)jobsToTrigger.get(upstreamPipelineFullName);
                    if (mavenArtifacts == null) {
                        mavenArtifacts = new TreeSet<MavenArtifact>();
                        jobsToTrigger.put(downstreamPipelineFullName, mavenArtifacts);
                    }
                    if (mavenArtifacts.contains(mavenArtifact)) continue;
                    mavenArtifacts.add(mavenArtifact);
                    continue;
                }
                LOGGER.log(Level.FINE, "Skip triggering of {0} by {1}: downstreamVisibleByUpstreamBuildAuth: {2}, upstreamVisibleByDownstreamBuildAuth: {3}", new Object[]{downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName(), downstreamVisibleByUpstreamBuildAuth, upstreamVisibleByDownstreamBuildAuth});
            }
        }
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : jobsToTrigger.entrySet()) {
            String downstreamJobFullName = (String)((Object)entry.getKey());
            Job downstreamJob = (Job)Jenkins.getInstance().getItemByFullName(downstreamJobFullName, Job.class);
            ArrayList<CauseAction> causeActions = new ArrayList<CauseAction>();
            Set mavenArtifacts = entry.getValue();
            for (MavenArtifact mavenArtifact : mavenArtifacts) {
                MavenDependencyUpstreamCause cause = new MavenDependencyUpstreamCause((Run<?, ?>)upstreamBuild, mavenArtifact);
                causeActions.add(new CauseAction((Cause)cause));
            }
            Queue.Item queuedItem = ParameterizedJobMixIn.scheduleBuild2((Job)downstreamJob, (int)-1, (Action[])causeActions.toArray(new Action[0]));
            String dependenciesMessage = Joiner.on((String)",").join((Iterable)Collections2.transform((Collection)mavenArtifacts, (Function)new Function<MavenArtifact, String>(){

                public String apply(@Nullable MavenArtifact mavenArtifact) {
                    return mavenArtifact == null ? "null" : mavenArtifact.getShortDescription();
                }
            }));
            if (queuedItem == null) {
                listener.getLogger().println("[withMaven] Skip scheduling downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + " due to dependencies on " + dependenciesMessage + ", it is already in the queue.");
                continue;
            }
            listener.getLogger().println("[withMaven] Scheduling downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamJob) + "#" + downstreamJob.getNextBuildNumber() + " due to dependency on " + dependenciesMessage + " ...");
        }
    }

    protected void checkNoInfiniteLoopOfUpstreamCause(@Nonnull Run initialBuild) throws IllegalStateException {
        Run currentBuild;
        LinkedList<Run> builds = new LinkedList<Run>(Collections.singleton(initialBuild));
        while ((currentBuild = (Run)builds.poll()) != null) {
            for (Cause cause : currentBuild.getCauses()) {
                Cause.UpstreamCause upstreamCause;
                Run upstreamBuild;
                if (!(cause instanceof Cause.UpstreamCause) || (upstreamBuild = (upstreamCause = (Cause.UpstreamCause)cause).getUpstreamRun()) == null) continue;
                if (Objects.equals(upstreamBuild.getParent().getFullName(), initialBuild.getParent().getFullName())) {
                    throw new IllegalStateException("Infinite loop of job triggers ");
                }
                builds.add(upstreamBuild);
            }
        }
    }

    @Nullable
    protected WorkflowJobDependencyTrigger getWorkflowJobDependencyTrigger(@Nonnull ParameterizedJobMixIn.ParameterizedJob parameterizedJob) {
        Map triggers = parameterizedJob.getTriggers();
        for (Object trigger : triggers.values()) {
            if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
            return (WorkflowJobDependencyTrigger)((Object)trigger);
        }
        if (parameterizedJob.getParent() instanceof ComputedFolder) {
            ComputedFolder multiBranchProject = (ComputedFolder)parameterizedJob.getParent();
            for (Trigger trigger : multiBranchProject.getTriggers().values()) {
                if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
                return (WorkflowJobDependencyTrigger)trigger;
            }
            if (multiBranchProject.getParent() instanceof ComputedFolder) {
                ComputedFolder grandParent = (ComputedFolder)multiBranchProject.getParent();
                Map grandParentTriggers = grandParent.getTriggers();
                for (Trigger trigger : grandParentTriggers.values()) {
                    if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
                    return (WorkflowJobDependencyTrigger)trigger;
                }
            }
        }
        return null;
    }

    protected boolean isUpstreamBuildVisibleByDownstreamBuildAuth(@Nonnull WorkflowJob upstreamPipeline, @Nonnull Queue.Task downstreamPipeline) {
        Authentication auth = Tasks.getAuthenticationOf((Queue.Task)downstreamPipeline);
        Authentication downstreamPipelineAuth = auth.equals(ACL.SYSTEM) && !QueueItemAuthenticatorConfiguration.get().getAuthenticators().isEmpty() ? Jenkins.ANONYMOUS : auth;
        try (ACLContext _ = ACL.as((Authentication)downstreamPipelineAuth);){
            WorkflowJob upstreamPipelineObtainedAsImpersonated = (WorkflowJob)Jenkins.getInstance().getItemByFullName(upstreamPipeline.getFullName(), WorkflowJob.class);
            boolean result = upstreamPipelineObtainedAsImpersonated != null;
            LOGGER.log(Level.FINE, "isUpstreamBuildVisibleByDownstreamBuildAuth({0}, {1}): taskAuth: {2}, downstreamPipelineAuth: {3}, upstreamPipelineObtainedAsImpersonated:{4}, result: {5}", new Object[]{upstreamPipeline, downstreamPipeline, auth, downstreamPipelineAuth, upstreamPipelineObtainedAsImpersonated, result});
            boolean bl = result;
            return bl;
        }
    }

    protected boolean isDownstreamVisibleByUpstreamBuildAuth(@Nonnull Item downstreamPipeline) {
        boolean result = Jenkins.getInstance().getItemByFullName(downstreamPipeline.getFullName()) != null;
        LOGGER.log(Level.FINE, "isDownstreamVisibleByUpstreamBuildAuth({0}, auth: {1}): {2}", new Object[]{downstreamPipeline, Jenkins.getAuthentication(), result});
        return result;
    }
}

