/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.cause;

import hudson.console.ModelHyperlinkNote;
import hudson.model.Cause;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.cause.MavenDependencyCause;

public class MavenDependencyUpstreamCause
extends Cause.UpstreamCause
implements MavenDependencyCause {
    private final MavenArtifact mavenArtifact;

    public MavenDependencyUpstreamCause(Run<?, ?> up, @Nonnull MavenArtifact mavenArtifact) {
        super(up);
        this.mavenArtifact = mavenArtifact;
    }

    public String getShortDescription() {
        return "Started by upstream build \"" + this.getUpstreamProject() + "\" #" + this.getUpstreamBuild() + " generating Maven artifact " + this.mavenArtifact.getShortDescription();
    }

    public void print(TaskListener listener) {
        this.print(listener, 0);
    }

    private void indent(TaskListener listener, int depth) {
        for (int i = 0; i < depth; ++i) {
            listener.getLogger().print(' ');
        }
    }

    private void print(TaskListener listener, int depth) {
        this.indent(listener, depth);
        Run upstreamRun = this.getUpstreamRun();
        if (upstreamRun == null) {
            listener.getLogger().println("Started by upstream build " + ModelHyperlinkNote.encodeTo((String)('/' + this.getUpstreamUrl()), (String)this.getUpstreamProject()) + "\" #" + ModelHyperlinkNote.encodeTo((String)('/' + this.getUpstreamUrl() + this.getUpstreamBuild()), (String)Integer.toString(this.getUpstreamBuild())) + " generating Maven artifact " + this.mavenArtifact.getShortDescription());
        } else {
            listener.getLogger().println("Started by upstream build " + ModelHyperlinkNote.encodeTo((String)('/' + upstreamRun.getUrl()), (String)upstreamRun.getFullDisplayName()) + " generating Maven artifact " + this.mavenArtifact.getShortDescription());
        }
        if (this.getUpstreamCauses() != null && !this.getUpstreamCauses().isEmpty()) {
            this.indent(listener, depth);
            listener.getLogger().println("originally caused by:");
            for (Cause cause : this.getUpstreamCauses()) {
                if (cause instanceof MavenDependencyUpstreamCause) {
                    ((MavenDependencyUpstreamCause)cause).print(listener, depth + 1);
                    continue;
                }
                this.indent(listener, depth + 1);
                cause.print(listener);
            }
        }
    }

    @Override
    @Nonnull
    public MavenArtifact getMavenArtifact() {
        return this.mavenArtifact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenDependencyUpstreamCause that = (MavenDependencyUpstreamCause)o;
        return Objects.equals(this.mavenArtifact, that.mavenArtifact);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mavenArtifact);
    }
}

