/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.AccessDeniedException;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenDependency;

public class MavenReport
implements RunAction2,
SimpleBuildStep.LastBuildAction,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger(MavenReport.class.getName());
    private transient Run run;
    private transient List<MavenArtifact> generatedArtifacts;

    public MavenReport(@Nonnull Run run) {
        this.run = run;
    }

    public synchronized void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public synchronized void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public synchronized Collection<? extends Action> getProjectActions() {
        return this.run.getParent().getLastSuccessfulBuild().getActions(MavenReport.class);
    }

    public synchronized Collection<MavenArtifact> getGeneratedArtifacts() {
        if (this.generatedArtifacts == null) {
            List<MavenArtifact> generatedArtifacts = GlobalPipelineMavenConfig.getDao().getGeneratedArtifacts(this.run.getParent().getFullName(), this.run.getNumber());
            if (this.run.getResult() == null) {
                LOGGER.log(Level.FINE, "Load generated artifacts for build {0}#{1} but don't cache them as the build is not finished: {2} entries", new Object[]{this.run.getParent().getName(), this.run.getNumber(), generatedArtifacts.size()});
            } else {
                LOGGER.log(Level.FINE, "Load generated artifacts for build {0}#{1} and cache them: {2}\u00a0entries", new Object[]{this.run.getParent().getName(), this.run.getNumber(), generatedArtifacts.size()});
                this.generatedArtifacts = generatedArtifacts;
            }
            return generatedArtifacts;
        }
        LOGGER.log(Level.FINE, "Use cached generated artifacts for build {0}#{1}: {2}\u00a0entries", new Object[]{this.run.getParent().getName(), this.run.getNumber(), this.generatedArtifacts.size()});
        return this.generatedArtifacts;
    }

    public synchronized Collection<Job> getDownstreamJobs() {
        List<String> downstreamJobFullNames = GlobalPipelineMavenConfig.getDao().listDownstreamJobs(this.run.getParent().getFullName(), this.run.getNumber());
        Collection downstreamJobs = Collections2.transform(downstreamJobFullNames, (Function)new Function<String, Job>(){

            public Job apply(@Nullable String jobFullName) {
                if (jobFullName == null) {
                    return null;
                }
                try {
                    return (Job)Jenkins.getInstance().getItemByFullName(jobFullName, Job.class);
                }
                catch (AccessDeniedException e) {
                    return null;
                }
            }
        });
        return Collections2.filter((Collection)downstreamJobs, (Predicate)Predicates.notNull());
    }

    public synchronized Collection<Run> getUpstreamBuilds() {
        Map<String, Integer> upstreamJobs = GlobalPipelineMavenConfig.getDao().listUpstreamJobs(this.run.getParent().getFullName(), this.run.getNumber());
        Collection upstreamBuilds = Collections2.transform(upstreamJobs.entrySet(), (Function)new Function<Map.Entry<String, Integer>, Run>(){

            public Run apply(@Nullable Map.Entry<String, Integer> entry) {
                Job job;
                if (entry == null) {
                    return null;
                }
                try {
                    job = (Job)Jenkins.getInstance().getItemByFullName(entry.getKey(), Job.class);
                }
                catch (AccessDeniedException e) {
                    return null;
                }
                if (job == null) {
                    return null;
                }
                Run run = job.getBuildByNumber(entry.getValue().intValue());
                if (run == null) {
                    return null;
                }
                return run;
            }
        });
        return Collections2.filter((Collection)upstreamBuilds, (Predicate)Predicates.notNull());
    }

    public synchronized Collection<MavenArtifact> getDeployedArtifacts() {
        return Collections2.filter(this.getGeneratedArtifacts(), (Predicate)new Predicate<MavenArtifact>(){

            public boolean apply(@Nullable MavenArtifact mavenArtifact) {
                return mavenArtifact == null ? false : mavenArtifact.isDeployed();
            }
        });
    }

    public synchronized Collection<MavenDependency> getDependencies() {
        return GlobalPipelineMavenConfig.getDao().listDependencies(this.run.getParent().getFullName(), this.run.getNumber());
    }

    public synchronized Run getRun() {
        return this.run;
    }

    @CheckForNull
    public String getIconFileName() {
        return "/plugin/pipeline-maven/images/24x24/apache-maven.png";
    }

    @CheckForNull
    public String getDisplayName() {
        return "Maven";
    }

    @CheckForNull
    public String getUrlName() {
        return "maven";
    }
}

