/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.tasks.TasksPublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.w3c.dom.Element;

public class TasksScannerPublisher
extends MavenPublisher {
    private static final Logger LOGGER = Logger.getLogger(TasksScannerPublisher.class.getName());
    private static final long serialVersionUID = 1L;
    private String highPriorityTaskIdentifiers = "";
    private String normalPriorityTaskIdentifiers = "";
    private String lowPriorityTaskIdentifiers = "";
    private boolean ignoreCase = false;
    private String pattern = "";
    private String excludePattern = "";
    private boolean asRegexp = false;

    @DataBoundConstructor
    public TasksScannerPublisher() {
    }

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        String fileSeparatorOnAgent = XmlUtils.getFileSeparatorOnRemote(workspace);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        try {
            Class.forName("hudson.plugins.tasks.TasksPublisher");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] Jenkins ");
            listener.hyperlink("https://wiki.jenkins-ci.org/display/JENKINS/Task+Scanner+Plugin", "Task Scanner Plugin");
            listener.getLogger().println(" not found, don't display results of source code scanning for 'TODO' and 'FIXME' in pipeline screen.");
            return;
        }
        ArrayList<String> sourceDirectoriesPatterns = new ArrayList<String>();
        for (Element executionEvent : XmlUtils.getExecutionEvents(mavenSpyLogsElt, "ProjectSucceeded", "ProjectFailed")) {
            Element buildElement = XmlUtils.getUniqueChildElementOrNull(executionEvent, "project", "build");
            if (buildElement == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Ignore execution event with missing 'build' child:" + XmlUtils.toString(executionEvent));
                continue;
            }
            Element projectElt = XmlUtils.getUniqueChildElement(executionEvent, "project");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            String sourceDirectory = buildElement.getAttribute("sourceDirectory");
            if (Objects.equals(sourceDirectory, "${project.basedir}/src/main/java")) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Skip task scanning for " + XmlUtils.toString(executionEvent));
                continue;
            }
            String sourceDirectoryRelativePath = XmlUtils.getPathInWorkspace(sourceDirectory, workspace);
            if (workspace.child(sourceDirectoryRelativePath).exists()) {
                sourceDirectoriesPatterns.add(sourceDirectoryRelativePath + fileSeparatorOnAgent + "**" + fileSeparatorOnAgent + "*");
                listener.getLogger().println("[withMaven] openTasksPublisher - Scan Tasks for Maven artifact " + mavenArtifact.getId() + " in source directory " + sourceDirectoryRelativePath);
                continue;
            }
            LOGGER.log(Level.FINE, "Skip task scanning for {0}, folder {1} does not exist", new Object[]{mavenArtifact, sourceDirectoryRelativePath});
        }
        if (sourceDirectoriesPatterns.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] openTasksPublisher - no folder to scan");
            }
            return;
        }
        TasksPublisher tasksPublisher = new TasksPublisher();
        String pattern = StringUtils.isEmpty((String)this.pattern) ? XmlUtils.join(sourceDirectoriesPatterns, ",") : this.pattern;
        tasksPublisher.setPattern(pattern);
        tasksPublisher.setExcludePattern(StringUtils.trimToNull((String)this.excludePattern));
        tasksPublisher.setHigh(StringUtils.defaultIfEmpty((String)this.highPriorityTaskIdentifiers, (String)"FIXME"));
        tasksPublisher.setNormal(StringUtils.defaultIfEmpty((String)this.normalPriorityTaskIdentifiers, (String)"TODO"));
        tasksPublisher.setLow(StringUtils.trimToNull((String)this.lowPriorityTaskIdentifiers));
        tasksPublisher.setIgnoreCase(this.ignoreCase);
        tasksPublisher.setAsRegexp(this.asRegexp);
        try {
            tasksPublisher.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            listener.error("[withMaven] openTasksPublisher - Silently ignore exception scanning tasks in " + pattern + ": " + e);
            LOGGER.log(Level.WARNING, "Exception scanning tasks in  " + pattern, e);
        }
    }

    public String getHighPriorityTaskIdentifiers() {
        return this.highPriorityTaskIdentifiers;
    }

    @DataBoundSetter
    public void setHighPriorityTaskIdentifiers(String highPriorityTaskIdentifiers) {
        this.highPriorityTaskIdentifiers = highPriorityTaskIdentifiers;
    }

    public String getNormalPriorityTaskIdentifiers() {
        return this.normalPriorityTaskIdentifiers;
    }

    @DataBoundSetter
    public void setNormalPriorityTaskIdentifiers(String normalPriorityTaskIdentifiers) {
        this.normalPriorityTaskIdentifiers = normalPriorityTaskIdentifiers;
    }

    public String getLowPriorityTaskIdentifiers() {
        return this.lowPriorityTaskIdentifiers;
    }

    @DataBoundSetter
    public void setLowPriorityTaskIdentifiers(String lowPriorityTaskIdentifiers) {
        this.lowPriorityTaskIdentifiers = lowPriorityTaskIdentifiers;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @DataBoundSetter
    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public String getPattern() {
        return this.pattern;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    @DataBoundSetter
    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public boolean isAsRegexp() {
        return this.asRegexp;
    }

    @DataBoundSetter
    public void setAsRegexp(boolean asRegexp) {
        this.asRegexp = asRegexp;
    }

    @Symbol(value={"openTasksPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return "Open Task Scanner Publisher";
        }

        @Override
        public int ordinal() {
            return 100;
        }

        @Override
        @Nonnull
        public String getSkipFileName() {
            return ".skip-task-scanner";
        }
    }
}

