/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import hudson.model.Action;
import hudson.model.Run;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;

public class MavenReport
implements RunAction2,
SimpleBuildStep.LastBuildAction,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger(MavenReport.class.getName());
    private transient Run run;
    private transient List<MavenArtifact> generatedArtifacts;

    public MavenReport(@Nonnull Run run) {
        this.run = run;
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public Collection<? extends Action> getProjectActions() {
        return this.run.getParent().getLastSuccessfulBuild().getActions(MavenReport.class);
    }

    public Collection<MavenArtifact> getGeneratedArtifacts() {
        if (this.generatedArtifacts == null) {
            List<MavenArtifact> generatedArtifacts = GlobalPipelineMavenConfig.getDao().getGeneratedArtifacts(this.run.getParent().getFullName(), this.run.getNumber());
            if (this.run.getResult() == null) {
                LOGGER.log(Level.FINE, "Load generated artifacts for build {0}#{1} but don't cache them as the build is not finished: {2} entries", new Object[]{this.run.getParent().getName(), this.run.getNumber(), generatedArtifacts.size()});
            } else {
                LOGGER.log(Level.FINE, "Load generated artifacts for build {0}#{1} and cache them: {2}\u00a0entries", new Object[]{this.run.getParent().getName(), this.run.getNumber(), generatedArtifacts.size()});
                this.generatedArtifacts = generatedArtifacts;
            }
            return generatedArtifacts;
        }
        LOGGER.log(Level.FINE, "Use cached generated artifacts for build {0}#{1}: {2}\u00a0entries", new Object[]{this.run.getParent().getName(), this.run.getNumber(), this.generatedArtifacts.size()});
        return this.generatedArtifacts;
    }

    public Collection<MavenArtifact> getDeployedArtifacts() {
        return Collections2.filter(this.getGeneratedArtifacts(), (Predicate)new Predicate<MavenArtifact>(){

            public boolean apply(@Nullable MavenArtifact mavenArtifact) {
                return mavenArtifact == null ? false : mavenArtifact.isDeployed();
            }
        });
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return null;
    }

    @CheckForNull
    public String getUrlName() {
        return null;
    }
}

