/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.w3c.dom.Element;

public class DependenciesLister {
    @Nonnull
    public static List<MavenSpyLogProcessor.MavenDependency> listDependencies(Element mavenSpyLogs, Logger logger) {
        ArrayList<MavenSpyLogProcessor.MavenDependency> result = new ArrayList<MavenSpyLogProcessor.MavenDependency>();
        for (Element dependencyResolutionResult : XmlUtils.getChildrenElements(mavenSpyLogs, "DependencyResolutionResult")) {
            Element resolvedDependenciesElt = XmlUtils.getUniqueChildElementOrNull(dependencyResolutionResult, "resolvedDependencies");
            if (resolvedDependenciesElt == null) continue;
            for (Element dependencyElt : XmlUtils.getChildrenElements(resolvedDependenciesElt, "dependency")) {
                MavenSpyLogProcessor.MavenDependency dependencyArtifact = XmlUtils.newMavenDependency(dependencyElt);
                Element fileElt = XmlUtils.getUniqueChildElementOrNull(dependencyElt, "file");
                if (fileElt == null || fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                    logger.log(Level.WARNING, "listDependencies: no associated file found for " + dependencyArtifact + " in " + XmlUtils.toString(dependencyElt));
                } else {
                    dependencyArtifact.file = StringUtils.trim((String)fileElt.getTextContent());
                }
                result.add(dependencyArtifact);
            }
        }
        return result;
    }

    @Nonnull
    public static List<MavenArtifact> listParentProjects(Element mavenSpyLogs, Logger logger) {
        ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
        for (Element dependencyResolutionResult : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectStarted")) {
            Element parentProjectElt = XmlUtils.getUniqueChildElementOrNull(dependencyResolutionResult, "parentProject");
            if (parentProjectElt == null) continue;
            MavenArtifact parentProject = new MavenArtifact();
            parentProject.groupId = parentProjectElt.getAttribute("groupId");
            parentProject.artifactId = parentProjectElt.getAttribute("artifactId");
            parentProject.baseVersion = parentProject.version = parentProjectElt.getAttribute("version");
            parentProject.snapshot = parentProject.version.endsWith("-SNAPSHOT");
            result.add(parentProject);
        }
        return result;
    }
}

