/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.h2.jdbcx.JdbcConnectionPool;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.util.ClassUtils;
import org.jenkinsci.plugins.pipeline.maven.util.RuntimeIoException;
import org.jenkinsci.plugins.pipeline.maven.util.RuntimeSqlException;

public class PipelineMavenPluginH2Dao
implements PipelineMavenPluginDao {
    private static Logger LOGGER = Logger.getLogger(PipelineMavenPluginH2Dao.class.getName());
    private transient JdbcConnectionPool jdbcConnectionPool;

    public PipelineMavenPluginH2Dao(File rootDir) {
        rootDir.getClass();
        File databaseFile = new File(rootDir, "jenkins-jobs");
        String jdbcUrl = "jdbc:h2:file:" + databaseFile.getAbsolutePath() + ";AUTO_SERVER=TRUE;MULTI_THREADED=1";
        if (LOGGER.isLoggable(Level.FINEST)) {
            jdbcUrl = jdbcUrl + ";TRACE_LEVEL_SYSTEM_OUT=3";
        } else if (LOGGER.isLoggable(Level.FINE)) {
            jdbcUrl = jdbcUrl + ";TRACE_LEVEL_SYSTEM_OUT=2";
        }
        LOGGER.log(Level.INFO, "Open database {0}", jdbcUrl);
        this.jdbcConnectionPool = JdbcConnectionPool.create((String)jdbcUrl, (String)"sa", (String)"sa");
        this.initializeDatabase();
        this.testDatabase();
    }

    public PipelineMavenPluginH2Dao(JdbcConnectionPool jdbcConnectionPool) {
        jdbcConnectionPool.getClass();
        this.jdbcConnectionPool = jdbcConnectionPool;
        this.initializeDatabase();
        this.testDatabase();
    }

    public PipelineMavenPluginH2Dao(String jdbcUrl, String username, String password) {
        jdbcUrl.getClass();
        username.getClass();
        password.getClass();
        this.jdbcConnectionPool = JdbcConnectionPool.create((String)jdbcUrl, (String)username, (String)password);
        LOGGER.log(Level.FINE, "Open database {0}", jdbcUrl);
        this.initializeDatabase();
    }

    @Override
    public void recordDependency(String jobFullName, int buildNumber, String groupId, String artifactId, String version, String type, String scope, boolean ignoreUpstreamTriggers, String classifier) {
        LOGGER.log(Level.FINE, "recordDependency({0}#{1}, {2}:{3}:{4}:{5}, {6}, ignoreUpstreamTriggers:{7}})", new Object[]{jobFullName, buildNumber, groupId, artifactId, version, type, scope, ignoreUpstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long artifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(groupId, artifactId, version, type, classifier);
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO MAVEN_DEPENDENCY(ARTIFACT_ID, BUILD_ID, SCOPE, IGNORE_UPSTREAM_TRIGGERS) VALUES (?, ?, ?, ?)");){
                stmt.setLong(1, artifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setString(3, scope);
                stmt.setBoolean(4, ignoreUpstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void recordParentProject(@Nonnull String jobFullName, int buildNumber, @Nonnull String parentGroupId, @Nonnull String parentArtifactId, @Nonnull String parentVersion, boolean ignoreUpstreamTriggers) {
        LOGGER.log(Level.FINE, "recordParentProject({0}#{1}, {2}:{3} ignoreUpstreamTriggers:{5}})", new Object[]{jobFullName, buildNumber, parentGroupId, parentArtifactId, parentVersion, ignoreUpstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long parentArtifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(parentGroupId, parentArtifactId, parentVersion, "pom", null);
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO MAVEN_PARENT_PROJECT(ARTIFACT_ID, BUILD_ID, IGNORE_UPSTREAM_TRIGGERS) VALUES (?, ?, ?)");){
                stmt.setLong(1, parentArtifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setBoolean(3, ignoreUpstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void recordGeneratedArtifact(String jobFullName, int buildNumber, String groupId, String artifactId, String version, String type, String baseVersion, String repositoryUrl, boolean skipDownstreamTriggers, String extension, String classifier) {
        LOGGER.log(Level.FINE, "recordGeneratedArtifact({0}#{1}, {2}:{3}:{4}:{5}, version:{6}, repositoryUrl:{7}, skipDownstreamTriggers:{8})", new Object[]{jobFullName, buildNumber, groupId, artifactId, baseVersion, type, version, repositoryUrl, skipDownstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long artifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(groupId, artifactId, baseVersion, type, classifier);
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO GENERATED_MAVEN_ARTIFACT(ARTIFACT_ID, BUILD_ID, VERSION, REPOSITORY_URL, EXTENSION, SKIP_DOWNSTREAM_TRIGGERS) VALUES (?, ?, ?, ?, ?, ?)");){
                stmt.setLong(1, artifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setString(3, version);
                stmt.setString(4, repositoryUrl);
                stmt.setString(5, extension);
                stmt.setBoolean(6, skipDownstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void renameJob(String oldFullName, String newFullName) {
        LOGGER.log(Level.FINER, "renameJob({0}, {1})", new Object[]{oldFullName, newFullName});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("UPDATE JENKINS_JOB SET FULL_NAME = ? WHERE FULL_NAME = ?");){
                stmt.setString(1, newFullName);
                stmt.setString(2, oldFullName);
                int count = stmt.executeUpdate();
                LOGGER.log(Level.FINE, "renameJob({0}, {1}): {2}", new Object[]{oldFullName, newFullName, count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void deleteJob(String jobFullName) {
        LOGGER.log(Level.FINER, "deleteJob({0})", new Object[]{jobFullName});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("DELETE FROM JENKINS_JOB WHERE FULL_NAME = ?");){
                stmt.setString(1, jobFullName);
                int count = stmt.executeUpdate();
                LOGGER.log(Level.FINE, "deleteJob({0}): {1}", new Object[]{jobFullName, count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void deleteBuild(String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "deleteBuild({0}#{1})", new Object[]{jobFullName, buildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            Long jobPrimaryKey;
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_JOB WHERE FULL_NAME = ?");){
                stmt.setString(1, jobFullName);
                try (ResultSet rst = stmt.executeQuery();){
                    jobPrimaryKey = rst.next() ? Long.valueOf(rst.getLong(1)) : null;
                }
            }
            if (jobPrimaryKey == null) {
                LOGGER.log(Level.FINE, "No record found for job {0}", new Object[]{jobFullName});
                return;
            }
            stmt = cnn.prepareStatement("DELETE FROM JENKINS_BUILD WHERE JOB_ID = ? AND NUMBER = ?");
            var7_8 = null;
            try {
                stmt.setLong(1, jobPrimaryKey);
                stmt.setInt(2, buildNumber);
                int count = stmt.executeUpdate();
                LOGGER.log(Level.FINE, "deleteJob({0}#{1}): {2}", new Object[]{jobFullName, buildNumber, count});
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var7_8 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var7_8.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void cleanup() {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            String sql = "DELETE FROM MAVEN_ARTIFACT WHERE ID NOT IN (SELECT DISTINCT ARTIFACT_ID FROM MAVEN_DEPENDENCY UNION SELECT DISTINCT ARTIFACT_ID FROM GENERATED_MAVEN_ARTIFACT)";
            try (Statement stmt = cnn.createStatement();){
                int count = stmt.executeUpdate(sql);
                LOGGER.log(Level.FINE, "cleanup(): {0}", new Object[]{count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getOrCreateBuildPrimaryKey(String jobFullName, int buildNumber) {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            Throwable throwable;
            ResultSet rst;
            Throwable throwable2;
            ResultSet rst2;
            cnn.setAutoCommit(false);
            Long jobPrimaryKey = null;
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_JOB WHERE FULL_NAME=?");){
                stmt.setString(1, jobFullName);
                rst2 = stmt.executeQuery();
                throwable2 = null;
                try {
                    if (rst2.next()) {
                        jobPrimaryKey = rst2.getLong(1);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rst2 != null) {
                        if (throwable2 != null) {
                            try {
                                rst2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            rst2.close();
                        }
                    }
                }
            }
            if (jobPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO JENKINS_JOB(FULL_NAME) VALUES (?)", 1);
                var7_9 = null;
                try {
                    stmt.setString(1, jobFullName);
                    stmt.execute();
                    rst2 = stmt.getGeneratedKeys();
                    throwable2 = null;
                    try {
                        if (!rst2.next()) throw new IllegalStateException();
                        jobPrimaryKey = rst2.getLong(1);
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (rst2 != null) {
                            if (throwable2 != null) {
                                try {
                                    rst2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                rst2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable7) {
                    var7_9 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (stmt != null) {
                        if (var7_9 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable8) {
                                var7_9.addSuppressed(throwable8);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            Long buildPrimaryKey = null;
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_BUILD WHERE JOB_ID=? AND NUMBER=?");){
                stmt.setLong(1, jobPrimaryKey);
                stmt.setInt(2, buildNumber);
                rst = stmt.executeQuery();
                throwable = null;
                try {
                    if (rst.next()) {
                        buildPrimaryKey = rst.getLong(1);
                    }
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (rst != null) {
                        if (throwable != null) {
                            try {
                                rst.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            rst.close();
                        }
                    }
                }
            }
            if (buildPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO JENKINS_BUILD(JOB_ID, NUMBER) VALUES (?, ?)", 1);
                var8_11 = null;
                try {
                    stmt.setLong(1, jobPrimaryKey);
                    stmt.setInt(2, buildNumber);
                    stmt.execute();
                    rst = stmt.getGeneratedKeys();
                    throwable = null;
                    try {
                        if (!rst.next()) throw new IllegalStateException();
                        buildPrimaryKey = rst.getLong(1);
                    }
                    catch (Throwable throwable11) {
                        throwable = throwable11;
                        throw throwable11;
                    }
                    finally {
                        if (rst != null) {
                            if (throwable != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable12) {
                                    throwable.addSuppressed(throwable12);
                                }
                            } else {
                                rst.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable13) {
                    var8_11 = throwable13;
                    throw throwable13;
                }
                finally {
                    if (stmt != null) {
                        if (var8_11 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable14) {
                                var8_11.addSuppressed(throwable14);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            cnn.commit();
            long l = buildPrimaryKey;
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getOrCreateArtifactPrimaryKey(@Nonnull String groupId, @Nonnull String artifactId, @Nonnull String version, @Nonnull String type, @Nullable String classifier) {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            Throwable throwable;
            ResultSet rst2;
            Throwable throwable2;
            PreparedStatement stmt;
            Long artifactPrimaryKey;
            block90: {
                cnn.setAutoCommit(false);
                artifactPrimaryKey = null;
                if (classifier == null) {
                    stmt = cnn.prepareStatement("SELECT ID FROM MAVEN_ARTIFACT WHERE GROUP_ID = ? AND ARTIFACT_ID = ? AND VERSION = ? AND TYPE = ? AND CLASSIFIER is NULL");
                    throwable2 = null;
                    try {
                        stmt.setString(1, groupId);
                        stmt.setString(2, artifactId);
                        stmt.setString(3, version);
                        stmt.setString(4, type);
                        rst2 = stmt.executeQuery();
                        throwable = null;
                        try {
                            if (rst2.next()) {
                                artifactPrimaryKey = rst2.getLong(1);
                            }
                            break block90;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rst2 != null) {
                                if (throwable != null) {
                                    try {
                                        rst2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    rst2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable rst2) {
                        throwable2 = rst2;
                        throw rst2;
                    }
                    finally {
                        if (stmt != null) {
                            if (throwable2 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable rst2) {
                                    throwable2.addSuppressed(rst2);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                stmt = cnn.prepareStatement("SELECT ID FROM MAVEN_ARTIFACT WHERE GROUP_ID = ? AND ARTIFACT_ID = ? AND VERSION = ? AND TYPE = ? AND CLASSIFIER = ?");
                throwable2 = null;
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, artifactId);
                    stmt.setString(3, version);
                    stmt.setString(4, type);
                    stmt.setString(5, classifier);
                    rst2 = stmt.executeQuery();
                    throwable = null;
                    try {
                        if (rst2.next()) {
                            artifactPrimaryKey = rst2.getLong(1);
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (rst2 != null) {
                            if (throwable != null) {
                                try {
                                    rst2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                rst2.close();
                            }
                        }
                    }
                }
                catch (Throwable rst3) {
                    throwable2 = rst3;
                    throw rst3;
                }
                finally {
                    if (stmt != null) {
                        if (throwable2 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable rst3) {
                                throwable2.addSuppressed(rst3);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            if (artifactPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO MAVEN_ARTIFACT(GROUP_ID, ARTIFACT_ID, VERSION, TYPE, CLASSIFIER) VALUES (?, ?, ?, ?, ?)", 1);
                throwable2 = null;
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, artifactId);
                    stmt.setString(3, version);
                    stmt.setString(4, type);
                    stmt.setString(5, classifier);
                    stmt.execute();
                    rst2 = stmt.getGeneratedKeys();
                    throwable = null;
                    try {
                        if (!rst2.next()) throw new IllegalStateException();
                        artifactPrimaryKey = rst2.getLong(1);
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (rst2 != null) {
                            if (throwable != null) {
                                try {
                                    rst2.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                rst2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (stmt != null) {
                        if (throwable2 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            cnn.commit();
            long l = artifactPrimaryKey;
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected synchronized void initializeDatabase() {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            String sqlScriptPath;
            InputStream sqlScriptInputStream;
            cnn.setAutoCommit(false);
            int initialSchemaVersion = this.getSchemaVersion(cnn);
            LOGGER.log(Level.FINE, "Initialise database. Current schema version: {0}", new Object[]{initialSchemaVersion});
            DecimalFormat numberFormat = new DecimalFormat("00");
            int idx = initialSchemaVersion;
            while ((sqlScriptInputStream = ClassUtils.getResourceAsStream(sqlScriptPath = "sql/h2/" + numberFormat.format(++idx) + "_migration.sql")) != null) {
                try (Statement stmt = cnn.createStatement();){
                    String sqlScript = IOUtils.toString((InputStream)sqlScriptInputStream);
                    LOGGER.log(Level.FINE, "Execute database migration script {0}", sqlScriptPath);
                    stmt.execute(sqlScript);
                }
                catch (IOException e) {
                    throw new RuntimeIoException("Exception reading " + sqlScriptPath, e);
                }
                cnn.commit();
            }
            int newSchemaVersion = this.getSchemaVersion(cnn);
            if (newSchemaVersion == 0) {
                throw new IllegalStateException("Failure to load database DDL files. Files 'sql/h2/xxx_migration.sql' NOT found in the Thread Context Class Loader.  Pipeline Maven Plugin may be installed in an unsupported manner (thread.contextClassLoader: " + Thread.currentThread().getContextClassLoader() + ", classLoader: " + ClassUtils.class.getClassLoader() + ")");
            }
            if (newSchemaVersion == initialSchemaVersion) {
            } else {
                LOGGER.log(Level.INFO, "Database successfully migrated from version {0} to version {1}", new Object[]{initialSchemaVersion, newSchemaVersion});
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected int getSchemaVersion(Connection cnn) throws SQLException {
        int schemaVersion;
        block27: {
            try (Statement stmt = cnn.createStatement();){
                try (ResultSet rst = stmt.executeQuery("SELECT * FROM VERSION");){
                    schemaVersion = rst.next() ? rst.getInt(1) : 0;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 42102) {
                        schemaVersion = 0;
                        break block27;
                    }
                    throw new RuntimeSqlException(e);
                }
            }
        }
        return schemaVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void testDatabase() throws RuntimeSqlException {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            List<String> tables = Arrays.asList("MAVEN_ARTIFACT", "JENKINS_JOB", "JENKINS_BUILD", "MAVEN_DEPENDENCY", "GENERATED_MAVEN_ARTIFACT", "MAVEN_PARENT_PROJECT");
            for (String table : tables) {
                try {
                    Statement stmt = cnn.createStatement();
                    Throwable throwable = null;
                    try {
                        ResultSet rst = stmt.executeQuery("SELECT count(*) FROM " + table);
                        Throwable throwable2 = null;
                        try {
                            if (!rst.next()) throw new IllegalStateException("Exception testing table '" + table + "'");
                            int count = rst.getInt(1);
                            LOGGER.log(Level.FINE, "Table {0}: {1} rows", new Object[]{table, count});
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rst == null) continue;
                            if (throwable2 != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            rst.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (stmt == null) continue;
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeSqlException("Exception testing table '" + table + "' on " + cnn.toString(), e);
                    return;
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    @Nonnull
    public List<String> listDownstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        List<String> downstreamJobs = this.listDownstreamPipelinesBasedOnMavenDependencies(jobFullName, buildNumber);
        downstreamJobs.addAll(this.listDownstreamPipelinesBasedOnParentProjectDependencies(jobFullName, buildNumber));
        return downstreamJobs;
    }

    protected List<String> listDownstreamPipelinesBasedOnMavenDependencies(@Nonnull String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "listDownstreamJobs({0}, {1})", new Object[]{jobFullName, buildNumber});
        String generatedArtifactsSql = "SELECT DISTINCT GENERATED_MAVEN_ARTIFACT.ARTIFACT_ID  FROM GENERATED_MAVEN_ARTIFACT  INNER JOIN JENKINS_BUILD AS UPSTREAM_BUILD ON GENERATED_MAVEN_ARTIFACT.BUILD_ID = UPSTREAM_BUILD.ID  INNER JOIN JENKINS_JOB AS UPSTREAM_JOB ON UPSTREAM_BUILD.JOB_ID = UPSTREAM_JOB.ID  WHERE    UPSTREAM_JOB.FULL_NAME = ? AND   UPSTREAM_BUILD.NUMBER = ? AND    GENERATED_MAVEN_ARTIFACT.SKIP_DOWNSTREAM_TRIGGERS = FALSE";
        String sql = "SELECT DISTINCT DOWNSTREAM_JOB.FULL_NAME  FROM JENKINS_JOB AS DOWNSTREAM_JOB INNER JOIN JENKINS_BUILD AS DOWNSTREAM_BUILD ON DOWNSTREAM_JOB.ID = DOWNSTREAM_BUILD.JOB_ID  INNER JOIN MAVEN_DEPENDENCY ON DOWNSTREAM_BUILD.ID = MAVEN_DEPENDENCY.BUILD_ID WHERE    MAVEN_DEPENDENCY.ARTIFACT_ID IN (" + generatedArtifactsSql + ") AND    MAVEN_DEPENDENCY.IGNORE_UPSTREAM_TRIGGERS = FALSE AND    DOWNSTREAM_BUILD.NUMBER in (SELECT MAX(JENKINS_BUILD.NUMBER) FROM JENKINS_BUILD WHERE DOWNSTREAM_JOB.ID = JENKINS_BUILD.JOB_ID) ORDER BY DOWNSTREAM_JOB.FULL_NAME";
        ArrayList<String> downstreamJobsFullNames = new ArrayList<String>();
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setInt(2, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listDownstreamJobs({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }

    protected List<String> listDownstreamPipelinesBasedOnParentProjectDependencies(@Nonnull String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String generatedArtifactsSql = "SELECT DISTINCT GENERATED_MAVEN_ARTIFACT.ARTIFACT_ID  FROM GENERATED_MAVEN_ARTIFACT  INNER JOIN JENKINS_BUILD AS UPSTREAM_BUILD ON GENERATED_MAVEN_ARTIFACT.BUILD_ID = UPSTREAM_BUILD.ID  INNER JOIN JENKINS_JOB AS UPSTREAM_JOB ON UPSTREAM_BUILD.JOB_ID = UPSTREAM_JOB.ID  WHERE    UPSTREAM_JOB.FULL_NAME = ? AND   UPSTREAM_BUILD.NUMBER = ? AND    GENERATED_MAVEN_ARTIFACT.SKIP_DOWNSTREAM_TRIGGERS = FALSE";
        String sql = "SELECT DISTINCT DOWNSTREAM_JOB.FULL_NAME  FROM JENKINS_JOB AS DOWNSTREAM_JOB INNER JOIN JENKINS_BUILD AS DOWNSTREAM_BUILD ON DOWNSTREAM_JOB.ID = DOWNSTREAM_BUILD.JOB_ID  INNER JOIN MAVEN_PARENT_PROJECT ON DOWNSTREAM_BUILD.ID = MAVEN_PARENT_PROJECT.BUILD_ID WHERE    MAVEN_PARENT_PROJECT.ARTIFACT_ID IN (" + generatedArtifactsSql + ") AND    MAVEN_PARENT_PROJECT.IGNORE_UPSTREAM_TRIGGERS = FALSE AND    DOWNSTREAM_BUILD.NUMBER in (SELECT MAX(JENKINS_BUILD.NUMBER) FROM JENKINS_BUILD WHERE DOWNSTREAM_JOB.ID = JENKINS_BUILD.JOB_ID) ORDER BY DOWNSTREAM_JOB.FULL_NAME";
        ArrayList<String> downstreamJobsFullNames = new ArrayList<String>();
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setInt(2, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }

    @Override
    @Nonnull
    public Map<String, Integer> listUpstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        Map<String, Integer> upstreamJobs = this.listUpstreamPipelinesBasedOnMavenDependencies(jobFullName, buildNumber);
        upstreamJobs.putAll(this.listUpstreamPipelinesBasedOnParentProjectDependencies(jobFullName, buildNumber));
        return upstreamJobs;
    }

    protected Map<String, Integer> listUpstreamPipelinesBasedOnMavenDependencies(@Nonnull String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "listUpstreamJobs({0}, {1})", new Object[]{jobFullName, buildNumber});
        String dependenciesSql = "SELECT DISTINCT MAVEN_DEPENDENCY.ARTIFACT_ID  FROM MAVEN_DEPENDENCY  INNER JOIN JENKINS_BUILD AS DOWNSTREAM_BUILD ON MAVEN_DEPENDENCY.BUILD_ID = DOWNSTREAM_BUILD.ID  INNER JOIN JENKINS_JOB AS DOWNSTREAM_JOB ON DOWNSTREAM_BUILD.JOB_ID = DOWNSTREAM_JOB.ID  WHERE    DOWNSTREAM_JOB.FULL_NAME = ? AND    DOWNSTREAM_BUILD.NUMBER = ?";
        String sql = "SELECT DISTINCT UPSTREAM_JOB.FULL_NAME, UPSTREAM_BUILD.NUMBER  FROM JENKINS_JOB AS UPSTREAM_JOB INNER JOIN JENKINS_BUILD AS UPSTREAM_BUILD ON UPSTREAM_JOB.ID = UPSTREAM_BUILD.JOB_ID  INNER JOIN GENERATED_MAVEN_ARTIFACT ON UPSTREAM_BUILD.ID = GENERATED_MAVEN_ARTIFACT.BUILD_ID WHERE    GENERATED_MAVEN_ARTIFACT.ARTIFACT_ID IN (" + dependenciesSql + ") AND    GENERATED_MAVEN_ARTIFACT.SKIP_DOWNSTREAM_TRIGGERS = FALSE AND    UPSTREAM_BUILD.NUMBER in (SELECT MAX(JENKINS_BUILD.NUMBER) FROM JENKINS_BUILD WHERE UPSTREAM_JOB.ID = JENKINS_BUILD.JOB_ID) ORDER BY UPSTREAM_JOB.FULL_NAME";
        HashMap<String, Integer> upstreamJobsFullNames = new HashMap<String, Integer>();
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setInt(2, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    upstreamJobsFullNames.put(rst.getString(1), rst.getInt(2));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listUpstreamJobs({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, upstreamJobsFullNames});
        return upstreamJobsFullNames;
    }

    protected Map<String, Integer> listUpstreamPipelinesBasedOnParentProjectDependencies(@Nonnull String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "listUpstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String dependenciesSql = "SELECT DISTINCT MAVEN_DEPENDENCY.ARTIFACT_ID  FROM MAVEN_DEPENDENCY  INNER JOIN JENKINS_BUILD AS DOWNSTREAM_BUILD ON MAVEN_DEPENDENCY.BUILD_ID = DOWNSTREAM_BUILD.ID  INNER JOIN JENKINS_JOB AS DOWNSTREAM_JOB ON DOWNSTREAM_BUILD.JOB_ID = DOWNSTREAM_JOB.ID  WHERE    DOWNSTREAM_JOB.FULL_NAME = ? AND    DOWNSTREAM_BUILD.NUMBER = ?";
        String sql = "SELECT DISTINCT UPSTREAM_JOB.FULL_NAME, UPSTREAM_BUILD.NUMBER  FROM JENKINS_JOB AS UPSTREAM_JOB INNER JOIN JENKINS_BUILD AS UPSTREAM_BUILD ON UPSTREAM_JOB.ID = UPSTREAM_BUILD.JOB_ID  INNER JOIN MAVEN_PARENT_PROJECT ON UPSTREAM_BUILD.ID = MAVEN_PARENT_PROJECT.BUILD_ID WHERE    MAVEN_PARENT_PROJECT.ARTIFACT_ID IN (" + dependenciesSql + ") AND    UPSTREAM_BUILD.NUMBER in (SELECT MAX(JENKINS_BUILD.NUMBER) FROM JENKINS_BUILD WHERE UPSTREAM_JOB.ID = JENKINS_BUILD.JOB_ID) ORDER BY UPSTREAM_JOB.FULL_NAME";
        HashMap<String, Integer> upstreamJobsFullNames = new HashMap<String, Integer>();
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setInt(2, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    upstreamJobsFullNames.put(rst.getString(1), rst.getInt(2));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listUpstreamPipelinesBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, upstreamJobsFullNames});
        return upstreamJobsFullNames;
    }

    @Override
    @Nonnull
    public Map<String, Integer> listTransitiveUpstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        return this.listTransitiveUpstreamJobs(jobFullName, buildNumber, new HashMap<String, Integer>());
    }

    private Map<String, Integer> listTransitiveUpstreamJobs(@Nonnull String jobFullName, int buildNumber, Map<String, Integer> result) {
        for (Map.Entry<String, Integer> entry : this.listUpstreamJobs(jobFullName, buildNumber).entrySet()) {
            String upstreamJobName = entry.getKey();
            Integer upstreamJobBuildNumber = entry.getValue();
            if (result.containsKey(upstreamJobName)) continue;
            result.put(upstreamJobName, upstreamJobBuildNumber);
            this.listTransitiveUpstreamJobs(upstreamJobName, upstreamJobBuildNumber, result);
        }
        return result;
    }

    @Override
    @Nonnull
    public List<MavenArtifact> getGeneratedArtifacts(@Nonnull String jobFullName, @Nonnull int buildNumber) {
        LOGGER.log(Level.FINER, "getGeneratedArtifacts({0}, {1})", new Object[]{jobFullName, buildNumber});
        String generatedArtifactsSql = "SELECT DISTINCT MAVEN_ARTIFACT.*,  GENERATED_MAVEN_ARTIFACT.*  FROM MAVEN_ARTIFACT  INNER JOIN GENERATED_MAVEN_ARTIFACT ON MAVEN_ARTIFACT.ID = GENERATED_MAVEN_ARTIFACT.ARTIFACT_ID INNER JOIN JENKINS_BUILD AS UPSTREAM_BUILD ON GENERATED_MAVEN_ARTIFACT.BUILD_ID = UPSTREAM_BUILD.ID  INNER JOIN JENKINS_JOB AS UPSTREAM_JOB ON UPSTREAM_BUILD.JOB_ID = UPSTREAM_JOB.ID  WHERE    UPSTREAM_JOB.FULL_NAME = ? AND   UPSTREAM_BUILD.NUMBER = ? ";
        ArrayList<MavenArtifact> results = new ArrayList<MavenArtifact>();
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(generatedArtifactsSql);){
            stmt.setString(1, jobFullName);
            stmt.setInt(2, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenArtifact artifact = new MavenArtifact();
                    artifact.groupId = rst.getString("maven_artifact.group_id");
                    artifact.artifactId = rst.getString("maven_artifact.artifact_id");
                    artifact.version = rst.getString("maven_artifact.version");
                    artifact.type = rst.getString("maven_artifact.type");
                    artifact.classifier = rst.getString("maven_artifact.classifier");
                    artifact.baseVersion = rst.getString("generated_maven_artifact.version");
                    artifact.repositoryUrl = rst.getString("generated_maven_artifact.repository_url");
                    artifact.extension = rst.getString("generated_maven_artifact.extension");
                    artifact.snapshot = artifact.version.endsWith("-SNAPSHOT");
                    results.add(artifact);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public String toPrettyString() {
        ArrayList<String> prettyStrings = new ArrayList<String>();
        try {
            Connection cnn = this.jdbcConnectionPool.getConnection();
            Object object = null;
            try {
                prettyStrings.add("jdbc.url: " + cnn.getMetaData().getURL());
                List<String> tables = Arrays.asList("MAVEN_ARTIFACT", "JENKINS_JOB", "JENKINS_BUILD", "MAVEN_DEPENDENCY", "GENERATED_MAVEN_ARTIFACT", "MAVEN_PARENT_PROJECT");
                for (String table : tables) {
                    try {
                        Statement stmt = cnn.createStatement();
                        Throwable throwable = null;
                        try {
                            ResultSet rst = stmt.executeQuery("SELECT count(*) FROM " + table);
                            Throwable throwable2 = null;
                            try {
                                if (rst.next()) {
                                    int count = rst.getInt(1);
                                    prettyStrings.add("Table " + table + ": " + count + " rows");
                                    continue;
                                }
                                prettyStrings.add("Table " + table + ": #IllegalStateException 'select count(*)' didn't return any row#");
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (rst == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        rst.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                rst.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        prettyStrings.add("Table " + table + ": " + e);
                        LOGGER.log(Level.WARNING, "SQLException counting rows on " + table, e);
                    }
                }
            }
            catch (Throwable tables) {
                object = tables;
                throw tables;
            }
            finally {
                if (cnn != null) {
                    if (object != null) {
                        try {
                            cnn.close();
                        }
                        catch (Throwable tables) {
                            ((Throwable)object).addSuppressed(tables);
                        }
                    } else {
                        cnn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            prettyStrings.add("SQLException getting a connection to " + this.jdbcConnectionPool + ": " + e);
            LOGGER.log(Level.WARNING, "SQLException getting a connection to " + this.jdbcConnectionPool, e);
        }
        StringBuilder result = new StringBuilder("PipelineMavenPluginH2Dao ");
        for (String prettyString : prettyStrings) {
            result.append("\r\n\t" + prettyString);
        }
        return result.toString();
    }
}

