/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.console;

import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class MaskSecretsOutputStream
extends LineTransformationOutputStream {
    private final Pattern secrets;
    private final Charset charset;
    private final OutputStream delegate;
    private static final Comparator<String> stringLengthComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o2.length() - o1.length();
        }
    };

    public MaskSecretsOutputStream(@Nonnull Pattern secrets, @Nonnull OutputStream delegate, @Nonnull Charset charset) {
        this.secrets = secrets;
        this.delegate = delegate;
        this.charset = charset;
    }

    protected void eol(byte[] b, int len) throws IOException {
        if (this.secrets.toString().isEmpty()) {
            this.delegate.write(b, 0, len);
        } else {
            Matcher matcher = this.secrets.matcher(new String(b, 0, len, this.charset));
            if (matcher.find()) {
                this.delegate.write(matcher.replaceAll("****").getBytes(this.charset));
            } else {
                this.delegate.write(b, 0, len);
            }
        }
    }

    @Nonnull
    public static String getPatternStringForSecrets(@Nonnull Collection<String> secrets) {
        ArrayList<String> sortedByLength = new ArrayList<String>(secrets);
        Collections.sort(sortedByLength, stringLengthComparator);
        StringBuilder regexp = new StringBuilder();
        for (String secret : sortedByLength) {
            if (secret.isEmpty()) continue;
            if (regexp.length() > 0) {
                regexp.append('|');
            }
            regexp.append(Pattern.quote(secret));
        }
        return regexp.toString();
    }
}

