/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.CompareToBuilder;

public class MavenArtifact
implements Serializable,
Comparable<MavenArtifact> {
    private static final long serialVersionUID = 1L;
    public String groupId;
    public String artifactId;
    public String version;
    public String baseVersion;
    public String type;
    public String classifier;
    public String extension;
    public String file;
    public boolean snapshot;
    @Nullable
    public String repositoryUrl;

    public String getFileName() {
        return this.artifactId + "-" + this.version + (this.classifier == null || this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + this.extension;
    }

    public String getFileNameWithBaseVersion() {
        return this.artifactId + "-" + this.baseVersion + (this.classifier == null || this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + this.extension;
    }

    public String getId() {
        return this.groupId + ":" + this.artifactId + ":" + this.baseVersion + (this.classifier == null || this.classifier.isEmpty() ? "" : ":" + this.classifier);
    }

    @Nullable
    public String getUrl() {
        if (this.repositoryUrl == null) {
            return null;
        }
        return this.repositoryUrl + "/" + this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/" + this.getFileNameWithBaseVersion();
    }

    public String toString() {
        return "MavenArtifact{" + this.groupId + ":" + this.artifactId + ":" + this.type + (this.classifier == null ? "" : ":" + this.classifier) + ":" + this.baseVersion + "(version: " + this.version + ", snapshot:" + this.snapshot + ") " + (this.file == null ? "" : " " + this.file) + '}';
    }

    @Override
    public int compareTo(MavenArtifact o) {
        return new CompareToBuilder().append((Object)this.groupId, (Object)o.groupId).append((Object)this.artifactId, (Object)o.artifactId).append((Object)this.version, (Object)o.version).append((Object)this.type, (Object)o.type).append((Object)this.classifier, (Object)o.classifier).toComparison();
    }

    public boolean isDeployed() {
        return this.repositoryUrl != null && !this.repositoryUrl.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.baseVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtifact other = (MavenArtifact)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        return !(this.baseVersion == null ? other.baseVersion != null : !this.baseVersion.equals(other.baseVersion));
    }
}

