/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.publishers.DependenciesLister;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.w3c.dom.Element;

public class PipelineGraphPublisher
extends MavenPublisher {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(PipelineGraphPublisher.class.getName());
    private boolean includeSnapshotVersions = true;
    private boolean includeReleaseVersions;
    private boolean includeScopeCompile = true;
    private boolean includeScopeRuntime = true;
    private boolean includeScopeTest;
    private boolean includeScopeProvided = true;
    private boolean skipDownstreamTriggers;
    private String lifecycleThreshold = "deploy";
    private boolean ignoreUpstreamTriggers;

    @DataBoundConstructor
    public PipelineGraphPublisher() {
    }

    protected Set<String> getIncludedScopes() {
        TreeSet<String> includedScopes = new TreeSet<String>();
        if (this.includeScopeCompile) {
            includedScopes.add("compile");
        }
        if (this.includeScopeRuntime) {
            includedScopes.add("runtime");
        }
        if (this.includeScopeProvided) {
            includedScopes.add("provided");
        }
        if (this.includeScopeTest) {
            includedScopes.add("test");
        }
        return includedScopes;
    }

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        Run run = (Run)context.get(Run.class);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        GlobalPipelineMavenConfig.get();
        PipelineMavenPluginDao dao = GlobalPipelineMavenConfig.getDao();
        List<MavenArtifact> parentProjects = DependenciesLister.listParentProjects(mavenSpyLogsElt, LOGGER);
        List<MavenSpyLogProcessor.MavenDependency> dependencies = DependenciesLister.listDependencies(mavenSpyLogsElt, LOGGER);
        List<MavenArtifact> generatedArtifacts = this.listGeneratedArtifacts(mavenSpyLogsElt);
        List<String> executedLifecyclePhases = XmlUtils.getExecutedLifecyclePhases(mavenSpyLogsElt);
        this.recordParentProject(parentProjects, generatedArtifacts, run, listener, dao);
        this.recordDependencies(dependencies, generatedArtifacts, run, listener, dao);
        this.recordGeneratedArtifacts(generatedArtifacts, executedLifecyclePhases, run, listener, dao);
    }

    protected void recordParentProject(List<MavenArtifact> parentProjects, List<MavenArtifact> generatedArtifacts, @Nonnull Run run, @Nonnull TaskListener listener, @Nonnull PipelineMavenPluginDao dao) {
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] pipelineGraphPublisher - recordParentProject - filter: versions[snapshot: " + this.isIncludeSnapshotVersions() + ", release: " + this.isIncludeReleaseVersions() + "]");
        }
        for (MavenArtifact parentProject : parentProjects) {
            if (generatedArtifacts.contains(parentProject)) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] pipelineGraphPublisher - Skip recording parent project to generated artifact: " + parentProject.getId());
                continue;
            }
            if (parentProject.snapshot) {
                if (!this.includeSnapshotVersions) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    listener.getLogger().println("[withMaven] pipelineGraphPublisher - Skip recording snapshot parent project: " + parentProject.getId());
                    continue;
                }
            } else if (!this.includeReleaseVersions) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] pipelineGraphPublisher - Skip recording release parent project: " + parentProject.getId());
                continue;
            }
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven] pipelineGraphPublisher - Record parent project: " + parentProject.getId() + ", ignoreUpstreamTriggers: " + this.ignoreUpstreamTriggers);
                }
                dao.recordParentProject(run.getParent().getFullName(), run.getNumber(), parentProject.groupId, parentProject.artifactId, parentProject.version, this.ignoreUpstreamTriggers);
            }
            catch (RuntimeException e) {
                listener.error("[withMaven] pipelineGraphPublisher - WARNING: Exception recording parent project " + parentProject.getId() + " on build, skip");
                e.printStackTrace(listener.getLogger());
                listener.getLogger().flush();
            }
        }
    }

    protected void recordDependencies(List<MavenSpyLogProcessor.MavenDependency> dependencies, List<MavenArtifact> generatedArtifacts, @Nonnull Run run, @Nonnull TaskListener listener, @Nonnull PipelineMavenPluginDao dao) {
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] pipelineGraphPublisher - recordDependencies - filter: versions[snapshot: " + this.isIncludeSnapshotVersions() + ", release: " + this.isIncludeReleaseVersions() + "], scopes:" + this.getIncludedScopes());
        }
        for (MavenSpyLogProcessor.MavenDependency dependency : dependencies) {
            if (generatedArtifacts.contains(dependency.asMavenArtifact())) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] pipelineGraphPublisher - Skip recording dependency to generated artifact: " + dependency.getId());
                continue;
            }
            if (dependency.snapshot) {
                if (!this.includeSnapshotVersions) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    listener.getLogger().println("[withMaven] pipelineGraphPublisher - Skip recording snapshot dependency: " + dependency.getId());
                    continue;
                }
            } else if (!this.includeReleaseVersions) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] pipelineGraphPublisher - Skip recording release dependency: " + dependency.getId());
                continue;
            }
            if (!this.getIncludedScopes().contains(dependency.getScope())) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] pipelineGraphPublisher - Skip recording dependency with ignored scope: " + dependency.getId());
                continue;
            }
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven] pipelineGraphPublisher - Record dependency: " + dependency.getId() + ", ignoreUpstreamTriggers: " + this.ignoreUpstreamTriggers);
                }
                dao.recordDependency(run.getParent().getFullName(), run.getNumber(), dependency.groupId, dependency.artifactId, dependency.baseVersion, dependency.type, dependency.getScope(), this.ignoreUpstreamTriggers, null);
            }
            catch (RuntimeException e) {
                listener.error("[withMaven] pipelineGraphPublisher - WARNING: Exception recording " + dependency.getId() + " on build, skip");
                e.printStackTrace(listener.getLogger());
                listener.getLogger().flush();
            }
        }
    }

    protected void recordGeneratedArtifacts(List<MavenArtifact> generatedArtifacts, List<String> executedLifecyclePhases, @Nonnull Run run, @Nonnull TaskListener listener, @Nonnull PipelineMavenPluginDao dao) {
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] pipelineGraphPublisher - recordGeneratedArtifacts...");
        }
        for (MavenArtifact artifact : generatedArtifacts) {
            boolean skipDownstreamPipelines;
            boolean bl = skipDownstreamPipelines = this.skipDownstreamTriggers || !executedLifecyclePhases.contains(this.lifecycleThreshold);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Build {0}#{1} - record generated {2}:{3}, version:{4}, executedLifecyclePhases: {5}, skipDownstreamTriggers:{6}, lifecycleThreshold: {7}", new Object[]{run.getParent().getFullName(), run.getNumber(), artifact.getId(), artifact.type, artifact.version, executedLifecyclePhases, this.skipDownstreamTriggers, this.lifecycleThreshold});
                listener.getLogger().println("[withMaven] pipelineGraphPublisher - Record generated artifact: " + artifact.getId() + ", version: " + artifact.version + ", executedLifecyclePhases: " + executedLifecyclePhases + ", skipDownstreamTriggers: " + this.skipDownstreamTriggers + ", lifecycleThreshold:" + this.lifecycleThreshold + ", file: " + artifact.file);
            }
            dao.recordGeneratedArtifact(run.getParent().getFullName(), run.getNumber(), artifact.groupId, artifact.artifactId, artifact.version, artifact.type, artifact.baseVersion, artifact.repositoryUrl, skipDownstreamPipelines, artifact.extension, artifact.classifier);
            if (!"bundle".equals(artifact.type) || !"jar".equals(artifact.extension)) continue;
            dao.recordGeneratedArtifact(run.getParent().getFullName(), run.getNumber(), artifact.groupId, artifact.artifactId, artifact.version, "jar", artifact.baseVersion, null, skipDownstreamPipelines, artifact.extension, artifact.classifier);
        }
    }

    @Nonnull
    public List<MavenArtifact> listGeneratedArtifacts(Element mavenSpyLogs) {
        ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
        List<Element> artifactDeployedEvents = XmlUtils.getArtifactDeployedEvents(mavenSpyLogs);
        for (Element projectSucceededElt : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectSucceeded")) {
            Element projectElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "project");
            MavenArtifact projectArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenArtifact pomArtifact = new MavenArtifact();
            pomArtifact.groupId = projectArtifact.groupId;
            pomArtifact.artifactId = projectArtifact.artifactId;
            pomArtifact.baseVersion = projectArtifact.baseVersion;
            pomArtifact.version = projectArtifact.version;
            pomArtifact.snapshot = projectArtifact.snapshot;
            pomArtifact.type = "pom";
            pomArtifact.extension = "pom";
            pomArtifact.file = projectElt.getAttribute("file");
            result.add(pomArtifact);
            Element artifactElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "artifact");
            MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(artifactElt);
            if ("pom".equals(mavenArtifact.type)) continue;
            Element fileElt = XmlUtils.getUniqueChildElementOrNull(artifactElt, "file");
            if (fileElt == null || fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINE, "listGeneratedArtifacts: Project " + projectArtifact + ":  no associated file found for " + mavenArtifact + " in " + XmlUtils.toString(artifactElt));
                }
            } else {
                mavenArtifact.file = StringUtils.trim((String)fileElt.getTextContent());
                Element artifactDeployedEvent = XmlUtils.getArtifactDeployedEvent(artifactDeployedEvents, mavenArtifact.file);
                if (artifactDeployedEvent != null) {
                    mavenArtifact.repositoryUrl = XmlUtils.getUniqueChildElement(artifactDeployedEvent, "repository").getAttribute("url");
                }
            }
            result.add(mavenArtifact);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[disabled=" + this.isDisabled() + ", scopes=" + this.getIncludedScopes() + ", versions={snapshot:" + this.isIncludeSnapshotVersions() + ", release:" + this.isIncludeReleaseVersions() + "}, skipDownstreamTriggers=" + this.isSkipDownstreamTriggers() + ", lifecycleThreshold=" + this.getLifecycleThreshold() + ", ignoreUpstreamTriggers=" + this.isIgnoreUpstreamTriggers() + ']';
    }

    public boolean isIncludeSnapshotVersions() {
        return this.includeSnapshotVersions;
    }

    @DataBoundSetter
    public void setIncludeSnapshotVersions(boolean includeSnapshotVersions) {
        this.includeSnapshotVersions = includeSnapshotVersions;
    }

    public boolean isIncludeReleaseVersions() {
        return this.includeReleaseVersions;
    }

    @DataBoundSetter
    public void setIncludeReleaseVersions(boolean includeReleaseVersions) {
        this.includeReleaseVersions = includeReleaseVersions;
    }

    public boolean isIncludeScopeCompile() {
        return this.includeScopeCompile;
    }

    @DataBoundSetter
    public void setIncludeScopeCompile(boolean includeScopeCompile) {
        this.includeScopeCompile = includeScopeCompile;
    }

    public boolean isIncludeScopeRuntime() {
        return this.includeScopeRuntime;
    }

    @DataBoundSetter
    public void setIncludeScopeRuntime(boolean includeScopeRuntime) {
        this.includeScopeRuntime = includeScopeRuntime;
    }

    public boolean isIncludeScopeTest() {
        return this.includeScopeTest;
    }

    @DataBoundSetter
    public void setIncludeScopeTest(boolean includeScopeTest) {
        this.includeScopeTest = includeScopeTest;
    }

    public boolean isIncludeScopeProvided() {
        return this.includeScopeProvided;
    }

    @DataBoundSetter
    public void setIncludeScopeProvided(boolean includeScopeProvided) {
        this.includeScopeProvided = includeScopeProvided;
    }

    public boolean isSkipDownstreamTriggers() {
        return this.skipDownstreamTriggers;
    }

    @DataBoundSetter
    public void setSkipDownstreamTriggers(boolean skipDownstreamTriggers) {
        this.skipDownstreamTriggers = skipDownstreamTriggers;
    }

    public boolean isIgnoreUpstreamTriggers() {
        return this.ignoreUpstreamTriggers;
    }

    @DataBoundSetter
    public void setIgnoreUpstreamTriggers(boolean ignoreUpstreamTriggers) {
        this.ignoreUpstreamTriggers = ignoreUpstreamTriggers;
    }

    public String getLifecycleThreshold() {
        return this.lifecycleThreshold;
    }

    @DataBoundSetter
    public void setLifecycleThreshold(String lifecycleThreshold) {
        this.lifecycleThreshold = lifecycleThreshold;
    }

    @Symbol(value={"pipelineGraphPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return "Pipeline Graph Publisher";
        }

        @Override
        public int ordinal() {
            return 20;
        }

        @Override
        @Nonnull
        public String getSkipFileName() {
            return ".skip-pipeline-graph";
        }

        public ListBoxModel doFillLifecycleThresholdItems() {
            ListBoxModel options = new ListBoxModel();
            options.add("package");
            options.add("install");
            options.add("deploy");
            return options;
        }
    }
}

