/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Result;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.tools.ToolConfigurationCategory;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginH2Dao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginNullDao;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=50.0)
@Symbol(value={"pipelineMaven"})
public class GlobalPipelineMavenConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(GlobalPipelineMavenConfig.class.getName());
    private static PipelineMavenPluginDao DAO;
    private boolean triggerDownstreamUponResultSuccess = true;
    private boolean triggerDownstreamUponResultUnstable;
    private boolean triggerDownstreamUponResultFailure;
    private boolean triggerDownstreamUponResultNotBuilt;
    private boolean triggerDownstreamUponResultAborted;
    private List<MavenPublisher> publisherOptions;

    @DataBoundConstructor
    public GlobalPipelineMavenConfig() {
        this.load();
    }

    public ToolConfigurationCategory getCategory() {
        return (ToolConfigurationCategory)GlobalConfigurationCategory.get(ToolConfigurationCategory.class);
    }

    @CheckForNull
    public List<MavenPublisher> getPublisherOptions() {
        return this.publisherOptions;
    }

    @DataBoundSetter
    public void setPublisherOptions(List<MavenPublisher> publisherOptions) {
        this.publisherOptions = publisherOptions;
    }

    public boolean isTriggerDownstreamUponResultSuccess() {
        return this.triggerDownstreamUponResultSuccess;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultSuccess(boolean triggerDownstreamUponResultSuccess) {
        this.triggerDownstreamUponResultSuccess = triggerDownstreamUponResultSuccess;
    }

    public boolean isTriggerDownstreamUponResultUnstable() {
        return this.triggerDownstreamUponResultUnstable;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultUnstable(boolean triggerDownstreamUponResultUnstable) {
        this.triggerDownstreamUponResultUnstable = triggerDownstreamUponResultUnstable;
    }

    public boolean isTriggerDownstreamUponResultFailure() {
        return this.triggerDownstreamUponResultFailure;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultFailure(boolean triggerDownstreamUponResultFailure) {
        this.triggerDownstreamUponResultFailure = triggerDownstreamUponResultFailure;
    }

    public boolean isTriggerDownstreamUponResultNotBuilt() {
        return this.triggerDownstreamUponResultNotBuilt;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultNotBuilt(boolean triggerDownstreamUponResultNotBuilt) {
        this.triggerDownstreamUponResultNotBuilt = triggerDownstreamUponResultNotBuilt;
    }

    public boolean isTriggerDownstreamUponResultAborted() {
        return this.triggerDownstreamUponResultAborted;
    }

    @DataBoundSetter
    public void setTriggerDownstreamUponResultAborted(boolean triggerDownstreamUponResultAborted) {
        this.triggerDownstreamUponResultAborted = triggerDownstreamUponResultAborted;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.publisherOptions = req.bindJSONToList(MavenPublisher.class, json.get("publisherOptions"));
        this.save();
        return true;
    }

    public static synchronized PipelineMavenPluginDao getDao() {
        if (DAO == null) {
            try {
                boolean created;
                File jenkinsRootDir = Jenkins.getInstance().getRootDir();
                File databaseRootDir = new File(jenkinsRootDir, "jenkins-jobs");
                if (!databaseRootDir.exists() && !(created = databaseRootDir.mkdirs())) {
                    throw new IllegalStateException("Failure to create database root dir " + databaseRootDir);
                }
                DAO = new PipelineMavenPluginH2Dao(databaseRootDir);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception creating database dao, skip", e);
                DAO = new PipelineMavenPluginNullDao();
            }
        }
        return DAO;
    }

    @Nonnull
    public Set<Result> getTriggerDownstreamBuildsResultsCriteria() {
        HashSet<Result> result = new HashSet<Result>(5);
        if (this.triggerDownstreamUponResultSuccess) {
            result.add(Result.SUCCESS);
        }
        if (this.triggerDownstreamUponResultUnstable) {
            result.add(Result.UNSTABLE);
        }
        if (this.triggerDownstreamUponResultAborted) {
            result.add(Result.ABORTED);
        }
        if (this.triggerDownstreamUponResultNotBuilt) {
            result.add(Result.NOT_BUILT);
        }
        if (this.triggerDownstreamUponResultFailure) {
            result.add(Result.FAILURE);
        }
        return result;
    }

    @Nonnull
    public static Set<Result> getTriggerDownstreamBuildsCriteria() {
        GlobalPipelineMavenConfig globalPipelineMavenConfig = GlobalPipelineMavenConfig.get();
        if (globalPipelineMavenConfig == null) {
            return Collections.singleton(Result.SUCCESS);
        }
        return globalPipelineMavenConfig.getTriggerDownstreamBuildsResultsCriteria();
    }

    @Nullable
    public static GlobalPipelineMavenConfig get() {
        return (GlobalPipelineMavenConfig)((Object)GlobalConfiguration.all().get(GlobalPipelineMavenConfig.class));
    }
}

