/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.console.ConsoleLogFilter;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.JDK;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.tasks.Maven;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.mvn.DefaultGlobalSettingsProvider;
import jenkins.mvn.DefaultSettingsProvider;
import jenkins.mvn.FilePathGlobalSettingsProvider;
import jenkins.mvn.FilePathSettingsProvider;
import jenkins.mvn.GlobalMavenConfig;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.SettingsProvider;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.maven.GlobalMavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.MavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.job.MvnGlobalSettingsProvider;
import org.jenkinsci.plugins.configfiles.maven.job.MvnSettingsProvider;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.WithMavenStep;
import org.jenkinsci.plugins.pipeline.maven.console.MaskPasswordsConsoleLogFilter;
import org.jenkinsci.plugins.pipeline.maven.console.MavenColorizerConsoleLogFilter;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.springframework.util.ClassUtils;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Contextual fields used only in start(); no onResume needed")
class WithMavenStepExecution
extends StepExecution {
    private static final long serialVersionUID = 1L;
    private static final String M2_HOME = "M2_HOME";
    private static final String MAVEN_HOME = "MAVEN_HOME";
    private static final String MAVEN_OPTS = "MAVEN_OPTS";
    private static final String MVN_CMD = "MVN_CMD";
    private static final String MVN_CMD_DIR = "MVN_CMD_DIR";
    private static final Logger LOGGER = Logger.getLogger(WithMavenStepExecution.class.getName());
    private final transient WithMavenStep step;
    private final transient TaskListener listener;
    private final transient FilePath ws;
    private final transient Launcher launcher;
    private final transient EnvVars env;
    private transient EnvVars envOverride;
    private final transient Run<?, ?> build;
    private transient Computer computer;
    private transient FilePath tempBinDir;
    private transient BodyExecution body;
    private boolean withContainer;
    private transient PrintStream console;

    WithMavenStepExecution(StepContext context, WithMavenStep step) throws Exception {
        super(context);
        this.step = step;
        this.listener = (TaskListener)context.get(TaskListener.class);
        this.ws = (FilePath)context.get(FilePath.class);
        this.launcher = (Launcher)context.get(Launcher.class);
        this.env = (EnvVars)context.get(EnvVars.class);
        this.build = (Run)context.get(Run.class);
    }

    public boolean start() throws Exception {
        this.envOverride = new EnvVars();
        this.console = this.listener.getLogger();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Maven: {0}", this.step.getMaven());
            LOGGER.log(Level.FINE, "Jdk: {0}", this.step.getJdk());
            LOGGER.log(Level.FINE, "MavenOpts: {0}", this.step.getMavenOpts());
            LOGGER.log(Level.FINE, "Settings Config: {0}", this.step.getMavenSettingsConfig());
            LOGGER.log(Level.FINE, "Settings FilePath: {0}", this.step.getMavenSettingsFilePath());
            LOGGER.log(Level.FINE, "Global settings Config: {0}", this.step.getGlobalMavenSettingsConfig());
            LOGGER.log(Level.FINE, "Global settings FilePath: {0}", this.step.getGlobalMavenSettingsFilePath());
            LOGGER.log(Level.FINE, "Options: {0}", this.step.getOptions());
            LOGGER.log(Level.FINE, "env.PATH: {0}", this.env.get((Object)"PATH"));
            LOGGER.log(Level.FINE, "ws: {0}", this.ws.getRemote());
        }
        this.listener.getLogger().println("[withMaven] Options: " + this.step.getOptions());
        ExtensionList availableMavenPublishers = Jenkins.getInstance().getExtensionList(MavenPublisher.class);
        this.listener.getLogger().println("[withMaven] Available options: " + Joiner.on((String)",").join((Iterable)availableMavenPublishers));
        this.getComputer();
        this.withContainer = this.detectWithContainer();
        if (this.withContainer) {
            this.listener.getLogger().print("[withMaven] WARNING: \"withMaven(){...}\" step running within \"docker.image('image').inside {...}\". Since the Docker Pipeline Plugin version 1.14, you MUST prepend the 'MVN_CMD_DIR' environment variable to the 'PATH' environment variable in every 'sh' step that invokes 'mvn'. ");
            this.listener.getLogger().print("See ");
            this.listener.hyperlink("https://wiki.jenkins.io/display/JENKINS/Pipeline+Maven+Plugin#PipelineMavenPlugin-HowtousethePipelineMavenPluginwithDocker", "Pipeline Maven Plugin FAQ");
            this.listener.getLogger().println(".");
            this.listener.getLogger().println("[withMaven] Sample:");
            this.listener.getLogger().println("[withMaven]    sh \"export PATH=$MVN_CMD_DIR:$PATH && mvn ...\"");
        }
        this.setupJDK();
        ArrayList<Credentials> credentials = new ArrayList<Credentials>();
        this.setupMaven(credentials);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, this.build + " - Track usage and mask password of credentials " + Joiner.on((String)", ").join((Iterable)Collections2.transform(credentials, (Function)new CredentialsToPrettyString())));
        }
        CredentialsProvider.trackAll(this.build, new ArrayList<Credentials>(credentials));
        ConsoleLogFilter originalFilter = (ConsoleLogFilter)this.getContext().get(ConsoleLogFilter.class);
        MaskPasswordsConsoleLogFilter maskSecretsFilter = MaskPasswordsConsoleLogFilter.newMaskPasswordsConsoleLogFilter(credentials, this.getComputer().getDefaultCharset());
        MavenColorizerConsoleLogFilter mavenColorizerFilter = new MavenColorizerConsoleLogFilter(this.getComputer().getDefaultCharset().name());
        ConsoleLogFilter newFilter = BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)originalFilter, (ConsoleLogFilter)maskSecretsFilter), (ConsoleLogFilter)mavenColorizerFilter);
        EnvironmentExpander envEx = EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(this.envOverride));
        LOGGER.log(Level.FINEST, "envOverride: {0}", this.envOverride);
        this.body = this.getContext().newBodyInvoker().withContexts(new Object[]{envEx, newFilter}).withCallback((BodyExecutionCallback)new WorkspaceCleanupCallback(this.tempBinDir, this.step.getOptions())).start();
        return false;
    }

    private boolean detectWithContainer() {
        Launcher launcher1 = this.launcher;
        while (launcher1 instanceof Launcher.DecoratedLauncher) {
            if (launcher1.getClass().getName().contains("WithContainerStep")) {
                LOGGER.fine("Step running within docker.image()");
                return true;
            }
            launcher1 = ((Launcher.DecoratedLauncher)launcher1).getInner();
        }
        return false;
    }

    private void setupJDK() throws AbortException, IOException, InterruptedException {
        String jdkInstallationName = this.step.getJdk();
        if (StringUtils.isEmpty((String)jdkInstallationName)) {
            this.console.println("[withMaven] use JDK installation provided by the build agent");
            return;
        }
        if (this.withContainer) {
            LOGGER.log(Level.FINE, "Ignoring JDK installation parameter: {0}", jdkInstallationName);
            this.console.println("WARNING: \"withMaven(){...}\" step running within \"docker.image().inside{...}\", tool installations are not available see https://issues.jenkins-ci.org/browse/JENKINS-36159. You have specified a JDK installation \"" + jdkInstallationName + "\", which will be ignored.");
            return;
        }
        this.console.println("[withMaven] use JDK installation " + jdkInstallationName);
        JDK jdk = Jenkins.getActiveInstance().getJDK(jdkInstallationName);
        if (jdk == null) {
            throw new AbortException("Could not find the JDK installation: " + jdkInstallationName + ". Make sure it is configured on the Global Tool Configuration page");
        }
        Node node = this.getComputer().getNode();
        if (node == null) {
            throw new AbortException("Could not obtain the Node for the computer: " + this.getComputer().getName());
        }
        jdk = jdk.forNode(node, this.listener).forEnvironment(this.env);
        jdk.buildEnvVars(this.envOverride);
    }

    private void setupMaven(@Nonnull Collection<Credentials> credentials) throws IOException, InterruptedException {
        this.tempBinDir = WithMavenStepExecution.tempDir(this.ws).child("withMaven" + Util.getDigestOf((String)UUID.randomUUID().toString()).substring(0, 8));
        this.tempBinDir.mkdirs();
        this.envOverride.put(MVN_CMD_DIR, this.tempBinDir.getRemote());
        String settingsFilePath = this.setupSettingFile(credentials);
        String globalSettingsFilePath = this.setupGlobalSettingFile(credentials);
        String mavenLocalRepo = this.setupMavenLocalRepo();
        FilePath mavenSpyJarPath = this.setupMavenSpy();
        String javaToolsOptions = this.env.get("JAVA_TOOL_OPTIONS", "");
        if (StringUtils.isNotEmpty((String)javaToolsOptions)) {
            javaToolsOptions = javaToolsOptions + " ";
        }
        javaToolsOptions = javaToolsOptions + "-Dmaven.ext.class.path=\"" + mavenSpyJarPath.getRemote() + "\" -Dorg.jenkinsci.plugins.pipeline.maven.reportsFolder=\"" + this.tempBinDir.getRemote() + "\" ";
        this.envOverride.put("JAVA_TOOL_OPTIONS", javaToolsOptions);
        StringBuilder mavenConfig = new StringBuilder();
        mavenConfig.append("--batch-mode ");
        mavenConfig.append("--show-version ");
        if (StringUtils.isNotEmpty((String)settingsFilePath)) {
            mavenConfig.append("--settings " + settingsFilePath + " ");
        }
        if (StringUtils.isNotEmpty((String)globalSettingsFilePath)) {
            mavenConfig.append("--global-settings " + globalSettingsFilePath + " ");
        }
        if (StringUtils.isNotEmpty((String)mavenLocalRepo)) {
            mavenConfig.append("-Dmaven.repo.local=" + mavenLocalRepo + " ");
        }
        this.envOverride.put("MAVEN_CONFIG", mavenConfig.toString());
        if (StringUtils.isNotEmpty((String)this.step.getMavenOpts())) {
            String mavenOpts = this.envOverride.expand(this.env.expand(this.step.getMavenOpts()));
            String mavenOpsOriginal = (String)this.env.get((Object)MAVEN_OPTS);
            if (mavenOpsOriginal != null) {
                mavenOpts = mavenOpts + " " + mavenOpsOriginal;
            }
            this.envOverride.put(MAVEN_OPTS, mavenOpts.replaceAll("[\t\r\n]+", " "));
        }
        String mvnExecPath = this.obtainMavenExec();
        LOGGER.log(Level.FINE, "Using temp dir: {0}", this.tempBinDir.getRemote());
        if (mvnExecPath == null) {
            throw new AbortException("Couldn\u2019t find any maven executable");
        }
        FilePath mvnExec = new FilePath(this.ws.getChannel(), mvnExecPath);
        String content = this.generateMavenWrapperScriptContent(mvnExec);
        this.envOverride.put("PATH+MAVEN", this.tempBinDir.getRemote());
        this.createWrapperScript(this.tempBinDir, mvnExec.getName(), content);
    }

    private FilePath setupMavenSpy() throws IOException, InterruptedException {
        InputStream in;
        if (this.tempBinDir == null) {
            throw new IllegalStateException("tempBinDir not defined");
        }
        String MAVEN_SPY_JAR_URL = "org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl";
        String mavenSpyJarUrl = System.getProperty("org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl");
        if (mavenSpyJarUrl == null) {
            String embeddedMavenSpyJarPath = "META-INF/lib/pipeline-maven-spy.jar";
            LOGGER.log(Level.FINE, "Load embedded maven spy jar '" + embeddedMavenSpyJarPath + "'");
            Class<WithMavenStepExecution> clazz = WithMavenStepExecution.class;
            ClassLoader classLoader = clazz.getClassLoader();
            LOGGER.log(Level.FINE, "Load " + embeddedMavenSpyJarPath + " using classloader " + classLoader.getClass() + ": " + classLoader);
            in = classLoader.getResourceAsStream(embeddedMavenSpyJarPath);
            if (in == null) {
                CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                String msg = "Embedded maven spy jar not found at " + embeddedMavenSpyJarPath + " in the pipeline-maven-plugin classpath. Maven Spy Jar URL can be defined with the system property: '" + "org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl" + "'Classloader " + classLoader.getClass() + ": " + classLoader + ". Class " + clazz.getName() + " loaded from " + (codeSource == null ? "#unknown#" : codeSource.getLocation());
                throw new IllegalStateException(msg);
            }
        } else {
            LOGGER.log(Level.FINE, "Load maven spy jar provided by system property 'org.jenkinsci.plugins.pipeline.maven.mavenSpyJarUrl': " + mavenSpyJarUrl);
            in = new URL(mavenSpyJarUrl).openStream();
        }
        FilePath mavenSpyJarFilePath = this.tempBinDir.child("pipeline-maven-spy.jar");
        mavenSpyJarFilePath.copyFrom(in);
        return mavenSpyJarFilePath;
    }

    private String obtainMavenExec() throws IOException, InterruptedException {
        String mvnExecPath;
        Maven.MavenInstallation mavenInstallation;
        String mavenInstallationName = this.step.getMaven();
        LOGGER.log(Level.FINE, "Setting up maven: {0}", mavenInstallationName);
        StringBuilder consoleMessage = new StringBuilder("[withMaven]");
        if (StringUtils.isEmpty((String)mavenInstallationName)) {
            consoleMessage.append(" use Maven installation provided by the build agent");
            mavenInstallation = null;
        } else if (this.withContainer) {
            this.console.println("WARNING: Specified Maven '" + mavenInstallationName + "' cannot be installed, will be ignored.Step running within docker.image() tool installations are not available see https://issues.jenkins-ci.org/browse/JENKINS-36159. ");
            LOGGER.log(Level.FINE, "Ignoring Maven Installation parameter: {0}", mavenInstallationName);
            mavenInstallation = null;
        } else {
            mavenInstallation = null;
            for (Maven.MavenInstallation i : WithMavenStepExecution.getMavenInstallations()) {
                if (!mavenInstallationName.equals(i.getName())) continue;
                mavenInstallation = i;
                consoleMessage.append(" use Maven installation '" + mavenInstallation.getName() + "'");
                LOGGER.log(Level.FINE, "Found maven installation {0} with installation home {1}", new Object[]{mavenInstallation.getName(), mavenInstallation.getHome()});
                break;
            }
            if (mavenInstallation == null) {
                throw new AbortException("Could not find Maven installation '" + mavenInstallationName + "'.");
            }
        }
        if (mavenInstallation == null) {
            LOGGER.fine("Searching for Maven through MAVEN_HOME and M2_HOME environment variables...");
            if (this.withContainer) {
                LOGGER.fine("Calling printenv on docker container...");
                String mavenHome = this.readFromProcess("printenv", MAVEN_HOME);
                if (mavenHome == null) {
                    mavenHome = this.readFromProcess("printenv", M2_HOME);
                    if (StringUtils.isNotEmpty((String)mavenHome)) {
                        consoleMessage.append(" with the environment variable M2_HOME=" + mavenHome);
                    }
                } else {
                    consoleMessage.append(" with the environment variable MAVEN_HOME=" + mavenHome);
                }
                if (mavenHome == null) {
                    LOGGER.log(Level.FINE, "NO maven installation discovered on docker container through MAVEN_HOME and M2_HOME environment variables");
                    mvnExecPath = null;
                } else {
                    LOGGER.log(Level.FINE, "Found maven installation on {0}", mavenHome);
                    mvnExecPath = mavenHome + "/bin/mvn";
                }
            } else {
                LOGGER.fine("Using computer environment...");
                EnvVars agentEnv = this.getComputer().getEnvironment();
                LOGGER.log(Level.FINE, "Agent env: {0}", agentEnv);
                String mavenHome = (String)agentEnv.get((Object)MAVEN_HOME);
                if (mavenHome == null) {
                    mavenHome = (String)agentEnv.get((Object)M2_HOME);
                    if (StringUtils.isNotEmpty((String)mavenHome)) {
                        consoleMessage.append(" with the environment variable M2_HOME=" + mavenHome);
                    }
                } else {
                    consoleMessage.append(" with the environment variable MAVEN_HOME=" + mavenHome);
                }
                if (mavenHome == null) {
                    LOGGER.log(Level.FINE, "NO maven installation discovered on build agent through MAVEN_HOME and M2_HOME environment variables");
                    mvnExecPath = null;
                } else {
                    LOGGER.log(Level.FINE, "Found maven installation on {0}", mavenHome);
                    mavenInstallation = new Maven.MavenInstallation("Maven Auto-discovered", mavenHome, null);
                    mavenInstallation.buildEnvVars(this.envOverride);
                    mvnExecPath = mavenInstallation.getExecutable(this.launcher);
                }
            }
        } else {
            Node node = this.getComputer().getNode();
            if (node == null) {
                throw new AbortException("Could not obtain the Node for the computer: " + this.getComputer().getName());
            }
            mavenInstallation = mavenInstallation.forNode(node, this.listener).forEnvironment(this.env);
            mavenInstallation.buildEnvVars(this.envOverride);
            mvnExecPath = mavenInstallation.getExecutable(this.launcher);
        }
        if (mvnExecPath == null) {
            LOGGER.fine("No Maven Installation or MAVEN_HOME found, looking for mvn executable by using which/where command");
            if (Boolean.TRUE.equals(this.getComputer().isUnix())) {
                mvnExecPath = this.readFromProcess("/bin/sh", "-c", "which mvn");
            } else {
                mvnExecPath = this.readFromProcess("where", "mvn.cmd");
                if (mvnExecPath == null) {
                    mvnExecPath = this.readFromProcess("where", "mvn.bat");
                }
            }
            consoleMessage.append(" with executable " + mvnExecPath);
        }
        this.console.println(consoleMessage.toString());
        if (mvnExecPath == null) {
            throw new AbortException("Could not find maven executable, please set up a Maven Installation or configure MAVEN_HOME or M2_HOME environment variable");
        }
        LOGGER.log(Level.FINE, "Found exec for maven on: {0}", mvnExecPath);
        return mvnExecPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String readFromProcess(String ... args) throws InterruptedException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Launcher.ProcStarter ps = this.launcher.launch();
            Proc p = this.launcher.launch(ps.cmds(args).stdout((OutputStream)baos));
            int exitCode = p.join();
            if (exitCode == 0) {
                String string2 = baos.toString(this.getComputer().getDefaultCharset().name()).replaceAll("[\t\r\n]+", " ").trim();
                return string2;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace(this.console.format("Error executing command '%s' : %s%n", Arrays.toString(args), e.getMessage()));
            return null;
        }
    }

    private String generateMavenWrapperScriptContent(FilePath mvnExec) throws AbortException {
        boolean isUnix = Boolean.TRUE.equals(this.getComputer().isUnix());
        StringBuilder script = new StringBuilder();
        if (isUnix) {
            String lineSep = "\n";
            script.append("#!/bin/sh -e").append(lineSep);
            script.append("echo ----- withMaven Wrapper script -----").append(lineSep);
            script.append(mvnExec.getRemote() + " $MAVEN_CONFIG \"$@\"").append(lineSep);
        } else {
            String lineSep = "\r\n";
            script.append("@echo off").append(lineSep);
            script.append("echo ----- withMaven Wrapper script -----").append(lineSep);
            script.append(mvnExec.getRemote() + " %MAVEN_CONFIG% %*").append(lineSep);
        }
        LOGGER.log(Level.FINER, "Generated Maven wrapper script: \n{0}", script);
        return script.toString();
    }

    private FilePath createWrapperScript(FilePath tempBinDir, String name, String content) throws IOException, InterruptedException {
        FilePath scriptFile = tempBinDir.child(name);
        this.envOverride.put(MVN_CMD, scriptFile.getRemote());
        scriptFile.write(content, this.getComputer().getDefaultCharset().name());
        scriptFile.chmod(493);
        return scriptFile;
    }

    @Nullable
    private String setupMavenLocalRepo() throws IOException, InterruptedException {
        String expandedMavenLocalRepo;
        if (StringUtils.isEmpty((String)this.step.getMavenLocalRepo())) {
            expandedMavenLocalRepo = null;
        } else {
            String expandedPath = this.envOverride.expand(this.env.expand(this.step.getMavenLocalRepo()));
            FilePath repoPath = new FilePath(this.ws, expandedPath);
            repoPath.mkdirs();
            expandedMavenLocalRepo = repoPath.getRemote();
        }
        LOGGER.log(Level.FINEST, "setupMavenLocalRepo({0}): {1}", new Object[]{this.step.getMavenLocalRepo(), expandedMavenLocalRepo});
        return expandedMavenLocalRepo;
    }

    @Nullable
    private String setupSettingFile(@Nonnull Collection<Credentials> credentials) throws IOException, InterruptedException {
        FilePath settingsDest = this.tempBinDir.child("settings.xml");
        if (StringUtils.isNotEmpty((String)this.step.getMavenSettingsConfig())) {
            this.console.format("[withMaven] use Maven settings provided by the Jenkins Managed Configuration File '%s' %n", this.step.getMavenSettingsConfig());
            this.settingsFromConfig(this.step.getMavenSettingsConfig(), settingsDest, credentials);
            this.envOverride.put("MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (StringUtils.isNotEmpty((String)this.step.getMavenSettingsFilePath())) {
            String settingsPath = this.step.getMavenSettingsFilePath();
            FilePath settings = this.ws.child(settingsPath);
            if (!settings.exists()) {
                throw new AbortException("Could not find file '" + settings + "' on the build agent");
            }
            this.console.format("[withMaven] use Maven settings provided on the build agent '%s' %n", settingsPath);
            LOGGER.log(Level.FINE, "Copying maven settings file from build agent {0} to {1}", new Object[]{settings, settingsDest});
            settings.copyTo(settingsDest);
            this.envOverride.put("MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        SettingsProvider settingsProvider = GlobalMavenConfig.get().getSettingsProvider();
        if (settingsProvider instanceof MvnSettingsProvider) {
            MvnSettingsProvider mvnSettingsProvider = (MvnSettingsProvider)settingsProvider;
            this.console.format("[withMaven] use Maven settings provided by the Jenkins global configuration '%s' %n", mvnSettingsProvider.getSettingsConfigId());
            this.settingsFromConfig(mvnSettingsProvider.getSettingsConfigId(), settingsDest, credentials);
            this.envOverride.put("MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (settingsProvider instanceof FilePathSettingsProvider) {
            FilePathSettingsProvider filePathSettingsProvider = (FilePathSettingsProvider)settingsProvider;
            String settingsPath = filePathSettingsProvider.getPath();
            FilePath settings = this.ws.child(settingsPath);
            if (!settings.exists()) {
                throw new AbortException("Could not find file provided by the Jenkins global configuration '" + settings + "' on the build agent");
            }
            this.console.format("[withMaven] use Maven settings provided by the Jenkins global configuration on the build agent '%s' %n", settingsPath);
            settings.copyTo(settingsDest);
            this.envOverride.put("MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (!(settingsProvider instanceof DefaultSettingsProvider) && settingsProvider != null) {
            this.console.println("[withMaven] Ignore unsupported Maven SettingsProvider " + settingsProvider);
        }
        return null;
    }

    @Nullable
    private String setupGlobalSettingFile(@Nonnull Collection<Credentials> credentials) throws IOException, InterruptedException {
        FilePath settingsDest = this.tempBinDir.child("globalSettings.xml");
        if (StringUtils.isNotEmpty((String)this.step.getGlobalMavenSettingsConfig())) {
            this.console.format("[withMaven] use Maven global settings provided by the Jenkins Managed Configuration File '%s' %n", this.step.getGlobalMavenSettingsConfig());
            this.globalSettingsFromConfig(this.step.getGlobalMavenSettingsConfig(), settingsDest, credentials);
            this.envOverride.put("GLOBAL_MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (StringUtils.isNotEmpty((String)this.step.getGlobalMavenSettingsFilePath())) {
            String settingsPath = this.step.getGlobalMavenSettingsFilePath();
            FilePath settings = this.ws.child(settingsPath);
            if (!settings.exists()) {
                throw new AbortException("Could not find file '" + settings + "' on the build agent");
            }
            this.console.format("[withMaven] use Maven global settings provided on the build agent '%s' %n", settingsPath);
            LOGGER.log(Level.FINE, "Copying maven global settings file from build agent {0} to {1}", new Object[]{settings, settingsDest});
            settings.copyTo(settingsDest);
            this.envOverride.put("GLOBAL_MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        GlobalSettingsProvider globalSettingsProvider = GlobalMavenConfig.get().getGlobalSettingsProvider();
        if (globalSettingsProvider instanceof MvnGlobalSettingsProvider) {
            MvnGlobalSettingsProvider mvnGlobalSettingsProvider = (MvnGlobalSettingsProvider)globalSettingsProvider;
            this.console.format("[withMaven] use Maven global settings provided by the Jenkins global configuration '%s' %n", mvnGlobalSettingsProvider.getSettingsConfigId());
            this.globalSettingsFromConfig(mvnGlobalSettingsProvider.getSettingsConfigId(), settingsDest, credentials);
            this.envOverride.put("GLOBAL_MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (globalSettingsProvider instanceof FilePathGlobalSettingsProvider) {
            FilePathGlobalSettingsProvider filePathGlobalSettingsProvider = (FilePathGlobalSettingsProvider)globalSettingsProvider;
            String settingsPath = filePathGlobalSettingsProvider.getPath();
            FilePath settings = this.ws.child(settingsPath);
            if (!settings.exists()) {
                throw new AbortException("Could not find file provided by the Jenkins global configuration '" + settings + "' on the build agent");
            }
            this.console.format("[withMaven] use Maven global settings provided by the Jenkins global configuration on the build agent '%s' %n", settingsPath);
            settings.copyTo(settingsDest);
            this.envOverride.put("GLOBAL_MVN_SETTINGS", settingsDest.getRemote());
            return settingsDest.getRemote();
        }
        if (!(globalSettingsProvider instanceof DefaultGlobalSettingsProvider) && globalSettingsProvider != null) {
            this.console.println("[withMaven] Ignore unsupported Maven GlobalSettingsProvider " + globalSettingsProvider);
        }
        return null;
    }

    private void settingsFromConfig(String mavenSettingsConfigId, FilePath mavenSettingsFile, @Nonnull Collection<Credentials> credentials) throws AbortException {
        Config c = ConfigFiles.getByIdOrNull(this.build, (String)mavenSettingsConfigId);
        if (c == null) {
            throw new AbortException("Could not find the Maven settings.xml config file id:" + mavenSettingsConfigId + ". Make sure it exists on Managed Files");
        }
        if (StringUtils.isBlank((String)c.content)) {
            throw new AbortException("Could not create Maven settings.xml config file id:" + mavenSettingsConfigId + ". Content of the file is empty");
        }
        MavenSettingsConfig mavenSettingsConfig = c instanceof MavenSettingsConfig ? (MavenSettingsConfig)c : new MavenSettingsConfig(c.id, c.name, c.comment, c.content, MavenSettingsConfig.isReplaceAllDefault, null);
        try {
            String mavenSettingsFileContent;
            List serverCredentialMappings = (List)Objects.firstNonNull((Object)mavenSettingsConfig.getServerCredentialMappings(), Collections.emptyList());
            Map resolvedCredentials = CredentialsHelper.resolveCredentials(this.build, (List)serverCredentialMappings);
            credentials.addAll(resolvedCredentials.values());
            if (resolvedCredentials.isEmpty()) {
                mavenSettingsFileContent = mavenSettingsConfig.content;
                this.console.println("[withMaven] use Maven settings.xml '" + mavenSettingsConfig.id + "' with NO Maven servers credentials provided by Jenkins");
            } else {
                ArrayList tempFiles = new ArrayList();
                mavenSettingsFileContent = CredentialsHelper.fillAuthentication((String)mavenSettingsConfig.content, (Boolean)mavenSettingsConfig.isReplaceAll, (Map)resolvedCredentials, (FilePath)this.tempBinDir, tempFiles);
                this.console.println("[withMaven] use Maven settings.xml '" + mavenSettingsConfig.id + "' with Maven servers credentials provided by Jenkins (replaceAll: " + mavenSettingsConfig.isReplaceAll + "): " + Joiner.on((String)", ").skipNulls().join(Iterables.transform(resolvedCredentials.entrySet(), (Function)new MavenServerToCredentialsMappingToStringFunction())));
            }
            mavenSettingsFile.write(mavenSettingsFileContent, this.getComputer().getDefaultCharset().name());
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception injecting Maven settings.xml " + mavenSettingsConfig.id + " during the build: " + this.build + ": " + e.getMessage(), e);
        }
    }

    private void globalSettingsFromConfig(String mavenGlobalSettingsConfigId, FilePath mavenGlobalSettingsFile, Collection<Credentials> credentials) throws AbortException {
        Config c = ConfigFiles.getByIdOrNull(this.build, (String)mavenGlobalSettingsConfigId);
        if (c == null) {
            throw new AbortException("Could not find the Maven global settings.xml config file id:" + mavenGlobalSettingsFile + ". Make sure it exists on Managed Files");
        }
        if (StringUtils.isBlank((String)c.content)) {
            throw new AbortException("Could not create Maven global settings.xml config file id:" + mavenGlobalSettingsFile + ". Content of the file is empty");
        }
        GlobalMavenSettingsConfig mavenGlobalSettingsConfig = c instanceof GlobalMavenSettingsConfig ? (GlobalMavenSettingsConfig)c : new GlobalMavenSettingsConfig(c.id, c.name, c.comment, c.content, MavenSettingsConfig.isReplaceAllDefault, null);
        try {
            String mavenGlobalSettingsFileContent;
            List serverCredentialMappings = (List)Objects.firstNonNull((Object)mavenGlobalSettingsConfig.getServerCredentialMappings(), Collections.emptyList());
            Map resolvedCredentials = CredentialsHelper.resolveCredentials(this.build, (List)serverCredentialMappings);
            credentials.addAll(resolvedCredentials.values());
            if (resolvedCredentials.isEmpty()) {
                mavenGlobalSettingsFileContent = mavenGlobalSettingsConfig.content;
                this.console.println("[withMaven] use Maven global settings.xml '" + mavenGlobalSettingsConfig.id + "' with NO Maven servers credentials provided by Jenkins");
            } else {
                ArrayList tempFiles = new ArrayList();
                mavenGlobalSettingsFileContent = CredentialsHelper.fillAuthentication((String)mavenGlobalSettingsConfig.content, (Boolean)mavenGlobalSettingsConfig.isReplaceAll, (Map)resolvedCredentials, (FilePath)this.tempBinDir, tempFiles);
                this.console.println("[withMaven] use Maven global settings.xml '" + mavenGlobalSettingsConfig.id + "' with Maven servers credentials provided by Jenkins (replaceAll: " + mavenGlobalSettingsConfig.isReplaceAll + "): " + Joiner.on((String)", ").skipNulls().join(Iterables.transform(resolvedCredentials.entrySet(), (Function)new MavenServerToCredentialsMappingToStringFunction())));
            }
            mavenGlobalSettingsFile.write(mavenGlobalSettingsFileContent, this.getComputer().getDefaultCharset().name());
            LOGGER.log(Level.FINE, "Created global config file {0}", new Object[]{mavenGlobalSettingsFile});
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception injecting Maven settings.xml " + mavenGlobalSettingsConfig.id + " during the build: " + this.build + ": " + e.getMessage(), e);
        }
    }

    private static Maven.MavenInstallation[] getMavenInstallations() {
        return ((Maven.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(Maven.DescriptorImpl.class)).getInstallations();
    }

    public void stop(Throwable cause) throws Exception {
        if (this.body != null) {
            this.body.cancel(cause);
        }
    }

    @Nonnull
    private Computer getComputer() throws AbortException {
        if (this.computer != null) {
            return this.computer;
        }
        String node = null;
        Jenkins j = Jenkins.getActiveInstance();
        for (Computer c : j.getComputers()) {
            if (c.getChannel() != this.launcher.getChannel()) continue;
            node = c.getName();
            break;
        }
        if (node == null) {
            throw new AbortException("Could not find computer for the job");
        }
        this.computer = j.getComputer(node);
        if (this.computer == null) {
            throw new AbortException("No such computer " + node);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Computer: {0}", this.computer.getName());
            try {
                LOGGER.log(Level.FINE, "Env: {0}", this.computer.getEnvironment());
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return this.computer;
    }

    private static FilePath tempDir(FilePath ws) {
        return WorkspaceList.tempDir((FilePath)ws);
    }

    private static class CredentialsToPrettyString
    implements Function<Credentials, String> {
        private CredentialsToPrettyString() {
        }

        public String apply(@javax.annotation.Nullable Credentials credentials) {
            if (credentials == null) {
                return "null";
            }
            String result = ClassUtils.getShortName(credentials.getClass()) + "[";
            if (credentials instanceof IdCredentials) {
                IdCredentials idCredentials = (IdCredentials)credentials;
                result = result + "id: " + idCredentials.getId() + ",";
            }
            if (credentials instanceof UsernameCredentials) {
                UsernameCredentials usernameCredentials = (UsernameCredentials)credentials;
                result = result + "username: " + usernameCredentials.getUsername() + "";
            }
            result = result + "]";
            return result;
        }
    }

    private static class MavenServerToCredentialsMappingToStringFunction
    implements Function<Map.Entry<String, StandardUsernameCredentials>, String> {
        private MavenServerToCredentialsMappingToStringFunction() {
        }

        public String apply(@Nullable Map.Entry<String, StandardUsernameCredentials> entry) {
            if (entry == null) {
                return null;
            }
            String mavenServerId = entry.getKey();
            StandardUsernameCredentials credentials = entry.getValue();
            return "[mavenServerId: '" + mavenServerId + "', jenkinsCredentials: '" + credentials.getId() + "', username: '" + credentials.getUsername() + "', type: '" + ClassUtils.getShortName(credentials.getClass()) + "']";
        }
    }

    private static class WorkspaceCleanupCallback
    extends BodyExecutionCallback.TailCall {
        private final FilePath tempBinDir;
        private final List<MavenPublisher> options;
        private final MavenSpyLogProcessor mavenSpyLogProcessor = new MavenSpyLogProcessor();
        private static final long serialVersionUID = 1L;

        public WorkspaceCleanupCallback(@Nonnull FilePath tempBinDir, @Nonnull List<MavenPublisher> options) {
            this.tempBinDir = tempBinDir;
            this.options = options;
        }

        protected void finished(StepContext context) throws Exception {
            this.mavenSpyLogProcessor.processMavenSpyLogs(context, this.tempBinDir, this.options);
            try {
                this.tempBinDir.deleteRecursive();
            }
            catch (IOException | InterruptedException e) {
                BuildListener listener = (BuildListener)context.get(BuildListener.class);
                try {
                    if (e instanceof IOException) {
                        Util.displayIOException((IOException)((IOException)e), (TaskListener)listener);
                    }
                    e.printStackTrace(listener.fatalError("Error deleting temporary files"));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> overrides;

        private ExpanderImpl(EnvVars overrides) {
            LOGGER.log(Level.FINEST, "ExpanderImpl(overrides: {0})", new Object[]{overrides});
            this.overrides = new HashMap<String, String>();
            for (Map.Entry entry : overrides.entrySet()) {
                this.overrides.put((String)entry.getKey(), (String)entry.getValue());
            }
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            LOGGER.log(Level.FINEST, "ExpanderImpl.expand - env before expand: {0}", new Object[]{env});
            env.overrideAll(this.overrides);
            LOGGER.log(Level.FINEST, "ExpanderImpl.expand - env after expand: {0}", new Object[]{env});
        }
    }
}

