/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.h2.jdbcx.JdbcConnectionPool;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.util.RuntimeIoException;
import org.jenkinsci.plugins.pipeline.maven.util.RuntimeSqlException;

public class PipelineMavenPluginH2Dao
implements PipelineMavenPluginDao {
    private static Logger LOGGER = Logger.getLogger(PipelineMavenPluginH2Dao.class.getName());
    private transient JdbcConnectionPool jdbcConnectionPool;

    public PipelineMavenPluginH2Dao(File rootDir) {
        rootDir.getClass();
        File databaseFile = new File(rootDir, "jenkins-jobs");
        String jdbcUrl = "jdbc:h2:file:" + databaseFile.getAbsolutePath() + ";AUTO_SERVER=TRUE;MULTI_THREADED=1";
        this.jdbcConnectionPool = JdbcConnectionPool.create((String)jdbcUrl, (String)"sa", (String)"sa");
        LOGGER.log(Level.FINE, "Open database {0}", jdbcUrl);
        this.initializeDatabase();
        this.testDatabase();
    }

    public PipelineMavenPluginH2Dao(JdbcConnectionPool jdbcConnectionPool) {
        jdbcConnectionPool.getClass();
        this.jdbcConnectionPool = jdbcConnectionPool;
        this.initializeDatabase();
        this.testDatabase();
    }

    public PipelineMavenPluginH2Dao(String jdbcUrl, String username, String password) {
        jdbcUrl.getClass();
        username.getClass();
        password.getClass();
        this.jdbcConnectionPool = JdbcConnectionPool.create((String)jdbcUrl, (String)username, (String)password);
        LOGGER.log(Level.FINE, "Open database {0}", jdbcUrl);
        this.initializeDatabase();
    }

    @Override
    public void recordDependency(String jobFullName, int buildNumber, String groupId, String artifactId, String version, String type, String scope, boolean ignoreUpstreamTriggers) {
        LOGGER.log(Level.FINE, "recordDependency({0}#{1}, {2}:{3}:{4}:{5}, {6}, ignoreUpstreamTriggers:{7}})", new Object[]{jobFullName, buildNumber, groupId, artifactId, version, type, scope, ignoreUpstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long artifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(groupId, artifactId, version, type);
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO MAVEN_DEPENDENCY(ARTIFACT_ID, BUILD_ID, SCOPE, IGNORE_UPSTREAM_TRIGGERS) VALUES (?, ?, ?, ?)");){
                stmt.setLong(1, artifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setString(3, scope);
                stmt.setBoolean(4, ignoreUpstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void recordGeneratedArtifact(String jobFullName, int buildNumber, String groupId, String artifactId, String version, String type, String baseVersion, boolean skipDownstreamTriggers) {
        LOGGER.log(Level.FINE, "recordGeneratedArtifact({0}#{1}, {2}:{3}:{4}:{5}, version:{6}, skipDownstreamTriggers:{7})", new Object[]{jobFullName, buildNumber, groupId, artifactId, baseVersion, type, version, skipDownstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long artifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(groupId, artifactId, baseVersion, type);
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO GENERATED_MAVEN_ARTIFACT(ARTIFACT_ID, BUILD_ID, VERSION, SKIP_DOWNSTREAM_TRIGGERS) VALUES (?, ?, ?, ?)");){
                stmt.setLong(1, artifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setString(3, version);
                stmt.setBoolean(4, skipDownstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void renameJob(String oldFullName, String newFullName) {
        LOGGER.log(Level.FINER, "renameJob({0}, {1})", new Object[]{oldFullName, newFullName});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("UPDATE JENKINS_JOB SET FULL_NAME = ? WHERE FULL_NAME = ?");){
                stmt.setString(1, newFullName);
                stmt.setString(2, oldFullName);
                int count = stmt.executeUpdate();
                LOGGER.log(Level.FINE, "renameJob({0}, {1}): {2}", new Object[]{oldFullName, newFullName, count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void deleteJob(String jobFullName) {
        LOGGER.log(Level.FINER, "deleteJob({0})", new Object[]{jobFullName});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("DELETE FROM JENKINS_JOB WHERE FULL_NAME = ?");){
                stmt.setString(1, jobFullName);
                int count = stmt.executeUpdate();
                LOGGER.log(Level.FINE, "deleteJob({0}): {1}", new Object[]{jobFullName, count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void deleteBuild(String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "deleteBuild({0}#{1})", new Object[]{jobFullName, buildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            Long jobPrimaryKey;
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_JOB WHERE FULL_NAME = ?");){
                stmt.setString(1, jobFullName);
                try (ResultSet rst = stmt.executeQuery();){
                    jobPrimaryKey = rst.next() ? Long.valueOf(rst.getLong(1)) : null;
                }
            }
            if (jobPrimaryKey == null) {
                LOGGER.log(Level.FINE, "No record found for job {0}", new Object[]{jobFullName});
                return;
            }
            stmt = cnn.prepareStatement("DELETE FROM JENKINS_BUILD WHERE JOB_ID = ? AND NUMBER = ?");
            var7_8 = null;
            try {
                stmt.setLong(1, jobPrimaryKey);
                stmt.setInt(2, buildNumber);
                int count = stmt.executeUpdate();
                LOGGER.log(Level.FINE, "deleteJob({0}#{1}): {2}", new Object[]{jobFullName, buildNumber, count});
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var7_8 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var7_8.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public void cleanup() {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            String sql = "DELETE FROM MAVEN_ARTIFACT WHERE ID NOT IN (SELECT DISTINCT ARTIFACT_ID FROM MAVEN_DEPENDENCY UNION SELECT DISTINCT ARTIFACT_ID FROM GENERATED_MAVEN_ARTIFACT)";
            try (Statement stmt = cnn.createStatement();){
                int count = stmt.executeUpdate(sql);
                LOGGER.log(Level.FINE, "cleanup(): {0}", new Object[]{count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getOrCreateBuildPrimaryKey(String jobFullName, int buildNumber) {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            Throwable throwable;
            ResultSet rst;
            Throwable throwable2;
            ResultSet rst2;
            cnn.setAutoCommit(false);
            Long jobPrimaryKey = null;
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_JOB WHERE FULL_NAME=?");){
                stmt.setString(1, jobFullName);
                rst2 = stmt.executeQuery();
                throwable2 = null;
                try {
                    if (rst2.next()) {
                        jobPrimaryKey = rst2.getLong(1);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rst2 != null) {
                        if (throwable2 != null) {
                            try {
                                rst2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            rst2.close();
                        }
                    }
                }
            }
            if (jobPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO JENKINS_JOB(FULL_NAME) VALUES (?)", 1);
                var7_9 = null;
                try {
                    stmt.setString(1, jobFullName);
                    stmt.execute();
                    rst2 = stmt.getGeneratedKeys();
                    throwable2 = null;
                    try {
                        if (!rst2.next()) throw new IllegalStateException();
                        jobPrimaryKey = rst2.getLong(1);
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (rst2 != null) {
                            if (throwable2 != null) {
                                try {
                                    rst2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                rst2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable7) {
                    var7_9 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (stmt != null) {
                        if (var7_9 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable8) {
                                var7_9.addSuppressed(throwable8);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            Long buildPrimaryKey = null;
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_BUILD WHERE JOB_ID=? AND NUMBER=?");){
                stmt.setLong(1, jobPrimaryKey);
                stmt.setInt(2, buildNumber);
                rst = stmt.executeQuery();
                throwable = null;
                try {
                    if (rst.next()) {
                        buildPrimaryKey = rst.getLong(1);
                    }
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (rst != null) {
                        if (throwable != null) {
                            try {
                                rst.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            rst.close();
                        }
                    }
                }
            }
            if (buildPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO JENKINS_BUILD(JOB_ID, NUMBER) VALUES (?, ?)", 1);
                var8_11 = null;
                try {
                    stmt.setLong(1, jobPrimaryKey);
                    stmt.setInt(2, buildNumber);
                    stmt.execute();
                    rst = stmt.getGeneratedKeys();
                    throwable = null;
                    try {
                        if (!rst.next()) throw new IllegalStateException();
                        buildPrimaryKey = rst.getLong(1);
                    }
                    catch (Throwable throwable11) {
                        throwable = throwable11;
                        throw throwable11;
                    }
                    finally {
                        if (rst != null) {
                            if (throwable != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable12) {
                                    throwable.addSuppressed(throwable12);
                                }
                            } else {
                                rst.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable13) {
                    var8_11 = throwable13;
                    throw throwable13;
                }
                finally {
                    if (stmt != null) {
                        if (var8_11 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable14) {
                                var8_11.addSuppressed(throwable14);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            cnn.commit();
            long l = buildPrimaryKey;
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getOrCreateArtifactPrimaryKey(String groupId, String artifactId, String version, String type) {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            Throwable throwable;
            ResultSet rst;
            cnn.setAutoCommit(false);
            Long artifactPrimaryKey = null;
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM MAVEN_ARTIFACT WHERE GROUP_ID = ? AND ARTIFACT_ID = ? AND VERSION = ? AND TYPE = ?");){
                stmt.setString(1, groupId);
                stmt.setString(2, artifactId);
                stmt.setString(3, version);
                stmt.setString(4, type);
                rst = stmt.executeQuery();
                throwable = null;
                try {
                    if (rst.next()) {
                        artifactPrimaryKey = rst.getLong(1);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rst != null) {
                        if (throwable != null) {
                            try {
                                rst.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rst.close();
                        }
                    }
                }
            }
            if (artifactPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO MAVEN_ARTIFACT(GROUP_ID, ARTIFACT_ID, VERSION, TYPE) VALUES (?, ?, ?, ?)", 1);
                var9_12 = null;
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, artifactId);
                    stmt.setString(3, version);
                    stmt.setString(4, type);
                    stmt.execute();
                    rst = stmt.getGeneratedKeys();
                    throwable = null;
                    try {
                        if (!rst.next()) throw new IllegalStateException();
                        artifactPrimaryKey = rst.getLong(1);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rst != null) {
                            if (throwable != null) {
                                try {
                                    rst.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                rst.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    var9_12 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (stmt != null) {
                        if (var9_12 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable7) {
                                var9_12.addSuppressed(throwable7);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            cnn.commit();
            long l = artifactPrimaryKey;
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected synchronized void initializeDatabase() {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            cnn.setAutoCommit(false);
            int initialSchemaVersion = this.getSchemaVersion(cnn);
            LOGGER.log(Level.FINE, "Initialise database. Current schema version: {0}", new Object[]{initialSchemaVersion});
            DecimalFormat numberFormat = new DecimalFormat("00");
            int idx = initialSchemaVersion;
            while (true) {
                String sqlScriptPath = "sql/h2/" + numberFormat.format(++idx) + "_migration.sql";
                InputStream sqlScriptInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(sqlScriptPath);
                if (sqlScriptInputStream == null) break;
                try (Statement stmt = cnn.createStatement();){
                    String sqlScript = IOUtils.toString((InputStream)sqlScriptInputStream);
                    LOGGER.log(Level.INFO, "Execute database migration script {0}", sqlScriptPath);
                    stmt.execute(sqlScript);
                }
                catch (IOException e) {
                    throw new RuntimeIoException("Exception reading " + sqlScriptPath, e);
                }
                cnn.commit();
            }
            int newSchemaVersion = this.getSchemaVersion(cnn);
            if (initialSchemaVersion != newSchemaVersion) {
                LOGGER.log(Level.INFO, "Database successfully migrated from version {0} to version {1}", new Object[]{initialSchemaVersion, newSchemaVersion});
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected int getSchemaVersion(Connection cnn) throws SQLException {
        int schemaVersion;
        block27: {
            try (Statement stmt = cnn.createStatement();){
                try (ResultSet rst = stmt.executeQuery("SELECT * FROM VERSION");){
                    schemaVersion = rst.next() ? rst.getInt(1) : 0;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 42102) {
                        schemaVersion = 0;
                        break block27;
                    }
                    throw new RuntimeSqlException(e);
                }
            }
        }
        return schemaVersion;
    }

    protected synchronized void testDatabase() throws RuntimeSqlException {
        try (Connection cnn = this.jdbcConnectionPool.getConnection();){
            List<String> tables = Arrays.asList("MAVEN_ARTIFACT", "JENKINS_JOB", "JENKINS_BUILD", "MAVEN_DEPENDENCY", "GENERATED_MAVEN_ARTIFACT");
            for (String table : tables) {
                Statement stmt = cnn.createStatement();
                Throwable throwable = null;
                try {
                    ResultSet rst = stmt.executeQuery("SELECT count(*) FROM " + table);
                    Throwable throwable2 = null;
                    try {
                        if (rst.next()) {
                            int count = rst.getInt(1);
                            LOGGER.log(Level.FINE, "Table {0}: {1} rows", new Object[]{table, count});
                            continue;
                        }
                        throw new IllegalStateException("Exception testing table '" + table + "'");
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rst == null) continue;
                        if (throwable2 != null) {
                            try {
                                rst.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rst.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stmt == null) continue;
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    @Nonnull
    public List<String> listDownstreamJobs(@Nonnull String jobFullName, int buildNumber) {
        LOGGER.log(Level.FINER, "listDownstreamJobs({0}, {1})", new Object[]{jobFullName, buildNumber});
        String generatedArtifactsSql = "SELECT DISTINCT GENERATED_MAVEN_ARTIFACT.ARTIFACT_ID  FROM GENERATED_MAVEN_ARTIFACT  INNER JOIN JENKINS_BUILD AS UPSTREAM_BUILD ON GENERATED_MAVEN_ARTIFACT.BUILD_ID = UPSTREAM_BUILD.ID  INNER JOIN JENKINS_JOB AS UPSTREAM_JOB ON UPSTREAM_BUILD.JOB_ID = UPSTREAM_JOB.ID  WHERE    UPSTREAM_JOB.FULL_NAME = ? AND   UPSTREAM_BUILD.NUMBER = ? AND    GENERATED_MAVEN_ARTIFACT.SKIP_DOWNSTREAM_TRIGGERS = FALSE";
        String sql = "SELECT DISTINCT DOWNSTREAM_JOB.FULL_NAME  FROM JENKINS_JOB AS DOWNSTREAM_JOB INNER JOIN JENKINS_BUILD AS DOWNSTREAM_BUILD ON DOWNSTREAM_JOB.ID = DOWNSTREAM_BUILD.JOB_ID  INNER JOIN MAVEN_DEPENDENCY ON DOWNSTREAM_BUILD.ID = MAVEN_DEPENDENCY.BUILD_ID WHERE    MAVEN_DEPENDENCY.ARTIFACT_ID IN (" + generatedArtifactsSql + ") AND    MAVEN_DEPENDENCY.IGNORE_UPSTREAM_TRIGGERS = FALSE AND    DOWNSTREAM_BUILD.NUMBER in (SELECT MAX(JENKINS_BUILD.NUMBER) FROM JENKINS_BUILD WHERE DOWNSTREAM_JOB.ID = JENKINS_BUILD.JOB_ID) ORDER BY DOWNSTREAM_JOB.FULL_NAME";
        ArrayList<String> downstreamJobsFullNames = new ArrayList<String>();
        LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.jdbcConnectionPool.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setInt(2, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        LOGGER.log(Level.FINE, "listDownstreamJobs({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }
}

