/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jenkins.model.InterruptedBuildAction;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.publishers.JenkinsMavenEventSpyLogsPublisher;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MavenSpyLogProcessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MavenSpyLogProcessor.class.getName());

    public void processMavenSpyLogs(StepContext context, FilePath mavenSpyLogFolder, List<MavenPublisher> options) throws IOException, InterruptedException {
        DocumentBuilder documentBuilder;
        FilePath[] mavenSpyLogsList = mavenSpyLogFolder.list("maven-spy-*.log");
        LOGGER.log(Level.FINE, "Found {0} maven execution reports in {1}", new Object[]{mavenSpyLogsList.length, mavenSpyLogFolder});
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Failure to create a DocumentBuilder", e);
        }
        for (FilePath mavenSpyLogs : mavenSpyLogsList) {
            try {
                InputStream mavenSpyLogsInputStream;
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven]  Evaluate Maven Spy logs: " + mavenSpyLogs.getRemote());
                }
                if ((mavenSpyLogsInputStream = mavenSpyLogs.read()) == null) {
                    throw new IllegalStateException("InputStream for " + mavenSpyLogs.getRemote() + " is null");
                }
                FilePath archiveJenkinsMavenEventSpyLogs = workspace.child(".archive-jenkins-maven-event-spy-logs");
                if (archiveJenkinsMavenEventSpyLogs.exists()) {
                    LOGGER.log(Level.FINE, "Archive Jenkins Maven Event Spy logs {0}", mavenSpyLogs.getRemote());
                    new JenkinsMavenEventSpyLogsPublisher().process(context, mavenSpyLogs);
                }
                Element mavenSpyLogsElt = documentBuilder.parse(mavenSpyLogsInputStream).getDocumentElement();
                List<MavenPublisher> mavenPublishers = MavenPublisher.buildPublishersList(options, listener);
                for (MavenPublisher mavenPublisher : mavenPublishers) {
                    String skipFileName = mavenPublisher.getDescriptor().getSkipFileName();
                    if (Boolean.TRUE.equals(mavenPublisher.isDisabled())) {
                        listener.getLogger().println("[withMaven] Skip '" + mavenPublisher.getDescriptor().getDisplayName() + "' disabled by configuration");
                        continue;
                    }
                    if (StringUtils.isNotEmpty((String)skipFileName) && workspace.child(skipFileName).exists()) {
                        listener.getLogger().println("[withMaven] Skip '" + mavenPublisher.getDescriptor().getDisplayName() + "' disabled by marker file '" + skipFileName + "'");
                        continue;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        listener.getLogger().println("[withMaven] Run '" + mavenPublisher.getDescriptor().getDisplayName() + "'...");
                    }
                    try {
                        mavenPublisher.process(context, mavenSpyLogsElt);
                    }
                    catch (IOException | RuntimeException e) {
                        PrintWriter error = listener.error("[withMaven] WARNING Exception executing Maven reporter '" + mavenPublisher.getDescriptor().getDisplayName() + "' / " + mavenPublisher.getDescriptor().getId() + ". Please report a bug associated for the component 'pipeline-maven-plugin' at https://issues.jenkins-ci.org ");
                        e.printStackTrace(error);
                    }
                }
            }
            catch (SAXException e) {
                Run run = (Run)context.get(Run.class);
                if (run.getActions(InterruptedBuildAction.class).isEmpty()) {
                    listener.error("[withMaven] WARNING Exception parsing the logs generated by the Jenkins Maven Event Spy " + mavenSpyLogs + ", ignore file.  Please report a bug associated for the component 'pipeline-maven-plugin' at https://issues.jenkins-ci.org ");
                } else {
                    listener.error("[withMaven] WARNING logs generated by the Jenkins Maven Event Spy " + mavenSpyLogs + " are invalid, probably due to the interruption of the job, ignore file.");
                }
                listener.error(e.toString());
            }
            catch (Exception e) {
                PrintWriter errorWriter = listener.error("[withMaven] WARNING Exception processing the logs generated by the Jenkins Maven Event Spy " + mavenSpyLogs + ", ignore file.  Please report a bug associated for the component 'pipeline-maven-plugin' at https://issues.jenkins-ci.org ");
                e.printStackTrace(errorWriter);
            }
        }
        FilePath[] mavenSpyLogsInterruptedList = mavenSpyLogFolder.list("maven-spy-*.log.tmp");
        if (mavenSpyLogsInterruptedList.length > 0) {
            listener.getLogger().print("[withMaven] One or multiple Maven executions have been ignored by the Jenkins Pipeline Maven Plugin because they have been interrupted before completion (" + mavenSpyLogsInterruptedList.length + "). See ");
            listener.hyperlink("https://wiki.jenkins.io/display/JENKINS/Pipeline+Maven+Plugin#PipelineMavenPlugin-mavenExecutionInterrupted", "Pipeline Maven Plugin FAQ");
            listener.getLogger().println(" for more details.");
            if (LOGGER.isLoggable(Level.FINE)) {
                for (FilePath mavenSpyLogsInterruptedLogs : mavenSpyLogsInterruptedList) {
                    listener.getLogger().print("[withMaven] Ignore: " + mavenSpyLogsInterruptedLogs.getRemote());
                }
            }
        }
    }

    public static class PluginInvocation {
        public String groupId;
        public String artifactId;
        public String version;
        public String goal;
        public String executionId;

        public String getId() {
            return this.artifactId + ":" + this.goal + " (" + this.executionId + ")";
        }

        public String toString() {
            return "PluginInvocation{" + this.groupId + ":" + this.artifactId + ":" + this.version + "@" + this.goal + "  " + this.executionId + '}';
        }
    }

    public static class MavenDependency
    extends MavenArtifact {
        private String scope;
        public boolean optional;

        @Nonnull
        public String getScope() {
            return this.scope == null ? "compile" : this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope == null || scope.isEmpty() ? null : scope;
        }

        @Override
        public String toString() {
            return "MavenDependency{" + this.groupId + ":" + this.artifactId + ":" + this.type + (this.classifier == null ? "" : ":" + this.classifier) + ":" + this.baseVersion + ", scope: " + this.scope + ",  optional: " + this.optional + " version: " + this.version + " snapshot: " + this.snapshot + (this.file == null ? "" : " " + this.file) + '}';
        }
    }

    public static class MavenArtifact {
        public String groupId;
        public String artifactId;
        public String version;
        public String baseVersion;
        public String type;
        public String classifier;
        public String extension;
        public String file;
        public boolean snapshot;

        public String getFileName() {
            return this.artifactId + "-" + this.version + (this.classifier == null || this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + this.extension;
        }

        public String getFileNameWithBaseVersion() {
            return this.artifactId + "-" + this.baseVersion + (this.classifier == null || this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + this.extension;
        }

        public String getId() {
            return this.groupId + ":" + this.artifactId + ":" + this.baseVersion + (this.classifier == null || this.classifier.isEmpty() ? "" : ":" + this.classifier);
        }

        public String toString() {
            return "MavenArtifact{" + this.groupId + ":" + this.artifactId + ":" + this.type + (this.classifier == null ? "" : ":" + this.classifier) + ":" + this.baseVersion + "(version: " + this.version + ", snapshot:" + this.snapshot + ") " + (this.file == null ? "" : " " + this.file) + '}';
        }
    }
}

