/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.listeners;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.triggers.Trigger;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.trigger.WorkflowJobDependencyTrigger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

@Extension
public class DownstreamPipelineTriggerRunListener
extends RunListener<WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(DownstreamPipelineTriggerRunListener.class.getName());

    public void onCompleted(WorkflowRun upstreamBuild, @Nonnull TaskListener listener) {
        LOGGER.log(Level.FINE, "onCompleted({0})", new Object[]{upstreamBuild});
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] pipelineGraphPublisher - triggerDownstreamPipelines");
        }
        if (!GlobalPipelineMavenConfig.getTriggerDownstreamBuildsCriteria().contains(upstreamBuild.getResult())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] Skip downstream job triggering for upstream build with ignored result status " + upstreamBuild + ": " + upstreamBuild.getResult());
            }
            return;
        }
        WorkflowJob upstreamPipeline = (WorkflowJob)upstreamBuild.getParent();
        List<String> downstreamPipelines = GlobalPipelineMavenConfig.getDao().listDownstreamJobs(upstreamPipeline.getFullName(), upstreamBuild.getNumber());
        for (String downstreamPipelineFullName : downstreamPipelines) {
            WorkflowJob downstreamPipeline = (WorkflowJob)Jenkins.getInstance().getItemByFullName(downstreamPipelineFullName, WorkflowJob.class);
            if (downstreamPipeline == null) {
                LOGGER.log(Level.FINE, "Downstream pipeline {0} not found from upstream build {1} with authentication {2}. Database synchronization issue?", new Object[]{downstreamPipelineFullName, upstreamBuild.getFullDisplayName(), Jenkins.getAuthentication()});
                continue;
            }
            if (downstreamPipeline.equals(upstreamPipeline)) continue;
            if (!downstreamPipeline.isBuildable()) {
                LOGGER.log(Level.FINE, "Skip triggering of non buildable (disabled: {0}, isHoldOffBuildUntilSave: {1}) downstream pipeline {2} from upstream build {3}", new Object[]{downstreamPipeline.isDisabled(), downstreamPipeline.isHoldOffBuildUntilSave(), downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName()});
                continue;
            }
            WorkflowJobDependencyTrigger downstreamPipelineTrigger = this.getWorkflowJobDependencyTrigger((ParameterizedJobMixIn.ParameterizedJob)downstreamPipeline);
            if (downstreamPipelineTrigger == null) {
                LOGGER.log(Level.FINE, "Skip triggering of downstream pipeline {0} from upstream build {1}: dependency trigger not configured", new Object[]{downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName()});
                continue;
            }
            boolean downstreamVisibleByUpstreamBuildAuth = this.isDownstreamVisibleByUpstreamBuildAuth((Item)downstreamPipeline);
            boolean upstreamVisibleByDownstreamBuildAuth = this.isUpstreamBuildVisibleByDownstreamBuildAuth(upstreamPipeline, (Queue.Task)downstreamPipeline);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "upstreamPipeline (" + upstreamPipeline.getFullName() + ", visibleByDownstreamBuildAuth: " + upstreamVisibleByDownstreamBuildAuth + "),  downstreamPipeline (" + downstreamPipeline.getFullName() + ", visibleByUpstreamBuildAuth: " + downstreamVisibleByUpstreamBuildAuth + "), upstreamBuildAuth: " + Jenkins.getAuthentication());
            }
            if (downstreamVisibleByUpstreamBuildAuth && upstreamVisibleByDownstreamBuildAuth) {
                Queue.Item queuedItem = ParameterizedJobMixIn.scheduleBuild2((Job)downstreamPipeline, (int)-1, (Action[])new Action[]{new CauseAction((Cause)new Cause.UpstreamCause((Run)upstreamBuild))});
                if (queuedItem == null) {
                    listener.getLogger().println("[withMaven] Skip scheduling downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + ", it is already in the queue.");
                    continue;
                }
                listener.getLogger().println("[withMaven] Scheduling downstream pipeline " + ModelHyperlinkNote.encodeTo((Item)downstreamPipeline) + "#" + downstreamPipeline.getNextBuildNumber() + "...");
                continue;
            }
            LOGGER.log(Level.FINE, "Skip triggering of {0} by {1}: downstreamVisibleByUpstreamBuildAuth: {2}, upstreamVisibleByDownstreamBuildAuth: {3}", new Object[]{downstreamPipeline.getFullName(), upstreamBuild.getFullDisplayName(), downstreamVisibleByUpstreamBuildAuth, upstreamVisibleByDownstreamBuildAuth});
        }
    }

    @Nullable
    protected WorkflowJobDependencyTrigger getWorkflowJobDependencyTrigger(@Nonnull ParameterizedJobMixIn.ParameterizedJob parameterizedJob) {
        Map triggers = parameterizedJob.getTriggers();
        for (Object trigger : triggers.values()) {
            if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
            return (WorkflowJobDependencyTrigger)((Object)trigger);
        }
        if (parameterizedJob.getParent() instanceof WorkflowMultiBranchProject) {
            WorkflowMultiBranchProject multiBranchProject = (WorkflowMultiBranchProject)parameterizedJob.getParent();
            for (Trigger trigger : multiBranchProject.getTriggers().values()) {
                if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
                return (WorkflowJobDependencyTrigger)trigger;
            }
            if (multiBranchProject.getParent() instanceof ComputedFolder) {
                ComputedFolder grandParent = (ComputedFolder)multiBranchProject.getParent();
                Map grandParentTriggers = grandParent.getTriggers();
                for (Trigger trigger : grandParentTriggers.values()) {
                    if (!(trigger instanceof WorkflowJobDependencyTrigger)) continue;
                    return (WorkflowJobDependencyTrigger)trigger;
                }
            }
        }
        return null;
    }

    protected boolean isUpstreamBuildVisibleByDownstreamBuildAuth(@Nonnull WorkflowJob upstreamPipeline, @Nonnull Queue.Task downstreamPipeline) {
        Authentication auth = Tasks.getAuthenticationOf((Queue.Task)downstreamPipeline);
        Authentication downstreamPipelineAuth = auth.equals(ACL.SYSTEM) && !QueueItemAuthenticatorConfiguration.get().getAuthenticators().isEmpty() ? Jenkins.ANONYMOUS : auth;
        try (ACLContext _ = ACL.as((Authentication)downstreamPipelineAuth);){
            WorkflowJob upstreamPipelineObtainedAsImpersonated = (WorkflowJob)Jenkins.getInstance().getItemByFullName(upstreamPipeline.getFullName(), WorkflowJob.class);
            boolean result = upstreamPipelineObtainedAsImpersonated != null;
            LOGGER.log(Level.FINE, "isUpstreamBuildVisibleByDownstreamBuildAuth({0}, {1}): taskAuth: {2}, downstreamPipelineAuth: {3}, upstreamPipelineObtainedAsImpersonated:{4}, result: {5}", new Object[]{upstreamPipeline, downstreamPipeline, auth, downstreamPipelineAuth, upstreamPipelineObtainedAsImpersonated, result});
            boolean bl = result;
            return bl;
        }
    }

    protected boolean isDownstreamVisibleByUpstreamBuildAuth(@Nonnull Item downstreamPipeline) {
        boolean result = Jenkins.getInstance().getItemByFullName(downstreamPipeline.getFullName()) != null;
        LOGGER.log(Level.FINE, "isDownstreamVisibleByUpstreamBuildAuth({0}, auth: {1}): {2}", new Object[]{downstreamPipeline, Jenkins.getAuthentication(), result});
        return result;
    }
}

