/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    private static final Logger LOGGER = Logger.getLogger(XmlUtils.class.getName());

    public static MavenSpyLogProcessor.MavenArtifact newMavenArtifact(Element artifactElt) {
        MavenSpyLogProcessor.MavenArtifact mavenArtifact = new MavenSpyLogProcessor.MavenArtifact();
        XmlUtils.loadMavenArtifact(artifactElt, mavenArtifact);
        return mavenArtifact;
    }

    public static MavenSpyLogProcessor.MavenDependency newMavenDependency(Element dependencyElt) {
        MavenSpyLogProcessor.MavenDependency dependency = new MavenSpyLogProcessor.MavenDependency();
        XmlUtils.loadMavenArtifact(dependencyElt, dependency);
        dependency.setScope(dependencyElt.getAttribute("scope"));
        dependency.optional = Boolean.valueOf(dependencyElt.getAttribute("optional"));
        return dependency;
    }

    private static void loadMavenArtifact(Element artifactElt, MavenSpyLogProcessor.MavenArtifact mavenArtifact) {
        mavenArtifact.groupId = artifactElt.getAttribute("groupId");
        mavenArtifact.artifactId = artifactElt.getAttribute("artifactId");
        mavenArtifact.version = artifactElt.getAttribute("version");
        mavenArtifact.baseVersion = artifactElt.getAttribute("baseVersion");
        if (mavenArtifact.baseVersion == null || mavenArtifact.baseVersion.isEmpty()) {
            mavenArtifact.baseVersion = mavenArtifact.version;
        }
        mavenArtifact.snapshot = Boolean.valueOf(artifactElt.getAttribute("snapshot"));
        mavenArtifact.type = artifactElt.getAttribute("type");
        mavenArtifact.classifier = artifactElt.hasAttribute("classifier") ? artifactElt.getAttribute("classifier") : null;
        mavenArtifact.extension = artifactElt.getAttribute("extension");
    }

    public static MavenSpyLogProcessor.PluginInvocation newPluginInvocation(Element pluginInvocationElt) {
        MavenSpyLogProcessor.PluginInvocation pluginInvocation = new MavenSpyLogProcessor.PluginInvocation();
        pluginInvocation.groupId = pluginInvocationElt.getAttribute("groupId");
        pluginInvocation.artifactId = pluginInvocationElt.getAttribute("artifactId");
        pluginInvocation.version = pluginInvocationElt.getAttribute("version");
        pluginInvocation.goal = pluginInvocationElt.getAttribute("goal");
        pluginInvocation.executionId = pluginInvocationElt.getAttribute("executionId");
        return pluginInvocation;
    }

    @Nonnull
    public static Element getUniqueChildElement(@Nonnull Element element, @Nonnull String childElementName) {
        Element child = XmlUtils.getUniqueChildElementOrNull(element, childElementName);
        if (child == null) {
            throw new IllegalStateException("No <" + childElementName + "> element found");
        }
        return child;
    }

    @Nullable
    public static Element getUniqueChildElementOrNull(@Nonnull Element element, String ... childElementName) {
        Element result = element;
        for (String childEltName : childElementName) {
            List<Element> childElts = XmlUtils.getChildrenElements(result, childEltName);
            if (childElts.size() == 0) {
                return null;
            }
            if (childElts.size() > 1) {
                throw new IllegalStateException("More than 1 (" + childElts.size() + ") elements <" + childEltName + "> found in " + XmlUtils.toString(element));
            }
            result = childElts.get(0);
        }
        return result;
    }

    @Nonnull
    public static List<Element> getChildrenElements(@Nonnull Element element, @Nonnull String childElementName) {
        NodeList childElts = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < childElts.getLength(); ++i) {
            Node node = childElts.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(childElementName)) continue;
            result.add((Element)node);
        }
        return result;
    }

    @Nonnull
    public static String toString(@Nullable Node node) {
        try {
            StringWriter out = new StringWriter();
            Transformer identityTransformer = TransformerFactory.newInstance().newTransformer();
            identityTransformer.transform(new DOMSource(node), new StreamResult(out));
            return out.toString();
        }
        catch (TransformerException e) {
            LOGGER.log(Level.WARNING, "Exception dumping node " + node, e);
            return e.toString();
        }
    }

    @Nonnull
    public static List<Element> getExecutionEvents(@Nonnull Element mavenSpyLogs, String ... expectedType) {
        HashSet<String> expectedTypes = new HashSet<String>(Arrays.asList(expectedType));
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : XmlUtils.getChildrenElements(mavenSpyLogs, "ExecutionEvent")) {
            if (!expectedTypes.contains(element.getAttribute("type"))) continue;
            result.add(element);
        }
        return result;
    }

    @Nonnull
    public static List<Element> getExecutionEvents(@Nonnull Element mavenSpyLogs, String pluginGroupId, String pluginArtifactId, String pluginGoal) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element executionEventElt : XmlUtils.getChildrenElements(mavenSpyLogs, "ExecutionEvent")) {
            Element pluginElt = XmlUtils.getUniqueChildElementOrNull(executionEventElt, "plugin");
            if (pluginElt == null || !pluginElt.getAttribute("groupId").equals(pluginGroupId) || !pluginElt.getAttribute("artifactId").equals(pluginArtifactId) || !pluginElt.getAttribute("goal").equals(pluginGoal)) continue;
            result.add(executionEventElt);
        }
        return result;
    }

    @Nonnull
    public static String getPathInWorkspace(@Nonnull String absoluteFilePath, @Nonnull FilePath workspace) {
        String fileSeparator;
        String sanitizedAbsoluteFilePath;
        String sanitizedWorkspaceRemote;
        boolean windows = XmlUtils.isWindows(workspace);
        String workspaceRemote = workspace.getRemote();
        if (windows) {
            sanitizedWorkspaceRemote = workspaceRemote.replace('/', '\\');
            sanitizedAbsoluteFilePath = absoluteFilePath.replace('/', '\\');
        } else if (workspaceRemote.startsWith("/var/") && absoluteFilePath.startsWith("/private/var/")) {
            sanitizedWorkspaceRemote = workspaceRemote;
            sanitizedAbsoluteFilePath = absoluteFilePath.substring("/private".length());
        } else {
            sanitizedAbsoluteFilePath = absoluteFilePath;
            sanitizedWorkspaceRemote = workspaceRemote;
        }
        if (!StringUtils.startsWithIgnoreCase((String)sanitizedAbsoluteFilePath, (String)sanitizedWorkspaceRemote)) {
            if (sanitizedWorkspaceRemote.contains("/workspace/") && sanitizedAbsoluteFilePath.contains("/workspace/")) {
                sanitizedAbsoluteFilePath = "/workspace/" + StringUtils.substringAfter((String)sanitizedAbsoluteFilePath, (String)"/workspace/");
                sanitizedWorkspaceRemote = "/workspace/" + StringUtils.substringAfter((String)sanitizedWorkspaceRemote, (String)"/workspace/");
            } else {
                throw new IllegalArgumentException("Cannot relativize '" + absoluteFilePath + "' relatively to '" + workspace.getRemote() + "'");
            }
        }
        String relativePath = StringUtils.removeStartIgnoreCase((String)sanitizedAbsoluteFilePath, (String)sanitizedWorkspaceRemote);
        String string = fileSeparator = windows ? "\\" : "/";
        if (relativePath.startsWith(fileSeparator)) {
            relativePath = relativePath.substring(fileSeparator.length());
        }
        LOGGER.log(Level.FINEST, "getPathInWorkspace({0}, {1}: {2}", new Object[]{absoluteFilePath, workspaceRemote, relativePath});
        return relativePath;
    }

    public static boolean isWindows(@Nonnull FilePath path) {
        String remote = path.getRemote();
        if (remote.length() > 3 && remote.charAt(1) == ':' && remote.charAt(2) == '\\') {
            return true;
        }
        if (remote.length() > 3 && remote.charAt(1) == ':' && remote.charAt(2) == '/') {
            return true;
        }
        int indexOfSlash = path.getRemote().indexOf(47);
        int indexOfBackSlash = path.getRemote().indexOf(92);
        if (indexOfSlash == -1) {
            return true;
        }
        if (indexOfBackSlash == -1) {
            return false;
        }
        return indexOfSlash >= indexOfBackSlash;
    }

    @Nonnull
    public static String getFileSeparatorOnRemote(@Nonnull FilePath filePath) {
        int indexOfSlash = filePath.getRemote().indexOf(47);
        int indexOfBackSlash = filePath.getRemote().indexOf(92);
        if (indexOfSlash == -1) {
            return "\\";
        }
        if (indexOfBackSlash == -1) {
            return "/";
        }
        if (indexOfSlash < indexOfBackSlash) {
            return "/";
        }
        return "\\";
    }

    @Nullable
    public static String getProjectBuildDirectory(@Nonnull Element projectElt) {
        Element build = XmlUtils.getUniqueChildElementOrNull(projectElt, "build");
        if (build == null) {
            return null;
        }
        return build.getAttribute("directory");
    }

    @NonNull
    public static String join(@NonNull Iterable<String> elements, @NonNull String delimiter) {
        StringBuilder result = new StringBuilder();
        Iterator<String> it = elements.iterator();
        while (it.hasNext()) {
            String element = it.next();
            result.append(element);
            if (!it.hasNext()) continue;
            result.append(delimiter);
        }
        return result.toString();
    }
}

