/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.GlobalPipelineMavenConfig;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.w3c.dom.Element;

public class PipelineGraphPublisher
extends MavenPublisher {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(PipelineGraphPublisher.class.getName());
    private boolean includeSnapshotVersions = true;
    private boolean includeReleaseVersions;
    private boolean includeScopeCompile = true;
    private boolean includeScopeRuntime = true;
    private boolean includeScopeTest;
    private boolean includeScopeProvided = true;

    @DataBoundConstructor
    public PipelineGraphPublisher() {
    }

    protected Set<String> getIncludedScopes() {
        TreeSet<String> includedScopes = new TreeSet<String>();
        if (this.includeScopeCompile) {
            includedScopes.add("compile");
        }
        if (this.includeScopeRuntime) {
            includedScopes.add("runtime");
        }
        if (this.includeScopeProvided) {
            includedScopes.add("provided");
        }
        if (this.includeScopeTest) {
            includedScopes.add("test");
        }
        return includedScopes;
    }

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        Run run = (Run)context.get(Run.class);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        GlobalPipelineMavenConfig.get();
        PipelineMavenPluginDao dao = GlobalPipelineMavenConfig.getDao();
        this.recordDependencies(mavenSpyLogsElt, run, listener, dao);
        this.recordGeneratedArtifacts(mavenSpyLogsElt, run, listener, dao);
    }

    protected void recordDependencies(@Nonnull Element mavenSpyLogsElt, @Nonnull Run run, @Nonnull TaskListener listener, @Nonnull PipelineMavenPluginDao dao) {
        List<MavenSpyLogProcessor.MavenDependency> dependencies = this.listDependencies(mavenSpyLogsElt);
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] pipelineGraphPublisher - recordDependencies - filter: versions[snapshot: " + this.isIncludeSnapshotVersions() + ", release: " + this.isIncludeReleaseVersions() + "], scopes:" + this.getIncludedScopes());
        }
        for (MavenSpyLogProcessor.MavenDependency dependency : dependencies) {
            if (dependency.snapshot) {
                if (!this.includeSnapshotVersions) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    listener.getLogger().println("[withMaven] pipelineGraphPublisher - Skip recording snapshot dependency: " + dependency);
                    continue;
                }
            } else if (!this.includeReleaseVersions) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] pipelineGraphPublisher - Skip recording release dependency: " + dependency);
                continue;
            }
            if (!this.getIncludedScopes().contains(dependency.getScope())) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                listener.getLogger().println("[withMaven] pipelineGraphPublisher - Skip recording dependency with ignored scope: " + dependency);
                continue;
            }
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    listener.getLogger().println("[withMaven] pipelineGraphPublisher - Record dependency: " + dependency);
                }
                dao.recordDependency(run.getParent().getFullName(), run.getNumber(), dependency.groupId, dependency.artifactId, dependency.version, dependency.type, dependency.getScope());
            }
            catch (RuntimeException e) {
                listener.error("[withMaven] pipelineGraphPublisher - WARNING: Exception recording " + dependency + " on build, skip");
                e.printStackTrace(listener.getLogger());
                listener.getLogger().flush();
            }
        }
    }

    protected void recordGeneratedArtifacts(@Nonnull Element mavenSpyLogsElt, @Nonnull Run run, @Nonnull TaskListener listener, @Nonnull PipelineMavenPluginDao dao) {
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] pipelineGraphPublisher - recordGeneratedArtifacts");
        }
        List<MavenSpyLogProcessor.MavenArtifact> generatedArtifacts = this.listArtifacts(mavenSpyLogsElt);
        for (MavenSpyLogProcessor.MavenArtifact artifact : generatedArtifacts) {
            LOGGER.log(Level.FINE, "Build {0}#{1} - record generated {2}:{3}:{4}:{5}", new Object[]{run.getParent().getFullName(), run.getNumber(), artifact.groupId, artifact.artifactId, artifact.version, artifact.type});
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven] pipelineGraphPublisher - Record generated artifact: " + artifact);
            }
            dao.recordGeneratedArtifact(run.getParent().getFullName(), run.getNumber(), artifact.groupId, artifact.artifactId, artifact.version, artifact.type);
        }
    }

    @Nonnull
    public List<MavenSpyLogProcessor.MavenArtifact> listArtifacts(Element mavenSpyLogs) {
        ArrayList<MavenSpyLogProcessor.MavenArtifact> result = new ArrayList<MavenSpyLogProcessor.MavenArtifact>();
        for (Element projectSucceededElt : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectSucceeded")) {
            Element projectElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "project");
            MavenSpyLogProcessor.MavenArtifact projectArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.MavenArtifact pomArtifact = new MavenSpyLogProcessor.MavenArtifact();
            pomArtifact.groupId = projectArtifact.groupId;
            pomArtifact.artifactId = projectArtifact.artifactId;
            pomArtifact.version = projectArtifact.version;
            pomArtifact.type = "pom";
            pomArtifact.extension = "pom";
            pomArtifact.file = projectElt.getAttribute("file");
            result.add(pomArtifact);
            Element artifactElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "artifact");
            MavenSpyLogProcessor.MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(artifactElt);
            if ("pom".equals(mavenArtifact.type)) continue;
            Element fileElt = XmlUtils.getUniqueChildElementOrNull(artifactElt, "file");
            if (fileElt == null || fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINE, "listArtifacts: Project " + projectArtifact + ":  no associated file found for " + mavenArtifact + " in " + XmlUtils.toString(artifactElt));
                }
            } else {
                mavenArtifact.file = StringUtils.trim((String)fileElt.getTextContent());
            }
            result.add(mavenArtifact);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[disabled=" + this.isDisabled() + ", scopes=" + this.getIncludedScopes() + ", versions={snapshot:" + this.isIncludeSnapshotVersions() + ", release:" + this.isIncludeReleaseVersions() + "}" + ']';
    }

    @Nonnull
    public List<MavenSpyLogProcessor.MavenDependency> listDependencies(Element mavenSpyLogs) {
        ArrayList<MavenSpyLogProcessor.MavenDependency> result = new ArrayList<MavenSpyLogProcessor.MavenDependency>();
        for (Element dependencyResolutionResult : XmlUtils.getChildrenElements(mavenSpyLogs, "DependencyResolutionResult")) {
            Element resolvedDependenciesElt = XmlUtils.getUniqueChildElementOrNull(dependencyResolutionResult, "resolvedDependencies");
            if (resolvedDependenciesElt == null) continue;
            for (Element dependencyElt : XmlUtils.getChildrenElements(resolvedDependenciesElt, "dependency")) {
                MavenSpyLogProcessor.MavenDependency dependencyArtifact = XmlUtils.newMavenDependency(dependencyElt);
                Element fileElt = XmlUtils.getUniqueChildElementOrNull(dependencyElt, "file");
                if (fileElt == null || fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                    LOGGER.log(Level.WARNING, "listDependencies: no associated file found for " + dependencyArtifact + " in " + XmlUtils.toString(dependencyElt));
                } else {
                    dependencyArtifact.file = StringUtils.trim((String)fileElt.getTextContent());
                }
                result.add(dependencyArtifact);
            }
        }
        return result;
    }

    public boolean isIncludeSnapshotVersions() {
        return this.includeSnapshotVersions;
    }

    @DataBoundSetter
    public void setIncludeSnapshotVersions(boolean includeSnapshotVersions) {
        this.includeSnapshotVersions = includeSnapshotVersions;
    }

    public boolean isIncludeReleaseVersions() {
        return this.includeReleaseVersions;
    }

    @DataBoundSetter
    public void setIncludeReleaseVersions(boolean includeReleaseVersions) {
        this.includeReleaseVersions = includeReleaseVersions;
    }

    public boolean isIncludeScopeCompile() {
        return this.includeScopeCompile;
    }

    @DataBoundSetter
    public void setIncludeScopeCompile(boolean includeScopeCompile) {
        this.includeScopeCompile = includeScopeCompile;
    }

    public boolean isIncludeScopeRuntime() {
        return this.includeScopeRuntime;
    }

    @DataBoundSetter
    public void setIncludeScopeRuntime(boolean includeScopeRuntime) {
        this.includeScopeRuntime = includeScopeRuntime;
    }

    public boolean isIncludeScopeTest() {
        return this.includeScopeTest;
    }

    @DataBoundSetter
    public void setIncludeScopeTest(boolean includeScopeTest) {
        this.includeScopeTest = includeScopeTest;
    }

    public boolean isIncludeScopeProvided() {
        return this.includeScopeProvided;
    }

    @DataBoundSetter
    public void setIncludeScopeProvided(boolean includeScopeProvided) {
        this.includeScopeProvided = includeScopeProvided;
    }

    @Symbol(value={"pipelineGraphPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return "Pipeline Graph Publisher";
        }

        @Override
        public int ordinal() {
            return 20;
        }

        @Override
        @Nonnull
        public String getSkipFileName() {
            return ".skip-pipeline-graph";
        }
    }
}

