/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.FingerprintMap;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.tasks.Fingerprinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.ArtifactManager;
import jenkins.model.Jenkins;
import jenkins.util.BuildListenerAdapter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Element;

public class GeneratedArtifactsPublisher
extends MavenPublisher {
    private static final Logger LOGGER = Logger.getLogger(GeneratedArtifactsPublisher.class.getName());
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GeneratedArtifactsPublisher() {
    }

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        Run run = (Run)context.get(Run.class);
        ArtifactManager artifactManager = run.pickArtifactManager();
        Launcher launcher = (Launcher)context.get(Launcher.class);
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        String fileSeparatorOnAgent = XmlUtils.getFileSeparatorOnRemote(workspace);
        List<MavenSpyLogProcessor.MavenArtifact> mavenArtifacts = this.listArtifacts(mavenSpyLogsElt);
        List<MavenSpyLogProcessor.MavenArtifact> attachedMavenArtifacts = this.listAttachedArtifacts(mavenSpyLogsElt);
        ArrayList<MavenSpyLogProcessor.MavenArtifact> join = new ArrayList<MavenSpyLogProcessor.MavenArtifact>();
        join.addAll(mavenArtifacts);
        join.addAll(attachedMavenArtifacts);
        HashMap<String, String> artifactsToArchive = new HashMap<String, String>();
        HashMap<String, String> artifactsToFingerPrint = new HashMap<String, String>();
        for (MavenSpyLogProcessor.MavenArtifact mavenArtifact : join) {
            try {
                FilePath filePath;
                if (StringUtils.isEmpty((String)mavenArtifact.file)) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    listener.getLogger().println("[withMaven] artifactsPublisher - Can't archive maven artifact with no file attached: " + mavenArtifact);
                    continue;
                }
                if (!mavenArtifact.file.endsWith("." + mavenArtifact.extension) && (filePath = workspace.child(XmlUtils.getPathInWorkspace(mavenArtifact.file, workspace))).isDirectory()) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    listener.getLogger().println("[withMaven] artifactsPublisher - Skip archiving for generated maven artifact of type directory (it's likely to be target/classes, see JENKINS-43714) " + mavenArtifact);
                    continue;
                }
                String string = mavenArtifact.groupId.replace(".", fileSeparatorOnAgent) + fileSeparatorOnAgent + mavenArtifact.artifactId + fileSeparatorOnAgent + mavenArtifact.version + fileSeparatorOnAgent + mavenArtifact.getFileName();
                String artifactPathInWorkspace = XmlUtils.getPathInWorkspace(mavenArtifact.file, workspace);
                if (StringUtils.isEmpty((String)artifactPathInWorkspace)) {
                    listener.error("[withMaven] artifactsPublisher - Invalid path in the workspace (" + workspace.getRemote() + ") for artifact " + mavenArtifact);
                    continue;
                }
                if (Objects.equals(string, mavenArtifact.file)) {
                    listener.error("[withMaven] artifactsPublisher - Failed to relativize '" + mavenArtifact.file + "' in workspace '" + workspace.getRemote() + "' with file separator '" + fileSeparatorOnAgent + "'");
                    continue;
                }
                FilePath artifactFilePath = new FilePath(workspace, artifactPathInWorkspace);
                if (artifactFilePath.exists()) {
                    listener.getLogger().println("[withMaven] artifactsPublisher - Archive artifact " + artifactPathInWorkspace + " under " + string);
                    artifactsToArchive.put(string, artifactPathInWorkspace);
                    String artifactDigest = artifactFilePath.digest();
                    artifactsToFingerPrint.put(string, artifactDigest);
                    continue;
                }
                listener.getLogger().println("[withMaven] artifactsPublisher - FAILURE to archive " + artifactPathInWorkspace + " under " + string + ", file not found in workspace " + workspace);
            }
            catch (IOException | RuntimeException exception) {
                listener.error("[withMaven] artifactsPublisher - WARNING: Exception archiving and fingerprinting " + mavenArtifact + ", skip archiving of the artifacts");
                exception.printStackTrace(listener.getLogger());
                listener.getLogger().flush();
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            listener.getLogger().println("[withMaven] artifactsPublisher - Archive and fingerprint artifacts " + artifactsToArchive + " located in workspace " + workspace.getRemote());
        }
        try {
            artifactManager.archive(workspace, launcher, (BuildListener)new BuildListenerAdapter(listener), artifactsToArchive);
        }
        catch (IOException e) {
            throw new IOException("Exception archiving " + artifactsToArchive, e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Exception archiving " + artifactsToArchive, e);
        }
        FingerprintMap fingerprintMap = Jenkins.getInstance().getFingerprintMap();
        for (Map.Entry entry : artifactsToFingerPrint.entrySet()) {
            String artifactPathInArchiveZone = (String)entry.getKey();
            String artifactMd5 = (String)entry.getValue();
            fingerprintMap.getOrCreate(run, artifactPathInArchiveZone, artifactMd5).addFor(run);
        }
        Fingerprinter.FingerprintAction fingerprintAction = (Fingerprinter.FingerprintAction)run.getAction(Fingerprinter.FingerprintAction.class);
        if (fingerprintAction == null) {
            run.addAction((Action)new Fingerprinter.FingerprintAction(run, artifactsToFingerPrint));
        } else {
            fingerprintAction.add(artifactsToFingerPrint);
        }
    }

    @Nonnull
    public List<MavenSpyLogProcessor.MavenArtifact> listArtifacts(Element mavenSpyLogs) {
        ArrayList<MavenSpyLogProcessor.MavenArtifact> result = new ArrayList<MavenSpyLogProcessor.MavenArtifact>();
        for (Element projectSucceededElt : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectSucceeded")) {
            Element projectElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "project");
            MavenSpyLogProcessor.MavenArtifact projectArtifact = XmlUtils.newMavenArtifact(projectElt);
            MavenSpyLogProcessor.MavenArtifact pomArtifact = new MavenSpyLogProcessor.MavenArtifact();
            pomArtifact.groupId = projectArtifact.groupId;
            pomArtifact.artifactId = projectArtifact.artifactId;
            pomArtifact.version = projectArtifact.version;
            pomArtifact.type = "pom";
            pomArtifact.extension = "pom";
            pomArtifact.file = projectElt.getAttribute("file");
            result.add(pomArtifact);
            Element artifactElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "artifact");
            MavenSpyLogProcessor.MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(artifactElt);
            if ("pom".equals(mavenArtifact.type)) continue;
            Element fileElt = XmlUtils.getUniqueChildElementOrNull(artifactElt, "file");
            if (fileElt == null || fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINE, "listArtifacts: Project " + projectArtifact + ":  no associated file found for " + mavenArtifact + " in " + XmlUtils.toString(artifactElt));
                }
            } else {
                mavenArtifact.file = StringUtils.trim((String)fileElt.getTextContent());
            }
            result.add(mavenArtifact);
        }
        return result;
    }

    @Nonnull
    public List<MavenSpyLogProcessor.MavenArtifact> listAttachedArtifacts(Element mavenSpyLogs) {
        ArrayList<MavenSpyLogProcessor.MavenArtifact> result = new ArrayList<MavenSpyLogProcessor.MavenArtifact>();
        for (Element projectSucceededElt : XmlUtils.getExecutionEvents(mavenSpyLogs, "ProjectSucceeded")) {
            Element projectElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "project");
            MavenSpyLogProcessor.MavenArtifact projectArtifact = XmlUtils.newMavenArtifact(projectElt);
            Element attachedArtifactsParentElt = XmlUtils.getUniqueChildElement(projectSucceededElt, "attachedArtifacts");
            List<Element> attachedArtifactsElts = XmlUtils.getChildrenElements(attachedArtifactsParentElt, "artifact");
            for (Element attachedArtifactElt : attachedArtifactsElts) {
                MavenSpyLogProcessor.MavenArtifact attachedMavenArtifact = XmlUtils.newMavenArtifact(attachedArtifactElt);
                Element fileElt = XmlUtils.getUniqueChildElementOrNull(attachedArtifactElt, "file");
                if (fileElt == null || fileElt.getTextContent() == null || fileElt.getTextContent().isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Project " + projectArtifact + ", no associated file found for attached artifact " + attachedMavenArtifact + " in " + XmlUtils.toString(attachedArtifactElt));
                    }
                } else {
                    attachedMavenArtifact.file = StringUtils.trim((String)fileElt.getTextContent());
                }
                result.add(attachedMavenArtifact);
            }
        }
        return result;
    }

    @Symbol(value={"artifactsPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return "Generated Artifacts Publisher";
        }

        @Override
        public int ordinal() {
            return 1;
        }

        @Override
        @Nonnull
        public String getSkipFileName() {
            return ".skip-archive-generated-artifacts";
        }
    }
}

