/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.publishers;

import htmlpublisher.HtmlPublisher;
import htmlpublisher.HtmlPublisherTarget;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.maven.MavenPublisher;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.w3c.dom.Element;

public class ConcordionTestsPublisher
extends MavenPublisher {
    private static final Logger LOGGER = Logger.getLogger(ConcordionTestsPublisher.class.getName());
    private static final String GROUP_ID = "org.apache.maven.plugins";
    private static final String SUREFIRE_ID = "maven-surefire-plugin";
    private static final String FAILSAFE_ID = "maven-failsafe-plugin";
    private static final String SUREFIRE_GOAL = "test";
    private static final String FAILSAFE_GOAL = "integration-test";
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ConcordionTestsPublisher() {
    }

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        HashSet<String> concordionOutputDirPatterns = new HashSet<String>();
        concordionOutputDirPatterns.addAll(this.findConcordionOutputDirPatterns(XmlUtils.getExecutionEvents(mavenSpyLogsElt, GROUP_ID, SUREFIRE_ID, SUREFIRE_GOAL)));
        concordionOutputDirPatterns.addAll(this.findConcordionOutputDirPatterns(XmlUtils.getExecutionEvents(mavenSpyLogsElt, GROUP_ID, FAILSAFE_ID, FAILSAFE_GOAL)));
        if (concordionOutputDirPatterns.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven - concordionPublisher] No concordion output dir pattern given, skip.");
            }
            return;
        }
        ArrayList<FilePath> paths = new ArrayList<FilePath>();
        for (String string : concordionOutputDirPatterns) {
            paths.addAll(Arrays.asList(workspace.list(string)));
        }
        if (paths.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                listener.getLogger().println("[withMaven - concordionPublisher] Did not found any Concordion reports directory, skip.");
            }
            return;
        }
        listener.getLogger().println("[withMaven - concordionPublisher] Found " + paths.size() + " file(s) in Concordion reports directory.");
        try {
            Class.forName("htmlpublisher.HtmlPublisher");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven - concordionPublisher] Jenkins ");
            listener.hyperlink("https://wiki.jenkins.io/display/JENKINS/HTML+Publisher+Plugin", "HTML Publisher Plugin");
            listener.getLogger().println(" not found, do not archive concordion reports.");
            return;
        }
        ArrayList<String> files = new ArrayList<String>();
        for (FilePath path : paths) {
            files.add(XmlUtils.getPathInWorkspace(path.getRemote(), workspace));
        }
        HtmlPublisherTarget htmlPublisherTarget = new HtmlPublisherTarget("Concordion reports", ".", XmlUtils.join(files, ","), true, true, true);
        try {
            listener.getLogger().println("[withMaven - concordionPublisher] Publishing HTML reports named \"" + htmlPublisherTarget.getReportName() + "\" with the following files: " + htmlPublisherTarget.getReportFiles());
            HtmlPublisher.publishReports((Run)run, (FilePath)workspace, (Launcher)launcher, (TaskListener)listener, Arrays.asList(htmlPublisherTarget), HtmlPublisher.class);
        }
        catch (Exception e) {
            listener.error("[withMaven - concordionPublisher] Silently ignore exception archiving Concordion reports: " + e);
            LOGGER.log(Level.WARNING, "Exception processing Concordion reports archiving", e);
        }
    }

    @Nonnull
    private Collection<String> findConcordionOutputDirPatterns(@Nonnull List<Element> elements) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element : elements) {
            Element concordionOutputDir;
            Element envVars = XmlUtils.getUniqueChildElementOrNull(XmlUtils.getUniqueChildElement(element, "plugin"), "systemPropertyVariables");
            if (envVars == null || (concordionOutputDir = XmlUtils.getUniqueChildElementOrNull(envVars, "concordion.output.dir")) == null) continue;
            result.add("**/" + concordionOutputDir.getTextContent().trim() + "/**");
        }
        return result;
    }

    @Symbol(value={"concordionPublisher"})
    @Extension
    public static class DescriptorImpl
    extends MavenPublisher.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return "Concordion Publisher";
        }

        @Override
        public int ordinal() {
            return 20;
        }

        @Override
        @Nonnull
        public String getSkipFileName() {
            return ".skip-publish-concordion-results";
        }
    }
}

