/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.reporters;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.tasks.TasksPublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.pipeline.maven.MavenSpyLogProcessor;
import org.jenkinsci.plugins.pipeline.maven.ResultsReporter;
import org.jenkinsci.plugins.pipeline.maven.reporters.FindbugsAnalysisReporter;
import org.jenkinsci.plugins.pipeline.maven.util.XmlUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.w3c.dom.Element;

public class TasksScannerReporter
implements ResultsReporter {
    private static final Logger LOGGER = Logger.getLogger(FindbugsAnalysisReporter.class.getName());

    @Override
    public void process(@Nonnull StepContext context, @Nonnull Element mavenSpyLogsElt) throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        Run run = (Run)context.get(Run.class);
        Launcher launcher = (Launcher)context.get(Launcher.class);
        try {
            Class.forName("hudson.plugins.tasks.TasksPublisher");
        }
        catch (ClassNotFoundException e) {
            listener.getLogger().print("[withMaven] Jenkins ");
            listener.hyperlink("https://wiki.jenkins-ci.org/display/JENKINS/Task+Scanner+Plugin", "Task Scanner Plugin");
            listener.getLogger().println(" not found, don't display results of source code scanning for 'TODO' and 'FIXME' in pipeline screen.");
            return;
        }
        ArrayList<String> sourceDirectoriesPatterns = new ArrayList<String>();
        for (Element executionEvent : XmlUtils.getExecutionEvents(mavenSpyLogsElt, "ProjectSucceeded", "ProjectFailed")) {
            Element buildElement = XmlUtils.getUniqueChildElementOrNull(executionEvent, "project", "build");
            if (buildElement == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Ignore execution event with missing 'build' child:" + XmlUtils.toString(executionEvent));
                continue;
            }
            Element projectElt = XmlUtils.getUniqueChildElement(executionEvent, "project");
            MavenSpyLogProcessor.MavenArtifact mavenArtifact = XmlUtils.newMavenArtifact(projectElt);
            String sourceDirectory = buildElement.getAttribute("sourceDirectory");
            String sourceDirectoryRelativePath = XmlUtils.getPathInWorkspace(sourceDirectory, workspace);
            if (workspace.child(sourceDirectoryRelativePath).exists()) {
                sourceDirectoriesPatterns.add(sourceDirectoryRelativePath + "/**/*");
                listener.getLogger().println("[withMaven] Scan Tasks for Maven artifact " + mavenArtifact.toString() + " in source directory " + sourceDirectoryRelativePath);
                continue;
            }
            LOGGER.log(Level.FINE, "Skip task scanning for {0}, folder {1} does not exist", new Object[]{mavenArtifact, sourceDirectoryRelativePath});
        }
        TasksPublisher tasksPublisher = new TasksPublisher();
        String pattern = XmlUtils.join(sourceDirectoriesPatterns, ",");
        tasksPublisher.setPattern(pattern);
        tasksPublisher.setHigh("FIXME");
        tasksPublisher.setNormal("TODO");
        try {
            tasksPublisher.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            listener.error("[withMaven] Silently ignore exception scanning tasks in " + pattern + ": " + e);
            LOGGER.log(Level.WARNING, "Exception scanning tasks in  " + pattern, e);
        }
    }
}

