/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jenkins.model.InterruptedBuildAction;
import org.jenkinsci.plugins.pipeline.maven.reporters.FindbugsAnalysisReporter;
import org.jenkinsci.plugins.pipeline.maven.reporters.GeneratedArtifactsReporter;
import org.jenkinsci.plugins.pipeline.maven.reporters.JunitTestsReporter;
import org.jenkinsci.plugins.pipeline.maven.reporters.TasksScannerReporter;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MavenSpyLogProcessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MavenSpyLogProcessor.class.getName());
    protected final transient DocumentBuilder documentBuilder;

    public MavenSpyLogProcessor() {
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void processMavenSpyLogs(StepContext context, FilePath mavenSpyLogFolder) throws IOException, InterruptedException {
        FilePath[] mavenSpyLogsList = mavenSpyLogFolder.list("maven-spy-*.log");
        LOGGER.log(Level.FINE, "Found {0} maven execution reports in {1}", new Object[]{mavenSpyLogsList.length, mavenSpyLogFolder});
        TaskListener listener = (TaskListener)context.get(TaskListener.class);
        if (listener == null) {
            LOGGER.warning("TaskListener is NULL, default to stderr");
            listener = new StreamBuildListener((OutputStream)System.err);
        }
        FilePath workspace = (FilePath)context.get(FilePath.class);
        for (FilePath mavenSpyLogs : mavenSpyLogsList) {
            try {
                LOGGER.log(Level.INFO, "Evaluate Maven Spy logs: " + mavenSpyLogs.getRemote());
                InputStream mavenSpyLogsInputStream = mavenSpyLogs.read();
                Element mavenSpyLogsElt = this.documentBuilder.parse(mavenSpyLogsInputStream).getDocumentElement();
                FilePath skipArchiveArtifactsFile = workspace.child(".skip-archive-generated-artifacts");
                if (skipArchiveArtifactsFile.exists()) {
                    listener.getLogger().println("[withMaven] Skip archiving of generated artifacts, file '" + skipArchiveArtifactsFile + "' found in workspace");
                } else {
                    LOGGER.log(Level.FINE, "Look for generated artifacts to archive, file {0} NOT found in workspace", skipArchiveArtifactsFile);
                    new GeneratedArtifactsReporter().process(context, mavenSpyLogsElt);
                }
                FilePath skipJunitFile = workspace.child(".skip-publish-junit-results");
                if (skipJunitFile.exists()) {
                    listener.getLogger().println("[withMaven] Skip publishing of JUnit results, file '" + skipJunitFile + "' found in workspace");
                } else {
                    LOGGER.log(Level.FINE, "Look for JUnit results to publish, file {0} NOT found in workspace", skipJunitFile);
                    new JunitTestsReporter().process(context, mavenSpyLogsElt);
                }
                FilePath skipFindbugsFile = workspace.child(".skip-publish-findbugs-results");
                if (skipFindbugsFile.exists()) {
                    listener.getLogger().println("[withMaven] Skip publishing of FindBugs results, file '" + skipFindbugsFile + "' found in workspace");
                } else {
                    LOGGER.log(Level.FINE, "Look for Findbugs results to publish, file {0} NOT found in workspace", skipFindbugsFile);
                    new FindbugsAnalysisReporter().process(context, mavenSpyLogsElt);
                }
                FilePath skipTasksScannerFile = workspace.child(".skip-task-scanner");
                if (skipTasksScannerFile.exists()) {
                    listener.getLogger().println("[withMaven] Skip publishing of tasks in source code, file '" + skipTasksScannerFile + "' found in workspace");
                    continue;
                }
                LOGGER.log(Level.FINE, "Look for tasks in source code to publish, file {0} NOT found in workspace", skipTasksScannerFile);
                new TasksScannerReporter().process(context, mavenSpyLogsElt);
            }
            catch (SAXException e) {
                Run run = (Run)context.get(Run.class);
                if (run.getActions(InterruptedBuildAction.class).isEmpty()) {
                    listener.error("[withMaven] WARNING Exception parsing the logs generated by the Jenkins Maven Event Spy " + mavenSpyLogs + ", ignore file.  Please report a bug associated for the component 'pipeline-maven-plugin' at https://issues.jenkins-ci.org ");
                } else {
                    listener.error("[withMaven] WARNING logs generated by the Jenkins Maven Event Spy " + mavenSpyLogs + " are invalid, probably due to the interruption of the job, ignore file.");
                }
                listener.error(e.toString());
            }
            catch (Exception e) {
                PrintWriter errorWriter = listener.error("[withMaven] WARNING Exception processing the logs generated by the Jenkins Maven Event Spy " + mavenSpyLogs + ", ignore file.  Please report a bug associated for the component 'pipeline-maven-plugin' at https://issues.jenkins-ci.org ");
                e.printStackTrace(errorWriter);
            }
        }
    }

    public static class PluginInvocation {
        public String groupId;
        public String artifactId;
        public String version;
        public String goal;
        public String executionId;

        public String toString() {
            return "PluginInvocation{" + this.groupId + ":" + this.artifactId + ":" + this.version + "@" + this.goal + "  " + this.executionId + '}';
        }
    }

    public static class MavenArtifact {
        public String groupId;
        public String artifactId;
        public String version;
        public String type;
        public String classifier;
        public String extension;
        public String file;

        public String getFileName() {
            return this.artifactId + "-" + this.version + (this.classifier == null || this.classifier.isEmpty() ? "" : "-" + this.classifier) + "." + this.extension;
        }

        public String toString() {
            return "MavenArtifact{" + this.groupId + ":" + this.artifactId + ":" + this.type + (this.classifier == null ? "" : ":" + this.classifier) + ":" + this.version + (this.file == null ? "" : " " + this.file) + '}';
        }
    }
}

